package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;

@Data
public class SkinFeature implements Serializable {

    // 皮肤
    private String SkinId;
    private String componentSkinCategory; //f314001 皮肤类型
    private Double componentSkinHistClick;   //f314004 历史点击率
    private Double componentSkinWeekClick; //f314005 一周点击率
    private Double componentSkinDayClick;   //f314006 当日点击率
    private Double componentSkinHistOrder;   //f314007 历史转化率
    private Double componentSkinWeekOrder; //f314008 一周转化率
    private Double componentSkinDayOrder; //f314009 当日转化率
    private Double skinHistConsumer; //f314013 当日转化率
    private Double skinWeekConsumer; //f314010 当日转化率
    private Double skinDayConsumer; //f314011 当日转化率
    private String skinEmbedding; //f314012 当日转化率

    private Integer cHistSkinsExposeTime;   //f493010 历史各皮肤重复曝光次数
    private Integer cWeekSkinsExposeTime;   //f493011 一周各皮肤重复曝光次数
    private Integer cDaySkinsExposeTime;   //f493012 当日各皮肤重复曝光次数
    private Integer cHistSkinsClickTime;   //f494010 当前皮肤历史重复参与次数
    private Integer cWeekSkinsClickTime;   //f494011 当前皮肤一周重复参与次数
    private Integer cDaySkinsClickTime;   //f494012 当前皮肤当日重复参与次数
    private Integer cHistSkinsOrderTime;   //f495010 历史各皮肤重复转化次数
    private Integer cWeekSkinsOrderTime;   //f495011 一周各皮肤重复转化次数
    private Integer cDaySkinsOrderTime;   //f495012 当日各皮肤重复转化次数

    private Double cAppSlotSkinHistClick;   //f240013 当前活动皮肤历史参与率
    private Double cAppSlotSkinWeekClick;   //f240014 当前活动皮肤一周参与率
    private Double cAppSlotSkinDayClick;   //f240015 当前活动皮肤当日参与率
    private Double cAppSlotSkinHistOrder;   //f241013 当前活动皮肤历史落地页转化率
    private Double cAppSlotSkinWeekOrder;   //f241014 当前活动皮肤一周落地页转化率
    private Double cAppSlotSkinDayOrder;   //f241015 当前活动皮肤当日落地页转化率
    private Double cAppSlotSkinHistConsumer;   //f242013 当前活动皮肤历史UV消耗
    private Double cAppSlotSkinWeekConsumer;   //f242014 当前活动皮肤一周UV消耗
    private Double cAppSlotSkinDayConsumer;   //f242015 当前活动皮肤当日UV消耗

}
