package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class TitleFeature implements Serializable {

    private String titleId;
    private String componentTitleCategory; //f311001 标题标签
    private Double componentTitleHistClick;   //f311002 历史点击率
    private Double componentTitleWeekClick;   //f311003 一周点击率
    private Double componentTitleDayClick; //f311004 当日点击率
    private Double componentTitleHistOrder;   //f311005 历史转化率
    private Double componentTitleWeekOrder;   //f311006 一周转化率
    private Double componentTitleDayOrder; //f311007 当日转化率
    private Double componentTitleHistConsumer; //f311007 当日转化率
    private Double componentTitleWeekConsumer; //f311007 当日转化率
    private Double componentTitleDayConsumer; //f311007 当日转化率
    private String componentTitleEmbedding; //f311007 当日转化率

    // 用户维度
    private Integer cHistTitlesExposeTime; //f493001 当前主标题历史重复曝光次数
    private Integer cWeekTitlesExposeTime; //f493002 当前主标题一周重复曝光次数
    private Integer cDayTitlesExposeTime;  //f493003 当前主标题当日重复曝光次数

    private Integer cHistTitlesClickTime; //f494001 当前主标题历史重复参与次数
    private Integer cWeekTitlesClickTime; //f494002 当前主标题一周重复参与次数
    private Integer cDayTitlesClickTime;  //f494003 当前主标题当日重复参与次数

    private Integer cHistTitlesOrderTime; //f495001 用户当前主标题历史重复转化次数
    private Integer cWeekTitlesOrderTime; //f495002 用户当前主标题一周重复转化次数
    private Integer cDayTitlesOrderTime;  //f495003 用户当前主标题当日重复转化次数

    private Double cAppSlotTitlesHistClick;    //f240004 当前主标题历史参与率
    private Double cAppSlotTitlesWeekClick;    //f240005 当前主标题一周参与率
    private Double cAppSlotTitlesDayClick;    //f240006 当前主标题当日参与率
    private Double cAppSlotTitlesHistOrder;    //f241004 当前主标题历史落地页转化率
    private Double cAppSlotTitlesWeekOrder;    //f241005 当前主标题一周落地页转化率
    private Double cAppSlotTitlesDayOrder;    //f241006 当前主标题当日落地页转化率
    private Double cAppSlotTitlesHistConsumer;    //f242004 当前主标题历史UV消耗
    private Double cAppSlotTitlesWeekConsumer;    //f242005 当前主标题一周UV消耗
    private Double cAppSlotTitlesDayConsumer;    //f242006 当前主标题当日UV消耗

}
