/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFeatureParse
extends BaseParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(ActivityFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        Map<String, String> contextFeature = ActivityFeatureParse.parseContextFeature(contextFeatureDoV2);
        retMap.putAll(contextFeature);
        Map<String, String> userFeature = ActivityFeatureParse.parseUserFeature(userFeatureDoV2);
        retMap.putAll(userFeature);
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActFeatureDoV2 data, UserFeatureDoV2 data2) {
        HashMap<String, String> retMap = new HashMap(F_MAX_SIZE);
        retMap = ActivityFeatureParse.parseActFeature(data, data2);
        return retMap;
    }

    public static Map<String, String> parseActFeature(ActFeatureDoV2 data, UserFeatureDoV2 data2) {
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        ActivityFeatureParse.putMapNotNull(retMap, "ft300301", data.getActivityId());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300304", data.getActivityPage());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300305", data.getActivitySkinType());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300302", data.getActivitySourceType());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300311", data.getActTradeTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300312", data.getActCrowdTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300313", data.getActPrizeTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300314", data.getActStyleTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300315", data.getActSeasonTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300316", data.getActFestivalTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300317", data.getActInduceTag());
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data2.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        List<Long> userActReqList = userBehaviorSubFeature.getUserActReqList();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{data.getActivityId(), userActReqList})) {
            Long hisLastActivity = userActReqList.get(userActReqList.size() - 1);
            if (data.getActivityId().equals(hisLastActivity)) {
                retMap.put("ft110910", "1");
            }
        }
        return retMap;
    }

    public static Map<String, String> parseContextFeature(ContextFeatureDoV2 data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        if (data != null) {
            ActivityFeatureParse.putMapNotNull(retMap, "ft300101", data.getAppId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft300201", DataUtil.Long2String((Long)data.getSlotId()));
            ActivityFeatureParse.putMapNotNull(retMap, "ft300202", data.getSlotSceneType());
            String areaCode = DataUtil.Long2String((Long)data.getAreaCode());
            String provinceId = RegionConf.getProvince(areaCode);
            String regionId = RegionConf.getRegion(provinceId);
            String cityTier = RegionConf.getCityTier(areaCode);
            ActivityFeatureParse.putMapNotNull(retMap, "ft300901", regionId);
            ActivityFeatureParse.putMapNotNull(retMap, "ft300902", provinceId);
            ActivityFeatureParse.putMapNotNull(retMap, "ft300903", areaCode);
            ActivityFeatureParse.putMapNotNull(retMap, "ft300904", cityTier);
            ActivityFeatureParse.putMapNotNull(retMap, "ft100210", data.getIp());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100209", data.getIpUsageType());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100211", data.getUa());
            ActivityFeatureParse.putMapNotNull(retMap, "ft300109", data.getUaAppPackage());
            ActivityFeatureParse.putMapNotNull(retMap, "ft300110", data.getUaAppPackageTrade());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100208", data.getPhoneOs());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100203", UserProfileFeature.formatOsVersion(data.getOsVersion()));
            ActivityFeatureParse.putMapNotNull(retMap, "ft100205", data.getBrandNameEn());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100204", UserProfileFeature.formatPhoneModelCode(data.getPhoneModelCode()));
            ActivityFeatureParse.putMapNotNull(retMap, "ft100206", data.getPhonePriceLevel());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100202", data.getOperatorType());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100201", data.getConnectionType());
            ActivityFeatureParse.putMapNotNull(retMap, "ft100207", data.getFirstShowTime());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600304", data.getGroupId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600305", data.getResourceId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft300102", data.getSceneType());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600201", data.getOpenAccountId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600202", data.getExtUnionSlotId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600203", data.getExtAdvertGroupId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600204", data.getExtIdeaId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600205-xxxx", data.getMaterailTag());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600301", data.getExtAppTrade());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600302", data.getExternalAdBlockId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft600303", data.getExternalAdBlockTypeId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft300203", data.getSlotMaterailId());
            ActivityFeatureParse.putMapNotNull(retMap, "ft300303", data.getDsm2A());
            LocalDateTime time = LocalDateTime.now();
            ActivityFeatureParse.putMapNotNull(retMap, "ft301001", time.getHour());
            ActivityFeatureParse.putMapNotNull(retMap, "ft301002", time.getDayOfWeek().getValue());
            ActivityFeatureParse.putMapNotNull(retMap, "ft301003", time.getDayOfMonth());
        }
        return retMap;
    }

    public static Map<String, String> parseUserFeature(UserFeatureDoV2 data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        UserProfileSubFeature userProfileFeature = Optional.ofNullable(data.getUserProfileSubFeature()).orElse(new UserProfileSubFeature());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100001", data.getOneId());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100103", userProfileFeature.getMarital());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100106", userProfileFeature.getAge());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100107", userProfileFeature.getGender());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100501", userProfileFeature.getBdFirstTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100502", userProfileFeature.getBdSecondTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100503", userProfileFeature.getBdThirdTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100504", userProfileFeature.getBdFourthTag());
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        retMap.put("f0202", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv())));
        retMap.put("f0203", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv())));
        retMap.put("f0204", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv())));
        retMap.put("f0205", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv())));
        retMap.put("f0413", DataUtil.longListToString(userBehaviorSubFeature.getUserActReqList()));
        retMap.put("f0417", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList()));
        retMap.put("f0418", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList()));
        retMap.put("f0301", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv1d())));
        retMap.put("f0302", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv1d())));
        retMap.put("f0303", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv1d())));
        retMap.put("f0304", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv1d())));
        retMap.put("f0305", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv1d())));
        retMap.put("f0316", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv1d())));
        retMap.put("f0311", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv14d())));
        retMap.put("f0312", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv14d())));
        retMap.put("f0313", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv14d())));
        retMap.put("f0314", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv14d())));
        retMap.put("f0315", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv14d())));
        retMap.put("f0320", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv14d())));
        retMap.put("f0341", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv180d())));
        retMap.put("f0342", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv180d())));
        retMap.put("f0343", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv180d())));
        retMap.put("f0344", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv180d())));
        retMap.put("f0345", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv180d())));
        retMap.put("f0350", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv180d())));
        retMap.put("f0403", DataUtil.longListToString(userBehaviorSubFeature.getUserActReqList14d()));
        retMap.put("f0407", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList14d()));
        retMap.put("f0408", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList14d()));
        return retMap;
    }
}

