package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;

@Data
public class RoutineActFeature implements Serializable {

    private String routineActId;
    private Double routineActHistClick;    //f301002 常规活动历史点击率
    private Double routineActWeekClick;    //f301003 常规活动一周点击率
    private Double routineActHistOrder;  //f301004 常规活动历史转化率
    private Double routineActWeekOrder; //f301005 常规活动一周转化率
    private String routineActTradeVisitTime;   //f301006 行业标签（媒体）访问次数
    private String routineActTradeClickTime;    //f301007 行业标签（媒体）参与次数
    private String routineActActType;   //f301008 活动类型
    private Double routineActHistConsumer; // 历史每UV消耗
    private Double routineActWeekConsumer; // 一周每UV消耗
    private Double routineActDayConsumer; // 当日每UV消耗
    private String routineActEmbedding; // Embedding

    private Integer blockStatus; // 区块状态 0-关 1-开
    private Integer autoFirstLaunchStatus; // 自动首次出券状态
    private Integer encStatus; // 增值状态
    private Integer layerStatus; // 广告定制弹层状态
    private Integer actPreLaunchDTOStatus; // 预出券状态
    private Integer actPreLaunchDTONum; // 预出券数量
    private String actPreLaunchDTOIndustryTagName; // 行业名称
    private Integer planAdvertFeatureDTODirectStatus; // 定制白名单开关 0-关 1-开
    private Integer planAdvertFeatureDTODirectModeStatus; // 仅投优投开关  1仅投放定制广告券列表，2优先投放定制广告券列表

    private Integer cHistActExposeTime; //f493013 当前活动历史重复曝光次数
    private Integer cWeekActExposeTime; //f493014 当前活动一周重复曝光次数
    private Integer cDayActExposeTime;  //f493015 当前活动当日重复曝光次数
    private Integer cHistActClickTime;   //f494013 当前活动历史重复参与次数
    private Integer cWeekActClickTime;   //f494014 当前活动一周重复参与次数
    private Integer cDayActClickTime;   //f494015 当前活动当日重复参与次数
    private Integer cHistActOrderTime;   //f495013 当前活动历史重复转化次数
    private Integer cWeekActOrderTime;   //f495014 当前活动一周重复转化次数
    private Integer cDayActOrderTime;   //f495015 当日各皮肤重复转化次数

    private Double cAppSlotActHistClick;   //f240001 当前活动历史活动参与率
    private Double cAppSlotActWeekClick;   //f240002 当前活动一周活动参与率
    private Double cAppSlotActDayClick;   //f240003 当前活动当日活动参与率
    private Double cAppSlotActHistOrder;   //f241001 当前活动历史落地页转化率
    private Double cAppSlotActWeekOrder;   //f241002 当前活动一周落地页转化率
    private Double cAppSlotActDayOrder;   //f241003 当前活动当日落地页转化率
    private Double cAppSlotActHistConsumer;   //f241001 当前活动历史消耗
    private Double cAppSlotActWeekConsumer;   //f241002 当前活动一周消耗
    private Double cAppSlotActDayConsumer;   //f241003 当前活动当日消耗

    private Double cAppSlotActJoinDayConsumer; // 广告位+活动三天每参与pv消耗
    private Double cAppSlotCtrPerTime; // 近30天 广告位+活动 平均ctr

    private Double cAppSlotActJoinMonthConsumer; // 广告位+活动一个月参与pv消耗

    private Double zdSlotActCostPerTime; //近一个月广告位上首次自动发券平均消耗
}
