/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureCoder
extends FeatureCoderBase {
    private static int F_MAX_SIZE = 64;
    public static Map<String, List<FeatureBaseType>> cache = new HashMap<String, List<FeatureBaseType>>();

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Long> pLenList = new ArrayList<Long>(F_MAX_SIZE);
        ArrayList<Set<Long>> ret = new ArrayList<Set<Long>>(F_MAX_SIZE);
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value, pLenList, indices, values);
            ret.add(retSub);
            for (int i = 0; i < retSub.size(); ++i) {
                fields.add(featureBaseType.getName());
            }
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Set<Long>> ret = new ArrayList<Set<Long>>(F_MAX_SIZE);
        HashMap<String, Map<Long, Double>> fieldFeatureMap = new HashMap<String, Map<Long, Double>>();
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value);
            ret.add(retSub);
            ArrayList<Long> retSubList = new ArrayList<Long>(retSub);
            HashMap<Long, Double> subFiledFeatureMap = new HashMap<Long, Double>();
            for (int i = 0; i < retSub.size(); ++i) {
                indices.add(((Long)retSubList.get(i)).intValue());
                values.add(1.0 / (double)retSub.size());
                fields.add(featureBaseType.getName());
                Double fValue = 1.0 / (double)retSub.size();
                subFiledFeatureMap.put((long)((Long)retSubList.get(i)).intValue() + 0L, fValue);
            }
            fieldFeatureMap.put(featureBaseType.getName(), subFiledFeatureMap);
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }

    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.get(featureBaseType.getName());
            Set<String> retSub = featureBaseType.parseFeatureValues(value);
            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f101001", "3");
        featureMap.put("f101002", "1,2,");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");
        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(10);
        featureBaseType1.setName("f101001");
        featureBaseType1.setSeq(",");
        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(11);
        featureBaseType2.setName("f101002");
        featureBaseType2.setSeq(",");
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);
        System.out.println(JSON.toJSONString(featureMap));
        try {
            String a = null;
            String b = null;
            System.out.println(a + b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

