/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.AdxFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.dmp.DmpFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.dmp.DmpUserSubFeatureDo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFeatureParseV2
extends BaseParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(AdxFeatureParseV2.class);

    public static Map<String, String> generateFeatureMapStatic(ContextFeatureDoV2 contextFeatureDoV2, DmpFeatureDo dmpFeatureDo) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        Map<String, String> contextFeature = AdxFeatureParseV2.parseContextFeature(contextFeatureDoV2);
        retMap.putAll(contextFeature);
        Map<String, String> userFeature = AdxFeatureParseV2.parseUserFeature(dmpFeatureDo);
        retMap.putAll(userFeature);
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(AdxFeatureDoV2 data, DmpFeatureDo data2, ContextFeatureDoV2 data3) {
        HashMap<String, String> retMap = new HashMap(F_MAX_SIZE);
        retMap = AdxFeatureParseV2.parseAdxFeature(data, data2, data3);
        return retMap;
    }

    public static Map<String, String> parseAdxFeature(AdxFeatureDoV2 data, DmpFeatureDo data2, ContextFeatureDoV2 data3) {
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        return retMap;
    }

    public static Map<String, String> parseContextFeature(ContextFeatureDoV2 data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        if (data != null) {
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300101", data.getAppId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300201", DataUtil.Long2String((Long)data.getSlotId()));
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300202", data.getSlotSceneType());
            String areaCode = DataUtil.Long2String((Long)data.getAreaCode());
            String provinceId = RegionConf.getProvince(areaCode);
            String regionId = RegionConf.getRegion(provinceId);
            String cityTier = RegionConf.getCityTier(areaCode);
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300901", regionId);
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300902", provinceId);
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300903", areaCode);
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300904", cityTier);
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100210", data.getIp());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100209", data.getIpUsageType());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100211", data.getUa());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300104", data.getAppIndustryTagPid());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300105", data.getAppIndustryTagId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300109", data.getUaAppPackage());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300110", data.getUaAppPackageTrade1());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300111", data.getUaAppPackageTrade2());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100208", data.getPhoneOs());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100203", data.getOsVersion());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100205", data.getBrandNameEn());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100204", UserProfileFeature.formatPhoneModelCode(data.getPhoneModelCode()));
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100206", data.getPhonePriceLevel());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100202", data.getOperatorType());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100201", data.getConnectionType());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft100207", data.getFirstShowTime());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600304", data.getGroupId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600305", data.getResourceId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600201", data.getOpenAccountId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft6002021", data.getExtUnionSlotId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft6002031", data.getExtAdvertGroupId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft6002041", data.getExtIdeaId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600206", ContextFeatureDoV2.formatInterestTag(data.getExtMaterialTitle()));
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600207", data.getExtMaterialId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600208", data.getExtMaterialType());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600205", data.getMaterialTag());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600301", data.getExtAppTrade());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600302", data.getExternalAdBlockId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft600303", data.getExternalAdBlockTypeId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300203", data.getSlotMaterialId());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft300303", data.getDsm2A());
            LocalDateTime time = LocalDateTime.now();
            AdxFeatureParseV2.putMapNotNull(retMap, "ft301001", time.getHour());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft301002", time.getDayOfWeek().getValue());
            AdxFeatureParseV2.putMapNotNull(retMap, "ft301003", time.getDayOfMonth());
        }
        return retMap;
    }

    public static Map<String, String> parseUserFeature(DmpFeatureDo data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        DmpUserSubFeatureDo dmpUserSubFeatureDo = Optional.ofNullable(data.getDmpUserSubFeatureDo()).orElse(new DmpUserSubFeatureDo());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100103", dmpUserSubFeatureDo.getMarital());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100106", dmpUserSubFeatureDo.getAge());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100107", dmpUserSubFeatureDo.getGender());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100501", dmpUserSubFeatureDo.getBdFirstTag());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100502", dmpUserSubFeatureDo.getBdSecondTag());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft1005031", dmpUserSubFeatureDo.getBdThirdTag());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100504", dmpUserSubFeatureDo.getBdFourthTag());
        AdxFeatureParseV2.putMapNotNull(retMap, "ft100603", dmpUserSubFeatureDo.getAppInstall());
        return retMap;
    }

    public static void main(String[] args) {
        ArrayList<String> reqList = new ArrayList<String>();
        reqList.add("100");
        reqList.add("101");
        Long activityId = 101L;
        String hisLastActivity = (String)reqList.get(reqList.size() - 1);
        Long hisLastActivityLong = Long.valueOf(hisLastActivity);
        System.out.println("hisLastActivit=" + hisLastActivity);
        System.out.println("hisLastActivityLong=" + hisLastActivityLong);
        System.out.println("hisLastActivit=" + activityId.equals(hisLastActivity));
        System.out.println("hisLastActivityLong=" + activityId.equals(hisLastActivityLong));
    }
}

