/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.util;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConverter {
    private static final Logger logger = LoggerFactory.getLogger(DataConverter.class);

    public static <T extends Number> Double accumulateMapValues(Map<?, T> map) {
        if (map == null) {
            return 0.0;
        }
        return map.values().stream().mapToDouble(Number::doubleValue).sum();
    }

    public static Map<String, String> series2Map(String s1, String s2, String split) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{s1, s2, split})) {
            return ret;
        }
        String[] s1Arr = s1.split(split);
        String[] s2Arr = s2.split(split);
        if (s1Arr.length <= 0 || s1Arr.length != s2Arr.length) {
            return ret;
        }
        for (int i = 0; i < s1Arr.length; ++i) {
            String item1 = s1Arr[i];
            String item2 = s2Arr[i];
            ret.put(item1, item2);
        }
        return ret;
    }

    public static String map2Str(Map<?, ?> map) {
        if (map == null || AssertUtil.isEmpty(map)) {
            return null;
        }
        String ret = "";
        try {
            ret = map.keySet().stream().map(key -> key + "_" + map.get(key)).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.json2Bucket2Str error", (Throwable)e);
        }
        return ret;
    }

    public static String json2Str(JSONObject amap) {
        if (amap == null || AssertUtil.isEmpty((Map)amap)) {
            return null;
        }
        String ret = "";
        try {
            ret = amap.keySet().stream().map(key -> key + "_" + amap.get(key)).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.json2Bucket2Str error", (Throwable)e);
        }
        return ret;
    }

    public static <V extends Number> String map2Bucket2Str(Map<?, V> map, Number[] bucketList) {
        if (map == null || AssertUtil.isEmpty(map)) {
            return null;
        }
        String ret = "";
        try {
            ret = map.keySet().stream().map(key -> key + "_" + DataConverter.bucket((Number)((Number)map.get(key)), (Number[])bucketList)).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.json2Bucket2Str error", (Throwable)e);
        }
        return ret;
    }

    public static <V extends Number> String mapKey2Str(Map<?, V> map) {
        if (map == null) {
            return null;
        }
        String ret = "";
        try {
            ret = map.keySet().stream().map(Object::toString).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.mapKey2Str error", (Throwable)e);
        }
        return ret;
    }

    public static String json2Bucket2Str(JSONObject ajson, Number[] bucketList) {
        if (ajson == null || AssertUtil.isEmpty((Map)ajson)) {
            return null;
        }
        String ret = "";
        try {
            ret = ajson.keySet().stream().map(key -> key + "_" + DataConverter.bucket((Number)ajson.getDouble(key), (Number[])bucketList)).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.json2Bucket2Str error", (Throwable)e);
        }
        return ret;
    }

    public static <V1 extends Number, V2 extends Number> String bucket(V1 value, V2[] bucketList) {
        if (value == null || bucketList == null || bucketList.length == 0) {
            return "";
        }
        int ret = bucketList.length;
        for (int i = 0; i < bucketList.length; ++i) {
            V2 bound = bucketList[i];
            if (!(value.doubleValue() <= ((Number)bound).doubleValue())) continue;
            ret = i;
            break;
        }
        return DataUtil.Integer2String((Integer)ret);
    }

    public static <V1 extends Number, V2 extends Number> String bucketRight(V1 value, V2[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = (long)bucketList.length + 1L;
            for (int i = 0; i < bucketList.length; ++i) {
                V2 bound = bucketList[i];
                if (!(value.doubleValue() <= ((Number)bound).doubleValue())) continue;
                ret = (long)i + 1L;
                break;
            }
        }
        return Long.toString(ret);
    }

    public static <T> String set2Str(Set<T> set) {
        if (AssertUtil.isEmpty(set)) {
            return null;
        }
        String ret = "";
        try {
            ret = set.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.set2Str error", (Throwable)e);
        }
        return ret;
    }

    public static <T> Set<T> setDiff(Set<T> base, Set<T> exclude) {
        if (base == null) {
            return null;
        }
        if (exclude == null) {
            return base;
        }
        HashSet<T> res = new HashSet<T>(base);
        try {
            res.removeAll(exclude);
        }
        catch (Exception e) {
            logger.error("DateConverter.setDiff error", (Throwable)e);
        }
        return res;
    }

    public static <T> Set<T> setInter(Set<T> set1, Set<T> set2) {
        if (set1 == null || set2 == null) {
            return null;
        }
        HashSet<T> res = new HashSet<T>(set1);
        try {
            res.retainAll(set2);
        }
        catch (Exception e) {
            logger.error("DateConverter.setInter error", (Throwable)e);
        }
        return res;
    }

    public static <T> String jointStrSet(String s, Set<T> set) {
        if (set == null || AssertUtil.isEmpty(set)) {
            return null;
        }
        String ret = "";
        try {
            ret = set.stream().map(key -> key.toString() + "_" + s).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("DateConverter.set2Str error", (Throwable)e);
        }
        return ret;
    }

    public static Map<String, String> transJointStrToMap(String JointStr, String s1, String s2) {
        String[] valueArr;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (JointStr == null) {
            return ret;
        }
        for (String s : valueArr = JointStr.split(s1)) {
            String[] itemArr = s.split(s2);
            ret.put(itemArr[0], itemArr.length >= 2 ? itemArr[1] : "");
        }
        return ret;
    }

    public static Long getTimeInterval(String date1, String date2, String unit) {
        if (date1 == null || date2 == null || unit == null) {
            return -1L;
        }
        LocalDateTime start = LocalDateUtil.getLocalDateTime((String)date1, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        LocalDateTime end = LocalDateUtil.getLocalDateTime((String)date2, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        Duration diff = Duration.between(start, end);
        switch (unit) {
            case "Y": {
                return diff.toDays() / 365L;
            }
            case "M": {
                return diff.toDays() / 30L;
            }
            case "D": {
                return diff.toDays();
            }
            case "W": {
                return diff.toDays() / 7L;
            }
            case "H": {
                return diff.toHours();
            }
            case "m": {
                return diff.toMinutes();
            }
            case "s": {
                return diff.toMillis() / 1000L;
            }
        }
        return null;
    }

    public static String getCurTradeLevel(JSONObject actMap, String newTrade, Number[] buckets) {
        if (newTrade == null || actMap == null) {
            return null;
        }
        Double cateValue = actMap.getDouble(newTrade);
        if (cateValue == null) {
            return "-1";
        }
        return DataConverter.bucket((Number)cateValue, (Number[])buckets);
    }

    public static String getMatchStatus(String s1, String s2) {
        if (s1 == null) {
            return "-1";
        }
        if (s2 == null) {
            return "-2";
        }
        if (!s1.equals(s2)) {
            return "0";
        }
        return "1";
    }

    public static String getMatchStatus(Long s1, Long s2) {
        if (s1 == null) {
            return "-1";
        }
        if (s2 == null) {
            return "-2";
        }
        if (!s1.equals(s2)) {
            return "0";
        }
        return "1";
    }

    public static String getMatchStatus2(String s1, String s2) {
        if (s1 == null) {
            return "0";
        }
        if (!s1.equals(s2)) {
            return "1";
        }
        return "2";
    }

    public static String dmpGender2AqyGender(String dmpGender) {
        if (dmpGender == null || dmpGender.equals("")) {
            return null;
        }
        if (dmpGender.equals("010101")) {
            return "119010101";
        }
        if (dmpGender.equals("010102")) {
            return "119010102";
        }
        return null;
    }

    public static void main(String[] args) {
        Number[] cntBucket = new Number[]{0, 1, 3, 5, 10, 15, 20};
        String jsonStr = "{\"totalRecords\": \"1293\", \"pageIndex\": \"1e\",   \"pageSize\": 200}";
        JSONObject jsonboj = JSONObject.parseObject((String)jsonStr);
        System.out.println(jsonboj.getDouble("totalRecords"));
        System.out.println(jsonboj.getDouble("pageIndex"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataConverter)) {
            return false;
        }
        DataConverter other = (DataConverter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataConverter;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "DataConverter()";
    }
}

