package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * @author lijingzhe
 * @description
 * @date 2020/10/27
 */
public class DpFeatureParse {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DpFeatureParse.class);

    public static int F_MAX_SIZE = 64;
    //  根据实际数据调整分桶阈值
    public static int[] userBehaviorBucket = {0, 1, 3, 5, 10, 15, 35, 50, 80};
    public static int[] cntBucket = {0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = {1, 4, 8};
    public static double[] statCtrBucket = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};

    // 广告位/媒体 相关统计值
    //  根据实际数据调整分桶阈值
    public static int[] slotMaterialTagExposeDayBucket = {3, 6, 10, 20, 50, 100, 500, 2000, 10000, 750000};
    public static int[] slotMaterialTagExposeHisBucket = {3, 12, 37, 103, 282, 843, 2612, 10716, 65838, 4978025};
    public static double[] userConBucket = {0.01, 0.05, 0.1, 0.5, 1, 3, 5, 10, 50, 100};
    public static double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};


    public static int[] slotSkinTypeExposeDayBucket = {1, 2, 5, 20, 80, 300, 1000, 2000, 8000, 30000};
    public static int[] slotSkinTypeExposeSevenBucket = {1, 4, 15, 63, 219, 770, 2293, 7241, 32396, 1026962};
    public static int[] slotSkinTypeExposeHisBucket = {1, 2, 4, 18, 111, 547, 2695, 11694, 57077, 3085582};
    public static int[] slotSkinTypeClickDayBucket = {1, 2, 3, 9, 28, 88, 180, 400, 1500, 5000};
    public static int[] slotSkinTypeClickSevenBucket = {2, 8, 24, 80, 272, 717, 1911, 5349, 22938, 864145};
    public static int[] slotSkinTypeClickHisBucket = {1, 4, 14, 54, 217, 896, 3155, 10601, 44939, 2458473};

    public static int[] slotRewardTagExposeDayBucket = {1, 2, 4, 8, 15, 30, 75, 220, 1200, 6000};
    public static int[] slotRewardTagExposeSevenBucket = {2, 4, 7, 14, 27, 58, 146, 507, 3001, 153710};
    public static int[] slotRewardTagExposeHisBucket = {2, 4, 9, 19, 39, 87, 226, 799, 6388, 448837};
    public static int[] slotRewardTagClickDayBucket = {1, 2, 3, 5, 10, 23, 60, 150, 800, 4800};
    public static int[] slotRewardTagClickSevenBucket = {2, 3, 7, 12, 23, 55, 132, 387, 2239, 126967};
    public static int[] slotRewardTagClickHisBucket = {2, 4, 9, 17, 35, 79, 199, 637, 4440, 220232};

    public static int[] appSkinTypeExposeDayBucket = {1, 2, 9, 35, 120, 400, 1200, 5000, 22000, 65000};
    public static int[] appSkinTypeExposeSevenBucket = {1, 3, 17, 83, 335, 1263, 3725, 12053, 59810, 1666682};
    public static int[] appSkinTypeExposeHisBucket = {1, 3, 17, 156, 823, 2025, 4229, 17325, 102025, 3854952};
    public static int[] appSkinTypeClickDayBucket = {1, 3, 9, 30, 100, 350, 700, 2100, 8500, 20000};
    public static int[] appSkinTypeClickSevenBucket = {2, 10, 34, 128, 408, 1058, 3607, 9581, 39887, 1055972};
    public static int[] appSkinTypeClickHisBucket = {1, 4, 18, 85, 356, 1317, 4375, 18299, 83998, 3017636};

    public static int[] appRewardTagExposeDayBucket = {1, 2, 5, 8, 15, 33, 120, 450, 2500, 100000};
    public static int[] appRewardTagExposeSevenBucket = {2, 4, 9, 17, 35, 82, 223, 837, 5324, 289787};
    public static int[] appRewardTagExposeHisBucket = {2, 4, 9, 23, 49, 119, 340, 1274, 11159, 682999};
    public static int[] appRewardTagClickDayBucket = {1, 2, 3, 5, 10, 23, 60, 150, 1000, 48000};
    public static int[] appRewardTagClickSevenBucket = {2, 4, 8, 15, 29, 70, 187, 599, 3560, 177802};
    public static int[] appRewardTagClickHisBucket = {2, 5, 10, 20, 42, 100, 303, 1025, 7421, 399933};


    // 活动皮肤id编码
    public static Map<String, Integer> actSkinTypeCodes = new HashMap<String, Integer>() {
        {
            put("1", 0);
            put("2", 1);
            put("3", 2);
            put("4", 3);
            put("5", 4);
            put("6", 5);
            put("7", 6);
            put("8", 7);
            put("9", 8);
            put("10", 9);
            put("11", 10);
            put("12", 11);
            put("13", 12);
            put("14", 13);
            put("15", 14);
            put("16", 15);
            put("17", 16);
            put("18", 17);
            put("19", 18);
            put("20", 19);
            put("21", 20);
            put("22", 21);
            put("23", 22);
            put("24", 23);
            put("25", 24);
            put("26", 25);
            put("27", 26);
            put("28", 27);
            put("29", 28);
            put("30", 29);
            put("31", 30);
            put("32", 31);
            put("33", 32);
        }
    };

    // 活动奖品标签编码
    public static Map<String, Integer> actRewardCodes = new HashMap<String, Integer>() {
        {
            put("29", 0);
            put("30", 1);
            put("31", 2);
            put("32", 3);
            put("33", 4);
            put("34", 5);
            put("35", 6);
            put("36", 7);
            put("37", 8);
            put("38", 9);
            put("39", 10);
            put("40", 11);
            put("41", 12);
            put("42", 13);
            put("43", 14);
        }
    };

    public static Map<String, String> generateDpFeatureMap(DpFeatureDo dpFeatureDo) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try{
            if (dpFeatureDo != null) {
                /**
                 * 活动DPA保留
                 */
                UserFeature userFeature = Optional.ofNullable(dpFeatureDo.getUserFeature()).orElse(new UserFeature());
                Map<String, Map<String, Long>> ubpMap = getUserBehavioralPreference(
                        userFeature.getUIIds(), userFeature.getUILaunchPV(), userFeature.getUIClickPv(), userFeature.getUIEffectPv());
                putMapNotNull(retMap, "f808001", getUserBehavioralPreference(2, "ctr", ubpMap, null));
                putMapNotNull(retMap, "f808002", getUserBehavioralPreference(2, "cvr", ubpMap, null));

                SlotActFeature slotActFeature = Optional.ofNullable(dpFeatureDo.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject weekCtrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCtrTrade());
                putMapNotNull(retMap, "f212003", getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
                JSONObject weekCvrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCvrTrade());
                putMapNotNull(retMap, "f214003", getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
                putMapNotNull(retMap, "f241001", DataUtil.Long2String(bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActHistOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241002", DataUtil.Long2String(bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActWeekOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241003", DataUtil.Long2String(bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActDayOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f242001", DataUtil.Long2String(bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActHistConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242002", DataUtil.Long2String(bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActWeekConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242003", DataUtil.Long2String(bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActDayConsumer(), userConBucket)));

                /**
                 * 素材DPA保留
                 */
                // 用户画像特征解析

                // 基本属性
                retMap.put("f451004", userFeature.getConsumeLevel());
                retMap.put("f451006", userFeature.getPermanentCity());

                // 用户画像特征解析
                retMap.put("f9902", userFeature.getAppList());
                retMap.put("f9801", userFeature.getSigList());

                //广告位
                SlotFeature slotFeature = Optional.ofNullable(dpFeatureDo.getSlotFeature()).orElse(new SlotFeature());

                retMap.put("f108001", DataUtil.Long2String(slotFeature.getSlotId()));


                AppFeature appFeature = Optional.ofNullable(dpFeatureDo.getAppFeature()).orElse(new AppFeature());
                retMap.put("f201001", DataUtil.Long2String(appFeature.getAppId()));
                // 媒体标签
                retMap.put("f205001", appFeature.getAppIndustryTagPid());
                retMap.put("f205002", appFeature.getAppIndustryTagId());

                //上下文
                MaterialContextFeature contextFeature = Optional.ofNullable(dpFeatureDo.getMaterialContextFeature()).orElse(new MaterialContextFeature());


//                retMap.put("f501001", contextFeature.getUa());
                retMap.put("f503001", DataUtil.Long2String(contextFeature.getCityId()));

                retMap.put("f503003", contextFeature.getProvinceCode());
                // 设备型号
                retMap.put("f504001", contextFeature.getModel());
                // 设备价格区间
//                retMap.put("f505001", contextFeature.getPriceSection());
//                retMap.put("f390017", contextFeature.getRequestHour());
//                retMap.put("f390018", contextFeature.getRequestWeekDay());
//                retMap.put("f390019", contextFeature.getRequestHolidays());


                // 新增后向行为特征
                // 活动访问
                retMap.put("f411001", FeatureParse.bucket(userFeature.getActivityRequest(), cntBucket).toString());
                retMap.put("f411002", FeatureParse.bucket(userFeature.getWeekActivityRequest(), cntBucket).toString());
                retMap.put("f411004", FeatureParse.bucket(userFeature.getIntervalActivityRequest(), cntBucket).toString());
                retMap.put("f411005", userFeature.getPeriodActivityRequest());

                // 活动参与412005
                retMap.put("f412001", FeatureParse.bucket(userFeature.getActivityJoin(), cntBucket).toString());
                retMap.put("f412002", FeatureParse.bucket(userFeature.getWeekActivityJoin(), cntBucket).toString());
                retMap.put("f412004", FeatureParse.bucket(userFeature.getIntervalActivityJoin(), cntBucket).toString());
                retMap.put("f412005", userFeature.getPeriodActivityJoin());

                // 点击
                Map<String, Integer> clickTraceActMap = DataUtil.stringToMap(userFeature.getClickTrade(), 0);
                retMap.put("f414001", getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
                Map<String, Integer> weekClickTradeActMap = DataUtil.stringToMap(userFeature.getWeekClickTrade(), 0);
                retMap.put("f414002", getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
                retMap.put("f414004", FeatureParse.bucket(userFeature.getIntervalClickTrade(), cntBucket).toString());
                retMap.put("f414005", userFeature.getPeriodClickTrade());
                retMap.put("f414007", userFeature.getLastClickTrade());

                // 转化
                Map<String, Integer> effectTradeActMap = DataUtil.stringToMap(userFeature.getEffectTrade(), 0);
                retMap.put("f415001", getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
                Map<String, Integer> weekEffectTradeActMap = DataUtil.stringToMap(userFeature.getWeekEffectTrade(), 0);
                retMap.put("f415002", getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
                retMap.put("f415004", FeatureParse.bucket(userFeature.getIntervalEffectTrade(), cntBucket).toString());
                retMap.put("f415005", userFeature.getPeriodEffectTrade());
                retMap.put("f415007", userFeature.getLastEffectTrade());

                // 用户-活动组件-皮肤类型
                Map<String, ComponentInfo> userToActSkinMap = userFeature.getUserToActSkinMap();
                if (!AssertUtil.isEmpty(userToActSkinMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(userToActSkinMap);
                    retMap.put("f391013", getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391014", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391015", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391016", getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391017", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391018", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, userBehaviorBucket));
                }

                // 用户-活动组件-奖品标签
                Map<String, ComponentInfo> userToRewardTagMap = userFeature.getUserToRewardTagMap();
                if (!AssertUtil.isEmpty(userToRewardTagMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(userToRewardTagMap);
                    retMap.put("f391019", getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391020", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391021", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391022", getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391023", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391024", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, userBehaviorBucket));
                }

                // 活动皮肤
                Map<String, ComponentInfo> slotToActSkinMap = slotFeature.getSlotToActSkinMap();
                if (!AssertUtil.isEmpty(slotToActSkinMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(slotToActSkinMap);
                    retMap.put("f391031", getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, slotSkinTypeExposeDayBucket));
                    retMap.put("f391032", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, slotSkinTypeExposeSevenBucket));
                    retMap.put("f391033", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, slotSkinTypeExposeHisBucket));
                    retMap.put("f391034", getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, slotSkinTypeClickDayBucket));
                    retMap.put("f391035", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, slotSkinTypeClickSevenBucket));
                    retMap.put("f391036", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, slotSkinTypeClickHisBucket));
                }

                // 活动奖品标签
                Map<String, ComponentInfo> slotToRewardTagMap = slotFeature.getSlotToRewardTagMap();
                if (!AssertUtil.isEmpty(slotToRewardTagMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(slotToRewardTagMap);
                    retMap.put("f391037", getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, slotRewardTagExposeDayBucket));
                    retMap.put("f391038", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, slotRewardTagExposeSevenBucket));
                    retMap.put("f391039", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, slotRewardTagExposeHisBucket));
                    retMap.put("f391040", getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, slotRewardTagClickDayBucket));
                    retMap.put("f391041", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, slotRewardTagClickSevenBucket));
                    retMap.put("f391042", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, slotRewardTagClickHisBucket));
                }

                // 活动皮肤
                Map<String, ComponentInfo> appToActSkinMap = appFeature.getAppToActSkinMap();
                if (!AssertUtil.isEmpty(appToActSkinMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(appToActSkinMap);
                    retMap.put("f391049", getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, appSkinTypeExposeDayBucket));
                    retMap.put("f391050", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, appSkinTypeExposeSevenBucket));
                    retMap.put("f391051", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, appSkinTypeExposeHisBucket));
                    retMap.put("f391052", getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, appSkinTypeClickDayBucket));
                    retMap.put("f391053", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, appSkinTypeClickSevenBucket));
                    retMap.put("f391054", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, appSkinTypeClickHisBucket));
                }

                Map<String, ComponentInfo> appToRewardTagMap = appFeature.getAppToRewardTagMap();
                if (!AssertUtil.isEmpty(appToRewardTagMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(appToRewardTagMap);
                    retMap.put("f391055", getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, appRewardTagExposeDayBucket));
                    retMap.put("f391056", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, appRewardTagExposeSevenBucket));
                    retMap.put("f391057", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, appRewardTagExposeHisBucket));
                    retMap.put("f391058", getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, appRewardTagClickDayBucket));
                    retMap.put("f391059", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, appRewardTagClickSevenBucket));
                    retMap.put("f391060", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, appRewardTagClickHisBucket));
                }
                // 用户-广告位-活动组件
                // 活动皮肤
                Map<String, ComponentInfo> userToSlotActSkinMap = slotFeature.getUserToSlotActSkinMap();
                if (!AssertUtil.isEmpty(userToSlotActSkinMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(userToSlotActSkinMap);
                    retMap.put("f391065", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391066", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391067", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391068", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, userBehaviorBucket));
                }
                // 活动奖品标签
                Map<String, ComponentInfo> userToSlotRewardTagMap = slotFeature.getUserToSlotRewardTagMap();
                if (!AssertUtil.isEmpty(userToSlotRewardTagMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = getSplitTimeMap(userToSlotRewardTagMap);
                    retMap.put("f391069", getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391070", getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391071", getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391072", getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, userBehaviorBucket));
                }

            }

        }catch (Exception e) {

            logger.error("MaterialFeatureParse.generateFeatureMapStatic error:", e);
            logger.error(JSONObject.toJSONString(dpFeatureDo));
        }
        
        return retMap;
    }

    /**
     * 将非空值放入map
     */
    public static void putMapNotNull(Map<String, String> map, String key, String value) {

        if (map == null || StringUtils.isBlank(value)) {
            return;
        }

        map.put(key, value);
    }

    public static String subList(List<String> list) {
        if (AssertUtil.isEmpty(list)) {
            return null;
        }
        List<String> subList = list;
        if (list.size() > 30) {
            subList = subList.subList(list.size() - 30, list.size());
            return StringUtils.strip(subList.toString().replace(" ", ""), "[]");
        } else {
            return StringUtils.strip(list.toString().replace(" ", ""), "[]");
        }
    }

    public static String sortSubList(String string) {
        if (AssertUtil.isEmpty(string)) {
            return null;
        }
        List<String> list = Arrays.asList(string.split(","));

        Collections.sort(list, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                String[] array1 = o1.split("-");
                String[] array2 = o2.split("-");
                return array1[0].compareTo(array2[0]);
            }
        });
        List<String> newArray = new ArrayList<>();
        for (String s : list) {
            if (s.split("-").length >= 2) {
                newArray.add(s.split("-")[1]);
            } else {
                newArray.add(s);
            }
        }
        return subList(newArray);
    }

    private static Map<Integer, Map<String, Integer>> getSplitTimeMap(Map<String, ComponentInfo> componentInfoMap) {
        Map<Integer, Map<String, Integer>> splitMap = new HashMap<>();
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            String key = entry.getKey();
            ComponentInfo componentInfo = entry.getValue();
            Map<String, Integer> firstMap = splitMap.getOrDefault(0, new HashMap<>());
            Map<String, Integer> secMap = splitMap.getOrDefault(1, new HashMap<>());
            Map<String, Integer> thirdMap = splitMap.getOrDefault(2, new HashMap<>());
            Map<String, Integer> fourthMap = splitMap.getOrDefault(3, new HashMap<>());
            Map<String, Integer> fifthMap = splitMap.getOrDefault(4, new HashMap<>());
            Map<String, Integer> sixthMap = splitMap.getOrDefault(5, new HashMap<>());

            firstMap.put(key, getValue(componentInfo.getCurrDayExpCnt()));
            secMap.put(key, getValue(componentInfo.getCurrDayClickCnt()));
            thirdMap.put(key, getValue(componentInfo.getLastSevenDaysExpCnt()));
            fourthMap.put(key, getValue(componentInfo.getLastSevenDaysClickCnt()));
            fifthMap.put(key, getValue(componentInfo.getHisExpCnt()));
            sixthMap.put(key, getValue(componentInfo.getHisClickCnt()));
            splitMap.put(0, firstMap);
            splitMap.put(1, thirdMap);
            splitMap.put(2, fifthMap);
            splitMap.put(3, secMap);
            splitMap.put(4, fourthMap);
            splitMap.put(5, sixthMap);
        }
        return splitMap;
    }

    private static Integer getValue(Integer num) {
        if (num != null) {
            return num;
        }
        return 0;
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {

        String ret = null;
        try {
            // 全局
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String(ubpMap.get(statType).get("0"));


            }
            // 当前广告
            if (dimType == 1 && ubpMap != null) {
                String tag = getTag(tags);

                if (tag != null) {
                    ret = ubpMap.get(statType).get(tag) + "";

                    if (tag.length() == 10 && ret == null) {
                        String sTag = tag.substring(0, 5);
                        ret = DataUtil.Long2String(ubpMap.get(statType).get(sTag));
                    }


                }
            }

            // 其他行业
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String v = entry.getKey() + "_" + entry.getValue() + ",";
                    ret += v;
                }

                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


            //统计计数
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {

                ret = "";
                Map<Long, Long> levelCntMap = new HashMap<>();

//                System.out.println("statType=" + statType);

//                for (long i = 0; i < ctrAndCvrLevelBucket.length + 2; i++) {
//                    levelCntMap.put(i, 0L);
//                }


                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag = entry.getKey();
                    Long ctrLevel = bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel != null && tag != "0") {
                        if (!levelCntMap.containsKey(ctrLevel)) {
                            levelCntMap.put(ctrLevel, 0L);
                        }
                        levelCntMap.put(ctrLevel, levelCntMap.get(ctrLevel) + 1);
//                        System.out.println("entry.getValue()=" + entry.getValue() + ",ctrLevel=" + ctrLevel + ",+1");
                    }
                }

                for (Map.Entry<Long, Long> entry : levelCntMap.entrySet()) {
                    if (entry.getKey() != null && entry.getValue() != null) {

                        Long cntLevel = bucket(entry.getValue(), cntBucket);
//                        System.out.println("entry.getKey()=" + entry.getKey() + "entry.getValue()=" + entry.getValue() + ",cntLevel=" + cntLevel + "+1");
                        String v = entry.getKey() * 100 + cntLevel + ",";
                        ret += v;
                    }

                }


                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static String getTag(String tags) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tags)) {
            String[] tagArr = tags.split(",");
            if (AssertUtil.isNotEmpty(tagArr)) {
                for (int i = 0; i < tagArr.length; i++) {
                    String tmp = validTag(tagArr[i]);
                    if (tmp != null) {
                        ret = validTag(tagArr[i]);
                    }

                }
            }
        }

        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tag)) {
            if (tag.contains(".")) {
                ret = tag;
            }
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds,
                                                                             String uILaunchPv,
                                                                             String uIClickPv,
                                                                             String uIEffectPv) {
        Map<String, Map<String, Long>> ret = new HashMap<>();
        ret.put("ctr", new HashMap<String, Long>());
        ret.put("cvr", new HashMap<String, Long>());
        if (AssertUtil.isAllNotEmpty(uIIds, uILaunchPv, uIClickPv, uIEffectPv)) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");

            if (uIIdsArr.length > 0 &&
                    uIIdsArr.length == uILaunchPvArr.length &&
                    uIIdsArr.length == uIClickPvArr.length &&
                    uIIdsArr.length == uIEffectPvArr.length) {

                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;


                for (int i = 0; i < uIIdsArr.length; i++) {
                    String id = uIIdsArr[i];
//                    System.out.println("uIIdsArr[i]=" + uIIdsArr[i]);
//                    System.out.println("uILaunchPvArr[i]=" + uILaunchPvArr[i]);
//                    System.out.println("uIClickPvArr[i]=" + uIClickPvArr[i]);
//                    System.out.println("uIEffectPvArr[i]=" + uIEffectPvArr[i]);

                    Long launchPv = DataUtil.str2Long(uILaunchPvArr[i], 0L);
                    Long clickPv = DataUtil.str2Long(uIClickPvArr[i], 0L);
                    Long effectPv = DataUtil.str2Long(uIEffectPvArr[i], 0L);

//                    System.out.println("launchPv=" + launchPv);
//                    System.out.println("clickPv=" + clickPv);
//                    System.out.println("effectPv=" + effectPv);

                    Double ctr = getCtrOrCvr(launchPv, clickPv);
                    Double cvr = getCtrOrCvr(clickPv, effectPv);

                    Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                    ret.get("ctr").put(id, ctrBucketLevel);
                    ret.get("cvr").put(id, cvrBucketLevel);

                    launchAccPv += launchPv;
                    clickAccPv += clickPv;
                    effectAccPv += effectPv;

                }
                Double ctr = getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = getCtrOrCvr(clickAccPv, effectAccPv);

                Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                ret.get("ctr").put("0", ctrBucketLevel);
                ret.get("cvr").put("0", cvrBucketLevel);

            }


        }

        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);

        return ret;
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Integer> entry: actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);
                    tmp.add(value);
                }
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cateKey: actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);
                    tmp.add(value);
                }
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    // 行业标签编码
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            put("8",0);
            put( "14",1);
            put( "15",2);
            put( "21",3);
            put( "20",4);
            put( "3",5);
            put( "5",6);
            put( "12",7);
            put( "2",8);
            put( "1",9);
            put( "24",10);
            put( "6",11);
            put( "7",12);
            put( "11",13);
            put( "13",14);
            put( "18",15);
            put( "22",16);
            put( "4",17);
            put( "17",18);
            put( "25",19);
            put( "10",20);
            put( "23",21);
            put( "9",22);
            put( "19",23);
            put( "16",24);
        }
    };

    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数2
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数3
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }
}
