package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import org.slf4j.LoggerFactory;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import java.util.*;

/**
 * Created by pc on 2017/2/17.
 */
public class FeatureParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureParse.class);


    public static int[] dayOrderRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};
    public static int[] orderRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};

    public static int[] dayActOrderRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 9, 20};
    public static int[] orderActRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 50};

    public static int[] orderGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};

    public static int[] orderActGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};

    public static double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public static double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public static double[] userSignRatioBucket = {0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.075, 0.1, 0.125, 0.15, 0.175, 0.20, 0.225, 0.25, 0.275, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};  // 签收率

    public static int[] cntBucket = {0, 1, 3, 5, 10, 15, 20};
    public static int[] bigCntBucket = {0, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000};
    public static int[] ctrAndCvrLevelBucket = {1, 4, 8};
    public static int[] videoDurationBucket = {0, 15, 30, 60, 5 * 60, 10 * 60, 15 * 60, 30 * 60, 45 * 60, 60 * 60, 90 * 60, 120 * 60};
    public static int[] colorRBGBucket = {0, 25, 50, 75, 100, 125, 150, 175, 200, 225};

    public static int[] priceBucket = {0, 5000, 10000, 20000, 50000, 100000, 200000};
    public static int[] totalPriceBucket = {0, 10000, 50000, 100000, 200000, 500000, 1000000};

    public static int[] cateScoreBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};

    public static double[] statCtrBucket = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static double[] statCvrBucket = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static double[] statBCvrBucket = {
            0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009,
            0.01 , 0.011, 0.012, 0.013, 0.014, 0.015, 0.016, 0.017, 0.018, 0.019,
            0.02 , 0.021, 0.022, 0.023, 0.024, 0.025, 0.026, 0.027, 0.028, 0.029,
            0.03 , 0.031, 0.032, 0.033, 0.034, 0.035, 0.036, 0.037, 0.038, 0.039,
            0.04 , 0.041, 0.042, 0.043, 0.044, 0.045, 0.046, 0.047, 0.048, 0.049,
            0.05 , 0.06, 0.07, 0.08, 0.09,
            0.1, 0.12, 0.14, 0.16, 0.18,
            0.2, 0.22, 0.24, 0.26, 0.28,
            0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static double[] cntRatioBucket = {0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};

    public static final int[] cntMeituanBucket = {-1, 1, 2, 3, 4, 5, 10, 20, 30};

    public static final int[] cntMeituanBucket30d = {0, 1, 2, 3, 5, 10, 30, 90};

    public static int[] convertCntBucket = {0, 5, 10, 50, 100, 200, 500, 1000};

    // 行业标签编码
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>() {
        {
            put("8", 0);
            put("14", 1);
            put("15", 2);
            put("21", 3);
            put("20", 4);
            put("3", 5);
            put("5", 6);
            put("12", 7);
            put("2", 8);
            put("1", 9);
            put("24", 10);
            put("6", 11);
            put("7", 12);
            put("11", 13);
            put("13", 14);
            put("18", 15);
            put("22", 16);
            put("4", 17);
            put("17", 18);
            put("25", 19);
            put("10", 20);
            put("23", 21);
            put("9", 22);
            put("19", 23);
            put("16", 24);
        }
    };

    // 落地页标签编码
    public static Map<String, Integer> loadingPageCodes = new HashMap<String, Integer>() {
        {
            put("04.01.0001", 0);
            put("04.01.0002", 1);
            put("04.01.0003", 2);
            put("04.01.0004", 3);
            put("04.01.0005", 4);
            put("04.01.0006", 5);
            put("04.01.0007", 6);
            put("04.01.0008", 7);
            put("04.01.0009", 8);
            put("04.01.0010", 9);
            put("04.02.0001", 10);
            put("04.03.0001", 11);
            put("04.03.0002", 12);
            put("04.03.0003", 13);
            put("04.03.0004", 14);
            put("04.03.0005", 15);
            put("04.03.0007", 16);
            put("04.03.0008", 17);
            put("04.03.0009", 18);
            put("04.03.0010", 19);
            put("04.03.0011", 20);
            put("04.03.0012", 21);
            put("04.03.0013", 22);
            put("04.03.0014", 23);
            put("04.03.0015", 24);
            put("04.03.0017", 25);
            put("04.03.0018", 26);
            put("04.03.0019", 27);
            put("04.03.0020", 28);
            put("04.03.0021", 29);
        }
    };


    // 资源标签编码
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>() {
        {
            put("07.23.0008", 0);
            put("07.23.0019", 1);
            put("07.23.0010", 2);
            put("07.24.0001", 3);
            put("07.23.0013", 4);
            put("07.23.0018", 5);
            put("07.23.0009", 6);
            put("07.23.0030", 7);
            put("07.23.0012", 8);
            put("07.23.0036", 9);
            put("07.23.0021", 10);
        }
    };
    // App类目编码
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
        }
    };
    // 签名类目编码
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
            put("31", 31);
            put("32", 32);
            put("33", 33);
            put("34", 34);
            put("35", 35);
            put("36", 36);
            put("37", 37);
            put("38", 38);
            put("39", 39);
            put("40", 40);
            put("41", 41);
            put("42", 42);
            put("43", 43);
        }
    };
    // 关键词类目编码
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
        }
    };
    // 视频类目编码 videoCate
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>() {
        {
            put("1273152", 0);
            put("1273153", 1);
            put("1273154", 2);
            put("1273155", 3);
            put("1273158", 4);
            put("1273163", 5);
            put("1273166", 6);
            put("1273190", 7);
            put("1273380", 8);
            put("1273399", 9);
            put("1275055", 10);
            put("1275060", 11);
            put("1275378", 12);
            put("1275381", 13);
            put("1275605", 14);
            put("1275609", 15);
            put("1275699", 16);
            put("1275850", 17);
            put("1276159", 18);
            put("1276427", 19);
            put("1277341", 20);
            put("1277350", 21);
            put("1277354", 22);
            put("1277360", 23);
            put("1277373", 24);
            put("1278212", 25);
            put("1279265", 26);
            put("1279863", 27);
            put("1281970", 28);
            put("1281978", 29);
            put("1282468", 30);
            put("1282983", 31);
            put("1283091", 32);
            put("1283242", 33);
            put("1284864", 34);
            put("1284891", 35);
            put("1284979", 36);
            put("1288586", 37);
            put("1289618", 38);
            put("1289633", 39);
            put("1289641", 40);
            put("1289642", 41);
            put("1291079", 42);
            put("1307098", 43);
            put("1307103", 44);
            put("1308055", 45);
            put("1310272", 46);
            put("1310276", 47);
            put("1311366", 48);
            put("1316217", 49);
            put("1323164", 50);
            put("1333414", 51);
            put("1343852", 52);
            put("1345203", 53);
            put("1345206", 54);
            put("1345801", 55);
            put("1347029", 56);
            put("1348464", 57);
            put("1348469", 58);
            put("1348589", 59);
            put("1348767", 60);
            put("1351397", 61);
            put("1362094", 62);
            put("1392855", 63);
            put("1399467", 64);
            put("1457705", 65);
            put("1506926", 66);
            put("1509530", 67);
            put("1652670", 68);
            put("1657117", 69);
            put("1657120", 70);
            put("1786669", 71);
            put("1791134", 72);
            put("1887279", 73);
            put("2289121", 74);
            put("2289182", 75);
            put("2289191", 76);
            put("2289194", 77);
            put("2289198", 78);
            put("2400701", 79);
            put("2422552", 80);
            put("2423962", 81);
            put("2425625", 82);
            put("2454957", 83);
            put("2456790", 84);
            put("2456802", 85);
            put("2456895", 86);
            put("2466968", 87);
            put("2469508", 88);
            put("2485369", 89);
            put("2577550", 90);
            put("2818641", 91);
            put("2820598", 92);
            put("2821045", 93);
            put("2821232", 94);
            put("2821234", 95);
            put("2823069", 96);
            put("2824674", 97);
            put("2825127", 98);
            put("2825132", 99);
            put("2825152", 100);
            put("2825153", 101);
            put("2825156", 102);
            put("2825165", 103);
            put("2825674", 104);
            put("2828097", 105);
            put("2829161", 106);
            put("2829647", 107);
            put("2830002", 108);
            put("2830311", 109);
            put("2830346", 110);
            put("2830613", 111);
            put("2830805", 112);
            put("2831234", 113);
            put("2831373", 114);
            put("2831480", 115);
            put("2832492", 116);
            put("2833635", 117);
            put("2834198", 118);
            put("2834248", 119);
            put("2834252", 120);
            put("2834254", 121);
            put("2834359", 122);
            put("2834697", 123);
            put("2834810", 124);
            put("2834931", 125);
            put("2835040", 126);
            put("2835116", 127);
            put("2835117", 128);
            put("2835164", 129);
            put("2835165", 130);
            put("2835495", 131);
            put("2835521", 132);
            put("2835645", 133);
            put("2835728", 134);
            put("2835738", 135);
            put("2835744", 136);
            put("2836094", 137);
            put("2836607", 138);
            put("2836677", 139);
            put("2837050", 140);
            put("2837679", 141);
            put("2837825", 142);
            put("2838438", 143);
            put("2838626", 144);
            put("2838627", 145);
            put("2838628", 146);
            put("2838680", 147);
            put("2839215", 148);
            put("2839217", 149);
            put("2839264", 150);
            put("2839388", 151);
            put("2840307", 152);
            put("2840460", 153);
            put("2840461", 154);
            put("2840492", 155);
            put("2840499", 156);
            put("2840500", 157);
            put("2840501", 158);
            put("2840502", 159);
            put("2840504", 160);
            put("2840944", 161);
            put("2841365", 162);
            put("2841425", 163);
            put("2841426", 164);
            put("2844458", 165);
            put("2844459", 166);
            put("2844461", 167);
            put("2844477", 168);
            put("2844488", 169);
            put("2844489", 170);
            put("2845047", 171);
            put("2847235", 172);
            put("2847874", 173);
            put("2847916", 174);
            put("2848190", 175);
            put("2848215", 176);
            put("2848229", 177);
            put("2848330", 178);
            put("2849576", 179);
            put("2850987", 180);
            put("2859501", 181);
            put("2859502", 182);
            put("2859503", 183);
            put("2859504", 184);
            put("2859505", 185);
            put("2859506", 186);
            put("2859507", 187);
            put("2859508", 188);
            put("2859509", 189);
            put("2859510", 190);
            put("2859511", 191);
            put("2859512", 192);
            put("2859513", 193);
            put("2859588", 194);
            put("2859785", 195);
            put("2860991", 196);
            put("2860992", 197);
            put("2923465", 198);
            put("2923466", 199);
            put("2924524", 200);
            put("2924526", 201);
            put("2924527", 202);
            put("2924539", 203);
            put("2924541", 204);
            put("2924542", 205);
            put("2924543", 206);
            put("2924965", 207);
            put("2924966", 208);
            put("2924967", 209);
            put("2924968", 210);
            put("2924969", 211);
            put("2924970", 212);
        }
    };
    // 视频频道编码 videoChannel
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>() {
        {
            put("aiqiyi--1", 0);
            put("aiqiyi-0", 1);
            put("aiqiyi-1", 2);
            put("aiqiyi-10", 3);
            put("aiqiyi-11", 4);
            put("aiqiyi-12", 5);
            put("aiqiyi-13", 6);
            put("aiqiyi-14", 7);
            put("aiqiyi-15", 8);
            put("aiqiyi-16", 9);
            put("aiqiyi-17", 10);
            put("aiqiyi-18", 11);
            put("aiqiyi-19", 12);
            put("aiqiyi-2", 13);
            put("aiqiyi-20", 14);
            put("aiqiyi-21", 15);
            put("aiqiyi-22", 16);
            put("aiqiyi-23", 17);
            put("aiqiyi-24", 18);
            put("aiqiyi-25", 19);
            put("aiqiyi-26", 20);
            put("aiqiyi-27", 21);
            put("aiqiyi-28", 22);
            put("aiqiyi-29", 23);
            put("aiqiyi-3", 24);
            put("aiqiyi-30", 25);
            put("aiqiyi-30003", 26);
            put("aiqiyi-30005", 27);
            put("aiqiyi-30008", 28);
            put("aiqiyi-30010", 29);
            put("aiqiyi-31", 30);
            put("aiqiyi-32", 31);
            put("aiqiyi-33", 32);
            put("aiqiyi-34", 33);
            put("aiqiyi-4", 34);
            put("aiqiyi-40004", 35);
            put("aiqiyi-49999", 36);
            put("aiqiyi-5", 37);
            put("aiqiyi-6", 38);
            put("aiqiyi-7", 39);
            put("aiqiyi-8", 40);
            put("aiqiyi-9", 41);
            put("aiqiyi-97", 42);
            put("aiqiyi-99", 43);
            put("mango-0", 44);
            put("mango-1", 45);
            put("mango-105", 46);
            put("mango-111", 47);
            put("mango-116", 48);
            put("mango-117", 49);
            put("mango-120", 50);
            put("mango-2", 51);
            put("mango-20", 52);
            put("mango-3", 53);
            put("mango-50", 54);
        }
    };
    // 颜色编码
    public static Map<String, Integer> colorCodes = new HashMap<String, Integer>() {
        {
            put("color0_r", 0);
            put("color0_g", 1);
            put("color0_b", 2);
            put("color1_r", 3);
            put("color1_g", 4);
            put("color1_b", 5);
            put("color2_r", 6);
            put("color2_g", 7);
            put("color2_b", 8);
        }
    };
    // 广告主编码
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>() {
        {
            put("18125", 0);
            put("18943", 1);
            put("22005", 2);
            put("21563", 3);
            put("17196", 4);
            put("29815", 5);
            put("27419", 6);
            put("25874", 7);
            put("30539", 8);
            put("27295", 9);
            put("30037", 10);
            put("24035", 11);
            put("23882", 12);
            put("29932", 13);
            put("19317", 14);
            put("10971", 15);
            put("27486", 16);
            put("12311", 17);
            put("22597", 18);
            put("21330", 19);
            put("26598", 20);
            put("30371", 21);
            put("19941", 22);
            put("27605", 23);
            put("17270", 24);
            put("12234", 25);
            put("17878", 26);
            put("28257", 27);
            put("30632", 28);
            put("25991", 29);
            put("30701", 30);
            put("30336", 31);
            put("12796", 32);
            put("29379", 33);
            put("30495", 34);
            put("29758", 35);
            put("19316", 36);
            put("14355", 37);
            put("29001", 38);
            put("30126", 39);
            put("30892", 40);
            put("26320", 41);
            put("18489", 42);
            put("14164", 43);
            put("24696", 44);
            put("28941", 45);
            put("30511", 46);
            put("5713", 47);
            put("30928", 48);
            put("19761", 49);
            put("30592", 50);
            put("30081", 51);
            put("28769", 52);
            put("29788", 53);
            put("21133", 54);
            put("30679", 55);
            put("30393", 56);
            put("26323", 57);
            put("29336", 58);
            put("29935", 59);
            put("29030", 60);
            put("26550", 61);
            put("30394", 62);
            put("30823", 63);
            put("28466", 64);
            put("8340", 65);
            put("30460", 66);
            put("30739", 67);
            put("26048", 68);
            put("30765", 69);
            put("30596", 70);
            put("25809", 71);
            put("30808", 72);
            put("30605", 73);
            put("27165", 74);
            put("30868", 75);
            put("30518", 76);
            put("29408", 77);
            put("30601", 78);
            put("30900", 79);
            put("25984", 80);
            put("27568", 81);
            put("23937", 82);
            put("15334", 83);
            put("30345", 84);
            put("26595", 85);
            put("8154", 86);
            put("28264", 87);
            put("30848", 88);
            put("13566", 89);
            put("26726", 90);
            put("8302", 91);
            put("29406", 92);
            put("16315", 93);
            put("30625", 94);
            put("20619", 95);
            put("28528", 96);
            put("30253", 97);
            put("29808", 98);
            put("30809", 99);
            put("6286", 100);
            put("22757", 101);
            put("9876", 102);
            put("24779", 103);
            put("25806", 104);
            put("30929", 105);
            put("30956", 106);
            put("30691", 107);
            put("29706", 108);
            put("29651", 109);
            put("30438", 110);
            put("27911", 111);
            put("30493", 112);
            put("29519", 113);
            put("30220", 114);
            put("30812", 115);
            put("27684", 116);
            put("30636", 117);
            put("17638", 118);
            put("28594", 119);
            put("29558", 120);
            put("27463", 121);
            put("28925", 122);
            put("28420", 123);
            put("30099", 124);
            put("28523", 125);
            put("30688", 126);
            put("28432", 127);
            put("18028", 128);
            put("6209", 129);
            put("30783", 130);
            put("22412", 131);
            put("30684", 132);
            put("30621", 133);
            put("30734", 134);
            put("30807", 135);
            put("30794", 136);
            put("28180", 137);
            put("28544", 138);
            put("30186", 139);
            put("24090", 140);
            put("30111", 141);
            put("8657", 142);
            put("23977", 143);
            put("29491", 144);
            put("30327", 145);
            put("30249", 146);
            put("23461", 147);
            put("28597", 148);
            put("30498", 149);
            put("30109", 150);
            put("30279", 151);
            put("30100", 152);
            put("30732", 153);
            put("23031", 154);
            put("30497", 155);
            put("25886", 156);
            put("27453", 157);
            put("29845", 158);
            put("30378", 159);
            put("30257", 160);
            put("28881", 161);
            put("27241", 162);
            put("30219", 163);
            put("22006", 164);
            put("30217", 165);
            put("25215", 166);
            put("19217", 167);
            put("28515", 168);
            put("30185", 169);
            put("29858", 170);
            put("27452", 171);
            put("18089", 172);
            put("30411", 173);
            put("26151", 174);
            put("29699", 175);
            put("29889", 176);
            put("30573", 177);
            put("30017", 178);
            put("2292", 179);
            put("29427", 180);
            put("30560", 181);
            put("30626", 182);
            put("28628", 183);
            put("29534", 184);
            put("30515", 185);
            put("30023", 186);
            put("30374", 187);
            put("21271", 188);
            put("27321", 189);
            put("30290", 190);
            put("28643", 191);
            put("14356", 192);
            put("23880", 193);
            put("30836", 194);
            put("30569", 195);
            put("29900", 196);
            put("29879", 197);
            put("30499", 198);
            put("29894", 199);
            put("28970", 200);
            put("21944", 201);
            put("30705", 202);
            put("30187", 203);
            put("28503", 204);
            put("29028", 205);
            put("30128", 206);
            put("30182", 207);
            put("30237", 208);
            put("29448", 209);
            put("30825", 210);
            put("27884", 211);
            put("27932", 212);
            put("30704", 213);
            put("30695", 214);
            put("30461", 215);
            put("30218", 216);
            put("29862", 217);
            put("25509", 218);
            put("30329", 219);
            put("26077", 220);
            put("25495", 221);
            put("30115", 222);
            put("27002", 223);
            put("30935", 224);
            put("23469", 225);
            put("30331", 226);
            put("30188", 227);
            put("24296", 228);
            put("22042", 229);
            put("7962", 230);
            put("323", 231);
            put("30272", 232);
            put("18071", 233);
            put("18072", 234);
            put("8220", 235);
            put("8331", 236);
            put("23680", 237);
            put("6419", 238);
        }
    };
    // 价格区间编码
    public static Map<String, Integer> priceCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            retMap = FeatureParse2.generateFeatureMapStatic(cf);
        } catch (Exception e) {
            logger.error("FeatureParse.FeatureParse2 static error", e);
        }

        return retMap;
    }


//    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, Map<String, String> retMap) {
//
//        boolean ret = false;
//        try {
//            if (cf != null) {
//                generateFeatureMapDynamic(cf, cf);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return retMap;
//    }


    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);

        try {
            retMap = FeatureParse2.generateFeatureMapDynamic(cf,staticCf);
        } catch (Exception e) {
            logger.error("FeatureParse.FeatureParse2 error", e);
        }
        return retMap;
    }


//    public static Map<String, String> getFeatureMap(FeatureDo cf) {
//
//        Map<String, String> retMap = new HashMap<>();
//        try {
//            generateFeatureMapStatic(cf);
//            generateFeatureMapDynamic(cf, retMap);
//
//        } catch (Exception e) {
//
//            e.printStackTrace();
//        }
//
//        return retMap;
//    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<>();
        map.put("a", "b");
        System.out.println(getValueSafety("a", map));

        HashMap<String, String> m = null;
        System.out.println(getValueSafety(null, map));
    }

    public static <T> String setJoin(Set<T> set, String sep) {
        if (AssertUtil.isAnyEmpty(set, sep)) {
            return null;
        }

        StringBuilder res = new StringBuilder();
        for (T s : set) {
            res.append(s).append(sep);
        }

        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }

        return res.toString();
    }


    public static <T> String userBehaviourCross(String exposeTopTarget, Set<T> behaviour) {

        String res = null;

        if (exposeTopTarget != null && exposeTopTarget.length() > 0 && behaviour != null && behaviour.size() > 0) {
            StringBuilder sb = new StringBuilder();

            for (T advert : behaviour) {
                if (advert != null && advert.toString().trim().length() > 0) {
                    sb.append(advert).append("_").append(exposeTopTarget).append(",");
                }
            }

            if (sb.length() > 0) {
                res = sb.substring(0, sb.length() - 1);
            }
        }

        return res;
    }

    public static String getOperatorBrandMatch(String operator, String brand, String trade) {
        // 仅在运营商行业下判断
        if (trade != null && trade.equals("16")) {
            if (operator == null || brand == null) {
                return "0";
            } else if (operator.equals(brand)) {
                return "1";
            } else {
                return "2";
            }
        } else {
            return "4";
        }
    }

    public static String getOperatorName(String op) {
        if (op == null) {
            return "未知";
        } else if (op.equals("1")) {
            return "移动";
        } else if (op.equals("2")) {
            return "联通";
        } else if (op.equals("3")) {
            return "电信";
        } else {
            return "未知";
        }
    }

    public static String advertTagConcat(String sep, String ... tags) {
        StringBuilder res = new StringBuilder();

        for (String tag : tags) {
            if (tag != null && tag.trim().length() > 0 && !tag.trim().equals("null")) {
                res.append(tag).append(sep);
            }
        }

        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }

        return res.toString();
    }


    public static String getAdAndSubType(Long advertId, String subType) {
        String ret = null;

        if (advertId != null) {
            Long retTmp = advertId + (getSubType(subType) + 1) * 1000000;
            ret = retTmp + "";
        }
        return ret;
    }

    public static Long getSubType(String subType) {
        Long ret = 0L;
        if (subType != null) {
            ret = Long.valueOf(subType);
        }

        return ret;
    }

    public static Long getCtrIntervelLevel(Double ctr) {

        Long ret = null;

        if (ctr == null) {
            ret = -1L;
        } else if (ctr <= 0.999) {
            ret = Math.round((ctr * 100) / 3);
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {

        Long ret = null;


        if (cvr == null) {
            ret = -1L;
        } else if (cvr <= 0.04) {
            ret = Math.round((cvr * 1000) / 4);
        } else if (cvr <= 0.999) {
            ret = 11 + Math.round(((cvr - 0.04) * 100) / 3);
        } else {
            ret = -1L;
        }
        return ret;
    }


    /**
     * @param date      新时间 大
     * @param otherDate 旧时间 小
     * @return
     */
    public static Long getOrderGmtIntervel(String date, String otherDate) {

        return LocalDateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);


    }


    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {

        Long ret = null;
        Long minutes = LocalDateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);

        if (minutes == null) {
            ret = -1L;
        } else if (minutes <= 5) {
            ret = 1L;
        } else if (minutes <= 10) {
            ret = 2L;
        } else if (minutes <= 30) {
            ret = 3L;
        } else if (minutes <= 60) {
            ret = 4L;
        } else {
            ret = 99L;
        }
        return ret;

    }

    public static Long getDayRankLevel(Long rank) {

        Long ret = null;
        if (rank == null) {
            ret = null;
        } else if (rank <= 7) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }


    public static Long getRankLevel(Long rank) {

        Long ret = null;
        if (rank == null) {
            ret = null;
        } else if (rank <= 15) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {

        Long ret = null;
        if (chargeNums == null || chargeNums < 1) {
            ret = 0L;
        } else {
            ret = 1L;
        }
        return ret;
    }

    public static Long getMatchStatus(String s1, String s2) {
        if (s1 == null) {
            return 0L;
        } else if (!s1.equals(s2)) {
            return 1L;
        } else {
            return 2L;
        }
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {

        Long ret = null;
        if (operatingActivityId == null || lastOperatingActivityId == null) {
            ret = 0L;
        } else if (operatingActivityId.equals(lastOperatingActivityId)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }


    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {

        Long ret = null;
        if (matchTagNums == null || lastMatchTagNums == null) {
            ret = 0L;
        } else if (matchTagNums.equals(lastMatchTagNums)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }

    /**
     * 是否大于1天
     *
     * @param userLastlogbigintime
     * @param userRegtime
     * @return
     */
    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long ret = (long) 0;

        if (AssertUtil.isAllNotEmpty(userLastlogbigintime, userRegtime)) {
            Long dayIntervals = LocalDateUtil.getIntervalDays(userLastlogbigintime, userRegtime);
            if (dayIntervals != null) {
                ret = dayIntervals > 1 ? (long) 1 : (long) 0;
            }
        }

        return ret;

    }


    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0) {
            ret = (long) (new Double(Math.ceil((price + 0.000001) / (cost))).intValue());
        }
        return ret;

    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0) {
            ret = (long) (new Double(Math.ceil(log(lvalue.doubleValue(), 2 / 0))).intValue());
        }
        return ret;

    }

    public static <K, V> V getValueSafety(K key, Map<K, V> map) {
        if (AssertUtil.isAnyEmpty(key, map)) {
            return null;
        }

        return map.get(key);
    }

    public static Map<String, Long> getMap(String keyList, String valueList) {
        HashMap<String, Long> resMap = new HashMap<>();

        if (AssertUtil.isAnyEmpty(keyList, valueList)) {
            return resMap;
        }

        String[] keys = keyList.split(",");
        String[] values = valueList.split(",");

        if (keys.length != values.length) {
            return resMap;
        }

        for (int i = 0; i < keys.length; i ++) {
            Long value = null;
            try {
                value = Long.parseLong(values[i]);
            } catch (NumberFormatException e) {
                continue;
            }
            resMap.put(keys[i], value);
        }

        return resMap;
    }


    public static String getLevel(String key, String idlist, String valueList) {
        String s = "";

        if ((idlist == null || valueList == null) || (idlist.isEmpty() || valueList.isEmpty())) {
            return null;
        }
        String idArr[] = idlist.split(",");
        String valueArr[] = valueList.split(",");
        if (idArr.length != valueArr.length) {
            return null;
        }

        for (int i = 0; i < idArr.length; ++i) {

            double value = 0;
            try {
                value = Double.parseDouble(valueArr[i]);
            } catch (NumberFormatException e) {
                continue;
            } catch (NullPointerException e) {
                continue;
            }
            s += idArr[i] + "&" + String.valueOf(discretization(key, value)) + ",";


        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;

    }

    public static int discretization(String key, double value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv":
                if (value > -100000000 & value <= 0) class_id = 1;
                else if (value > 0 & value <= 1) class_id = 2;
                else if (value > 1 & value <= 2) class_id = 3;
                else if (value > 2 & value <= 3) class_id = 4;
                else if (value > 3 & value <= 4) class_id = 5;
                else if (value > 4 & value <= 5) class_id = 6;
                else if (value > 5 & value <= 6) class_id = 7;
                else if (value > 6 & value <= 7) class_id = 8;
                else if (value > 7 & value <= 18) class_id = 9;
                else if (value > 18 & value <= 50) class_id = 10;
                else if (value > 50 & value <= 150) class_id = 11;
                else if (value > 150 & value <= 300) class_id = 12;
                else class_id = 13;
                break;
            case "click_pv":
                if (value > -100000000 & value <= 0) class_id = 1;
                else if (value > 0 & value <= 1) class_id = 2;
                else if (value > 2 & value <= 3) class_id = 3;
                else if (value > 3 & value <= 4) class_id = 4;
                else if (value > 4 & value <= 5) class_id = 5;
                else if (value > 5 & value <= 6) class_id = 6;
                else if (value > 6 & value <= 8) class_id = 7;
                else if (value > 8 & value <= 15) class_id = 8;
                else if (value > 15 & value <= 80) class_id = 9;
                else if (value > 80 & value <= 225) class_id = 10;
                else class_id = 11;
                break;
            case "effect_pv":
                if (value > -100000000 & value <= 0) class_id = 1;
                else if (value > 0 & value <= 1) class_id = 2;
                else if (value > 1 & value <= 2) class_id = 3;
                else if (value > 2 & value <= 3) class_id = 4;
                else if (value > 4 & value <= 15.0) class_id = 5;
                else if (value > 15.0 & value <= 25) class_id = 6;
                else if (value > 25.0 & value <= 70) class_id = 7;
                else if (value > 70 & value <= 150) class_id = 8;
                else if (value > 150 & value <= 225) class_id = 9;
                else class_id = 10;
                break;
            case "score":
                if (value > -100000000 & value <= -471) class_id = 1;
                else if (value > -471 & value <= -331) class_id = 2;
                else if (value > -331 & value <= -168) class_id = 3;
                else if (value > -168 & value <= -52) class_id = 4;
                else if (value > -52 & value <= -19) class_id = 5;
                else if (value > -19 & value <= -8) class_id = 6;
                else if (value > -8 & value <= -4) class_id = 7;
                else if (value > -4 & value <= 1) class_id = 8;
                else if (value > 1 & value <= 2) class_id = 9;
                else if (value > 2 & value <= 17) class_id = 10;
                else if (value > 17 & value <= 42) class_id = 11;
                else if (value > 42 & value <= 73) class_id = 12;
                else if (value > 73 & value <= 126) class_id = 13;
                else if (value > 126 & value <= 284) class_id = 14;
                else class_id = 15;
                break;

        }
        return class_id;
    }


    /**
     * 用户行为数据解析
     *
     * @return
     */
    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {

        String ret = null;
        try {
            // 全局
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String(ubpMap.get(statType).get("0"));


            }
            // 当前广告
            if (dimType == 1 && ubpMap != null) {
                String tag = getTag(tags);

                if (tag != null) {
                    ret = ubpMap.get(statType).get(tag) + "";

                    if (tag.length() == 10 && ret == null) {
                        String sTag = tag.substring(0, 5);
                        ret = DataUtil.Long2String(ubpMap.get(statType).get(sTag));
                    }


                }
            }

            // 其他行业
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String v = entry.getKey() + "_" + entry.getValue() + ",";
                    ret += v;
                }

                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


            //统计计数
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {

                ret = "";
                Map<Long, Long> levelCntMap = new HashMap<>();

//                System.out.println("statType=" + statType);

//                for (long i = 0; i < ctrAndCvrLevelBucket.length + 2; i++) {
//                    levelCntMap.put(i, 0L);
//                }


                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag = entry.getKey();
                    Long ctrLevel = bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel != null && tag != "0") {
                        if (!levelCntMap.containsKey(ctrLevel)) {
                            levelCntMap.put(ctrLevel, 0L);
                        }
                        levelCntMap.put(ctrLevel, levelCntMap.get(ctrLevel) + 1);
//                        System.out.println("entry.getValue()=" + entry.getValue() + ",ctrLevel=" + ctrLevel + ",+1");
                    }
                }

                for (Map.Entry<Long, Long> entry : levelCntMap.entrySet()) {
                    if (entry.getKey() != null && entry.getValue() != null) {

                        Long cntLevel = bucket(entry.getValue(), cntBucket);
//                        System.out.println("entry.getKey()=" + entry.getKey() + "entry.getValue()=" + entry.getValue() + ",cntLevel=" + cntLevel + "+1");
                        String v = entry.getKey() * 100 + cntLevel + ",";
                        ret += v;
                    }

                }


                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static String getTag(String tags) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tags)) {
            String[] tagArr = tags.split(",");
            if (AssertUtil.isNotEmpty(tagArr)) {
                for (int i = 0; i < tagArr.length; i++) {
                    String tmp = validTag(tagArr[i]);
                    if (tmp != null) {
                        ret = validTag(tagArr[i]);
                    }

                }
            }
        }

        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tag)) {
            if (tag.contains(".")) {
                ret = tag;
            }
        }
        return ret;
    }


    /**
     * 用户行为数据解析
     *
     * @param uIIds
     * @param uILaunchPv
     * @param uIClickPv
     * @param uIEffectPv
     * @return
     */
    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds,
                                                                             String uILaunchPv,
                                                                             String uIClickPv,
                                                                             String uIEffectPv) {
        Map<String, Map<String, Long>> ret = new HashMap<>();
        ret.put("ctr", new HashMap<String, Long>());
        ret.put("cvr", new HashMap<String, Long>());
        if (AssertUtil.isAllNotEmpty(uIIds, uILaunchPv, uIClickPv, uIEffectPv)) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");

            if (uIIdsArr.length > 0 &&
                    uIIdsArr.length == uILaunchPvArr.length &&
                    uIIdsArr.length == uIClickPvArr.length &&
                    uIIdsArr.length == uIEffectPvArr.length) {

                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;


                for (int i = 0; i < uIIdsArr.length; i++) {
                    String id = uIIdsArr[i];
//                    System.out.println("uIIdsArr[i]=" + uIIdsArr[i]);
//                    System.out.println("uILaunchPvArr[i]=" + uILaunchPvArr[i]);
//                    System.out.println("uIClickPvArr[i]=" + uIClickPvArr[i]);
//                    System.out.println("uIEffectPvArr[i]=" + uIEffectPvArr[i]);

                    Long launchPv = DataUtil.str2Long(uILaunchPvArr[i], 0L);
                    Long clickPv = DataUtil.str2Long(uIClickPvArr[i], 0L);
                    Long effectPv = DataUtil.str2Long(uIEffectPvArr[i], 0L);

//                    System.out.println("launchPv=" + launchPv);
//                    System.out.println("clickPv=" + clickPv);
//                    System.out.println("effectPv=" + effectPv);

                    Double ctr = getCtrOrCvr(launchPv, clickPv);
                    Double cvr = getCtrOrCvr(clickPv, effectPv);

                    Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                    ret.get("ctr").put(id, ctrBucketLevel);
                    ret.get("cvr").put(id, cvrBucketLevel);

                    launchAccPv += launchPv;
                    clickAccPv += clickPv;
                    effectAccPv += effectPv;

                }
                Double ctr = getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = getCtrOrCvr(clickAccPv, effectAccPv);

                Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                ret.get("ctr").put("0", ctrBucketLevel);
                ret.get("cvr").put("0", cvrBucketLevel);// ret = {"ctr":{"0":ctr_level, "trade1":ctr_level..}, {"cvr":{"0":cvr_level, "trade1":.. }}}

            }


        }

        return ret;
    }


    /**
     * @param firstPv  分母 非空
     * @param secondPv 分子 非空
     * @return
     */
    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);

        return ret;
    }

    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数2
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    public static Long bucketBSearch(Double value, double[] arr) {
        if (value == null || arr == null || arr.length == 0) {
            return 0L;
        }

        int low = 0;
        int high = arr.length - 1;

        if (value > arr[arr.length - 1]) {
            return (long) arr.length + 1;
        }

        while (low <= high) {
            int mid = low + ((high - low) >> 1);

            if (arr[mid] >=  value) {
                if (mid == 0 || arr[mid - 1] < value) {
                    return (long) mid + 1;
                } else {
                    high = mid - 1;
                }
            } else {
                low = mid + 1;
            }
        }

        return 0L;
    }

    public static <T> Map<T, Long> mapBucket(Map<T, Double> map, double[] bucketList) {
        if (AssertUtil.isAnyEmpty(map, bucketList)) {
            return null;
        }

        HashMap<T, Long> resMap = new HashMap<>();

        for (Map.Entry<T, Double> entry : map.entrySet()) {
            resMap.put(entry.getKey(), bucketBSearch(entry.getValue(), bucketList));
        }

        return resMap;
    }

    /**
     * 分桶函数3
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }


    // 20180815 广告位尺寸类型
    public static String getSlotAreaType(Integer slotLength, Integer slotWidth) {
        int ret1 = 12;
        if (slotLength == null || slotWidth == null) {
            return String.valueOf(ret1);
        }
        try {
            Integer area = slotLength * slotWidth;

            if (area >= 0 && area <= 500000) {
                ret1 = (int) (area / 50000);
            }
            if (area > 500000 && area != null) {
                ret1 = 11;
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return String.valueOf(ret1);

    }


    /**
     * @param categoryCount
     * @param categoryType
     * @return
     */
    public static String categoryIdAndCnt(Map<String, Long> categoryCount, Integer categoryType) {
        String ret1 = null;
        if (categoryCount == null) {
            return ret1;
        }

        if (categoryType == 1) {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    if (value >= 1 && value <= 3) {
                        valueRet = "g1";
                    } else if (value >= 4 && value <= 10) {
                        valueRet = "g2";
                    } else if (value >= 11 && value <= 20) {
                        valueRet = "g3";
                    } else {
                        valueRet = "g4";
                    }
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        } else {

            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    if (value == 1) {
                        valueRet = "g1";
                    } else if (value == 2 || value == 3) {
                        valueRet = "g2";
                    } else if (value >= 4 && value <= 8) {
                        valueRet = "g3";
                    } else {
                        valueRet = "g4";
                    }
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
        return ret1;
    }


    //20190123
    //计算用户当日该资源下发券次序(分桶)f770102
    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long ret = null;
        if (operatingResource == null || dayResourceOrderRank == null) {
            ret = null;
        } else {
            Long rank = dayResourceOrderRank.get(operatingResource);
            if (rank == null || rank < 1) {
                ret = 1L;
            } else if (rank <= 7) {
                ret = rank + 1;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }

    // 计算用户该资源当前单与前一单时间差（分桶）f770202
    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource);
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
//                Date date = DateUtil.StringToDate(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                if (date == null) {
//                    return null;
//                }
//                Long timeStamp = date.getTime();

                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                if (seconds == null) {
                    ret = -1L;
                } else if (seconds <= 5) {
                    ret = 1L;
                } else if (seconds <= 10) {
                    ret = 2L;
                } else if (seconds <= 30) {
                    ret = 3L;
                } else if (seconds <= 60) {
                    ret = 4L;
                } else if (seconds <= 5 * 60) {
                    ret = 5L;
                } else if (seconds <= 10 * 60) {
                    ret = 6L;
                } else if (seconds <= 30 * 60) {
                    ret = 7L;
                } else if (seconds <= 60 * 60) {
                    ret = 8L;
                } else if (seconds <= 5 * 60 * 60) {
                    ret = 9L;
                } else if (seconds <= 10 * 60 * 60) {
                    ret = 10L;
                } else if (seconds <= 15 * 60 * 60) {
                    ret = 11L;
                } else if (seconds <= 20 * 60 * 60) {
                    ret = 12L;
                } else if (seconds <= 24 * 60 * 60) {
                    ret = 13L;
                } else if (seconds <= 36 * 60 * 60) {
                    ret = 14L;
                } else if (seconds <= 48 * 60 * 60) {
                    ret = 15L;
                } else {
                    ret = 99L;
                }
            }
        }
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevelOneId(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource);
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
//                Date date = DateUtil.StringToDate(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                if (date == null) {
//                    return null;
//                }
//                Long timeStamp = date.getTime();

                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                Long otherTimeStamp = LocalDateUtil.getTimeMillis(lastGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                if (seconds == null) {
                    ret = -1L;
                } else if (seconds <= 5) {
                    ret = 1L;
                } else if (seconds <= 10) {
                    ret = 2L;
                } else if (seconds <= 30) {
                    ret = 3L;
                } else if (seconds <= 60) {
                    ret = 4L;
                } else if (seconds <= 5 * 60) {
                    ret = 5L;
                } else if (seconds <= 10 * 60) {
                    ret = 6L;
                } else if (seconds <= 30 * 60) {
                    ret = 7L;
                } else if (seconds <= 60 * 60) {
                    ret = 8L;
                } else if (seconds <= 5 * 60 * 60) {
                    ret = 9L;
                } else if (seconds <= 10 * 60 * 60) {
                    ret = 10L;
                } else if (seconds <= 15 * 60 * 60) {
                    ret = 11L;
                } else if (seconds <= 20 * 60 * 60) {
                    ret = 12L;
                } else if (seconds <= 24 * 60 * 60) {
                    ret = 13L;
                } else if (seconds <= 36 * 60 * 60) {
                    ret = 14L;
                } else if (seconds <= 48 * 60 * 60) {
                    ret = 15L;
                } else {
                    ret = 99L;
                }
            }
        }
        return ret;
    }

    // 用户该资源前一单是否计费 f770301
    public static Long getResourceLastOrderIsClick(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastClickOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastClickOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastClickOrderId = resourceLastClickOrderId.get(operatingResource + "-770301_2");

            if (lastLaunchOrderId == null) {
                ret = null;
            } else {
                if (lastClickOrderId == null) {
                    ret = 0L;
                } else {
                    if (lastLaunchOrderId.equals(lastClickOrderId)) {
                        ret = 1L;
                    } else {
                        ret = 0L;
                    }
                }
            }
        }
        return ret;
    }

    // 用户该资源前一单是否转化 f770302
    public static Long getResourceLastOrderIsConvert(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastConvertOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastConvertOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastConvertOrderId = resourceLastConvertOrderId.get(operatingResource + "-770301_3");

            if (lastLaunchOrderId == null) {
                ret = null;
            } else {
                if (lastConvertOrderId == null) {
                    ret = 0L;
                } else {
                    if (lastLaunchOrderId.equals(lastConvertOrderId)) {
                        ret = 1L;
                    } else {
                        ret = 0L;
                    }
                }
            }
        }
        return ret;
    }

    //当日用户该资源累计点击数 f770401
    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long ret = null;
        if (operatingResource == null || dayResourceChargeCnt == null) {
            ret = null;
        } else {
            Long cnt = dayResourceChargeCnt.get(operatingResource);
            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= 7) {
                ret = cnt;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }

    //当日用户该资源累计转化数 f770402
    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long ret = null;
        if (operatingResource == null || dayResourceConvertCnt == null) {
            ret = null;
        } else {
            Long cnt = dayResourceConvertCnt.get(operatingResource);
            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= 7) {
                ret = cnt;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }

    //计算用户当前单与前一单资源是否相同f770501
    public static Long getLastResourceEqualStatus(String operatingResource, String lastOperatingResource) {
        Long ret = null;
        if (operatingResource == null && lastOperatingResource == null) {
            ret = null;

        } else if (operatingResource != null && lastOperatingResource != null) {
            if (operatingResource.equals(lastOperatingResource)) {
                ret = 1L;
            } else {
                ret = 0L;
            }

        } else {
            ret = 0L;
        }
        return ret;
    }


    //20190507
    //计算用户当日该综合行业下发券次序(分桶) f660102
    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty(operatingNewTrade, newTradeDayOrderRank)) {
            Long rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
            if (rank == null || rank < 1) {
                ret = 1L;
            } else if (rank <= 7) {
                ret = rank + 1;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }

    //计算用户当前单与前一单的综合行业是否相同 f660201
    public static Long getLastNewTradeEqualStatus(String operatingNewTrade, String lastOperatingNewTrade) {
        Long ret = 0L;
        if (AssertUtil.isAllEmpty(operatingNewTrade, lastOperatingNewTrade)) {
            ret = null;
        } else if (AssertUtil.isAllNotEmpty(operatingNewTrade, lastOperatingNewTrade)) {
            if (operatingNewTrade.equals(lastOperatingNewTrade)) {
                ret = 1L;
            } else {
                ret = 0L;
            }
        }
        return ret;
    }

    //计算用户当日该综合行业前后单时间差（分桶）f660302
    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty(operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime)) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);

                if (AssertUtil.isAnyEmpty(timeStamp, otherTimeStamp)) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                if (seconds == null) {
                    ret = -1L;
                } else if (seconds <= 5) {
                    ret = 1L;
                } else if (seconds <= 10) {
                    ret = 2L;
                } else if (seconds <= 30) {
                    ret = 3L;
                } else if (seconds <= 60) {
                    ret = 4L;
                } else if (seconds <= 5 * 60) {
                    ret = 5L;
                } else if (seconds <= 10 * 60) {
                    ret = 6L;
                } else if (seconds <= 30 * 60) {
                    ret = 7L;
                } else if (seconds <= 60 * 60) {
                    ret = 8L;
                } else if (seconds <= 5 * 60 * 60) {
                    ret = 9L;
                } else if (seconds <= 10 * 60 * 60) {
                    ret = 10L;
                } else if (seconds <= 15 * 60 * 60) {
                    ret = 11L;
                } else if (seconds <= 20 * 60 * 60) {
                    ret = 12L;
                } else if (seconds <= 24 * 60 * 60) {
                    ret = 13L;
                } else {
                    ret = 99L;
                }
            }
        }
        return ret;
    }


    /**
     * @param firstMap           分母
     * @param secondMap          分子
     * @param statCtrOrCvrBucket 分桶
     * @return
     */
    public static String getCtrOrCvrInKey(Map<String, Long> firstMap,
                                          Map<String, Long> secondMap,
                                          double[] statCtrOrCvrBucket) {
        String ret = null;
        try {

            if (AssertUtil.isNotEmpty(firstMap)) {

                for (Map.Entry<String, Long> entry : firstMap.entrySet()) {
                    String key = entry.getKey();

                    if (key != null) {
                        Long firstPv = entry.getValue();
                        if (firstPv == null) {
                            firstPv = 0L;
                        }

                        Long secondPv = 0L;
                        if (AssertUtil.isNotEmpty(secondMap)) {
                            secondPv = secondMap.getOrDefault(key, 0L);
                        }

                        Double value = getCtrOrCvr(firstPv, secondPv);
                        Long valueLevel = bucket(value, statCtrOrCvrBucket);

                        String tmpRet = key + "&" + DataUtil.Long2String(valueLevel);
                        ret = ret + "," + tmpRet;
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    //计算媒体/媒体行业在不同广告行业上的ctr,cvr(分桶)
    public static String getStatInNewTrade(String statType,
                                           Map<String, Map<String, Long>> newTradeMap) {

        String ret = null;
        try {

            if (AssertUtil.isNotEmpty(newTradeMap)) {
                Map<String, Long> launchMap = newTradeMap.get("launch");
                Map<String, Long> clickMap = newTradeMap.get("click");
                Map<String, Long> effectMap = newTradeMap.get("effect");

                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }

                } else if (statType == "cvr") {
                    if (AssertUtil.isNotEmpty(clickMap)) {
                        ret = getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    //计算广告/广告行业在不同媒体行业上的ctr,cvr(分桶)
    public static String getStatInAppTag(String statType,
                                         Map<String, Map<String, Long>> appTagMap) {

        String ret = null;
        try {

            if (AssertUtil.isNotEmpty(appTagMap)) {
                Map<String, Long> launchMap = appTagMap.get("launch");
                Map<String, Long> clickMap = appTagMap.get("click");
                Map<String, Long> effectMap = appTagMap.get("effect");

                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }

                } else if (statType == "cvr") {
                    if (AssertUtil.isNotEmpty(clickMap)) {
                        ret = getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    // 20191023特征交叉
    public static String getCrossFeature(String ids, String id0) {
        String ret = null;

        if (ids == null || "".equals(ids) || " ".equals(ids) || ",".equals(ids) || id0 == null || "".equals(id0) || " ".equals(id0)) {
            ret = "null";
        } else {
            List<String> crossFeature = new ArrayList<String>();
            try {
                for (String id : ids.split(",")) {
                    if (id == "" || id == " ") {
                        continue;
//                        return "null";
                    } else {
                        crossFeature.add(id + "_" + id0);
                    }
                }
                if (crossFeature.size() > 0) {
                    ret = Joiner.on(",").skipNulls().join(crossFeature);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (ret == null || ret == "" || ret == " " || ret == ",") {
            ret = "null";
        }

        if (!ret.equalsIgnoreCase("null")) {
            ret = "null," + ret;
        }
        return ret;

    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (String cateKey : actMap.keySet()) {
                Integer cateValue = actMap.getIntValue(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }

    }


    // 根据行业发券数量，区分新老用户
    public static String getUserCategoryLaunchTrade(JSONObject actMap, String category) {

        if (AssertUtil.isAnyEmpty(actMap, category)) {
            return "-1";
        }
        // 曝光次数小于等于1，则为新用户，标记为"0"
        if (actMap.getIntValue(category) <= 1) {
            return "0";
        } else {
            return "1";
        }
    }


    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }
    }

    // 用户分行业统计数据解析
    public static String getCategoryLevelByCalcBucket(JSONObject actMap1, JSONObject actMap2, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap1, actMap2, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (String cateKey : actMap1.keySet()) {
                double cateValue1 = Long.parseLong(actMap1.getOrDefault(cateKey, 0).toString());
                if (cateValue1 == 0) {
                    continue;
                }
                double cateValue2 = Long.parseLong(actMap2.getOrDefault(cateKey, 0).toString());
                // 过滤不置信转化，个数小于5个
                if (category.containsKey(cateKey) && cateValue2 > 5.0) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue2 / cateValue1, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            logger.warn("getCategoryLevelByCalcBucket failed=" + actMap2);
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (String cateKey : actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }
    }

    // 用户签收率分桶计算
    public static Long getUserSignRatioBucket(Long signEffect, Long issueEffect, double[] bucket) {
        long ret = 0;

        if (signEffect == null || issueEffect == null || bucket == null || issueEffect == 0) {
            return ret;
        } else {
            return bucket(signEffect.doubleValue() / issueEffect, bucket);
        }
    }



    public static int countFeatures(String valueList) {
        if (valueList == null) {
            return -1;
        }
        if (valueList.isEmpty()) {
            return 0;
        }
        String idArr[] = valueList.split(",");
        if (idArr == null) {
            return -1;
        }
        return idArr.length;
    }

    private static <T> Set<String> getSetIntersection(Set<T> base, Set<String> rawSet) {
        HashSet<String> advertSet = new HashSet<>();

        if (base != null && base.size() > 0 && rawSet != null && rawSet.size() > 0) {
            for (T b : base) {
                if (rawSet.contains(b.toString())) {
                    advertSet.add(b.toString());
                }
            }
        }

        return advertSet;
    }

    private static <T> Set<T> getSetSubtract(Set<T> base, Set<T> exclude) {
        Set<T> res = null;

        if (AssertUtil.isAllNotEmpty(base, exclude)) {
            res = new HashSet<T>();

            for (T b : base) {
                if (!exclude.contains(b)) {
                    res.add(b);
                }
            }
        } else {
            res = base;
        }

        return res;
    }

    private static Set<String> getConvertAdvertSet(String convertStr, Set<String> rawSet) {
        Set<String> advertSet = new HashSet<>();
        if (convertStr.length() > 0) {
            String tmp = convertStr.replaceAll("[{}]", "");
            String[] tmpArray = tmp.split(",");
            for (String arr : tmpArray) {
                if (!arr.contains("=") && rawSet.contains(arr)) {
                    advertSet.add(arr);
                }
                if (arr.contains("=")) {
                    String[] tmpArray2 = arr.split("=");
                    if (tmpArray2.length >= 2) {
                        if (rawSet.contains(tmpArray2[1])) {
                            advertSet.add(tmpArray2[1]);
                        }
                    }
                }
            }
        }
        return advertSet;
    }

    // 20210115 两两特征交叉
    public static String getFeatureCross(String str0, String str1) {
        String ret;
        String tmp_str0 = str0 == null ? "nu" : str0;
        String tmp_str1 = str1 == null ? "nu" : str1;
        ret = tmp_str0 + "_" + tmp_str1;
        return ret;
    }
}