package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import com.alibaba.fastjson.JSONObject;

import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;


import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;



public class FeatureParse2 {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureParse2.class);
    public static int F_MAX_SIZE = 64;
    public static Integer[] orderGmtIntervelBucket = {0, 2, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 2,60 * 24 * 4, 60 * 24 * 7,60 * 24 * 30 };// 时间间隔
    public static Integer[] orderActGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};
    public static Number[] cntBucket = {0, 1, 3, 5, 10, 15, 20};


    public static Number[] launchRankBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 30, 50, 100, 200};
    public static Number[] clickRankBucket = {0, 1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 30, 50};
    public static Number[] effectRankBucket = {0, 1, 2, 3, 4, 5, 10};

    public static Number[] dayLaunchRankBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 15, 30};
    public static Number[] dayClickRankBucket = {0, 1, 2, 3, 4, 5, 10, 20};
    public static Number[] dayEffectRankBucket = {0, 1, 2, 3, 4, 5 };

    public static Number[] statCtrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.55, 0.6,0.63,0.66, 0.7,0.75, 0.8, 0.9};


    public static Number[] statCvrBucket = {0.0005, 0.001,0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05,0.07, 0.1, 0.15, 0.20, 0.25, 0.30, 0.5};

    public static Number[] statCtrBucketAct = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static Number[] statCvrBucketAct = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};


    public static final Number[] cntMeituanBucket30d = {0, 1, 2, 3, 5, 10, 20, 50};
    public static final Number[] cntMeituanBucket = {-1, 1, 2, 3, 4, 5, 10, 20, 30};


    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                //把时间配置上，不然后面关于时间的特征就要全是空了。
                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
                // 1、用户侧 设备信息
                retMap.put("ft100201", cf.getConnectionType());// 网络类型（2G，3G，4G）
                retMap.put("ft100202", cf.getOperatorType());// 运营商（中国联通，中国移动，中国电信）
                retMap.put("ft100203", UserProfileFeature.formatOsVersion(cf.getOsVersion()));//系统版本
                retMap.put("ft100204", UserProfileFeature.formatPhoneModelCode(cf.getPhoneModelCode()));//设备型号//
                retMap.put("ft100205", cf.getBrandNameEn());//品牌英文名称
                retMap.put("ft100206", cf.getPhonePriceLevel());// 设备价格区间
                retMap.put("ft100207", UserProfileFeature.formatFirstShowTime(cf.getFirstShowTime()));//首发年份
                retMap.put("ft100208", UserProfileFeature.formatPhoneOs(cf.getPhoneOs()));//操作系统
                retMap.put("ft100209",  cf.getIpUsageType());//ip场景


                // 2、用户侧 画像信息
                UserProfileFeature userProfileFeature = Optional.ofNullable(cf.getUserProfileFeature()).orElse(new UserProfileFeature());
                retMap.put("ft100001", cf.getOneId());//
                retMap.put("ft100103", userProfileFeature.getMarital());//婚育情况
                retMap.put("ft100105", userProfileFeature.getInterestPreference());//兴趣标签
                retMap.put("ft100106", userProfileFeature.getAge());//dmp年龄
                retMap.put("ft100107", userProfileFeature.getGender());//dmp性别


                retMap.put("ft100501", cf.getBdFirstTag());// 百度兴趣标签 1级
                retMap.put("ft100502", cf.getBdSecondTag());// 百度兴趣标签 2级
                retMap.put("ft100503", cf.getBdThirdTag());// 百度兴趣标签 3级
                retMap.put("ft100504", cf.getBdFourthTag());// 百度兴趣标签 4级

                // app 分箱
                retMap.put("ft100505", DataConverter.mapKey2Str(cf.getAppInstallFirstTag()));// app安装一级分类集合
                retMap.put("ft100506", DataConverter.mapKey2Str(cf.getAppInstallSecondTag()));// app安装二级分类集合
                //
                retMap.put("ft100601", DataConverter.map2Bucket2Str(cf.getAppInstallFirstTag(), cntBucket));// app安装一级分类
                retMap.put("ft100602", DataConverter.map2Bucket2Str(cf.getAppInstallSecondTag(), cntBucket));// app安装二级分类

                putMapNotNull(retMap, "ft100603", cf.getAppInstall());// app安装

                // 3、用户侧 行为信息
                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());
                retMap.put("ft110000", DataConverter.bucket(userActFeature.getUserActiveDays(), cntBucket));// 历史最早发券距今天数

                retMap.put("ft111021", DataConverter.bucket(userActFeature.getWeekActivityRequest(), cntBucket)); // 历史=7，活动访问PV
                retMap.put("ft111011", DataConverter.bucket(userActFeature.getDayActivityRequest(), cntBucket)); // 当日，活动访问PV
                // 历史累计
                retMap.put("ft110001", DataConverter.bucket(userActFeature.getHistory30LaunchCount(), launchRankBucket));//历史=30，曝光PV
                retMap.put("ft110002", DataConverter.bucket(userActFeature.getHistory30ClickCount(), clickRankBucket)); //历史=30，点击PV
                retMap.put("ft110003", DataConverter.bucket(userActFeature.getHistory30EffectCount(), effectRankBucket));//历史=30，转化PV
                // 当日累计
                retMap.put("ft110011", DataConverter.bucket(userActFeature.getTodayLaunchCount(), dayLaunchRankBucket));//当日，曝光PV
                retMap.put("ft110012", DataConverter.bucket(userActFeature.getTodayClickCount(), dayClickRankBucket));//当日，点击PV
                retMap.put("ft110013", DataConverter.bucket(userActFeature.getTodayEffectCount(), dayEffectRankBucket));//当日，转化PV
                retMap.put("ft110014", DataConverter.bucket(cf.getPutIndex(), dayLaunchRankBucket));// 当日，发券putindex

                //ft110201 历史=30，不同广告主，发券PV
                //ft110202 历史=30，不同广告主，点击PV
                //ft110203 历史=30，不同广告主，转化PV

                //ft110401 历史=30，不同资源，发券PV
                //ft110402 历史=30，不同资源，点击PV
                //ft110403 历史=30，不同资源，转化PV

                retMap.put("ft110301",DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeLaunch(), launchRankBucket));//历史=30，不同行业，发券PV
                retMap.put("ft110302",DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeClick(), clickRankBucket));//历史=30，不同行业，点击PV
                retMap.put("ft110303",DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeEffect(), effectRankBucket));//历史=30，不同行业，转化PV

                retMap.put("ft110501", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertLaunch(), dayLaunchRankBucket));// 历史=30，不同广告，发券PV
                retMap.put("ft110502", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertClick(), dayClickRankBucket));// 历史=30，不同广告，点击PV
                retMap.put("ft110503", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertEffect(), dayEffectRankBucket));// 历史=30，不同广告，转化PV

//                // 用户行为集合
                Set<Integer> advertExposureSet = userActFeature.getAdvertExposureSet();
                Set<Integer> advertClickSet = userActFeature.getAdvertClickSet();

                retMap.put("ft110601", DataConverter.set2Str(advertExposureSet));
                retMap.put("ft110602", DataConverter.set2Str(advertClickSet));
                retMap.put("ft110603", DataConverter.set2Str(DataConverter.setDiff(advertExposureSet, advertClickSet)));
                retMap.put("ft110604", DataConverter.set2Str(userActFeature.getAccountClickSet()));
                retMap.put("ft110605", DataConverter.set2Str(userActFeature.getResourceClickSet()));
                retMap.put("ft110606", DataConverter.set2Str(userActFeature.getTradeClickSet()));
                retMap.put("ft110607", DataConverter.set2Str(userActFeature.getAdvertEffectSet()));
                retMap.put("ft110608", DataConverter.set2Str(userActFeature.getAccountEffectSet()));
                retMap.put("ft110609", DataConverter.set2Str(userActFeature.getResourceEffectSet()));
                retMap.put("ft110610", DataConverter.set2Str(userActFeature.getTradeEffectSet()));


                // 用户行为ctr/cvr偏好
                Map<String, Map<String, Long>> historyTradeCtrCvr = userActFeature.getHistoryTradeCtrCvr();

                retMap.put("ft110701", DataUtil.Long2String(historyTradeCtrCvr.get("ctr").get("0")));//整体ctr f8090011
                retMap.put("ft110702", DataUtil.Long2String(historyTradeCtrCvr.get("cvr").get("0")));//整体cvr f8090021
                retMap.put("ft110703", DataConverter.map2Str(historyTradeCtrCvr.get("ctr")));//行业ctr
                retMap.put("ft110704", DataConverter.map2Str(historyTradeCtrCvr.get("cvr")));//行业cvr


                // 4、上下文 媒体
                String activityId = DataUtil.Long2String(cf.getOperatingActivityId());
                String sceneType = Objects.equals(activityId, "999999") ? "2" : "1";
                String appId = DataUtil.Long2String(cf.getAppId());
                String unionAppId = cf.getUnionAppId();
                retMap.put("ft300101", appId);//媒体ID
                retMap.put("ft300102", sceneType);// 场景 互动/直投, 活动id为999999为直投，其他为互动
                //20220809 由于业务要求，把下面这个特征改为与联盟媒体id无关
                // todo 后续需要恢复
                retMap.put("ft300103", appId);
                //retMap.put("ft300103", unionAppId == null || unionAppId.trim().equals("") ? appId : appId + "_" + unionAppId);
                retMap.put("ft300104", cf.getAppIndustryTagPid());//媒体行业一级标签（视频/阅读等）
                retMap.put("ft300105", cf.getAppIndustryTagId());//媒体行业二级标签（短视频/新闻阅读等）
                retMap.put("ft300106", cf.getAppTradeTypeTagId());// todo 媒体交易方式（RTB/ADX/固价-cpm等）
                retMap.put("ft300107", cf.getAppCarrierFlowTagId());//todo 媒体流量载体（微信-小程序/支付宝/H5等）
                retMap.put("ft300108", cf.getMmoTag());// 是否网赚


                // 5、上下文 广告位
                retMap.put("ft300201", DataUtil.Long2String(cf.getSlotId()));//广告位ID
                retMap.put("ft300202", cf.getSlotSceneType());//todo 广告位类型（开屏/信息流/banner/icon等）
                retMap.put("ft300203", cf.getMaterailID());//广告位素材ID
                retMap.put("ft300204", DataUtil.Long2String(cf.getSlotId()));//广告位ID 2，50000空间

                // 6、上下文 活动
                retMap.put("ft300301", activityId);//活动id（当前活动）
                retMap.put("ft300302", cf.getActivitySourceType());//活动[进入当前券]的访问类型[广告位、浮标、返回拦截、弹层、区块]
                retMap.put("ft300303", DataUtil.Long2String(cf.getDsm2A()));// 活动访问类型（广告位/返回拦截）
                retMap.put("ft300304", DataUtil.Long2String(cf.getActivityPage()));//自定义活动ID（主活动ID）
                retMap.put("ft300305", cf.getActivitySkinType());// todo 活动皮肤ID/Name（玩法，大转盘/翻牌子/扭蛋机等）
                retMap.put("ft300306", DataUtil.Long2String(cf.getActivityType()));// f306001 活动类型


                // 6、上下文 实时ip解析地域
                String cityId = DataUtil.Long2String(cf.getCityId());
                String provinceId = RegionConf.getProvince(cityId);
                String regionId = RegionConf.getRegion(provinceId);
                String CityTier = RegionConf.getCityTier(cityId);
                retMap.put("ft300901", regionId);//地域-地区（华北/华东等）
                retMap.put("ft300902", provinceId);// 地域-省/直辖市
                retMap.put("ft300903", cityId);//地域-市
                retMap.put("ft300904", CityTier);//地域-几线


                // 上下文 订单时间
                Integer hour = LocalDateUtil.getHour(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer weekDay = LocalDateUtil.getDayOfWeek(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer dayOfMonth = LocalDateUtil.getDayOfMonthSafely(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("ft301001", DataUtil.Integer2String(hour));//订单时间 hour（时段）
                retMap.put("ft301002", DataUtil.Integer2String(weekDay));// 订单时间 weekday（周几）
                retMap.put("ft301003", DataUtil.Integer2String(dayOfMonth));// 订单时间 day（几号）

                // 6、媒体（媒体/广告位/媒体行业） 与广告（广告/广告行业/广告主等）交叉统计泛化
                // 广告位 交叉 广告行业
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
                retMap.put("ft400101", DataConverter.json2Bucket2Str(ctrTradeMap, statCtrBucket));// 历史，广告位，广告行业CTR
                JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
                retMap.put("ft400102", DataConverter.json2Bucket2Str(cvrTradeMap, statCvrBucket));//历史，广告位，当前广告行业CVR


                // 媒体 交叉广告行业
                // todo getAppInNewTrade 取值为空
//                String appInNewTradeCtr = getStatInNewTrade("ctr", cf.getAppInNewTrade());
//                retMap.put("ft400401", appInNewTradeCtr);//历史，媒体，广告行业CTR
//                String appInNewTradeCvr = getStatInNewTrade("cvr", cf.getAppInNewTrade());
//                retMap.put("ft400402", appInNewTradeCvr);//历史，媒体，广告行业CVR

                // 7、adx相关
                // adx-美团
//                retMap.put("f680001", bucket(cf.getRequestCnt(), cntMeituanBucket).toString());
                retMap.put("ft600101", DataConverter.bucket(cf.getRequestCnt30d(), cntMeituanBucket30d));
                retMap.put("ft600102", DataConverter.bucket(cf.getExposureCnt30d(), cntMeituanBucket30d));
                retMap.put("ft600103", DataConverter.bucket(cf.getClickCnt30d(), cntMeituanBucket30d));


                retMap.put("ft600104", DataConverter.bucket(cf.getRequestCnt(), cntMeituanBucket).toString());
                retMap.put("ft600105", DataConverter.bucket(cf.getExposureCnt(), cntMeituanBucket).toString());
                retMap.put("ft600106", DataConverter.bucket(cf.getClickCnt(), cntMeituanBucket).toString());



                // adx-快手
                retMap.put("ft600201", cf.getOpenAccountId());  //媒体开户账号id
                retMap.put("ft600202", cf.getExtUnionSlotId());  //联盟广告位id
                retMap.put("ft600203", cf.getExtAdvertGroupId());  //外部广告组id
                retMap.put("ft600204", cf.getExtIdeaId());  //外部创意id

                // adx-百度联盟
                String extAppTrade = cf.getExtAppTrade();
                retMap.put("ft600301", extAppTrade);
                String externalAdBlockId = cf.getExternalAdBlockId();
                retMap.put("ft600302", externalAdBlockId);
                String externalAdBlockTypeId = cf.getExternalAdBlockTypeId();
                retMap.put("ft600303", externalAdBlockTypeId);
                String groupId = DataUtil.Long2String(cf.getGroupId());
                retMap.put("ft600304", groupId);
                String resourceId = DataUtil.Long2String(cf.getResourceId());
                retMap.put("ft600305", resourceId);

//                retMap.put("todayAdvertLaunch", DataConverter.map2Str(userActFeature.getTodayAdvertLaunch()));
//                retMap.put("todayAdvertClick", DataConverter.map2Str(userActFeature.getTodayAdvertClick()));
//                retMap.put("todayAdvertEffect", DataConverter.map2Str(userActFeature.getTodayAdvertEffect()));
//                retMap.put("historyAdvertLaunch", DataConverter.map2Str(userActFeature.getHistoryAdvertLaunch()));
//                retMap.put("historyAdvertClick", DataConverter.map2Str(userActFeature.getHistoryAdvertClick()));
//                retMap.put("historyAdvertEffect", DataConverter.map2Str(userActFeature.getHistoryAdvertEffect()));
//
//                retMap.put("AppTagInNewTrade1", JSON.toJSONString(cf.getAppTagInNewTrade()));
//                retMap.put("AppInNewTrade1", JSON.toJSONString(cf.getAppInNewTrade()));


//                临时兼容老版本
                retMap.put("f306001", retMap.getOrDefault("ft300306", ""));
                retMap.put("f8090011", retMap.getOrDefault("ft110701", ""));
                retMap.put("f8090021", retMap.getOrDefault("ft110702", ""));
                retMap.put("f8080011", retMap.getOrDefault("ft110703", ""));
                retMap.put("f8080021", retMap.getOrDefault("ft110704", ""));


                /**
                 * 媒体侧特征
                 * 2022.10.19
                 */
                putMapNotNull(retMap, "ft300109", cf.getUaAppPackage()); // 媒体包
                putMapNotNull(retMap, "ft300110", cf.getUaAppPackageTrade1()); // 媒体包行业类目，大类，网赚、计步等
                putMapNotNull(retMap, "ft300111", cf.getUaAppPackageTrade2()); // 媒体包行业类目，小类，网赚、计步等
                putMapNotNull(retMap, "ft600206", ContextFeatureDoV2.formatInterestTag(cf.getExtMaterialTitle())); //外部素材广告语
                putMapNotNull(retMap, "ft600207", cf.getExtMaterialId()); //外部素材ID
                putMapNotNull(retMap, "ft600208", cf.getExtMaterialType()); //外部素材类型 :1-横版图片、2-竖版图片、3-横版视频、4-竖版视频

                putMapNotNull(retMap, "ft300313", cf.getActInteresteTag()); //3、权益标签；红包、话费、手机等；格式：1,3  映射：939-红包，941-话费，942-手机


            }
        } catch (Exception e) {
            logger.error("FeatureParse2.generateFeatureMapStatic error", e);
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {
                // 广告侧 广告基本信息
                String advertId = DataUtil.Long2String(cf.getAdvertId());// 广告ID
                String accountId =  DataUtil.Long2String(cf.getAccountId());// 广告主ID
                String OperatingResource = cf.getOperatingResource();//资源ID
                String adNewTrade = cf.getOperatingNewTrade();// 广告行业ID（new_trade）
                LoadingPageFeature loadingPageFeature = Optional.ofNullable(cf.getLoadingPageFeature()).orElse(new LoadingPageFeature());
                String adTradeTag = cf.getMatchTagNums();

                retMap.put("ft200101", advertId);
                retMap.put("ft200102", accountId);
                retMap.put("ft200103", OperatingResource);
                retMap.put("ft200104", adNewTrade);
                retMap.put("ft200105", adTradeTag); // 广告行业标签
                retMap.put("ft200106", cf.getMaterialId());//广告素材ID
                retMap.put("ft200107", cf.getMaterialTags());//  广告素材标签
                retMap.put("ft200108", loadingPageFeature.getLoadingPageID());//落地页链接-MD5
                retMap.put("ft200109", DataUtil.Long2String(cf.getTimes()));//f110001 广告投放次数

                // 广告侧 转化类型
                String frontCvrType = cf.getBankEndType();
                String backCvrType = cf.getDeepConvertTypes();
                retMap.put("ft200201", frontCvrType);//前端转化类型，值范围：0～10
                retMap.put("ft200202", backCvrType);//后端转化类型，值范围：1～30


                // 用户侧 上一单数据
                UserActFeature userActFeature = Optional.ofNullable(staticCf.getUserActFeature()).orElse(new UserActFeature());
                String lastActivity = userActFeature.getLastActivity();
                String lastLaunchTrade = userActFeature.getLastLaunchTrade();
                String lastResource = userActFeature.getLastResource();
                String lastAccount = userActFeature.getLastLaunchAccount();
                String lastAdvert = userActFeature.getLastLaunchPlan();
                String lastActivityLaunchOrder = userActFeature.getLastActivityLaunchOrder();
                String lastActivityClickOrder = userActFeature.getLastActivityClickOrder();
                retMap.put("ft110901", lastActivity);//上一单，活动ID
                retMap.put("ft110902", lastLaunchTrade);
                retMap.put("ft110903", lastResource);
                retMap.put("ft110904", lastAccount);
                retMap.put("ft110905", lastAdvert);
                retMap.put("ft110906", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());//上一单，是否点击
                retMap.put("ft110907", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());//上一单，是否转化
                retMap.put("ft110908", DataConverter.getMatchStatus(lastLaunchTrade, adNewTrade));//上一单，与当前，行业是否相同
                retMap.put("ft110909", DataConverter.getMatchStatus(lastAdvert, advertId));//上一单，与当前，计划是否相同
                String activityId = DataUtil.Long2String(staticCf.getOperatingActivityId());
                retMap.put("ft110910", DataConverter.getMatchStatus(lastActivity, activityId));//上一单，与当前，活动是否相同、
                String curOrderTime = staticCf.getCurrentGmtCreateTime();
                String lastLaunchTime = userActFeature.getLastLaunchTime();
                String lastActivityTime = userActFeature.getLastActivityLaunchTime();
                retMap.put("ft110911", DataConverter.bucket(DataConverter.getTimeInterval(lastLaunchTime,curOrderTime,"m"), orderGmtIntervelBucket));//上一单，与当前发券，时间差
                retMap.put("ft110912", DataConverter.bucketRight(DataConverter.getTimeInterval(lastActivityTime, curOrderTime,"m"), orderActGmtIntervelBucket));//上一次活动，与当前发券，时间差
                retMap.put("ft110913", DataConverter.bucketRight(DataConverter.getTimeInterval(lastLaunchTime,curOrderTime,"m"), orderActGmtIntervelBucket));//上一单，与当前发券，时间差2
                retMap.put("ft110914", DataConverter.getMatchStatus2(lastActivityLaunchOrder, lastActivityClickOrder));// 该活动下上一次发券是否点击



                // 6、媒体（媒体/广告位/媒体行业） 与当前广告（广告/广告行业/广告主等）交叉统计泛化
                // 广告位 交叉 当前广告行业
                SlotActFeature slotActFeature = Optional.ofNullable(staticCf.getSlotActFeature()).orElse(new SlotActFeature());

                JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
                JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
                retMap.put("ft400201", DataConverter.getCurTradeLevel(ctrTradeMap, adNewTrade, statCtrBucket));//历史，广告位，当前广告行业CTR
                retMap.put("ft400202", DataConverter.getCurTradeLevel(cvrTradeMap, adNewTrade, statCvrBucket));//历史，广告位，当前广告行业CVR  无论投放目标，均为落地页转化cvr


                // 广告位 交叉 当前广告
                retMap.put("ft400301", DataConverter.bucket(cf.getAdvertSlotCtr(), statCtrBucket));//历史，广告位，当前广告CTR
                retMap.put("ft400302", DataConverter.bucket(cf.getAdvertSlotCvr(), statCvrBucket));//历史，广告位，当前广告CTR
                retMap.put("ft400303", DataConverter.bucket(cf.getAdvertSlotBCvr(), statCvrBucket));//历史，广告位，当前广告CVR, 与当前配置投放目标一致


                // 媒体 交叉 当前广告行业
                // todo getAppInNewTrade 取值为空
//                String appInNewTradeCtr = getStatInNewTrade("ctr", staticCf.getAppInNewTrade());
//                String appInNewTradeCvr = getStatInNewTrade("cvr", staticCf.getAppInNewTrade());
//                retMap.put("ft400501", transJointStrToMap(appInNewTradeCtr, ",","&").getOrDefault(adNewTrade, "-1"));//历史，媒体，当前广告行业CTR
//                retMap.put("ft400502", transJointStrToMap(appInNewTradeCvr, ",","&").getOrDefault(adNewTrade, "-1"));//历史，媒体，当前广告行业CVR
//                retMap.put("AppTagInNewTrade2", JSON.toJSONString(staticCf.getAppTagInNewTrade()));
//                retMap.put("AppInNewTrade2", JSON.toJSONString(staticCf.getAppInNewTrade()));


                // 媒体 交叉 当前广告
                retMap.put("ft400601", DataConverter.bucket(cf.getAdvertAppCtr(), statCtrBucket));//历史，广告位，当前广告CTR
                retMap.put("ft400602", DataConverter.bucket(cf.getAdvertAppCvr(), statCvrBucket));//历史，广告位，当前广告CVR
                retMap.put("ft400603", DataConverter.bucket(cf.getAdvertAppBCvr(), statCvrBucket));//历史，媒体，当前广告CVR 与当前配置投放目标一致

                // 当前广告 统计ctr、cvr
                retMap.put("ft400701", DataConverter.bucket(cf.getAdvertCtr(), statCtrBucket));
                retMap.put("ft400702", DataConverter.bucket(cf.getAdvertCvr(), statCvrBucket));
                retMap.put("ft400703", DataConverter.bucket(cf.getAdvertBCvr(), statCvrBucket));//历史当前广告CVR 与当前配置投放目标一致

                // 广告 交叉 活动
                retMap.put("ft400801", DataConverter.bucketRight(cf.getAdvertActivityCtr(), statCtrBucketAct));
                retMap.put("ft400802", DataConverter.bucketRight(cf.getAdvertActivityCvr(), statCvrBucketAct));
                retMap.put("ft400803", DataConverter.bucketRight(cf.getAdvertActivityBCvr(), statCvrBucketAct));//历史，活动，当前广告CVR, 与当前配置投放目标一致



                // 用户端 历史=30，当前广告行业 // 源数据使用的是adTradeTag作为key
                retMap.put("ft110101",DataConverter.bucket(userActFeature.getHistoryTradeLaunch().getOrDefault(adTradeTag, 0L), launchRankBucket));//历史=30，当前广告行业，曝光PV
                retMap.put("ft110102",DataConverter.bucket(userActFeature.getHistoryTradeClick().getOrDefault(adTradeTag, 0L), clickRankBucket));//历史=30，当前广告行业，点击PV
                retMap.put("ft110103",DataConverter.bucket(userActFeature.getHistoryTradeEffect().getOrDefault(adTradeTag, 0L), effectRankBucket));//历史=30，当前广告行业，转化PV
                Map<String, Map<String, Long>> historyTradeCtrCvr = userActFeature.getHistoryTradeCtrCvr();
                retMap.put("ft110705",historyTradeCtrCvr.get("ctr").getOrDefault(adTradeTag, 0L).toString());//当前广告行业，ctr
                retMap.put("ft110706",historyTradeCtrCvr.get("cvr").getOrDefault(adTradeTag, 0L).toString());//当前广告行业，cvr



                // 8、字符交叉
                String advertIdString = advertId == null ? "ad" : advertId;
                retMap.put("ft500101", advertIdString+ "_" + frontCvrType);// 广告 + 前端类型
                retMap.put("ft500201", advertIdString + "_" + backCvrType);// 广告 + 后端类型

                String accountIdString = accountId == null ? "acc" : accountId;
                retMap.put("ft500102", accountIdString + "_" + frontCvrType);// 广告主 + 前端类型
                retMap.put("ft500202", accountIdString + "_" + backCvrType);// 广告主 + 后端类型

                String tradeIdString = adNewTrade == null ? "un" : adNewTrade;
                retMap.put("ft500103", tradeIdString + "_" + frontCvrType);// 行业 + 前端类型
                retMap.put("ft500203", tradeIdString + "_" + backCvrType);// 行业 + 后端类型


                String appIndustryTagPidString = staticCf.getAppIndustryTagPid() == null ? "un" : staticCf.getAppIndustryTagPid();
                retMap.put("ft500104", appIndustryTagPidString + "_" + frontCvrType);// 媒体行业 + 前端类型
                retMap.put("ft500204", appIndustryTagPidString + "_" + backCvrType);// 媒体行业 + 后端类型



                // 9 为了兼容老版模型特征过渡
                AdvertTagFeature atf = Optional.ofNullable(cf.getAdvertTagFeature()).orElse(new AdvertTagFeature());
                String adInExposeTop250 = (cf.getIsExposeTop250() != null && cf.getIsExposeTop250() > 0) ? DataUtil.Long2String(cf.getAdvertId()) : "";

                String clickNoEffectCross = DataConverter.jointStrSet(adInExposeTop250, DataConverter.setDiff(userActFeature.getAdvertClickSet(), userActFeature.getAdvertEffectSet()));
                retMap.put("ft900001", clickNoEffectCross);//f9110031
                Set<Integer> advertEffectSet = userActFeature.getAdvertEffectSet();
                Set<String> advertEffectSet2 = (advertEffectSet!=null) ? advertEffectSet.stream().map(Object::toString).collect(Collectors.toSet()) : new HashSet<String>();
                String convertBehaviourCross = DataConverter.jointStrSet(adInExposeTop250, DataConverter.setInter(advertEffectSet2, staticCf.getTopAdvertSet()));
                retMap.put("ft900002", convertBehaviourCross);//f9110041

                String operatorType = staticCf.getOperatorType() == null ? "op" : staticCf.getOperatorType();
                String operatorName = getOperatorName(operatorType);
                String tradeId = cf.getOperatingNewTrade() == null ? "un" : cf.getOperatingNewTrade();
                String phoneModel = staticCf.getPhoneModelCode() == null ? "" : staticCf.getPhoneModelCode();
                String phoneBrand = staticCf.getBrandNameEn() == null ? "" : staticCf.getBrandNameEn();
                retMap.put("ft900003", advertId + "_" + operatorType);
                retMap.put("ft900004", getOperatorBrandMatch(operatorName, atf.getBrand(), adNewTrade));//f5070012

                retMap.put("ft900005", accountId + "_" + operatorName);//f5070015
                retMap.put("ft900006", tradeId + "_" + operatorName);//f5070016
                retMap.put("ft900007", tradeId + "_" + phoneModel);//f5090012
                retMap.put("ft900008", tradeId + "_" + phoneBrand);//f5090022

                retMap.put("f8100011", retMap.getOrDefault("ft110705", ""));
                retMap.put("f8100021", retMap.getOrDefault("ft110706", ""));
                retMap.put("f110001", retMap.getOrDefault("ft200109", ""));
                retMap.put("f9110041", retMap.getOrDefault("ft900002", ""));
                retMap.put("f9110031", retMap.getOrDefault("ft900001", ""));

                retMap.put("f5070011", retMap.getOrDefault("ft900003", ""));
                retMap.put("f5070012", retMap.getOrDefault("ft900004", ""));
                retMap.put("f5070015", retMap.getOrDefault("ft900005", ""));

                retMap.put("f5070016", retMap.getOrDefault("ft900006", ""));
                retMap.put("f5090012", retMap.getOrDefault("ft900007", ""));
                retMap.put("f5090022", retMap.getOrDefault("ft900008", ""));






            }
        } catch (Exception e) {
            logger.error("FeatureParse2.generateFeatureMapDynamic error", e);

        }

        return retMap;
    }




    public static String getOperatorBrandMatch(String operator, String brand, String trade) {
        // 仅在运营商行业下判断
        if (trade != null && trade.equals("16")) {
            if (operator == null || brand == null) {
                return "0";
            } else if (operator.equals(brand)) {
                return "1";
            } else {
                return "2";
            }
        } else {
            return "4";
        }
    }
    // 过渡
    public static String getOperatorName(String op) {
        if (op == null) {
            return "未知";
        } else if (op.equals("1")) {
            return "移动";
        } else if (op.equals("2")) {
            return "联通";
        } else if (op.equals("3")) {
            return "电信";
        } else {
            return "未知";
        }
    }


    /**
     * 仅非空值 存入map中
     *
     * @param map
     * @param key
     * @param value
     */
    public static void putMapNotNull(Map<String, String> map, String key, String value) {

        if (value != null) {
            map.put(key, value);
        }
    }




    //测试
    public static void main(String[] args) {

    }


}




