package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

@Data

public class SlotMaterialFeature {
    //素材今日在广告位上的点击次数（考虑是否可做截断）
    private Long slotClickDayCnt;
    //素材过去7天在广告位上的点击次数
    private Long slotClickWeekCnt;
    //素材过去7天在广告位上的曝光次数
    private Long slotExposeWeekCnt;
    //素材今日在广告位上的曝光次数
    private Long slotExposeDayCnt;
    //历史入口该素材曝光频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Long slotExposePeriod;
    //历史入口该素材点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜)
    private Long slotClickPeriod;
    //历史该素材上的前端转化/后端转化次数
    private Long slotConvertHistCnt;
    private Long slotBConvertHistCnt;
    //一周内该素材上的前端转化/后端次数
    private Long slotConvertWeekCnt;
    private Long slotBConvertWeekCnt;

    private Long slotSckExpUV14D; // 广告位-素材过去14天曝光uv
    private Long slotSckClkUV14D; // 广告位-素材过去14天点击uv
    private Long slotSckExpUV7D; //	广告位-素材过去7天曝光uv
    private Long slotSckClkUV7D; //	广告位-素材过去7天点击uv
    private Long slotSckExpUV3D; //	广告位-素材过去3天曝光uv
    private Long slotSckClkUV3D; //	广告位-素材过去3天点击uv

}
