package cn.com.duiba.nezha.alg.feature.vo.v2.dmp;

import lombok.Data;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Map;

@Data
public class DmpUserSubFeatureDo implements Serializable {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DmpUserSubFeatureDo.class);
    private static final long serialVersionUID = 6653753667287162448L;


    /**
     * 基础属性
     */
    private String gender; // 性别
    private String age; // 年龄
    private String marital; // 婚育

    //private String permanentProvince; // f451005  常住地（省份）
    //private String permanentCity; // f451006  常住地（城市）
    //private String interestPreference; // 兴趣标签

    private String bdFirstTag;  // 百度一级标签
    private String bdSecondTag; // 百度二级标签
    private String bdThirdTag;  // 百度三级标签
    private String bdFourthTag; // 百度四级标签

    private String appInstall; // app安装列表
    //private Map<String , Integer> appInstallFirstTag; // app安装一级类别个数
    //private Map<String , Integer> appInstallSecondTag; // app安装二级类别个数

    /**
     * 状态：活动广告位、当日投放状态
     */
    private Map<String,String> d201	;//设备，集合<adx联盟媒体广告位，adx竞价请求PV>	近14日
    private Map<String,String> d202	;//设备，集合<adx资源位，adx竞价请求PV>	近14日
    private Map<String,String> d203	;//设备，集合<媒体包/slot，活动访问PV>	近14日
    private Map<String,String> d204	;//设备，集合<媒体包小类，活动访问PV>	近14日
    private Map<String,String> d205	;//设备，集合<活动ID，活动访问PV>	当日
    private String d206	;//设备，上一券订单，广告行业ID	当日
    private String d207	;//设备，上一券订单，时间	当日
    private String d208	;//设备，上一券订单，访问活动ID	当日
    private String d209	;//设备，上一券订单，是否点击	当日
    private String d210	;//设备，首次adx竞价请求时间	当日
    private String d211	;//设备，首次活动访问时间	当日

    /**
     * 用户行为，当日
     */
    private Integer d301	;//设备，adx竞价请求PV
    private Integer d302	;//设备，adx竞价返回PV
    private Integer d303	;//设备，adx曝光PV
    private Integer d304	;//设备，adx入口素材点击PV
    private Integer d305	;//设备，活动访问PV
    private Integer d306	;//设备，活动参与PV
    private Integer d307	;//设备，券曝光PV
    private Integer d308	;//设备，券点击PV
    private Map<String,String> d309	;//设备，集合<广告行业，落地页转化PV>
    private Map<String,String> d310	;//设备，集合<广告行业，注册转化PV>
    private Map<String,String> d311	;//设备，集合<广告行业，理论消耗>

    /**
     * 用户行为，近14天
     */
    private Integer d401	;//设备，adx竞价请求PV
    private Integer d402	;//设备，adx竞价返回PV
    private Integer d403	;//设备，adx曝光PV
    private Integer d404	;//设备，adx入口素材点击PV
    private Integer d405	;//设备，活动访问PV
    private Integer d406	;//设备，活动参与PV
    private Integer d407	;//设备，券曝光PV
    private Integer d408	;//设备，券点击PV
    private Map<String,String> d409	;//设备，集合<广告行业，落地页转化PV>
    private Map<String,String> d410	;//设备，集合<广告行业，注册转化PV>
    private Map<String,String> d411	;//设备，集合<广告行业，理论消耗>

    /**
     * 用户行为，近180天
     */
    private Integer d501	;//设备，adx竞价请求PV
    private Integer d502	;//设备，adx竞价返回PV
    private Integer d503	;//设备，adx曝光PV
    private Integer d504	;//设备，adx入口素材点击PV
    private Integer d505	;//设备，活动访问PV
    private Integer d506	;//设备，活动参与PV
    private Integer d507	;//设备，券曝光PV
    private Integer d508	;//设备，券点击PV
    private Map<String,String> d509	;//设备，集合<广告行业，落地页转化PV>
    private Map<String,String> d510	;//设备，集合<广告行业，注册转化PV>
    private Map<String,String> d511	;//设备，集合<广告行业，理论消耗>




}

