package cn.com.duiba.nezha.alg.feature.vo.v2.sub;

import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
public class UserProfileSubFeature implements Serializable {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(UserProfileSubFeature.class);
    private static final long serialVersionUID = 6653753667287162448L;


    /**
     * 基础属性
     */
    private String gender; // 性别
    private String age; // 年龄
    private String marital; // 婚育

    //private String permanentProvince; // f451005  常住地（省份）
    private String permanentCity; // f451006  常住地（城市）

    /**
     * 兴趣
     * 是否存在？
     */
    private String interestPreference; // 兴趣标签

    /**
     * 百度兴趣标签
     */
    private String bdFirstTag;  // 一级标签
    private String bdSecondTag; // 二级标签
    private String bdThirdTag;  // 三级标签
    private String bdFourthTag; // 四级标签

    /**
     * APP安装信息偏好
     */
    private String appInstall; // app安装列表
//    private Map<String , Integer> appInstallFirstTag; // app安装一级类别个数
//    private Map<String , Integer> appInstallSecondTag; // app安装二级类别个数

}

