/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseParse {
    private static final Logger logger = LoggerFactory.getLogger(BaseParse.class);
    public static Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};
    public static Integer[] orderGmtIntervelBucket = new Integer[]{0, 2, 5, 10, 60, 720, 1440, 2880, 5760, 10080, 43200};
    public static Integer[] orderActGmtIntervelBucket = new Integer[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static Number[] cntBucket = new Number[]{0, 1, 3, 5, 10, 15, 20};
    public static Number[] launchRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 30, 50, 100, 200};
    public static Number[] clickRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 30, 50};
    public static Number[] effectRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 10};
    public static Number[] dayLaunchRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 15, 30};
    public static Number[] dayClickRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 10, 20};
    public static Number[] dayEffectRankBucket = new Number[]{0, 1, 2, 3, 4, 5};
    public static Number[] statCtrBucket = new Number[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.63, 0.66, 0.7, 0.75, 0.8, 0.9};
    public static Number[] statCvrBucket = new Number[]{5.0E-4, 0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.07, 0.1, 0.15, 0.2, 0.25, 0.3, 0.5};
    public static Number[] statCtrBucketAct = new Number[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static Number[] statCvrBucketAct = new Number[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static final Number[] cntMeituanBucket30d = new Number[]{0, 1, 2, 3, 5, 10, 20, 50};
    public static final Number[] cntMeituanBucket = new Number[]{-1, 1, 2, 3, 4, 5, 10, 20, 30};

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }

    public static void putMapNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static void putMapNotNull(Map<String, String> map, String key, Long value) {
        if (value != null) {
            map.put(key, Long.toString(value));
        }
    }

    public static void putMapNotNull(Map<String, String> map, String key, Integer value) {
        if (value != null) {
            map.put(key, Integer.toString(value));
        }
    }

    public static String formatOsVersion(String osVersion) {
        if (StringUtils.isBlank((String)osVersion)) {
            return null;
        }
        return osVersion.split("\\.")[0].toUpperCase();
    }

    public static String formatPhoneModelCode(String phoneModel) {
        if (StringUtils.isBlank((String)phoneModel)) {
            return null;
        }
        return phoneModel.substring(0, Math.min(phoneModel.length(), 100));
    }

    public static String formatFirstShowTime(Integer firstShowTime) {
        if (firstShowTime == null) {
            return null;
        }
        if (firstShowTime < 2000 || firstShowTime > 2030) {
            return "-1";
        }
        return firstShowTime.toString();
    }

    public static String formatPhoneOs(String phoneOs) {
        if (StringUtils.isBlank((String)phoneOs)) {
            return null;
        }
        if (phoneOs.equalsIgnoreCase("android")) {
            return "android";
        }
        if (phoneOs.equalsIgnoreCase("ios")) {
            return "ios";
        }
        return null;
    }

    public static String formatInterestTag(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        if (str.contains("\u7ea2\u5305") || str.contains("\u73b0\u91d1")) {
            return "939";
        }
        if (str.contains("\u8bdd\u8d39")) {
            return "941";
        }
        if (str.contains("\u624b\u673a") || str.contains("\u82f9\u679c") || str.contains("\u534e\u4e3a") || str.contains("\u5c0f\u7c73") || str.contains("iPhone")) {
            return "942";
        }
        return null;
    }

    public static <V1 extends Number, V2 extends Number> String bucket(V1 value, V2[] bucketList) {
        if (value == null || bucketList == null || bucketList.length == 0) {
            return "";
        }
        int ret = bucketList.length;
        for (int i = 0; i < bucketList.length; ++i) {
            V2 bound = bucketList[i];
            if (!(value.doubleValue() <= ((Number)bound).doubleValue())) continue;
            ret = i;
            break;
        }
        return DataUtil.Integer2String((Integer)ret);
    }

    public static <V extends Number> String map2Bucket2Str(Map<?, V> map, Number[] bucketList) {
        if (map == null || AssertUtil.isEmpty(map)) {
            return null;
        }
        String ret = "";
        try {
            ret = map.keySet().stream().map(key -> key + "_" + BaseParse.bucket((Number)((Number)map.get(key)), (Number[])bucketList)).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("BaseParse.json2Bucket2Str error", (Throwable)e);
        }
        return ret;
    }

    public static <T> String set2Str(Set<T> set) {
        if (AssertUtil.isEmpty(set)) {
            return null;
        }
        String ret = "";
        try {
            ret = set.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("BaseParse.set2Str error", (Throwable)e);
        }
        return ret;
    }

    public static <T> Set<T> setDiff(Set<T> base, Set<T> exclude) {
        if (base == null) {
            return null;
        }
        if (exclude == null) {
            return base;
        }
        HashSet<T> res = new HashSet<T>(base);
        try {
            res.removeAll(exclude);
        }
        catch (Exception e) {
            logger.error("BaseParse.setDiff error", (Throwable)e);
        }
        return res;
    }

    public static String json2Bucket2Str(JSONObject ajson, Number[] bucketList) {
        if (ajson == null || AssertUtil.isEmpty((Map)ajson)) {
            return null;
        }
        String ret = "";
        try {
            ret = ajson.keySet().stream().map(key -> key + "_" + BaseParse.bucket((Number)ajson.getDouble(key), (Number[])bucketList)).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            logger.error("BaseParse.json2Bucket2Str error", (Throwable)e);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseParse)) {
            return false;
        }
        BaseParse other = (BaseParse)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseParse;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "BaseParse()";
    }
}

