/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActFeature
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(UserActFeature.class);
    private static final long serialVersionUID = -2203632123858487448L;
    public static Double[] userCtrBucket = new Double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static Double[] userCvrBucket = new Double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    private Integer userActiveDays;
    private Integer activityRequest;
    private Integer weekActivityRequest;
    private Integer dayActivityRequest;
    private Integer intervalActivityRequest;
    private String periodActivityRequest;
    private Integer activityJoin;
    private Integer weekActivityJoin;
    private Integer dayActivityJoin;
    private Integer intervalActivityJoin;
    private String periodActivityJoin;
    private Integer activityPageStay;
    private String launchTrade;
    private String weekLaunchTrade;
    private Map<String, Integer> dayLaunchTrade;
    private Integer intervalLaunchTrade;
    private String periodLaunchTrade;
    private Integer avgLaunchStay;
    private String lastLaunchTrade;
    private Integer clickLaunchTrade;
    private String clickTrade;
    private String weekClickTrade;
    private Map<String, Integer> dayClickTrade;
    private Integer intervalClickTrade;
    private String periodClickTrade;
    private String lastClickTrade;
    private Integer effectClickTrade;
    private String effectTrade;
    private String weekEffectTrade;
    private Map<String, Integer> dayEffectTrade;
    private Integer intervalEffectTrade;
    private String periodEffectTrade;
    private String lastEffectTrade;
    private Long todayLaunch;
    private Long historyLaunch;
    private Long todayActivityLaunch;
    private Long historyActivityLaunch;
    private String lastLaunchTime;
    private String lastActivityLaunchTime;
    private String lastActivityLaunchOrder;
    private String lastActivityClickOrder;
    private String lastLaunchOrder;
    private String lastClickOrder;
    private String lastActivity;
    private String lastAdvertMatchTag;
    private Map<String, Long> todayResourceLaunch;
    private Map<String, String> lastResourceLaunchTime;
    private Map<String, String> lastResourceLaunchOrder;
    private Map<String, String> lastResourceClickOrder;
    private Map<String, String> lastResourceEffectOrder;
    private Map<String, Long> todayResourceClickAdvertCount;
    private Map<String, Long> todayResourceEffectAdvertCount;
    private String lastResource;
    private String lastLaunchAccount;
    private String lastLaunchPlan;
    private Set<Integer> advertExposureSet;
    private Set<Integer> advertClickSet;
    private Set<Integer> accountClickSet;
    private Set<String> resourceClickSet;
    private Set<Integer> tradeClickSet;
    private Set<Integer> advertEffectSet;
    private Set<Integer> accountEffectSet;
    private Set<String> resourceEffectSet;
    private Set<Integer> tradeEffectSet;
    private Map<Integer, Long> todayAdvertLaunch;
    private Map<Integer, Long> todayAdvertClick;
    private Map<Integer, Long> todayAdvertEffect;
    private Map<Integer, Long> historyAdvertLaunch;
    private Map<Integer, Long> historyAdvertClick;
    private Map<Integer, Long> historyAdvertEffect;
    private Integer history30LaunchCount;
    private Integer history30ClickCount;
    private Integer history30EffectCount;
    private Integer todayLaunchCount;
    private Integer todayClickCount;
    private Integer todayEffectCount;
    private String oUIIds;
    private String oUILaunchPV;
    private String oUIClickPv;
    private String oUIEffectPv;
    private Map<String, Long> historyTradeLaunch;
    private Map<String, Long> historyTradeClick;
    private Map<String, Long> historyTradeEffect;
    private Map<String, Map<String, Long>> historyTradeCtrCvr;
    private String clickCategory;
    private String weekClickCategory;
    private Map<String, Integer> dayClickCategory;
    private Integer intervalClickCategory;
    private String periodClickCategory;
    private Integer avgLandpageStay;
    private String lastClickCategory;
    private Integer effectClickCategory;
    private String lastClickBrand;
    private Integer issueEffectClickCategory;
    private String effectCategory;
    private String weekEffectCategory;
    private Map<String, Integer> dayEffectCategory;
    private Integer intervalEffectCategory;
    private String periodEffectCategory;
    private String lastEffectCategory;
    private String lastEffectBrand;
    private Integer addressCount;
    private Integer numberCount;
    private String issueEffectCategory;
    private String weekIssueEffectCategory;
    private Integer intervalIssueEffectCategory;
    private String periodIssueEffectCategory;
    private String lastIssueEffectCategory;
    private String lastIssueEffectBrand;
    private String scoreEffectCategory;
    private String scoreIssueEffectCategory;
    private Integer orderFee;
    private Integer weekOrderFee;
    private Integer maxOrderFee;
    private Integer minOrderFee;
    private Integer avgOrderFee;
    private Integer lastOrderFee;
    private Integer zeroLaunch;
    private Integer nonZeroLaunch;
    private Integer zeroClick;
    private Integer nonZeroClick;
    private Integer zeroEffect;
    private Integer nonZeroEffect;
    private Integer zeroIssueEffect;
    private Integer nonZeroIssueEffect;
    private Integer vouchFailed;
    private Integer weekVouchFailed;
    private Integer intervalVouchFailed;
    private Integer reject;
    private Integer weekReject;
    private Integer intervalReject;
    private Integer complaint;
    private Integer weekComplaint;
    private Integer intervalComplaint;
    private Integer addressException;
    private Integer weekAddressException;
    private Integer intervalAddressException;
    private Integer numberEmpty;
    private Integer weekNumberEmpty;
    private Integer intervalNumberEmpty;
    private Integer cheat;
    private Integer weekCheat;
    private Integer intervalCheat;
    private String lastApp;
    private Long lastVideoTime;
    private String lastVideoChannel;
    private String lastVideoInfo;
    private String lastVideoCategory;
    private String lastVideoArea;
    private String lastVideoYears;
    private String histEntrancesExposeTime;
    private String weekEntrancesExposeTime;
    private Map<String, Integer> dayEntrancesExposeTime;
    private String materialExposeInterval;
    private String materialExposePeriod;
    private Integer cHistEntrancesExposeTime;
    private Integer cWeekEntrancesExposeTime;
    private Integer cDayEntrancesExposeTime;
    private Integer cMaterialExposeInterval;
    private String histEntrancesClickTime;
    private String weekEntrancesClickTime;
    private Map<String, Integer> dayEntrancesClickTime;
    private String materialClickInterval;
    private String materialClickPeriod;
    private Integer cHistEntrancesClickTime;
    private Integer cWeekEntrancesClickTime;
    private Integer cDayEntrancesClickTime;
    private Integer cMaterialClickInterval;
    private String histMainTitlesExposeTime;
    private String weekMainTitlesExposeTime;
    private Map<String, Integer> dayMainTitlesExposeTime;
    private String histSubTitlesExposeTime;
    private String weekSubTitlesExposeTime;
    private Map<String, Integer> daySubTitlesExposeTime;
    private String histPrizesExposeTime;
    private String weekPrizesExposeTime;
    private Map<String, Integer> dayPrizesExposeTime;
    private String histSkinsExposeTime;
    private String weekSkinsExposeTime;
    private Map<String, Integer> daySkinsExposeTime;
    private String histActExposeTime;
    private String weekActExposeTime;
    private Map<String, Integer> dayActExposeTime;
    private String histMainTitlesClickTime;
    private String weekMainTitlesClickTime;
    private Map<String, Integer> dayMainTitlesClickTime;
    private String histSubTitlesClickTime;
    private String weekSubTitlesClickTime;
    private Map<String, Integer> daySubTitlesClickTime;
    private String histPrizesClickTime;
    private String weekPrizesClickTime;
    private Map<String, Integer> dayPrizesClickTime;
    private String histSkinsClickTime;
    private String weekSkinsClickTime;
    private Map<String, Integer> daySkinsClickTime;
    private String histActClickTime;
    private String weekActClickTime;
    private Map<String, Integer> dayActClickTime;
    private String histMainTitlesOrderTime;
    private String weekMainTitlesOrderTime;
    private Map<String, Integer> dayMainTitlesOrderTime;
    private String histSubTitlesOrderTime;
    private String weekSubTitlesOrderTime;
    private Map<String, Integer> daySubTitlesOrderTime;
    private String histPrizesOrderTime;
    private String weekPrizesOrderTime;
    private Map<String, Integer> dayPrizesOrderTime;
    private String histSkinsOrderTime;
    private String weekSkinsOrderTime;
    private Map<String, Integer> daySkinsOrderTime;
    private String histActOrderTime;
    private String weekActOrderTime;
    private Map<String, Integer> dayActOrderTime;
    private String launchSequence;
    private String mainTitleSequence;
    private String subTitleSequence;
    private String prizeSequence;
    private String prizeCategorySequence;
    private String skinSequence;

    public Map<String, Long> getHistoryTradeLaunch() {
        if (this.historyTradeLaunch != null) {
            return this.historyTradeLaunch;
        }
        Map<String, String> historyTradeLaunchMap = DataConverter.series2Map(this.oUIIds, this.oUILaunchPV, ",");
        HashMap<String, Long> historyTradeLaunchMapL = new HashMap<String, Long>();
        try {
            for (Map.Entry<String, String> entry : historyTradeLaunchMap.entrySet()) {
                historyTradeLaunchMapL.put(entry.getKey(), DataUtil.str2Long((String)entry.getValue(), (Long)0L));
            }
            this.historyTradeLaunch = historyTradeLaunchMapL;
        }
        catch (Exception e) {
            logger.error("FeatureParse2.getHistoryTradeLaunch error", (Throwable)e);
            return historyTradeLaunchMapL;
        }
        return historyTradeLaunchMapL;
    }

    public Map<String, Long> getHistoryTradeClick() {
        if (this.historyTradeClick != null) {
            return this.historyTradeClick;
        }
        Map<String, String> historyTradeClickMap = DataConverter.series2Map(this.oUIIds, this.oUIClickPv, ",");
        HashMap<String, Long> historyTradeClickMapL = new HashMap<String, Long>();
        try {
            for (Map.Entry<String, String> entry : historyTradeClickMap.entrySet()) {
                historyTradeClickMapL.put(entry.getKey(), DataUtil.str2Long((String)entry.getValue(), (Long)0L));
            }
            this.historyTradeClick = historyTradeClickMapL;
        }
        catch (Exception e) {
            logger.error("FeatureParse2.getHistoryTradeClick error", (Throwable)e);
            return historyTradeClickMapL;
        }
        return historyTradeClickMapL;
    }

    public Map<String, Long> getHistoryTradeEffect() {
        if (this.historyTradeEffect != null) {
            return this.historyTradeEffect;
        }
        Map<String, String> historyTradeEffectMap = DataConverter.series2Map(this.oUIIds, this.oUIEffectPv, ",");
        HashMap<String, Long> historyTradeEffectMapL = new HashMap<String, Long>();
        try {
            for (Map.Entry<String, String> entry : historyTradeEffectMap.entrySet()) {
                historyTradeEffectMapL.put(entry.getKey(), DataUtil.str2Long((String)entry.getValue(), (Long)0L));
            }
            this.historyTradeEffect = historyTradeEffectMapL;
        }
        catch (Exception e) {
            logger.error("FeatureParse2.getHistoryTradeEffect error", (Throwable)e);
            return historyTradeEffectMapL;
        }
        return historyTradeEffectMapL;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public Map<String, Map<String, Long>> getHistoryTradeCtrCvr() {
        if (this.historyTradeCtrCvr != null) {
            return this.historyTradeCtrCvr;
        }
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        Map<String, Long> historyTradeLaunch = this.getHistoryTradeLaunch();
        Map<String, Long> historyTradeClick = this.getHistoryTradeClick();
        Map<String, Long> historyTradeEffect = this.getHistoryTradeEffect();
        if (this.oUIIds == null || AssertUtil.isEmpty((String)this.oUIIds)) {
            return ret;
        }
        String[] oUIIdsArr = this.oUIIds.split(",");
        for (int i = 0; i < oUIIdsArr.length; ++i) {
            String id = oUIIdsArr[i];
            Long launchPv = historyTradeLaunch.getOrDefault(id, 0L);
            Long clickPv = historyTradeClick.getOrDefault(id, 0L);
            Long effectPv = historyTradeEffect.getOrDefault(id, 0L);
            Double ctr = UserActFeature.getCtrOrCvr(launchPv, clickPv);
            Double cvr = UserActFeature.getCtrOrCvr(clickPv, effectPv);
            Long ctrBkt = DataUtil.str2Long((String)DataConverter.bucketRight((Number)ctr, (Number[])userCtrBucket), (Long)0L);
            Long cvrBkt = DataUtil.str2Long((String)DataConverter.bucketRight((Number)cvr, (Number[])userCvrBucket), (Long)0L);
            ((Map)ret.get("ctr")).put(id, ctrBkt);
            ((Map)ret.get("cvr")).put(id, cvrBkt);
        }
        Long launchAccPv = DataConverter.accumulateMapValues(historyTradeLaunch).longValue();
        Long clickAccPv = DataConverter.accumulateMapValues(historyTradeClick).longValue();
        Long effectAccPv = DataConverter.accumulateMapValues(historyTradeEffect).longValue();
        Double ctr = UserActFeature.getCtrOrCvr(launchAccPv, clickAccPv);
        Double cvr = UserActFeature.getCtrOrCvr(clickAccPv, effectAccPv);
        Long ctrBucketLevel = DataUtil.str2Long((String)DataConverter.bucketRight((Number)ctr, (Number[])userCtrBucket), (Long)0L);
        Long cvrBucketLevel = DataUtil.str2Long((String)DataConverter.bucketRight((Number)cvr, (Number[])userCvrBucket), (Long)0L);
        ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
        ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
        this.historyTradeCtrCvr = ret;
        return ret;
    }

    public Integer getHistory30LaunchCount() {
        if (this.history30LaunchCount != null) {
            return this.history30LaunchCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertLaunch).intValue();
    }

    public Integer getHistory30ClickCount() {
        if (this.history30ClickCount != null) {
            return this.history30ClickCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertClick).intValue();
    }

    public Integer getHistory30EffectCount() {
        if (this.history30EffectCount != null) {
            return this.history30EffectCount;
        }
        return DataConverter.accumulateMapValues(this.historyAdvertEffect).intValue();
    }

    public Integer getTodayLaunchCount() {
        if (this.todayLaunchCount != null) {
            return this.todayLaunchCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertLaunch).intValue();
    }

    public Integer getTodayClickCount() {
        if (this.todayClickCount != null) {
            return this.todayClickCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertClick).intValue();
    }

    public Integer getTodayEffectCount() {
        if (this.todayEffectCount != null) {
            return this.todayEffectCount;
        }
        return DataConverter.accumulateMapValues(this.todayAdvertEffect).intValue();
    }

    public Integer getUserActiveDays() {
        return this.userActiveDays;
    }

    public Integer getActivityRequest() {
        return this.activityRequest;
    }

    public Integer getWeekActivityRequest() {
        return this.weekActivityRequest;
    }

    public Integer getDayActivityRequest() {
        return this.dayActivityRequest;
    }

    public Integer getIntervalActivityRequest() {
        return this.intervalActivityRequest;
    }

    public String getPeriodActivityRequest() {
        return this.periodActivityRequest;
    }

    public Integer getActivityJoin() {
        return this.activityJoin;
    }

    public Integer getWeekActivityJoin() {
        return this.weekActivityJoin;
    }

    public Integer getDayActivityJoin() {
        return this.dayActivityJoin;
    }

    public Integer getIntervalActivityJoin() {
        return this.intervalActivityJoin;
    }

    public String getPeriodActivityJoin() {
        return this.periodActivityJoin;
    }

    public Integer getActivityPageStay() {
        return this.activityPageStay;
    }

    public String getLaunchTrade() {
        return this.launchTrade;
    }

    public String getWeekLaunchTrade() {
        return this.weekLaunchTrade;
    }

    public Map<String, Integer> getDayLaunchTrade() {
        return this.dayLaunchTrade;
    }

    public Integer getIntervalLaunchTrade() {
        return this.intervalLaunchTrade;
    }

    public String getPeriodLaunchTrade() {
        return this.periodLaunchTrade;
    }

    public Integer getAvgLaunchStay() {
        return this.avgLaunchStay;
    }

    public String getLastLaunchTrade() {
        return this.lastLaunchTrade;
    }

    public Integer getClickLaunchTrade() {
        return this.clickLaunchTrade;
    }

    public String getClickTrade() {
        return this.clickTrade;
    }

    public String getWeekClickTrade() {
        return this.weekClickTrade;
    }

    public Map<String, Integer> getDayClickTrade() {
        return this.dayClickTrade;
    }

    public Integer getIntervalClickTrade() {
        return this.intervalClickTrade;
    }

    public String getPeriodClickTrade() {
        return this.periodClickTrade;
    }

    public String getLastClickTrade() {
        return this.lastClickTrade;
    }

    public Integer getEffectClickTrade() {
        return this.effectClickTrade;
    }

    public String getEffectTrade() {
        return this.effectTrade;
    }

    public String getWeekEffectTrade() {
        return this.weekEffectTrade;
    }

    public Map<String, Integer> getDayEffectTrade() {
        return this.dayEffectTrade;
    }

    public Integer getIntervalEffectTrade() {
        return this.intervalEffectTrade;
    }

    public String getPeriodEffectTrade() {
        return this.periodEffectTrade;
    }

    public String getLastEffectTrade() {
        return this.lastEffectTrade;
    }

    public Long getTodayLaunch() {
        return this.todayLaunch;
    }

    public Long getHistoryLaunch() {
        return this.historyLaunch;
    }

    public Long getTodayActivityLaunch() {
        return this.todayActivityLaunch;
    }

    public Long getHistoryActivityLaunch() {
        return this.historyActivityLaunch;
    }

    public String getLastLaunchTime() {
        return this.lastLaunchTime;
    }

    public String getLastActivityLaunchTime() {
        return this.lastActivityLaunchTime;
    }

    public String getLastActivityLaunchOrder() {
        return this.lastActivityLaunchOrder;
    }

    public String getLastActivityClickOrder() {
        return this.lastActivityClickOrder;
    }

    public String getLastLaunchOrder() {
        return this.lastLaunchOrder;
    }

    public String getLastClickOrder() {
        return this.lastClickOrder;
    }

    public String getLastActivity() {
        return this.lastActivity;
    }

    public String getLastAdvertMatchTag() {
        return this.lastAdvertMatchTag;
    }

    public Map<String, Long> getTodayResourceLaunch() {
        return this.todayResourceLaunch;
    }

    public Map<String, String> getLastResourceLaunchTime() {
        return this.lastResourceLaunchTime;
    }

    public Map<String, String> getLastResourceLaunchOrder() {
        return this.lastResourceLaunchOrder;
    }

    public Map<String, String> getLastResourceClickOrder() {
        return this.lastResourceClickOrder;
    }

    public Map<String, String> getLastResourceEffectOrder() {
        return this.lastResourceEffectOrder;
    }

    public Map<String, Long> getTodayResourceClickAdvertCount() {
        return this.todayResourceClickAdvertCount;
    }

    public Map<String, Long> getTodayResourceEffectAdvertCount() {
        return this.todayResourceEffectAdvertCount;
    }

    public String getLastResource() {
        return this.lastResource;
    }

    public String getLastLaunchAccount() {
        return this.lastLaunchAccount;
    }

    public String getLastLaunchPlan() {
        return this.lastLaunchPlan;
    }

    public Set<Integer> getAdvertExposureSet() {
        return this.advertExposureSet;
    }

    public Set<Integer> getAdvertClickSet() {
        return this.advertClickSet;
    }

    public Set<Integer> getAccountClickSet() {
        return this.accountClickSet;
    }

    public Set<String> getResourceClickSet() {
        return this.resourceClickSet;
    }

    public Set<Integer> getTradeClickSet() {
        return this.tradeClickSet;
    }

    public Set<Integer> getAdvertEffectSet() {
        return this.advertEffectSet;
    }

    public Set<Integer> getAccountEffectSet() {
        return this.accountEffectSet;
    }

    public Set<String> getResourceEffectSet() {
        return this.resourceEffectSet;
    }

    public Set<Integer> getTradeEffectSet() {
        return this.tradeEffectSet;
    }

    public Map<Integer, Long> getTodayAdvertLaunch() {
        return this.todayAdvertLaunch;
    }

    public Map<Integer, Long> getTodayAdvertClick() {
        return this.todayAdvertClick;
    }

    public Map<Integer, Long> getTodayAdvertEffect() {
        return this.todayAdvertEffect;
    }

    public Map<Integer, Long> getHistoryAdvertLaunch() {
        return this.historyAdvertLaunch;
    }

    public Map<Integer, Long> getHistoryAdvertClick() {
        return this.historyAdvertClick;
    }

    public Map<Integer, Long> getHistoryAdvertEffect() {
        return this.historyAdvertEffect;
    }

    public String getOUIIds() {
        return this.oUIIds;
    }

    public String getOUILaunchPV() {
        return this.oUILaunchPV;
    }

    public String getOUIClickPv() {
        return this.oUIClickPv;
    }

    public String getOUIEffectPv() {
        return this.oUIEffectPv;
    }

    public String getClickCategory() {
        return this.clickCategory;
    }

    public String getWeekClickCategory() {
        return this.weekClickCategory;
    }

    public Map<String, Integer> getDayClickCategory() {
        return this.dayClickCategory;
    }

    public Integer getIntervalClickCategory() {
        return this.intervalClickCategory;
    }

    public String getPeriodClickCategory() {
        return this.periodClickCategory;
    }

    public Integer getAvgLandpageStay() {
        return this.avgLandpageStay;
    }

    public String getLastClickCategory() {
        return this.lastClickCategory;
    }

    public Integer getEffectClickCategory() {
        return this.effectClickCategory;
    }

    public String getLastClickBrand() {
        return this.lastClickBrand;
    }

    public Integer getIssueEffectClickCategory() {
        return this.issueEffectClickCategory;
    }

    public String getEffectCategory() {
        return this.effectCategory;
    }

    public String getWeekEffectCategory() {
        return this.weekEffectCategory;
    }

    public Map<String, Integer> getDayEffectCategory() {
        return this.dayEffectCategory;
    }

    public Integer getIntervalEffectCategory() {
        return this.intervalEffectCategory;
    }

    public String getPeriodEffectCategory() {
        return this.periodEffectCategory;
    }

    public String getLastEffectCategory() {
        return this.lastEffectCategory;
    }

    public String getLastEffectBrand() {
        return this.lastEffectBrand;
    }

    public Integer getAddressCount() {
        return this.addressCount;
    }

    public Integer getNumberCount() {
        return this.numberCount;
    }

    public String getIssueEffectCategory() {
        return this.issueEffectCategory;
    }

    public String getWeekIssueEffectCategory() {
        return this.weekIssueEffectCategory;
    }

    public Integer getIntervalIssueEffectCategory() {
        return this.intervalIssueEffectCategory;
    }

    public String getPeriodIssueEffectCategory() {
        return this.periodIssueEffectCategory;
    }

    public String getLastIssueEffectCategory() {
        return this.lastIssueEffectCategory;
    }

    public String getLastIssueEffectBrand() {
        return this.lastIssueEffectBrand;
    }

    public String getScoreEffectCategory() {
        return this.scoreEffectCategory;
    }

    public String getScoreIssueEffectCategory() {
        return this.scoreIssueEffectCategory;
    }

    public Integer getOrderFee() {
        return this.orderFee;
    }

    public Integer getWeekOrderFee() {
        return this.weekOrderFee;
    }

    public Integer getMaxOrderFee() {
        return this.maxOrderFee;
    }

    public Integer getMinOrderFee() {
        return this.minOrderFee;
    }

    public Integer getAvgOrderFee() {
        return this.avgOrderFee;
    }

    public Integer getLastOrderFee() {
        return this.lastOrderFee;
    }

    public Integer getZeroLaunch() {
        return this.zeroLaunch;
    }

    public Integer getNonZeroLaunch() {
        return this.nonZeroLaunch;
    }

    public Integer getZeroClick() {
        return this.zeroClick;
    }

    public Integer getNonZeroClick() {
        return this.nonZeroClick;
    }

    public Integer getZeroEffect() {
        return this.zeroEffect;
    }

    public Integer getNonZeroEffect() {
        return this.nonZeroEffect;
    }

    public Integer getZeroIssueEffect() {
        return this.zeroIssueEffect;
    }

    public Integer getNonZeroIssueEffect() {
        return this.nonZeroIssueEffect;
    }

    public Integer getVouchFailed() {
        return this.vouchFailed;
    }

    public Integer getWeekVouchFailed() {
        return this.weekVouchFailed;
    }

    public Integer getIntervalVouchFailed() {
        return this.intervalVouchFailed;
    }

    public Integer getReject() {
        return this.reject;
    }

    public Integer getWeekReject() {
        return this.weekReject;
    }

    public Integer getIntervalReject() {
        return this.intervalReject;
    }

    public Integer getComplaint() {
        return this.complaint;
    }

    public Integer getWeekComplaint() {
        return this.weekComplaint;
    }

    public Integer getIntervalComplaint() {
        return this.intervalComplaint;
    }

    public Integer getAddressException() {
        return this.addressException;
    }

    public Integer getWeekAddressException() {
        return this.weekAddressException;
    }

    public Integer getIntervalAddressException() {
        return this.intervalAddressException;
    }

    public Integer getNumberEmpty() {
        return this.numberEmpty;
    }

    public Integer getWeekNumberEmpty() {
        return this.weekNumberEmpty;
    }

    public Integer getIntervalNumberEmpty() {
        return this.intervalNumberEmpty;
    }

    public Integer getCheat() {
        return this.cheat;
    }

    public Integer getWeekCheat() {
        return this.weekCheat;
    }

    public Integer getIntervalCheat() {
        return this.intervalCheat;
    }

    public String getLastApp() {
        return this.lastApp;
    }

    public Long getLastVideoTime() {
        return this.lastVideoTime;
    }

    public String getLastVideoChannel() {
        return this.lastVideoChannel;
    }

    public String getLastVideoInfo() {
        return this.lastVideoInfo;
    }

    public String getLastVideoCategory() {
        return this.lastVideoCategory;
    }

    public String getLastVideoArea() {
        return this.lastVideoArea;
    }

    public String getLastVideoYears() {
        return this.lastVideoYears;
    }

    public String getHistEntrancesExposeTime() {
        return this.histEntrancesExposeTime;
    }

    public String getWeekEntrancesExposeTime() {
        return this.weekEntrancesExposeTime;
    }

    public Map<String, Integer> getDayEntrancesExposeTime() {
        return this.dayEntrancesExposeTime;
    }

    public String getMaterialExposeInterval() {
        return this.materialExposeInterval;
    }

    public String getMaterialExposePeriod() {
        return this.materialExposePeriod;
    }

    public Integer getCHistEntrancesExposeTime() {
        return this.cHistEntrancesExposeTime;
    }

    public Integer getCWeekEntrancesExposeTime() {
        return this.cWeekEntrancesExposeTime;
    }

    public Integer getCDayEntrancesExposeTime() {
        return this.cDayEntrancesExposeTime;
    }

    public Integer getCMaterialExposeInterval() {
        return this.cMaterialExposeInterval;
    }

    public String getHistEntrancesClickTime() {
        return this.histEntrancesClickTime;
    }

    public String getWeekEntrancesClickTime() {
        return this.weekEntrancesClickTime;
    }

    public Map<String, Integer> getDayEntrancesClickTime() {
        return this.dayEntrancesClickTime;
    }

    public String getMaterialClickInterval() {
        return this.materialClickInterval;
    }

    public String getMaterialClickPeriod() {
        return this.materialClickPeriod;
    }

    public Integer getCHistEntrancesClickTime() {
        return this.cHistEntrancesClickTime;
    }

    public Integer getCWeekEntrancesClickTime() {
        return this.cWeekEntrancesClickTime;
    }

    public Integer getCDayEntrancesClickTime() {
        return this.cDayEntrancesClickTime;
    }

    public Integer getCMaterialClickInterval() {
        return this.cMaterialClickInterval;
    }

    public String getHistMainTitlesExposeTime() {
        return this.histMainTitlesExposeTime;
    }

    public String getWeekMainTitlesExposeTime() {
        return this.weekMainTitlesExposeTime;
    }

    public Map<String, Integer> getDayMainTitlesExposeTime() {
        return this.dayMainTitlesExposeTime;
    }

    public String getHistSubTitlesExposeTime() {
        return this.histSubTitlesExposeTime;
    }

    public String getWeekSubTitlesExposeTime() {
        return this.weekSubTitlesExposeTime;
    }

    public Map<String, Integer> getDaySubTitlesExposeTime() {
        return this.daySubTitlesExposeTime;
    }

    public String getHistPrizesExposeTime() {
        return this.histPrizesExposeTime;
    }

    public String getWeekPrizesExposeTime() {
        return this.weekPrizesExposeTime;
    }

    public Map<String, Integer> getDayPrizesExposeTime() {
        return this.dayPrizesExposeTime;
    }

    public String getHistSkinsExposeTime() {
        return this.histSkinsExposeTime;
    }

    public String getWeekSkinsExposeTime() {
        return this.weekSkinsExposeTime;
    }

    public Map<String, Integer> getDaySkinsExposeTime() {
        return this.daySkinsExposeTime;
    }

    public String getHistActExposeTime() {
        return this.histActExposeTime;
    }

    public String getWeekActExposeTime() {
        return this.weekActExposeTime;
    }

    public Map<String, Integer> getDayActExposeTime() {
        return this.dayActExposeTime;
    }

    public String getHistMainTitlesClickTime() {
        return this.histMainTitlesClickTime;
    }

    public String getWeekMainTitlesClickTime() {
        return this.weekMainTitlesClickTime;
    }

    public Map<String, Integer> getDayMainTitlesClickTime() {
        return this.dayMainTitlesClickTime;
    }

    public String getHistSubTitlesClickTime() {
        return this.histSubTitlesClickTime;
    }

    public String getWeekSubTitlesClickTime() {
        return this.weekSubTitlesClickTime;
    }

    public Map<String, Integer> getDaySubTitlesClickTime() {
        return this.daySubTitlesClickTime;
    }

    public String getHistPrizesClickTime() {
        return this.histPrizesClickTime;
    }

    public String getWeekPrizesClickTime() {
        return this.weekPrizesClickTime;
    }

    public Map<String, Integer> getDayPrizesClickTime() {
        return this.dayPrizesClickTime;
    }

    public String getHistSkinsClickTime() {
        return this.histSkinsClickTime;
    }

    public String getWeekSkinsClickTime() {
        return this.weekSkinsClickTime;
    }

    public Map<String, Integer> getDaySkinsClickTime() {
        return this.daySkinsClickTime;
    }

    public String getHistActClickTime() {
        return this.histActClickTime;
    }

    public String getWeekActClickTime() {
        return this.weekActClickTime;
    }

    public Map<String, Integer> getDayActClickTime() {
        return this.dayActClickTime;
    }

    public String getHistMainTitlesOrderTime() {
        return this.histMainTitlesOrderTime;
    }

    public String getWeekMainTitlesOrderTime() {
        return this.weekMainTitlesOrderTime;
    }

    public Map<String, Integer> getDayMainTitlesOrderTime() {
        return this.dayMainTitlesOrderTime;
    }

    public String getHistSubTitlesOrderTime() {
        return this.histSubTitlesOrderTime;
    }

    public String getWeekSubTitlesOrderTime() {
        return this.weekSubTitlesOrderTime;
    }

    public Map<String, Integer> getDaySubTitlesOrderTime() {
        return this.daySubTitlesOrderTime;
    }

    public String getHistPrizesOrderTime() {
        return this.histPrizesOrderTime;
    }

    public String getWeekPrizesOrderTime() {
        return this.weekPrizesOrderTime;
    }

    public Map<String, Integer> getDayPrizesOrderTime() {
        return this.dayPrizesOrderTime;
    }

    public String getHistSkinsOrderTime() {
        return this.histSkinsOrderTime;
    }

    public String getWeekSkinsOrderTime() {
        return this.weekSkinsOrderTime;
    }

    public Map<String, Integer> getDaySkinsOrderTime() {
        return this.daySkinsOrderTime;
    }

    public String getHistActOrderTime() {
        return this.histActOrderTime;
    }

    public String getWeekActOrderTime() {
        return this.weekActOrderTime;
    }

    public Map<String, Integer> getDayActOrderTime() {
        return this.dayActOrderTime;
    }

    public String getLaunchSequence() {
        return this.launchSequence;
    }

    public String getMainTitleSequence() {
        return this.mainTitleSequence;
    }

    public String getSubTitleSequence() {
        return this.subTitleSequence;
    }

    public String getPrizeSequence() {
        return this.prizeSequence;
    }

    public String getPrizeCategorySequence() {
        return this.prizeCategorySequence;
    }

    public String getSkinSequence() {
        return this.skinSequence;
    }

    public void setUserActiveDays(Integer userActiveDays) {
        this.userActiveDays = userActiveDays;
    }

    public void setActivityRequest(Integer activityRequest) {
        this.activityRequest = activityRequest;
    }

    public void setWeekActivityRequest(Integer weekActivityRequest) {
        this.weekActivityRequest = weekActivityRequest;
    }

    public void setDayActivityRequest(Integer dayActivityRequest) {
        this.dayActivityRequest = dayActivityRequest;
    }

    public void setIntervalActivityRequest(Integer intervalActivityRequest) {
        this.intervalActivityRequest = intervalActivityRequest;
    }

    public void setPeriodActivityRequest(String periodActivityRequest) {
        this.periodActivityRequest = periodActivityRequest;
    }

    public void setActivityJoin(Integer activityJoin) {
        this.activityJoin = activityJoin;
    }

    public void setWeekActivityJoin(Integer weekActivityJoin) {
        this.weekActivityJoin = weekActivityJoin;
    }

    public void setDayActivityJoin(Integer dayActivityJoin) {
        this.dayActivityJoin = dayActivityJoin;
    }

    public void setIntervalActivityJoin(Integer intervalActivityJoin) {
        this.intervalActivityJoin = intervalActivityJoin;
    }

    public void setPeriodActivityJoin(String periodActivityJoin) {
        this.periodActivityJoin = periodActivityJoin;
    }

    public void setActivityPageStay(Integer activityPageStay) {
        this.activityPageStay = activityPageStay;
    }

    public void setLaunchTrade(String launchTrade) {
        this.launchTrade = launchTrade;
    }

    public void setWeekLaunchTrade(String weekLaunchTrade) {
        this.weekLaunchTrade = weekLaunchTrade;
    }

    public void setDayLaunchTrade(Map<String, Integer> dayLaunchTrade) {
        this.dayLaunchTrade = dayLaunchTrade;
    }

    public void setIntervalLaunchTrade(Integer intervalLaunchTrade) {
        this.intervalLaunchTrade = intervalLaunchTrade;
    }

    public void setPeriodLaunchTrade(String periodLaunchTrade) {
        this.periodLaunchTrade = periodLaunchTrade;
    }

    public void setAvgLaunchStay(Integer avgLaunchStay) {
        this.avgLaunchStay = avgLaunchStay;
    }

    public void setLastLaunchTrade(String lastLaunchTrade) {
        this.lastLaunchTrade = lastLaunchTrade;
    }

    public void setClickLaunchTrade(Integer clickLaunchTrade) {
        this.clickLaunchTrade = clickLaunchTrade;
    }

    public void setClickTrade(String clickTrade) {
        this.clickTrade = clickTrade;
    }

    public void setWeekClickTrade(String weekClickTrade) {
        this.weekClickTrade = weekClickTrade;
    }

    public void setDayClickTrade(Map<String, Integer> dayClickTrade) {
        this.dayClickTrade = dayClickTrade;
    }

    public void setIntervalClickTrade(Integer intervalClickTrade) {
        this.intervalClickTrade = intervalClickTrade;
    }

    public void setPeriodClickTrade(String periodClickTrade) {
        this.periodClickTrade = periodClickTrade;
    }

    public void setLastClickTrade(String lastClickTrade) {
        this.lastClickTrade = lastClickTrade;
    }

    public void setEffectClickTrade(Integer effectClickTrade) {
        this.effectClickTrade = effectClickTrade;
    }

    public void setEffectTrade(String effectTrade) {
        this.effectTrade = effectTrade;
    }

    public void setWeekEffectTrade(String weekEffectTrade) {
        this.weekEffectTrade = weekEffectTrade;
    }

    public void setDayEffectTrade(Map<String, Integer> dayEffectTrade) {
        this.dayEffectTrade = dayEffectTrade;
    }

    public void setIntervalEffectTrade(Integer intervalEffectTrade) {
        this.intervalEffectTrade = intervalEffectTrade;
    }

    public void setPeriodEffectTrade(String periodEffectTrade) {
        this.periodEffectTrade = periodEffectTrade;
    }

    public void setLastEffectTrade(String lastEffectTrade) {
        this.lastEffectTrade = lastEffectTrade;
    }

    public void setTodayLaunch(Long todayLaunch) {
        this.todayLaunch = todayLaunch;
    }

    public void setHistoryLaunch(Long historyLaunch) {
        this.historyLaunch = historyLaunch;
    }

    public void setTodayActivityLaunch(Long todayActivityLaunch) {
        this.todayActivityLaunch = todayActivityLaunch;
    }

    public void setHistoryActivityLaunch(Long historyActivityLaunch) {
        this.historyActivityLaunch = historyActivityLaunch;
    }

    public void setLastLaunchTime(String lastLaunchTime) {
        this.lastLaunchTime = lastLaunchTime;
    }

    public void setLastActivityLaunchTime(String lastActivityLaunchTime) {
        this.lastActivityLaunchTime = lastActivityLaunchTime;
    }

    public void setLastActivityLaunchOrder(String lastActivityLaunchOrder) {
        this.lastActivityLaunchOrder = lastActivityLaunchOrder;
    }

    public void setLastActivityClickOrder(String lastActivityClickOrder) {
        this.lastActivityClickOrder = lastActivityClickOrder;
    }

    public void setLastLaunchOrder(String lastLaunchOrder) {
        this.lastLaunchOrder = lastLaunchOrder;
    }

    public void setLastClickOrder(String lastClickOrder) {
        this.lastClickOrder = lastClickOrder;
    }

    public void setLastActivity(String lastActivity) {
        this.lastActivity = lastActivity;
    }

    public void setLastAdvertMatchTag(String lastAdvertMatchTag) {
        this.lastAdvertMatchTag = lastAdvertMatchTag;
    }

    public void setTodayResourceLaunch(Map<String, Long> todayResourceLaunch) {
        this.todayResourceLaunch = todayResourceLaunch;
    }

    public void setLastResourceLaunchTime(Map<String, String> lastResourceLaunchTime) {
        this.lastResourceLaunchTime = lastResourceLaunchTime;
    }

    public void setLastResourceLaunchOrder(Map<String, String> lastResourceLaunchOrder) {
        this.lastResourceLaunchOrder = lastResourceLaunchOrder;
    }

    public void setLastResourceClickOrder(Map<String, String> lastResourceClickOrder) {
        this.lastResourceClickOrder = lastResourceClickOrder;
    }

    public void setLastResourceEffectOrder(Map<String, String> lastResourceEffectOrder) {
        this.lastResourceEffectOrder = lastResourceEffectOrder;
    }

    public void setTodayResourceClickAdvertCount(Map<String, Long> todayResourceClickAdvertCount) {
        this.todayResourceClickAdvertCount = todayResourceClickAdvertCount;
    }

    public void setTodayResourceEffectAdvertCount(Map<String, Long> todayResourceEffectAdvertCount) {
        this.todayResourceEffectAdvertCount = todayResourceEffectAdvertCount;
    }

    public void setLastResource(String lastResource) {
        this.lastResource = lastResource;
    }

    public void setLastLaunchAccount(String lastLaunchAccount) {
        this.lastLaunchAccount = lastLaunchAccount;
    }

    public void setLastLaunchPlan(String lastLaunchPlan) {
        this.lastLaunchPlan = lastLaunchPlan;
    }

    public void setAdvertExposureSet(Set<Integer> advertExposureSet) {
        this.advertExposureSet = advertExposureSet;
    }

    public void setAdvertClickSet(Set<Integer> advertClickSet) {
        this.advertClickSet = advertClickSet;
    }

    public void setAccountClickSet(Set<Integer> accountClickSet) {
        this.accountClickSet = accountClickSet;
    }

    public void setResourceClickSet(Set<String> resourceClickSet) {
        this.resourceClickSet = resourceClickSet;
    }

    public void setTradeClickSet(Set<Integer> tradeClickSet) {
        this.tradeClickSet = tradeClickSet;
    }

    public void setAdvertEffectSet(Set<Integer> advertEffectSet) {
        this.advertEffectSet = advertEffectSet;
    }

    public void setAccountEffectSet(Set<Integer> accountEffectSet) {
        this.accountEffectSet = accountEffectSet;
    }

    public void setResourceEffectSet(Set<String> resourceEffectSet) {
        this.resourceEffectSet = resourceEffectSet;
    }

    public void setTradeEffectSet(Set<Integer> tradeEffectSet) {
        this.tradeEffectSet = tradeEffectSet;
    }

    public void setTodayAdvertLaunch(Map<Integer, Long> todayAdvertLaunch) {
        this.todayAdvertLaunch = todayAdvertLaunch;
    }

    public void setTodayAdvertClick(Map<Integer, Long> todayAdvertClick) {
        this.todayAdvertClick = todayAdvertClick;
    }

    public void setTodayAdvertEffect(Map<Integer, Long> todayAdvertEffect) {
        this.todayAdvertEffect = todayAdvertEffect;
    }

    public void setHistoryAdvertLaunch(Map<Integer, Long> historyAdvertLaunch) {
        this.historyAdvertLaunch = historyAdvertLaunch;
    }

    public void setHistoryAdvertClick(Map<Integer, Long> historyAdvertClick) {
        this.historyAdvertClick = historyAdvertClick;
    }

    public void setHistoryAdvertEffect(Map<Integer, Long> historyAdvertEffect) {
        this.historyAdvertEffect = historyAdvertEffect;
    }

    public void setHistory30LaunchCount(Integer history30LaunchCount) {
        this.history30LaunchCount = history30LaunchCount;
    }

    public void setHistory30ClickCount(Integer history30ClickCount) {
        this.history30ClickCount = history30ClickCount;
    }

    public void setHistory30EffectCount(Integer history30EffectCount) {
        this.history30EffectCount = history30EffectCount;
    }

    public void setTodayLaunchCount(Integer todayLaunchCount) {
        this.todayLaunchCount = todayLaunchCount;
    }

    public void setTodayClickCount(Integer todayClickCount) {
        this.todayClickCount = todayClickCount;
    }

    public void setTodayEffectCount(Integer todayEffectCount) {
        this.todayEffectCount = todayEffectCount;
    }

    public void setOUIIds(String oUIIds) {
        this.oUIIds = oUIIds;
    }

    public void setOUILaunchPV(String oUILaunchPV) {
        this.oUILaunchPV = oUILaunchPV;
    }

    public void setOUIClickPv(String oUIClickPv) {
        this.oUIClickPv = oUIClickPv;
    }

    public void setOUIEffectPv(String oUIEffectPv) {
        this.oUIEffectPv = oUIEffectPv;
    }

    public void setHistoryTradeLaunch(Map<String, Long> historyTradeLaunch) {
        this.historyTradeLaunch = historyTradeLaunch;
    }

    public void setHistoryTradeClick(Map<String, Long> historyTradeClick) {
        this.historyTradeClick = historyTradeClick;
    }

    public void setHistoryTradeEffect(Map<String, Long> historyTradeEffect) {
        this.historyTradeEffect = historyTradeEffect;
    }

    public void setHistoryTradeCtrCvr(Map<String, Map<String, Long>> historyTradeCtrCvr) {
        this.historyTradeCtrCvr = historyTradeCtrCvr;
    }

    public void setClickCategory(String clickCategory) {
        this.clickCategory = clickCategory;
    }

    public void setWeekClickCategory(String weekClickCategory) {
        this.weekClickCategory = weekClickCategory;
    }

    public void setDayClickCategory(Map<String, Integer> dayClickCategory) {
        this.dayClickCategory = dayClickCategory;
    }

    public void setIntervalClickCategory(Integer intervalClickCategory) {
        this.intervalClickCategory = intervalClickCategory;
    }

    public void setPeriodClickCategory(String periodClickCategory) {
        this.periodClickCategory = periodClickCategory;
    }

    public void setAvgLandpageStay(Integer avgLandpageStay) {
        this.avgLandpageStay = avgLandpageStay;
    }

    public void setLastClickCategory(String lastClickCategory) {
        this.lastClickCategory = lastClickCategory;
    }

    public void setEffectClickCategory(Integer effectClickCategory) {
        this.effectClickCategory = effectClickCategory;
    }

    public void setLastClickBrand(String lastClickBrand) {
        this.lastClickBrand = lastClickBrand;
    }

    public void setIssueEffectClickCategory(Integer issueEffectClickCategory) {
        this.issueEffectClickCategory = issueEffectClickCategory;
    }

    public void setEffectCategory(String effectCategory) {
        this.effectCategory = effectCategory;
    }

    public void setWeekEffectCategory(String weekEffectCategory) {
        this.weekEffectCategory = weekEffectCategory;
    }

    public void setDayEffectCategory(Map<String, Integer> dayEffectCategory) {
        this.dayEffectCategory = dayEffectCategory;
    }

    public void setIntervalEffectCategory(Integer intervalEffectCategory) {
        this.intervalEffectCategory = intervalEffectCategory;
    }

    public void setPeriodEffectCategory(String periodEffectCategory) {
        this.periodEffectCategory = periodEffectCategory;
    }

    public void setLastEffectCategory(String lastEffectCategory) {
        this.lastEffectCategory = lastEffectCategory;
    }

    public void setLastEffectBrand(String lastEffectBrand) {
        this.lastEffectBrand = lastEffectBrand;
    }

    public void setAddressCount(Integer addressCount) {
        this.addressCount = addressCount;
    }

    public void setNumberCount(Integer numberCount) {
        this.numberCount = numberCount;
    }

    public void setIssueEffectCategory(String issueEffectCategory) {
        this.issueEffectCategory = issueEffectCategory;
    }

    public void setWeekIssueEffectCategory(String weekIssueEffectCategory) {
        this.weekIssueEffectCategory = weekIssueEffectCategory;
    }

    public void setIntervalIssueEffectCategory(Integer intervalIssueEffectCategory) {
        this.intervalIssueEffectCategory = intervalIssueEffectCategory;
    }

    public void setPeriodIssueEffectCategory(String periodIssueEffectCategory) {
        this.periodIssueEffectCategory = periodIssueEffectCategory;
    }

    public void setLastIssueEffectCategory(String lastIssueEffectCategory) {
        this.lastIssueEffectCategory = lastIssueEffectCategory;
    }

    public void setLastIssueEffectBrand(String lastIssueEffectBrand) {
        this.lastIssueEffectBrand = lastIssueEffectBrand;
    }

    public void setScoreEffectCategory(String scoreEffectCategory) {
        this.scoreEffectCategory = scoreEffectCategory;
    }

    public void setScoreIssueEffectCategory(String scoreIssueEffectCategory) {
        this.scoreIssueEffectCategory = scoreIssueEffectCategory;
    }

    public void setOrderFee(Integer orderFee) {
        this.orderFee = orderFee;
    }

    public void setWeekOrderFee(Integer weekOrderFee) {
        this.weekOrderFee = weekOrderFee;
    }

    public void setMaxOrderFee(Integer maxOrderFee) {
        this.maxOrderFee = maxOrderFee;
    }

    public void setMinOrderFee(Integer minOrderFee) {
        this.minOrderFee = minOrderFee;
    }

    public void setAvgOrderFee(Integer avgOrderFee) {
        this.avgOrderFee = avgOrderFee;
    }

    public void setLastOrderFee(Integer lastOrderFee) {
        this.lastOrderFee = lastOrderFee;
    }

    public void setZeroLaunch(Integer zeroLaunch) {
        this.zeroLaunch = zeroLaunch;
    }

    public void setNonZeroLaunch(Integer nonZeroLaunch) {
        this.nonZeroLaunch = nonZeroLaunch;
    }

    public void setZeroClick(Integer zeroClick) {
        this.zeroClick = zeroClick;
    }

    public void setNonZeroClick(Integer nonZeroClick) {
        this.nonZeroClick = nonZeroClick;
    }

    public void setZeroEffect(Integer zeroEffect) {
        this.zeroEffect = zeroEffect;
    }

    public void setNonZeroEffect(Integer nonZeroEffect) {
        this.nonZeroEffect = nonZeroEffect;
    }

    public void setZeroIssueEffect(Integer zeroIssueEffect) {
        this.zeroIssueEffect = zeroIssueEffect;
    }

    public void setNonZeroIssueEffect(Integer nonZeroIssueEffect) {
        this.nonZeroIssueEffect = nonZeroIssueEffect;
    }

    public void setVouchFailed(Integer vouchFailed) {
        this.vouchFailed = vouchFailed;
    }

    public void setWeekVouchFailed(Integer weekVouchFailed) {
        this.weekVouchFailed = weekVouchFailed;
    }

    public void setIntervalVouchFailed(Integer intervalVouchFailed) {
        this.intervalVouchFailed = intervalVouchFailed;
    }

    public void setReject(Integer reject) {
        this.reject = reject;
    }

    public void setWeekReject(Integer weekReject) {
        this.weekReject = weekReject;
    }

    public void setIntervalReject(Integer intervalReject) {
        this.intervalReject = intervalReject;
    }

    public void setComplaint(Integer complaint) {
        this.complaint = complaint;
    }

    public void setWeekComplaint(Integer weekComplaint) {
        this.weekComplaint = weekComplaint;
    }

    public void setIntervalComplaint(Integer intervalComplaint) {
        this.intervalComplaint = intervalComplaint;
    }

    public void setAddressException(Integer addressException) {
        this.addressException = addressException;
    }

    public void setWeekAddressException(Integer weekAddressException) {
        this.weekAddressException = weekAddressException;
    }

    public void setIntervalAddressException(Integer intervalAddressException) {
        this.intervalAddressException = intervalAddressException;
    }

    public void setNumberEmpty(Integer numberEmpty) {
        this.numberEmpty = numberEmpty;
    }

    public void setWeekNumberEmpty(Integer weekNumberEmpty) {
        this.weekNumberEmpty = weekNumberEmpty;
    }

    public void setIntervalNumberEmpty(Integer intervalNumberEmpty) {
        this.intervalNumberEmpty = intervalNumberEmpty;
    }

    public void setCheat(Integer cheat) {
        this.cheat = cheat;
    }

    public void setWeekCheat(Integer weekCheat) {
        this.weekCheat = weekCheat;
    }

    public void setIntervalCheat(Integer intervalCheat) {
        this.intervalCheat = intervalCheat;
    }

    public void setLastApp(String lastApp) {
        this.lastApp = lastApp;
    }

    public void setLastVideoTime(Long lastVideoTime) {
        this.lastVideoTime = lastVideoTime;
    }

    public void setLastVideoChannel(String lastVideoChannel) {
        this.lastVideoChannel = lastVideoChannel;
    }

    public void setLastVideoInfo(String lastVideoInfo) {
        this.lastVideoInfo = lastVideoInfo;
    }

    public void setLastVideoCategory(String lastVideoCategory) {
        this.lastVideoCategory = lastVideoCategory;
    }

    public void setLastVideoArea(String lastVideoArea) {
        this.lastVideoArea = lastVideoArea;
    }

    public void setLastVideoYears(String lastVideoYears) {
        this.lastVideoYears = lastVideoYears;
    }

    public void setHistEntrancesExposeTime(String histEntrancesExposeTime) {
        this.histEntrancesExposeTime = histEntrancesExposeTime;
    }

    public void setWeekEntrancesExposeTime(String weekEntrancesExposeTime) {
        this.weekEntrancesExposeTime = weekEntrancesExposeTime;
    }

    public void setDayEntrancesExposeTime(Map<String, Integer> dayEntrancesExposeTime) {
        this.dayEntrancesExposeTime = dayEntrancesExposeTime;
    }

    public void setMaterialExposeInterval(String materialExposeInterval) {
        this.materialExposeInterval = materialExposeInterval;
    }

    public void setMaterialExposePeriod(String materialExposePeriod) {
        this.materialExposePeriod = materialExposePeriod;
    }

    public void setCHistEntrancesExposeTime(Integer cHistEntrancesExposeTime) {
        this.cHistEntrancesExposeTime = cHistEntrancesExposeTime;
    }

    public void setCWeekEntrancesExposeTime(Integer cWeekEntrancesExposeTime) {
        this.cWeekEntrancesExposeTime = cWeekEntrancesExposeTime;
    }

    public void setCDayEntrancesExposeTime(Integer cDayEntrancesExposeTime) {
        this.cDayEntrancesExposeTime = cDayEntrancesExposeTime;
    }

    public void setCMaterialExposeInterval(Integer cMaterialExposeInterval) {
        this.cMaterialExposeInterval = cMaterialExposeInterval;
    }

    public void setHistEntrancesClickTime(String histEntrancesClickTime) {
        this.histEntrancesClickTime = histEntrancesClickTime;
    }

    public void setWeekEntrancesClickTime(String weekEntrancesClickTime) {
        this.weekEntrancesClickTime = weekEntrancesClickTime;
    }

    public void setDayEntrancesClickTime(Map<String, Integer> dayEntrancesClickTime) {
        this.dayEntrancesClickTime = dayEntrancesClickTime;
    }

    public void setMaterialClickInterval(String materialClickInterval) {
        this.materialClickInterval = materialClickInterval;
    }

    public void setMaterialClickPeriod(String materialClickPeriod) {
        this.materialClickPeriod = materialClickPeriod;
    }

    public void setCHistEntrancesClickTime(Integer cHistEntrancesClickTime) {
        this.cHistEntrancesClickTime = cHistEntrancesClickTime;
    }

    public void setCWeekEntrancesClickTime(Integer cWeekEntrancesClickTime) {
        this.cWeekEntrancesClickTime = cWeekEntrancesClickTime;
    }

    public void setCDayEntrancesClickTime(Integer cDayEntrancesClickTime) {
        this.cDayEntrancesClickTime = cDayEntrancesClickTime;
    }

    public void setCMaterialClickInterval(Integer cMaterialClickInterval) {
        this.cMaterialClickInterval = cMaterialClickInterval;
    }

    public void setHistMainTitlesExposeTime(String histMainTitlesExposeTime) {
        this.histMainTitlesExposeTime = histMainTitlesExposeTime;
    }

    public void setWeekMainTitlesExposeTime(String weekMainTitlesExposeTime) {
        this.weekMainTitlesExposeTime = weekMainTitlesExposeTime;
    }

    public void setDayMainTitlesExposeTime(Map<String, Integer> dayMainTitlesExposeTime) {
        this.dayMainTitlesExposeTime = dayMainTitlesExposeTime;
    }

    public void setHistSubTitlesExposeTime(String histSubTitlesExposeTime) {
        this.histSubTitlesExposeTime = histSubTitlesExposeTime;
    }

    public void setWeekSubTitlesExposeTime(String weekSubTitlesExposeTime) {
        this.weekSubTitlesExposeTime = weekSubTitlesExposeTime;
    }

    public void setDaySubTitlesExposeTime(Map<String, Integer> daySubTitlesExposeTime) {
        this.daySubTitlesExposeTime = daySubTitlesExposeTime;
    }

    public void setHistPrizesExposeTime(String histPrizesExposeTime) {
        this.histPrizesExposeTime = histPrizesExposeTime;
    }

    public void setWeekPrizesExposeTime(String weekPrizesExposeTime) {
        this.weekPrizesExposeTime = weekPrizesExposeTime;
    }

    public void setDayPrizesExposeTime(Map<String, Integer> dayPrizesExposeTime) {
        this.dayPrizesExposeTime = dayPrizesExposeTime;
    }

    public void setHistSkinsExposeTime(String histSkinsExposeTime) {
        this.histSkinsExposeTime = histSkinsExposeTime;
    }

    public void setWeekSkinsExposeTime(String weekSkinsExposeTime) {
        this.weekSkinsExposeTime = weekSkinsExposeTime;
    }

    public void setDaySkinsExposeTime(Map<String, Integer> daySkinsExposeTime) {
        this.daySkinsExposeTime = daySkinsExposeTime;
    }

    public void setHistActExposeTime(String histActExposeTime) {
        this.histActExposeTime = histActExposeTime;
    }

    public void setWeekActExposeTime(String weekActExposeTime) {
        this.weekActExposeTime = weekActExposeTime;
    }

    public void setDayActExposeTime(Map<String, Integer> dayActExposeTime) {
        this.dayActExposeTime = dayActExposeTime;
    }

    public void setHistMainTitlesClickTime(String histMainTitlesClickTime) {
        this.histMainTitlesClickTime = histMainTitlesClickTime;
    }

    public void setWeekMainTitlesClickTime(String weekMainTitlesClickTime) {
        this.weekMainTitlesClickTime = weekMainTitlesClickTime;
    }

    public void setDayMainTitlesClickTime(Map<String, Integer> dayMainTitlesClickTime) {
        this.dayMainTitlesClickTime = dayMainTitlesClickTime;
    }

    public void setHistSubTitlesClickTime(String histSubTitlesClickTime) {
        this.histSubTitlesClickTime = histSubTitlesClickTime;
    }

    public void setWeekSubTitlesClickTime(String weekSubTitlesClickTime) {
        this.weekSubTitlesClickTime = weekSubTitlesClickTime;
    }

    public void setDaySubTitlesClickTime(Map<String, Integer> daySubTitlesClickTime) {
        this.daySubTitlesClickTime = daySubTitlesClickTime;
    }

    public void setHistPrizesClickTime(String histPrizesClickTime) {
        this.histPrizesClickTime = histPrizesClickTime;
    }

    public void setWeekPrizesClickTime(String weekPrizesClickTime) {
        this.weekPrizesClickTime = weekPrizesClickTime;
    }

    public void setDayPrizesClickTime(Map<String, Integer> dayPrizesClickTime) {
        this.dayPrizesClickTime = dayPrizesClickTime;
    }

    public void setHistSkinsClickTime(String histSkinsClickTime) {
        this.histSkinsClickTime = histSkinsClickTime;
    }

    public void setWeekSkinsClickTime(String weekSkinsClickTime) {
        this.weekSkinsClickTime = weekSkinsClickTime;
    }

    public void setDaySkinsClickTime(Map<String, Integer> daySkinsClickTime) {
        this.daySkinsClickTime = daySkinsClickTime;
    }

    public void setHistActClickTime(String histActClickTime) {
        this.histActClickTime = histActClickTime;
    }

    public void setWeekActClickTime(String weekActClickTime) {
        this.weekActClickTime = weekActClickTime;
    }

    public void setDayActClickTime(Map<String, Integer> dayActClickTime) {
        this.dayActClickTime = dayActClickTime;
    }

    public void setHistMainTitlesOrderTime(String histMainTitlesOrderTime) {
        this.histMainTitlesOrderTime = histMainTitlesOrderTime;
    }

    public void setWeekMainTitlesOrderTime(String weekMainTitlesOrderTime) {
        this.weekMainTitlesOrderTime = weekMainTitlesOrderTime;
    }

    public void setDayMainTitlesOrderTime(Map<String, Integer> dayMainTitlesOrderTime) {
        this.dayMainTitlesOrderTime = dayMainTitlesOrderTime;
    }

    public void setHistSubTitlesOrderTime(String histSubTitlesOrderTime) {
        this.histSubTitlesOrderTime = histSubTitlesOrderTime;
    }

    public void setWeekSubTitlesOrderTime(String weekSubTitlesOrderTime) {
        this.weekSubTitlesOrderTime = weekSubTitlesOrderTime;
    }

    public void setDaySubTitlesOrderTime(Map<String, Integer> daySubTitlesOrderTime) {
        this.daySubTitlesOrderTime = daySubTitlesOrderTime;
    }

    public void setHistPrizesOrderTime(String histPrizesOrderTime) {
        this.histPrizesOrderTime = histPrizesOrderTime;
    }

    public void setWeekPrizesOrderTime(String weekPrizesOrderTime) {
        this.weekPrizesOrderTime = weekPrizesOrderTime;
    }

    public void setDayPrizesOrderTime(Map<String, Integer> dayPrizesOrderTime) {
        this.dayPrizesOrderTime = dayPrizesOrderTime;
    }

    public void setHistSkinsOrderTime(String histSkinsOrderTime) {
        this.histSkinsOrderTime = histSkinsOrderTime;
    }

    public void setWeekSkinsOrderTime(String weekSkinsOrderTime) {
        this.weekSkinsOrderTime = weekSkinsOrderTime;
    }

    public void setDaySkinsOrderTime(Map<String, Integer> daySkinsOrderTime) {
        this.daySkinsOrderTime = daySkinsOrderTime;
    }

    public void setHistActOrderTime(String histActOrderTime) {
        this.histActOrderTime = histActOrderTime;
    }

    public void setWeekActOrderTime(String weekActOrderTime) {
        this.weekActOrderTime = weekActOrderTime;
    }

    public void setDayActOrderTime(Map<String, Integer> dayActOrderTime) {
        this.dayActOrderTime = dayActOrderTime;
    }

    public void setLaunchSequence(String launchSequence) {
        this.launchSequence = launchSequence;
    }

    public void setMainTitleSequence(String mainTitleSequence) {
        this.mainTitleSequence = mainTitleSequence;
    }

    public void setSubTitleSequence(String subTitleSequence) {
        this.subTitleSequence = subTitleSequence;
    }

    public void setPrizeSequence(String prizeSequence) {
        this.prizeSequence = prizeSequence;
    }

    public void setPrizeCategorySequence(String prizeCategorySequence) {
        this.prizeCategorySequence = prizeCategorySequence;
    }

    public void setSkinSequence(String skinSequence) {
        this.skinSequence = skinSequence;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void other$skinSequence;
        void this$skinSequence;
        void other$prizeCategorySequence;
        void this$prizeCategorySequence;
        void other$prizeSequence;
        void this$prizeSequence;
        void other$subTitleSequence;
        void this$subTitleSequence;
        void other$mainTitleSequence;
        void this$mainTitleSequence;
        void other$launchSequence;
        void this$launchSequence;
        void other$dayActOrderTime;
        void this$dayActOrderTime;
        void other$weekActOrderTime;
        void this$weekActOrderTime;
        void other$histActOrderTime;
        void this$histActOrderTime;
        void other$daySkinsOrderTime;
        void this$daySkinsOrderTime;
        void other$weekSkinsOrderTime;
        void this$weekSkinsOrderTime;
        void other$histSkinsOrderTime;
        void this$histSkinsOrderTime;
        void other$dayPrizesOrderTime;
        void this$dayPrizesOrderTime;
        void other$weekPrizesOrderTime;
        void this$weekPrizesOrderTime;
        void other$histPrizesOrderTime;
        void this$histPrizesOrderTime;
        void other$daySubTitlesOrderTime;
        void this$daySubTitlesOrderTime;
        void other$weekSubTitlesOrderTime;
        void this$weekSubTitlesOrderTime;
        void other$histSubTitlesOrderTime;
        void this$histSubTitlesOrderTime;
        void other$dayMainTitlesOrderTime;
        void this$dayMainTitlesOrderTime;
        void other$weekMainTitlesOrderTime;
        void this$weekMainTitlesOrderTime;
        void other$histMainTitlesOrderTime;
        void this$histMainTitlesOrderTime;
        void other$dayActClickTime;
        void this$dayActClickTime;
        void other$weekActClickTime;
        void this$weekActClickTime;
        void other$histActClickTime;
        void this$histActClickTime;
        void other$daySkinsClickTime;
        void this$daySkinsClickTime;
        void other$weekSkinsClickTime;
        void this$weekSkinsClickTime;
        void other$histSkinsClickTime;
        void this$histSkinsClickTime;
        void other$dayPrizesClickTime;
        void this$dayPrizesClickTime;
        void other$weekPrizesClickTime;
        void this$weekPrizesClickTime;
        void other$histPrizesClickTime;
        void this$histPrizesClickTime;
        void other$daySubTitlesClickTime;
        void this$daySubTitlesClickTime;
        void other$weekSubTitlesClickTime;
        void this$weekSubTitlesClickTime;
        void other$histSubTitlesClickTime;
        void this$histSubTitlesClickTime;
        void other$dayMainTitlesClickTime;
        void this$dayMainTitlesClickTime;
        void other$weekMainTitlesClickTime;
        void this$weekMainTitlesClickTime;
        void other$histMainTitlesClickTime;
        void this$histMainTitlesClickTime;
        void other$dayActExposeTime;
        void this$dayActExposeTime;
        void other$weekActExposeTime;
        void this$weekActExposeTime;
        void other$histActExposeTime;
        void this$histActExposeTime;
        void other$daySkinsExposeTime;
        void this$daySkinsExposeTime;
        void other$weekSkinsExposeTime;
        void this$weekSkinsExposeTime;
        void other$histSkinsExposeTime;
        void this$histSkinsExposeTime;
        void other$dayPrizesExposeTime;
        void this$dayPrizesExposeTime;
        void other$weekPrizesExposeTime;
        void this$weekPrizesExposeTime;
        void other$histPrizesExposeTime;
        void this$histPrizesExposeTime;
        void other$daySubTitlesExposeTime;
        void this$daySubTitlesExposeTime;
        void other$weekSubTitlesExposeTime;
        void this$weekSubTitlesExposeTime;
        void other$histSubTitlesExposeTime;
        void this$histSubTitlesExposeTime;
        void other$dayMainTitlesExposeTime;
        void this$dayMainTitlesExposeTime;
        void other$weekMainTitlesExposeTime;
        void this$weekMainTitlesExposeTime;
        void other$histMainTitlesExposeTime;
        void this$histMainTitlesExposeTime;
        void other$cMaterialClickInterval;
        void this$cMaterialClickInterval;
        void other$cDayEntrancesClickTime;
        void this$cDayEntrancesClickTime;
        void other$cWeekEntrancesClickTime;
        void this$cWeekEntrancesClickTime;
        void other$cHistEntrancesClickTime;
        void this$cHistEntrancesClickTime;
        void other$materialClickPeriod;
        void this$materialClickPeriod;
        void other$materialClickInterval;
        void this$materialClickInterval;
        void other$dayEntrancesClickTime;
        void this$dayEntrancesClickTime;
        void other$weekEntrancesClickTime;
        void this$weekEntrancesClickTime;
        void other$histEntrancesClickTime;
        void this$histEntrancesClickTime;
        void other$cMaterialExposeInterval;
        void this$cMaterialExposeInterval;
        void other$cDayEntrancesExposeTime;
        void this$cDayEntrancesExposeTime;
        void other$cWeekEntrancesExposeTime;
        void this$cWeekEntrancesExposeTime;
        void other$cHistEntrancesExposeTime;
        void this$cHistEntrancesExposeTime;
        void other$materialExposePeriod;
        void this$materialExposePeriod;
        void other$materialExposeInterval;
        void this$materialExposeInterval;
        void other$dayEntrancesExposeTime;
        void this$dayEntrancesExposeTime;
        void other$weekEntrancesExposeTime;
        void this$weekEntrancesExposeTime;
        void other$histEntrancesExposeTime;
        void this$histEntrancesExposeTime;
        void other$lastVideoYears;
        void this$lastVideoYears;
        void other$lastVideoArea;
        void this$lastVideoArea;
        void other$lastVideoCategory;
        void this$lastVideoCategory;
        void other$lastVideoInfo;
        void this$lastVideoInfo;
        void other$lastVideoChannel;
        void this$lastVideoChannel;
        void other$lastVideoTime;
        void this$lastVideoTime;
        void other$lastApp;
        void this$lastApp;
        void other$intervalCheat;
        void this$intervalCheat;
        void other$weekCheat;
        void this$weekCheat;
        void other$cheat;
        void this$cheat;
        void other$intervalNumberEmpty;
        void this$intervalNumberEmpty;
        void other$weekNumberEmpty;
        void this$weekNumberEmpty;
        void other$numberEmpty;
        void this$numberEmpty;
        void other$intervalAddressException;
        void this$intervalAddressException;
        void other$weekAddressException;
        void this$weekAddressException;
        void other$addressException;
        void this$addressException;
        void other$intervalComplaint;
        void this$intervalComplaint;
        void other$weekComplaint;
        void this$weekComplaint;
        void other$complaint;
        void this$complaint;
        void other$intervalReject;
        void this$intervalReject;
        void other$weekReject;
        void this$weekReject;
        void other$reject;
        void this$reject;
        void other$intervalVouchFailed;
        void this$intervalVouchFailed;
        void other$weekVouchFailed;
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserActFeature)) {
            return false;
        }
        UserActFeature other = (UserActFeature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$userActiveDays = this.getUserActiveDays();
        Integer other$userActiveDays = other.getUserActiveDays();
        if (this$userActiveDays == null ? other$userActiveDays != null : !((Object)this$userActiveDays).equals(other$userActiveDays)) {
            return false;
        }
        Integer this$activityRequest = this.getActivityRequest();
        Integer other$activityRequest = other.getActivityRequest();
        if (this$activityRequest == null ? other$activityRequest != null : !((Object)this$activityRequest).equals(other$activityRequest)) {
            return false;
        }
        Integer this$weekActivityRequest = this.getWeekActivityRequest();
        Integer other$weekActivityRequest = other.getWeekActivityRequest();
        if (this$weekActivityRequest == null ? other$weekActivityRequest != null : !((Object)this$weekActivityRequest).equals(other$weekActivityRequest)) {
            return false;
        }
        Integer this$dayActivityRequest = this.getDayActivityRequest();
        Integer other$dayActivityRequest = other.getDayActivityRequest();
        if (this$dayActivityRequest == null ? other$dayActivityRequest != null : !((Object)this$dayActivityRequest).equals(other$dayActivityRequest)) {
            return false;
        }
        Integer this$intervalActivityRequest = this.getIntervalActivityRequest();
        Integer other$intervalActivityRequest = other.getIntervalActivityRequest();
        if (this$intervalActivityRequest == null ? other$intervalActivityRequest != null : !((Object)this$intervalActivityRequest).equals(other$intervalActivityRequest)) {
            return false;
        }
        String this$periodActivityRequest = this.getPeriodActivityRequest();
        String other$periodActivityRequest = other.getPeriodActivityRequest();
        if (this$periodActivityRequest == null ? other$periodActivityRequest != null : !this$periodActivityRequest.equals(other$periodActivityRequest)) {
            return false;
        }
        Integer this$activityJoin = this.getActivityJoin();
        Integer other$activityJoin = other.getActivityJoin();
        if (this$activityJoin == null ? other$activityJoin != null : !((Object)this$activityJoin).equals(other$activityJoin)) {
            return false;
        }
        Integer this$weekActivityJoin = this.getWeekActivityJoin();
        Integer other$weekActivityJoin = other.getWeekActivityJoin();
        if (this$weekActivityJoin == null ? other$weekActivityJoin != null : !((Object)this$weekActivityJoin).equals(other$weekActivityJoin)) {
            return false;
        }
        Integer this$dayActivityJoin = this.getDayActivityJoin();
        Integer other$dayActivityJoin = other.getDayActivityJoin();
        if (this$dayActivityJoin == null ? other$dayActivityJoin != null : !((Object)this$dayActivityJoin).equals(other$dayActivityJoin)) {
            return false;
        }
        Integer this$intervalActivityJoin = this.getIntervalActivityJoin();
        Integer other$intervalActivityJoin = other.getIntervalActivityJoin();
        if (this$intervalActivityJoin == null ? other$intervalActivityJoin != null : !((Object)this$intervalActivityJoin).equals(other$intervalActivityJoin)) {
            return false;
        }
        String this$periodActivityJoin = this.getPeriodActivityJoin();
        String other$periodActivityJoin = other.getPeriodActivityJoin();
        if (this$periodActivityJoin == null ? other$periodActivityJoin != null : !this$periodActivityJoin.equals(other$periodActivityJoin)) {
            return false;
        }
        Integer this$activityPageStay = this.getActivityPageStay();
        Integer other$activityPageStay = other.getActivityPageStay();
        if (this$activityPageStay == null ? other$activityPageStay != null : !((Object)this$activityPageStay).equals(other$activityPageStay)) {
            return false;
        }
        String this$launchTrade = this.getLaunchTrade();
        String other$launchTrade = other.getLaunchTrade();
        if (this$launchTrade == null ? other$launchTrade != null : !this$launchTrade.equals(other$launchTrade)) {
            return false;
        }
        String this$weekLaunchTrade = this.getWeekLaunchTrade();
        String other$weekLaunchTrade = other.getWeekLaunchTrade();
        if (this$weekLaunchTrade == null ? other$weekLaunchTrade != null : !this$weekLaunchTrade.equals(other$weekLaunchTrade)) {
            return false;
        }
        Map<String, Integer> this$dayLaunchTrade = this.getDayLaunchTrade();
        Map<String, Integer> other$dayLaunchTrade = other.getDayLaunchTrade();
        if (this$dayLaunchTrade == null ? other$dayLaunchTrade != null : !((Object)this$dayLaunchTrade).equals(other$dayLaunchTrade)) {
            return false;
        }
        Integer this$intervalLaunchTrade = this.getIntervalLaunchTrade();
        Integer other$intervalLaunchTrade = other.getIntervalLaunchTrade();
        if (this$intervalLaunchTrade == null ? other$intervalLaunchTrade != null : !((Object)this$intervalLaunchTrade).equals(other$intervalLaunchTrade)) {
            return false;
        }
        String this$periodLaunchTrade = this.getPeriodLaunchTrade();
        String other$periodLaunchTrade = other.getPeriodLaunchTrade();
        if (this$periodLaunchTrade == null ? other$periodLaunchTrade != null : !this$periodLaunchTrade.equals(other$periodLaunchTrade)) {
            return false;
        }
        Integer this$avgLaunchStay = this.getAvgLaunchStay();
        Integer other$avgLaunchStay = other.getAvgLaunchStay();
        if (this$avgLaunchStay == null ? other$avgLaunchStay != null : !((Object)this$avgLaunchStay).equals(other$avgLaunchStay)) {
            return false;
        }
        String this$lastLaunchTrade = this.getLastLaunchTrade();
        String other$lastLaunchTrade = other.getLastLaunchTrade();
        if (this$lastLaunchTrade == null ? other$lastLaunchTrade != null : !this$lastLaunchTrade.equals(other$lastLaunchTrade)) {
            return false;
        }
        Integer this$clickLaunchTrade = this.getClickLaunchTrade();
        Integer other$clickLaunchTrade = other.getClickLaunchTrade();
        if (this$clickLaunchTrade == null ? other$clickLaunchTrade != null : !((Object)this$clickLaunchTrade).equals(other$clickLaunchTrade)) {
            return false;
        }
        String this$clickTrade = this.getClickTrade();
        String other$clickTrade = other.getClickTrade();
        if (this$clickTrade == null ? other$clickTrade != null : !this$clickTrade.equals(other$clickTrade)) {
            return false;
        }
        String this$weekClickTrade = this.getWeekClickTrade();
        String other$weekClickTrade = other.getWeekClickTrade();
        if (this$weekClickTrade == null ? other$weekClickTrade != null : !this$weekClickTrade.equals(other$weekClickTrade)) {
            return false;
        }
        Map<String, Integer> this$dayClickTrade = this.getDayClickTrade();
        Map<String, Integer> other$dayClickTrade = other.getDayClickTrade();
        if (this$dayClickTrade == null ? other$dayClickTrade != null : !((Object)this$dayClickTrade).equals(other$dayClickTrade)) {
            return false;
        }
        Integer this$intervalClickTrade = this.getIntervalClickTrade();
        Integer other$intervalClickTrade = other.getIntervalClickTrade();
        if (this$intervalClickTrade == null ? other$intervalClickTrade != null : !((Object)this$intervalClickTrade).equals(other$intervalClickTrade)) {
            return false;
        }
        String this$periodClickTrade = this.getPeriodClickTrade();
        String other$periodClickTrade = other.getPeriodClickTrade();
        if (this$periodClickTrade == null ? other$periodClickTrade != null : !this$periodClickTrade.equals(other$periodClickTrade)) {
            return false;
        }
        String this$lastClickTrade = this.getLastClickTrade();
        String other$lastClickTrade = other.getLastClickTrade();
        if (this$lastClickTrade == null ? other$lastClickTrade != null : !this$lastClickTrade.equals(other$lastClickTrade)) {
            return false;
        }
        Integer this$effectClickTrade = this.getEffectClickTrade();
        Integer other$effectClickTrade = other.getEffectClickTrade();
        if (this$effectClickTrade == null ? other$effectClickTrade != null : !((Object)this$effectClickTrade).equals(other$effectClickTrade)) {
            return false;
        }
        String this$effectTrade = this.getEffectTrade();
        String other$effectTrade = other.getEffectTrade();
        if (this$effectTrade == null ? other$effectTrade != null : !this$effectTrade.equals(other$effectTrade)) {
            return false;
        }
        String this$weekEffectTrade = this.getWeekEffectTrade();
        String other$weekEffectTrade = other.getWeekEffectTrade();
        if (this$weekEffectTrade == null ? other$weekEffectTrade != null : !this$weekEffectTrade.equals(other$weekEffectTrade)) {
            return false;
        }
        Map<String, Integer> this$dayEffectTrade = this.getDayEffectTrade();
        Map<String, Integer> other$dayEffectTrade = other.getDayEffectTrade();
        if (this$dayEffectTrade == null ? other$dayEffectTrade != null : !((Object)this$dayEffectTrade).equals(other$dayEffectTrade)) {
            return false;
        }
        Integer this$intervalEffectTrade = this.getIntervalEffectTrade();
        Integer other$intervalEffectTrade = other.getIntervalEffectTrade();
        if (this$intervalEffectTrade == null ? other$intervalEffectTrade != null : !((Object)this$intervalEffectTrade).equals(other$intervalEffectTrade)) {
            return false;
        }
        String this$periodEffectTrade = this.getPeriodEffectTrade();
        String other$periodEffectTrade = other.getPeriodEffectTrade();
        if (this$periodEffectTrade == null ? other$periodEffectTrade != null : !this$periodEffectTrade.equals(other$periodEffectTrade)) {
            return false;
        }
        String this$lastEffectTrade = this.getLastEffectTrade();
        String other$lastEffectTrade = other.getLastEffectTrade();
        if (this$lastEffectTrade == null ? other$lastEffectTrade != null : !this$lastEffectTrade.equals(other$lastEffectTrade)) {
            return false;
        }
        Long this$todayLaunch = this.getTodayLaunch();
        Long other$todayLaunch = other.getTodayLaunch();
        if (this$todayLaunch == null ? other$todayLaunch != null : !((Object)this$todayLaunch).equals(other$todayLaunch)) {
            return false;
        }
        Long this$historyLaunch = this.getHistoryLaunch();
        Long other$historyLaunch = other.getHistoryLaunch();
        if (this$historyLaunch == null ? other$historyLaunch != null : !((Object)this$historyLaunch).equals(other$historyLaunch)) {
            return false;
        }
        Long this$todayActivityLaunch = this.getTodayActivityLaunch();
        Long other$todayActivityLaunch = other.getTodayActivityLaunch();
        if (this$todayActivityLaunch == null ? other$todayActivityLaunch != null : !((Object)this$todayActivityLaunch).equals(other$todayActivityLaunch)) {
            return false;
        }
        Long this$historyActivityLaunch = this.getHistoryActivityLaunch();
        Long other$historyActivityLaunch = other.getHistoryActivityLaunch();
        if (this$historyActivityLaunch == null ? other$historyActivityLaunch != null : !((Object)this$historyActivityLaunch).equals(other$historyActivityLaunch)) {
            return false;
        }
        String this$lastLaunchTime = this.getLastLaunchTime();
        String other$lastLaunchTime = other.getLastLaunchTime();
        if (this$lastLaunchTime == null ? other$lastLaunchTime != null : !this$lastLaunchTime.equals(other$lastLaunchTime)) {
            return false;
        }
        String this$lastActivityLaunchTime = this.getLastActivityLaunchTime();
        String other$lastActivityLaunchTime = other.getLastActivityLaunchTime();
        if (this$lastActivityLaunchTime == null ? other$lastActivityLaunchTime != null : !this$lastActivityLaunchTime.equals(other$lastActivityLaunchTime)) {
            return false;
        }
        String this$lastActivityLaunchOrder = this.getLastActivityLaunchOrder();
        String other$lastActivityLaunchOrder = other.getLastActivityLaunchOrder();
        if (this$lastActivityLaunchOrder == null ? other$lastActivityLaunchOrder != null : !this$lastActivityLaunchOrder.equals(other$lastActivityLaunchOrder)) {
            return false;
        }
        String this$lastActivityClickOrder = this.getLastActivityClickOrder();
        String other$lastActivityClickOrder = other.getLastActivityClickOrder();
        if (this$lastActivityClickOrder == null ? other$lastActivityClickOrder != null : !this$lastActivityClickOrder.equals(other$lastActivityClickOrder)) {
            return false;
        }
        String this$lastLaunchOrder = this.getLastLaunchOrder();
        String other$lastLaunchOrder = other.getLastLaunchOrder();
        if (this$lastLaunchOrder == null ? other$lastLaunchOrder != null : !this$lastLaunchOrder.equals(other$lastLaunchOrder)) {
            return false;
        }
        String this$lastClickOrder = this.getLastClickOrder();
        String other$lastClickOrder = other.getLastClickOrder();
        if (this$lastClickOrder == null ? other$lastClickOrder != null : !this$lastClickOrder.equals(other$lastClickOrder)) {
            return false;
        }
        String this$lastActivity = this.getLastActivity();
        String other$lastActivity = other.getLastActivity();
        if (this$lastActivity == null ? other$lastActivity != null : !this$lastActivity.equals(other$lastActivity)) {
            return false;
        }
        String this$lastAdvertMatchTag = this.getLastAdvertMatchTag();
        String other$lastAdvertMatchTag = other.getLastAdvertMatchTag();
        if (this$lastAdvertMatchTag == null ? other$lastAdvertMatchTag != null : !this$lastAdvertMatchTag.equals(other$lastAdvertMatchTag)) {
            return false;
        }
        Map<String, Long> this$todayResourceLaunch = this.getTodayResourceLaunch();
        Map<String, Long> other$todayResourceLaunch = other.getTodayResourceLaunch();
        if (this$todayResourceLaunch == null ? other$todayResourceLaunch != null : !((Object)this$todayResourceLaunch).equals(other$todayResourceLaunch)) {
            return false;
        }
        Map<String, String> this$lastResourceLaunchTime = this.getLastResourceLaunchTime();
        Map<String, String> other$lastResourceLaunchTime = other.getLastResourceLaunchTime();
        if (this$lastResourceLaunchTime == null ? other$lastResourceLaunchTime != null : !((Object)this$lastResourceLaunchTime).equals(other$lastResourceLaunchTime)) {
            return false;
        }
        Map<String, String> this$lastResourceLaunchOrder = this.getLastResourceLaunchOrder();
        Map<String, String> other$lastResourceLaunchOrder = other.getLastResourceLaunchOrder();
        if (this$lastResourceLaunchOrder == null ? other$lastResourceLaunchOrder != null : !((Object)this$lastResourceLaunchOrder).equals(other$lastResourceLaunchOrder)) {
            return false;
        }
        Map<String, String> this$lastResourceClickOrder = this.getLastResourceClickOrder();
        Map<String, String> other$lastResourceClickOrder = other.getLastResourceClickOrder();
        if (this$lastResourceClickOrder == null ? other$lastResourceClickOrder != null : !((Object)this$lastResourceClickOrder).equals(other$lastResourceClickOrder)) {
            return false;
        }
        Map<String, String> this$lastResourceEffectOrder = this.getLastResourceEffectOrder();
        Map<String, String> other$lastResourceEffectOrder = other.getLastResourceEffectOrder();
        if (this$lastResourceEffectOrder == null ? other$lastResourceEffectOrder != null : !((Object)this$lastResourceEffectOrder).equals(other$lastResourceEffectOrder)) {
            return false;
        }
        Map<String, Long> this$todayResourceClickAdvertCount = this.getTodayResourceClickAdvertCount();
        Map<String, Long> other$todayResourceClickAdvertCount = other.getTodayResourceClickAdvertCount();
        if (this$todayResourceClickAdvertCount == null ? other$todayResourceClickAdvertCount != null : !((Object)this$todayResourceClickAdvertCount).equals(other$todayResourceClickAdvertCount)) {
            return false;
        }
        Map<String, Long> this$todayResourceEffectAdvertCount = this.getTodayResourceEffectAdvertCount();
        Map<String, Long> other$todayResourceEffectAdvertCount = other.getTodayResourceEffectAdvertCount();
        if (this$todayResourceEffectAdvertCount == null ? other$todayResourceEffectAdvertCount != null : !((Object)this$todayResourceEffectAdvertCount).equals(other$todayResourceEffectAdvertCount)) {
            return false;
        }
        String this$lastResource = this.getLastResource();
        String other$lastResource = other.getLastResource();
        if (this$lastResource == null ? other$lastResource != null : !this$lastResource.equals(other$lastResource)) {
            return false;
        }
        String this$lastLaunchAccount = this.getLastLaunchAccount();
        String other$lastLaunchAccount = other.getLastLaunchAccount();
        if (this$lastLaunchAccount == null ? other$lastLaunchAccount != null : !this$lastLaunchAccount.equals(other$lastLaunchAccount)) {
            return false;
        }
        String this$lastLaunchPlan = this.getLastLaunchPlan();
        String other$lastLaunchPlan = other.getLastLaunchPlan();
        if (this$lastLaunchPlan == null ? other$lastLaunchPlan != null : !this$lastLaunchPlan.equals(other$lastLaunchPlan)) {
            return false;
        }
        Set<Integer> this$advertExposureSet = this.getAdvertExposureSet();
        Set<Integer> other$advertExposureSet = other.getAdvertExposureSet();
        if (this$advertExposureSet == null ? other$advertExposureSet != null : !((Object)this$advertExposureSet).equals(other$advertExposureSet)) {
            return false;
        }
        Set<Integer> this$advertClickSet = this.getAdvertClickSet();
        Set<Integer> other$advertClickSet = other.getAdvertClickSet();
        if (this$advertClickSet == null ? other$advertClickSet != null : !((Object)this$advertClickSet).equals(other$advertClickSet)) {
            return false;
        }
        Set<Integer> this$accountClickSet = this.getAccountClickSet();
        Set<Integer> other$accountClickSet = other.getAccountClickSet();
        if (this$accountClickSet == null ? other$accountClickSet != null : !((Object)this$accountClickSet).equals(other$accountClickSet)) {
            return false;
        }
        Set<String> this$resourceClickSet = this.getResourceClickSet();
        Set<String> other$resourceClickSet = other.getResourceClickSet();
        if (this$resourceClickSet == null ? other$resourceClickSet != null : !((Object)this$resourceClickSet).equals(other$resourceClickSet)) {
            return false;
        }
        Set<Integer> this$tradeClickSet = this.getTradeClickSet();
        Set<Integer> other$tradeClickSet = other.getTradeClickSet();
        if (this$tradeClickSet == null ? other$tradeClickSet != null : !((Object)this$tradeClickSet).equals(other$tradeClickSet)) {
            return false;
        }
        Set<Integer> this$advertEffectSet = this.getAdvertEffectSet();
        Set<Integer> other$advertEffectSet = other.getAdvertEffectSet();
        if (this$advertEffectSet == null ? other$advertEffectSet != null : !((Object)this$advertEffectSet).equals(other$advertEffectSet)) {
            return false;
        }
        Set<Integer> this$accountEffectSet = this.getAccountEffectSet();
        Set<Integer> other$accountEffectSet = other.getAccountEffectSet();
        if (this$accountEffectSet == null ? other$accountEffectSet != null : !((Object)this$accountEffectSet).equals(other$accountEffectSet)) {
            return false;
        }
        Set<String> this$resourceEffectSet = this.getResourceEffectSet();
        Set<String> other$resourceEffectSet = other.getResourceEffectSet();
        if (this$resourceEffectSet == null ? other$resourceEffectSet != null : !((Object)this$resourceEffectSet).equals(other$resourceEffectSet)) {
            return false;
        }
        Set<Integer> this$tradeEffectSet = this.getTradeEffectSet();
        Set<Integer> other$tradeEffectSet = other.getTradeEffectSet();
        if (this$tradeEffectSet == null ? other$tradeEffectSet != null : !((Object)this$tradeEffectSet).equals(other$tradeEffectSet)) {
            return false;
        }
        Map<Integer, Long> this$todayAdvertLaunch = this.getTodayAdvertLaunch();
        Map<Integer, Long> other$todayAdvertLaunch = other.getTodayAdvertLaunch();
        if (this$todayAdvertLaunch == null ? other$todayAdvertLaunch != null : !((Object)this$todayAdvertLaunch).equals(other$todayAdvertLaunch)) {
            return false;
        }
        Map<Integer, Long> this$todayAdvertClick = this.getTodayAdvertClick();
        Map<Integer, Long> other$todayAdvertClick = other.getTodayAdvertClick();
        if (this$todayAdvertClick == null ? other$todayAdvertClick != null : !((Object)this$todayAdvertClick).equals(other$todayAdvertClick)) {
            return false;
        }
        Map<Integer, Long> this$todayAdvertEffect = this.getTodayAdvertEffect();
        Map<Integer, Long> other$todayAdvertEffect = other.getTodayAdvertEffect();
        if (this$todayAdvertEffect == null ? other$todayAdvertEffect != null : !((Object)this$todayAdvertEffect).equals(other$todayAdvertEffect)) {
            return false;
        }
        Map<Integer, Long> this$historyAdvertLaunch = this.getHistoryAdvertLaunch();
        Map<Integer, Long> other$historyAdvertLaunch = other.getHistoryAdvertLaunch();
        if (this$historyAdvertLaunch == null ? other$historyAdvertLaunch != null : !((Object)this$historyAdvertLaunch).equals(other$historyAdvertLaunch)) {
            return false;
        }
        Map<Integer, Long> this$historyAdvertClick = this.getHistoryAdvertClick();
        Map<Integer, Long> other$historyAdvertClick = other.getHistoryAdvertClick();
        if (this$historyAdvertClick == null ? other$historyAdvertClick != null : !((Object)this$historyAdvertClick).equals(other$historyAdvertClick)) {
            return false;
        }
        Map<Integer, Long> this$historyAdvertEffect = this.getHistoryAdvertEffect();
        Map<Integer, Long> other$historyAdvertEffect = other.getHistoryAdvertEffect();
        if (this$historyAdvertEffect == null ? other$historyAdvertEffect != null : !((Object)this$historyAdvertEffect).equals(other$historyAdvertEffect)) {
            return false;
        }
        Integer this$history30LaunchCount = this.getHistory30LaunchCount();
        Integer other$history30LaunchCount = other.getHistory30LaunchCount();
        if (this$history30LaunchCount == null ? other$history30LaunchCount != null : !((Object)this$history30LaunchCount).equals(other$history30LaunchCount)) {
            return false;
        }
        Integer this$history30ClickCount = this.getHistory30ClickCount();
        Integer other$history30ClickCount = other.getHistory30ClickCount();
        if (this$history30ClickCount == null ? other$history30ClickCount != null : !((Object)this$history30ClickCount).equals(other$history30ClickCount)) {
            return false;
        }
        Integer this$history30EffectCount = this.getHistory30EffectCount();
        Integer other$history30EffectCount = other.getHistory30EffectCount();
        if (this$history30EffectCount == null ? other$history30EffectCount != null : !((Object)this$history30EffectCount).equals(other$history30EffectCount)) {
            return false;
        }
        Integer this$todayLaunchCount = this.getTodayLaunchCount();
        Integer other$todayLaunchCount = other.getTodayLaunchCount();
        if (this$todayLaunchCount == null ? other$todayLaunchCount != null : !((Object)this$todayLaunchCount).equals(other$todayLaunchCount)) {
            return false;
        }
        Integer this$todayClickCount = this.getTodayClickCount();
        Integer other$todayClickCount = other.getTodayClickCount();
        if (this$todayClickCount == null ? other$todayClickCount != null : !((Object)this$todayClickCount).equals(other$todayClickCount)) {
            return false;
        }
        Integer this$todayEffectCount = this.getTodayEffectCount();
        Integer other$todayEffectCount = other.getTodayEffectCount();
        if (this$todayEffectCount == null ? other$todayEffectCount != null : !((Object)this$todayEffectCount).equals(other$todayEffectCount)) {
            return false;
        }
        String this$oUIIds = this.getOUIIds();
        String other$oUIIds = other.getOUIIds();
        if (this$oUIIds == null ? other$oUIIds != null : !this$oUIIds.equals(other$oUIIds)) {
            return false;
        }
        String this$oUILaunchPV = this.getOUILaunchPV();
        String other$oUILaunchPV = other.getOUILaunchPV();
        if (this$oUILaunchPV == null ? other$oUILaunchPV != null : !this$oUILaunchPV.equals(other$oUILaunchPV)) {
            return false;
        }
        String this$oUIClickPv = this.getOUIClickPv();
        String other$oUIClickPv = other.getOUIClickPv();
        if (this$oUIClickPv == null ? other$oUIClickPv != null : !this$oUIClickPv.equals(other$oUIClickPv)) {
            return false;
        }
        String this$oUIEffectPv = this.getOUIEffectPv();
        String other$oUIEffectPv = other.getOUIEffectPv();
        if (this$oUIEffectPv == null ? other$oUIEffectPv != null : !this$oUIEffectPv.equals(other$oUIEffectPv)) {
            return false;
        }
        Map<String, Long> this$historyTradeLaunch = this.getHistoryTradeLaunch();
        Map<String, Long> other$historyTradeLaunch = other.getHistoryTradeLaunch();
        if (this$historyTradeLaunch == null ? other$historyTradeLaunch != null : !((Object)this$historyTradeLaunch).equals(other$historyTradeLaunch)) {
            return false;
        }
        Map<String, Long> this$historyTradeClick = this.getHistoryTradeClick();
        Map<String, Long> other$historyTradeClick = other.getHistoryTradeClick();
        if (this$historyTradeClick == null ? other$historyTradeClick != null : !((Object)this$historyTradeClick).equals(other$historyTradeClick)) {
            return false;
        }
        Map<String, Long> this$historyTradeEffect = this.getHistoryTradeEffect();
        Map<String, Long> other$historyTradeEffect = other.getHistoryTradeEffect();
        if (this$historyTradeEffect == null ? other$historyTradeEffect != null : !((Object)this$historyTradeEffect).equals(other$historyTradeEffect)) {
            return false;
        }
        Map<String, Map<String, Long>> this$historyTradeCtrCvr = this.getHistoryTradeCtrCvr();
        Map<String, Map<String, Long>> other$historyTradeCtrCvr = other.getHistoryTradeCtrCvr();
        if (this$historyTradeCtrCvr == null ? other$historyTradeCtrCvr != null : !((Object)this$historyTradeCtrCvr).equals(other$historyTradeCtrCvr)) {
            return false;
        }
        String this$clickCategory = this.getClickCategory();
        String other$clickCategory = other.getClickCategory();
        if (this$clickCategory == null ? other$clickCategory != null : !this$clickCategory.equals(other$clickCategory)) {
            return false;
        }
        String this$weekClickCategory = this.getWeekClickCategory();
        String other$weekClickCategory = other.getWeekClickCategory();
        if (this$weekClickCategory == null ? other$weekClickCategory != null : !this$weekClickCategory.equals(other$weekClickCategory)) {
            return false;
        }
        Map<String, Integer> this$dayClickCategory = this.getDayClickCategory();
        Map<String, Integer> other$dayClickCategory = other.getDayClickCategory();
        if (this$dayClickCategory == null ? other$dayClickCategory != null : !((Object)this$dayClickCategory).equals(other$dayClickCategory)) {
            return false;
        }
        Integer this$intervalClickCategory = this.getIntervalClickCategory();
        Integer other$intervalClickCategory = other.getIntervalClickCategory();
        if (this$intervalClickCategory == null ? other$intervalClickCategory != null : !((Object)this$intervalClickCategory).equals(other$intervalClickCategory)) {
            return false;
        }
        String this$periodClickCategory = this.getPeriodClickCategory();
        String other$periodClickCategory = other.getPeriodClickCategory();
        if (this$periodClickCategory == null ? other$periodClickCategory != null : !this$periodClickCategory.equals(other$periodClickCategory)) {
            return false;
        }
        Integer this$avgLandpageStay = this.getAvgLandpageStay();
        Integer other$avgLandpageStay = other.getAvgLandpageStay();
        if (this$avgLandpageStay == null ? other$avgLandpageStay != null : !((Object)this$avgLandpageStay).equals(other$avgLandpageStay)) {
            return false;
        }
        String this$lastClickCategory = this.getLastClickCategory();
        String other$lastClickCategory = other.getLastClickCategory();
        if (this$lastClickCategory == null ? other$lastClickCategory != null : !this$lastClickCategory.equals(other$lastClickCategory)) {
            return false;
        }
        Integer this$effectClickCategory = this.getEffectClickCategory();
        Integer other$effectClickCategory = other.getEffectClickCategory();
        if (this$effectClickCategory == null ? other$effectClickCategory != null : !((Object)this$effectClickCategory).equals(other$effectClickCategory)) {
            return false;
        }
        String this$lastClickBrand = this.getLastClickBrand();
        String other$lastClickBrand = other.getLastClickBrand();
        if (this$lastClickBrand == null ? other$lastClickBrand != null : !this$lastClickBrand.equals(other$lastClickBrand)) {
            return false;
        }
        Integer this$issueEffectClickCategory = this.getIssueEffectClickCategory();
        Integer other$issueEffectClickCategory = other.getIssueEffectClickCategory();
        if (this$issueEffectClickCategory == null ? other$issueEffectClickCategory != null : !((Object)this$issueEffectClickCategory).equals(other$issueEffectClickCategory)) {
            return false;
        }
        String this$effectCategory = this.getEffectCategory();
        String other$effectCategory = other.getEffectCategory();
        if (this$effectCategory == null ? other$effectCategory != null : !this$effectCategory.equals(other$effectCategory)) {
            return false;
        }
        String this$weekEffectCategory = this.getWeekEffectCategory();
        String other$weekEffectCategory = other.getWeekEffectCategory();
        if (this$weekEffectCategory == null ? other$weekEffectCategory != null : !this$weekEffectCategory.equals(other$weekEffectCategory)) {
            return false;
        }
        Map<String, Integer> this$dayEffectCategory = this.getDayEffectCategory();
        Map<String, Integer> other$dayEffectCategory = other.getDayEffectCategory();
        if (this$dayEffectCategory == null ? other$dayEffectCategory != null : !((Object)this$dayEffectCategory).equals(other$dayEffectCategory)) {
            return false;
        }
        Integer this$intervalEffectCategory = this.getIntervalEffectCategory();
        Integer other$intervalEffectCategory = other.getIntervalEffectCategory();
        if (this$intervalEffectCategory == null ? other$intervalEffectCategory != null : !((Object)this$intervalEffectCategory).equals(other$intervalEffectCategory)) {
            return false;
        }
        String this$periodEffectCategory = this.getPeriodEffectCategory();
        String other$periodEffectCategory = other.getPeriodEffectCategory();
        if (this$periodEffectCategory == null ? other$periodEffectCategory != null : !this$periodEffectCategory.equals(other$periodEffectCategory)) {
            return false;
        }
        String this$lastEffectCategory = this.getLastEffectCategory();
        String other$lastEffectCategory = other.getLastEffectCategory();
        if (this$lastEffectCategory == null ? other$lastEffectCategory != null : !this$lastEffectCategory.equals(other$lastEffectCategory)) {
            return false;
        }
        String this$lastEffectBrand = this.getLastEffectBrand();
        String other$lastEffectBrand = other.getLastEffectBrand();
        if (this$lastEffectBrand == null ? other$lastEffectBrand != null : !this$lastEffectBrand.equals(other$lastEffectBrand)) {
            return false;
        }
        Integer this$addressCount = this.getAddressCount();
        Integer other$addressCount = other.getAddressCount();
        if (this$addressCount == null ? other$addressCount != null : !((Object)this$addressCount).equals(other$addressCount)) {
            return false;
        }
        Integer this$numberCount = this.getNumberCount();
        Integer other$numberCount = other.getNumberCount();
        if (this$numberCount == null ? other$numberCount != null : !((Object)this$numberCount).equals(other$numberCount)) {
            return false;
        }
        String this$issueEffectCategory = this.getIssueEffectCategory();
        String other$issueEffectCategory = other.getIssueEffectCategory();
        if (this$issueEffectCategory == null ? other$issueEffectCategory != null : !this$issueEffectCategory.equals(other$issueEffectCategory)) {
            return false;
        }
        String this$weekIssueEffectCategory = this.getWeekIssueEffectCategory();
        String other$weekIssueEffectCategory = other.getWeekIssueEffectCategory();
        if (this$weekIssueEffectCategory == null ? other$weekIssueEffectCategory != null : !this$weekIssueEffectCategory.equals(other$weekIssueEffectCategory)) {
            return false;
        }
        Integer this$intervalIssueEffectCategory = this.getIntervalIssueEffectCategory();
        Integer other$intervalIssueEffectCategory = other.getIntervalIssueEffectCategory();
        if (this$intervalIssueEffectCategory == null ? other$intervalIssueEffectCategory != null : !((Object)this$intervalIssueEffectCategory).equals(other$intervalIssueEffectCategory)) {
            return false;
        }
        String this$periodIssueEffectCategory = this.getPeriodIssueEffectCategory();
        String other$periodIssueEffectCategory = other.getPeriodIssueEffectCategory();
        if (this$periodIssueEffectCategory == null ? other$periodIssueEffectCategory != null : !this$periodIssueEffectCategory.equals(other$periodIssueEffectCategory)) {
            return false;
        }
        String this$lastIssueEffectCategory = this.getLastIssueEffectCategory();
        String other$lastIssueEffectCategory = other.getLastIssueEffectCategory();
        if (this$lastIssueEffectCategory == null ? other$lastIssueEffectCategory != null : !this$lastIssueEffectCategory.equals(other$lastIssueEffectCategory)) {
            return false;
        }
        String this$lastIssueEffectBrand = this.getLastIssueEffectBrand();
        String other$lastIssueEffectBrand = other.getLastIssueEffectBrand();
        if (this$lastIssueEffectBrand == null ? other$lastIssueEffectBrand != null : !this$lastIssueEffectBrand.equals(other$lastIssueEffectBrand)) {
            return false;
        }
        String this$scoreEffectCategory = this.getScoreEffectCategory();
        String other$scoreEffectCategory = other.getScoreEffectCategory();
        if (this$scoreEffectCategory == null ? other$scoreEffectCategory != null : !this$scoreEffectCategory.equals(other$scoreEffectCategory)) {
            return false;
        }
        String this$scoreIssueEffectCategory = this.getScoreIssueEffectCategory();
        String other$scoreIssueEffectCategory = other.getScoreIssueEffectCategory();
        if (this$scoreIssueEffectCategory == null ? other$scoreIssueEffectCategory != null : !this$scoreIssueEffectCategory.equals(other$scoreIssueEffectCategory)) {
            return false;
        }
        Integer this$orderFee = this.getOrderFee();
        Integer other$orderFee = other.getOrderFee();
        if (this$orderFee == null ? other$orderFee != null : !((Object)this$orderFee).equals(other$orderFee)) {
            return false;
        }
        Integer this$weekOrderFee = this.getWeekOrderFee();
        Integer other$weekOrderFee = other.getWeekOrderFee();
        if (this$weekOrderFee == null ? other$weekOrderFee != null : !((Object)this$weekOrderFee).equals(other$weekOrderFee)) {
            return false;
        }
        Integer this$maxOrderFee = this.getMaxOrderFee();
        Integer other$maxOrderFee = other.getMaxOrderFee();
        if (this$maxOrderFee == null ? other$maxOrderFee != null : !((Object)this$maxOrderFee).equals(other$maxOrderFee)) {
            return false;
        }
        Integer this$minOrderFee = this.getMinOrderFee();
        Integer other$minOrderFee = other.getMinOrderFee();
        if (this$minOrderFee == null ? other$minOrderFee != null : !((Object)this$minOrderFee).equals(other$minOrderFee)) {
            return false;
        }
        Integer this$avgOrderFee = this.getAvgOrderFee();
        Integer other$avgOrderFee = other.getAvgOrderFee();
        if (this$avgOrderFee == null ? other$avgOrderFee != null : !((Object)this$avgOrderFee).equals(other$avgOrderFee)) {
            return false;
        }
        Integer this$lastOrderFee = this.getLastOrderFee();
        Integer other$lastOrderFee = other.getLastOrderFee();
        if (this$lastOrderFee == null ? other$lastOrderFee != null : !((Object)this$lastOrderFee).equals(other$lastOrderFee)) {
            return false;
        }
        Integer this$zeroLaunch = this.getZeroLaunch();
        Integer other$zeroLaunch = other.getZeroLaunch();
        if (this$zeroLaunch == null ? other$zeroLaunch != null : !((Object)this$zeroLaunch).equals(other$zeroLaunch)) {
            return false;
        }
        Integer this$nonZeroLaunch = this.getNonZeroLaunch();
        Integer other$nonZeroLaunch = other.getNonZeroLaunch();
        if (this$nonZeroLaunch == null ? other$nonZeroLaunch != null : !((Object)this$nonZeroLaunch).equals(other$nonZeroLaunch)) {
            return false;
        }
        Integer this$zeroClick = this.getZeroClick();
        Integer other$zeroClick = other.getZeroClick();
        if (this$zeroClick == null ? other$zeroClick != null : !((Object)this$zeroClick).equals(other$zeroClick)) {
            return false;
        }
        Integer this$nonZeroClick = this.getNonZeroClick();
        Integer other$nonZeroClick = other.getNonZeroClick();
        if (this$nonZeroClick == null ? other$nonZeroClick != null : !((Object)this$nonZeroClick).equals(other$nonZeroClick)) {
            return false;
        }
        Integer this$zeroEffect = this.getZeroEffect();
        Integer other$zeroEffect = other.getZeroEffect();
        if (this$zeroEffect == null ? other$zeroEffect != null : !((Object)this$zeroEffect).equals(other$zeroEffect)) {
            return false;
        }
        Integer this$nonZeroEffect = this.getNonZeroEffect();
        Integer other$nonZeroEffect = other.getNonZeroEffect();
        if (this$nonZeroEffect == null ? other$nonZeroEffect != null : !((Object)this$nonZeroEffect).equals(other$nonZeroEffect)) {
            return false;
        }
        Integer this$zeroIssueEffect = this.getZeroIssueEffect();
        Integer other$zeroIssueEffect = other.getZeroIssueEffect();
        if (this$zeroIssueEffect == null ? other$zeroIssueEffect != null : !((Object)this$zeroIssueEffect).equals(other$zeroIssueEffect)) {
            return false;
        }
        Integer this$nonZeroIssueEffect = this.getNonZeroIssueEffect();
        Integer other$nonZeroIssueEffect = other.getNonZeroIssueEffect();
        if (this$nonZeroIssueEffect == null ? other$nonZeroIssueEffect != null : !((Object)this$nonZeroIssueEffect).equals(other$nonZeroIssueEffect)) {
            return false;
        }
        Integer this$vouchFailed = this.getVouchFailed();
        Integer other$vouchFailed = other.getVouchFailed();
        if (this$vouchFailed == null ? other$vouchFailed != null : !((Object)this$vouchFailed).equals(other$vouchFailed)) {
            return false;
        }
        Integer this$weekVouchFailed = this.getWeekVouchFailed();
        Integer n = other.getWeekVouchFailed();
        if (this$weekVouchFailed == null ? other$weekVouchFailed != null : !((Object)this$weekVouchFailed).equals(other$weekVouchFailed)) {
            return false;
        }
        Integer n2 = this.getIntervalVouchFailed();
        Integer n3 = other.getIntervalVouchFailed();
        if (this$intervalVouchFailed == null ? other$intervalVouchFailed != null : !this$intervalVouchFailed.equals(other$intervalVouchFailed)) {
            return false;
        }
        Integer n4 = this.getReject();
        Integer n5 = other.getReject();
        if (this$reject == null ? other$reject != null : !this$reject.equals(other$reject)) {
            return false;
        }
        Integer n6 = this.getWeekReject();
        Integer n7 = other.getWeekReject();
        if (this$weekReject == null ? other$weekReject != null : !this$weekReject.equals(other$weekReject)) {
            return false;
        }
        Integer n8 = this.getIntervalReject();
        Integer n9 = other.getIntervalReject();
        if (this$intervalReject == null ? other$intervalReject != null : !this$intervalReject.equals(other$intervalReject)) {
            return false;
        }
        Integer n10 = this.getComplaint();
        Integer n11 = other.getComplaint();
        if (this$complaint == null ? other$complaint != null : !this$complaint.equals(other$complaint)) {
            return false;
        }
        Integer n12 = this.getWeekComplaint();
        Integer n13 = other.getWeekComplaint();
        if (this$weekComplaint == null ? other$weekComplaint != null : !this$weekComplaint.equals(other$weekComplaint)) {
            return false;
        }
        Integer n14 = this.getIntervalComplaint();
        Integer n15 = other.getIntervalComplaint();
        if (this$intervalComplaint == null ? other$intervalComplaint != null : !this$intervalComplaint.equals(other$intervalComplaint)) {
            return false;
        }
        Integer n16 = this.getAddressException();
        Integer n17 = other.getAddressException();
        if (this$addressException == null ? other$addressException != null : !this$addressException.equals(other$addressException)) {
            return false;
        }
        Integer n18 = this.getWeekAddressException();
        Integer n19 = other.getWeekAddressException();
        if (this$weekAddressException == null ? other$weekAddressException != null : !this$weekAddressException.equals(other$weekAddressException)) {
            return false;
        }
        Integer n20 = this.getIntervalAddressException();
        Integer n21 = other.getIntervalAddressException();
        if (this$intervalAddressException == null ? other$intervalAddressException != null : !this$intervalAddressException.equals(other$intervalAddressException)) {
            return false;
        }
        Integer n22 = this.getNumberEmpty();
        Integer n23 = other.getNumberEmpty();
        if (this$numberEmpty == null ? other$numberEmpty != null : !this$numberEmpty.equals(other$numberEmpty)) {
            return false;
        }
        Integer n24 = this.getWeekNumberEmpty();
        Integer n25 = other.getWeekNumberEmpty();
        if (this$weekNumberEmpty == null ? other$weekNumberEmpty != null : !this$weekNumberEmpty.equals(other$weekNumberEmpty)) {
            return false;
        }
        Integer n26 = this.getIntervalNumberEmpty();
        Integer n27 = other.getIntervalNumberEmpty();
        if (this$intervalNumberEmpty == null ? other$intervalNumberEmpty != null : !this$intervalNumberEmpty.equals(other$intervalNumberEmpty)) {
            return false;
        }
        Integer n28 = this.getCheat();
        Integer n29 = other.getCheat();
        if (this$cheat == null ? other$cheat != null : !this$cheat.equals(other$cheat)) {
            return false;
        }
        Integer n30 = this.getWeekCheat();
        Integer n31 = other.getWeekCheat();
        if (this$weekCheat == null ? other$weekCheat != null : !this$weekCheat.equals(other$weekCheat)) {
            return false;
        }
        Integer n32 = this.getIntervalCheat();
        Integer n33 = other.getIntervalCheat();
        if (this$intervalCheat == null ? other$intervalCheat != null : !this$intervalCheat.equals(other$intervalCheat)) {
            return false;
        }
        String string = this.getLastApp();
        String string2 = other.getLastApp();
        if (this$lastApp == null ? other$lastApp != null : !this$lastApp.equals(other$lastApp)) {
            return false;
        }
        Long l = this.getLastVideoTime();
        Long l2 = other.getLastVideoTime();
        if (this$lastVideoTime == null ? other$lastVideoTime != null : !this$lastVideoTime.equals(other$lastVideoTime)) {
            return false;
        }
        String string3 = this.getLastVideoChannel();
        String string4 = other.getLastVideoChannel();
        if (this$lastVideoChannel == null ? other$lastVideoChannel != null : !this$lastVideoChannel.equals(other$lastVideoChannel)) {
            return false;
        }
        String string5 = this.getLastVideoInfo();
        String string6 = other.getLastVideoInfo();
        if (this$lastVideoInfo == null ? other$lastVideoInfo != null : !this$lastVideoInfo.equals(other$lastVideoInfo)) {
            return false;
        }
        String string7 = this.getLastVideoCategory();
        String string8 = other.getLastVideoCategory();
        if (this$lastVideoCategory == null ? other$lastVideoCategory != null : !this$lastVideoCategory.equals(other$lastVideoCategory)) {
            return false;
        }
        String string9 = this.getLastVideoArea();
        String string10 = other.getLastVideoArea();
        if (this$lastVideoArea == null ? other$lastVideoArea != null : !this$lastVideoArea.equals(other$lastVideoArea)) {
            return false;
        }
        String string11 = this.getLastVideoYears();
        String string12 = other.getLastVideoYears();
        if (this$lastVideoYears == null ? other$lastVideoYears != null : !this$lastVideoYears.equals(other$lastVideoYears)) {
            return false;
        }
        String string13 = this.getHistEntrancesExposeTime();
        String string14 = other.getHistEntrancesExposeTime();
        if (this$histEntrancesExposeTime == null ? other$histEntrancesExposeTime != null : !this$histEntrancesExposeTime.equals(other$histEntrancesExposeTime)) {
            return false;
        }
        String string15 = this.getWeekEntrancesExposeTime();
        String string16 = other.getWeekEntrancesExposeTime();
        if (this$weekEntrancesExposeTime == null ? other$weekEntrancesExposeTime != null : !this$weekEntrancesExposeTime.equals(other$weekEntrancesExposeTime)) {
            return false;
        }
        Map<String, Integer> map = this.getDayEntrancesExposeTime();
        Map<String, Integer> map2 = other.getDayEntrancesExposeTime();
        if (this$dayEntrancesExposeTime == null ? other$dayEntrancesExposeTime != null : !this$dayEntrancesExposeTime.equals(other$dayEntrancesExposeTime)) {
            return false;
        }
        String string17 = this.getMaterialExposeInterval();
        String string18 = other.getMaterialExposeInterval();
        if (this$materialExposeInterval == null ? other$materialExposeInterval != null : !this$materialExposeInterval.equals(other$materialExposeInterval)) {
            return false;
        }
        String string19 = this.getMaterialExposePeriod();
        String string20 = other.getMaterialExposePeriod();
        if (this$materialExposePeriod == null ? other$materialExposePeriod != null : !this$materialExposePeriod.equals(other$materialExposePeriod)) {
            return false;
        }
        Integer n34 = this.getCHistEntrancesExposeTime();
        Integer n35 = other.getCHistEntrancesExposeTime();
        if (this$cHistEntrancesExposeTime == null ? other$cHistEntrancesExposeTime != null : !this$cHistEntrancesExposeTime.equals(other$cHistEntrancesExposeTime)) {
            return false;
        }
        Integer n36 = this.getCWeekEntrancesExposeTime();
        Integer n37 = other.getCWeekEntrancesExposeTime();
        if (this$cWeekEntrancesExposeTime == null ? other$cWeekEntrancesExposeTime != null : !this$cWeekEntrancesExposeTime.equals(other$cWeekEntrancesExposeTime)) {
            return false;
        }
        Integer n38 = this.getCDayEntrancesExposeTime();
        Integer n39 = other.getCDayEntrancesExposeTime();
        if (this$cDayEntrancesExposeTime == null ? other$cDayEntrancesExposeTime != null : !this$cDayEntrancesExposeTime.equals(other$cDayEntrancesExposeTime)) {
            return false;
        }
        Integer n40 = this.getCMaterialExposeInterval();
        Integer n41 = other.getCMaterialExposeInterval();
        if (this$cMaterialExposeInterval == null ? other$cMaterialExposeInterval != null : !this$cMaterialExposeInterval.equals(other$cMaterialExposeInterval)) {
            return false;
        }
        String string21 = this.getHistEntrancesClickTime();
        String string22 = other.getHistEntrancesClickTime();
        if (this$histEntrancesClickTime == null ? other$histEntrancesClickTime != null : !this$histEntrancesClickTime.equals(other$histEntrancesClickTime)) {
            return false;
        }
        String string23 = this.getWeekEntrancesClickTime();
        String string24 = other.getWeekEntrancesClickTime();
        if (this$weekEntrancesClickTime == null ? other$weekEntrancesClickTime != null : !this$weekEntrancesClickTime.equals(other$weekEntrancesClickTime)) {
            return false;
        }
        Map<String, Integer> map3 = this.getDayEntrancesClickTime();
        Map<String, Integer> map4 = other.getDayEntrancesClickTime();
        if (this$dayEntrancesClickTime == null ? other$dayEntrancesClickTime != null : !this$dayEntrancesClickTime.equals(other$dayEntrancesClickTime)) {
            return false;
        }
        String string25 = this.getMaterialClickInterval();
        String string26 = other.getMaterialClickInterval();
        if (this$materialClickInterval == null ? other$materialClickInterval != null : !this$materialClickInterval.equals(other$materialClickInterval)) {
            return false;
        }
        String string27 = this.getMaterialClickPeriod();
        String string28 = other.getMaterialClickPeriod();
        if (this$materialClickPeriod == null ? other$materialClickPeriod != null : !this$materialClickPeriod.equals(other$materialClickPeriod)) {
            return false;
        }
        Integer n42 = this.getCHistEntrancesClickTime();
        Integer n43 = other.getCHistEntrancesClickTime();
        if (this$cHistEntrancesClickTime == null ? other$cHistEntrancesClickTime != null : !this$cHistEntrancesClickTime.equals(other$cHistEntrancesClickTime)) {
            return false;
        }
        Integer n44 = this.getCWeekEntrancesClickTime();
        Integer n45 = other.getCWeekEntrancesClickTime();
        if (this$cWeekEntrancesClickTime == null ? other$cWeekEntrancesClickTime != null : !this$cWeekEntrancesClickTime.equals(other$cWeekEntrancesClickTime)) {
            return false;
        }
        Integer n46 = this.getCDayEntrancesClickTime();
        Integer n47 = other.getCDayEntrancesClickTime();
        if (this$cDayEntrancesClickTime == null ? other$cDayEntrancesClickTime != null : !this$cDayEntrancesClickTime.equals(other$cDayEntrancesClickTime)) {
            return false;
        }
        Integer n48 = this.getCMaterialClickInterval();
        Integer n49 = other.getCMaterialClickInterval();
        if (this$cMaterialClickInterval == null ? other$cMaterialClickInterval != null : !this$cMaterialClickInterval.equals(other$cMaterialClickInterval)) {
            return false;
        }
        String string29 = this.getHistMainTitlesExposeTime();
        String string30 = other.getHistMainTitlesExposeTime();
        if (this$histMainTitlesExposeTime == null ? other$histMainTitlesExposeTime != null : !this$histMainTitlesExposeTime.equals(other$histMainTitlesExposeTime)) {
            return false;
        }
        String string31 = this.getWeekMainTitlesExposeTime();
        String string32 = other.getWeekMainTitlesExposeTime();
        if (this$weekMainTitlesExposeTime == null ? other$weekMainTitlesExposeTime != null : !this$weekMainTitlesExposeTime.equals(other$weekMainTitlesExposeTime)) {
            return false;
        }
        Map<String, Integer> map5 = this.getDayMainTitlesExposeTime();
        Map<String, Integer> map6 = other.getDayMainTitlesExposeTime();
        if (this$dayMainTitlesExposeTime == null ? other$dayMainTitlesExposeTime != null : !this$dayMainTitlesExposeTime.equals(other$dayMainTitlesExposeTime)) {
            return false;
        }
        String string33 = this.getHistSubTitlesExposeTime();
        String string34 = other.getHistSubTitlesExposeTime();
        if (this$histSubTitlesExposeTime == null ? other$histSubTitlesExposeTime != null : !this$histSubTitlesExposeTime.equals(other$histSubTitlesExposeTime)) {
            return false;
        }
        String string35 = this.getWeekSubTitlesExposeTime();
        String string36 = other.getWeekSubTitlesExposeTime();
        if (this$weekSubTitlesExposeTime == null ? other$weekSubTitlesExposeTime != null : !this$weekSubTitlesExposeTime.equals(other$weekSubTitlesExposeTime)) {
            return false;
        }
        Map<String, Integer> map7 = this.getDaySubTitlesExposeTime();
        Map<String, Integer> map8 = other.getDaySubTitlesExposeTime();
        if (this$daySubTitlesExposeTime == null ? other$daySubTitlesExposeTime != null : !this$daySubTitlesExposeTime.equals(other$daySubTitlesExposeTime)) {
            return false;
        }
        String string37 = this.getHistPrizesExposeTime();
        String string38 = other.getHistPrizesExposeTime();
        if (this$histPrizesExposeTime == null ? other$histPrizesExposeTime != null : !this$histPrizesExposeTime.equals(other$histPrizesExposeTime)) {
            return false;
        }
        String string39 = this.getWeekPrizesExposeTime();
        String string40 = other.getWeekPrizesExposeTime();
        if (this$weekPrizesExposeTime == null ? other$weekPrizesExposeTime != null : !this$weekPrizesExposeTime.equals(other$weekPrizesExposeTime)) {
            return false;
        }
        Map<String, Integer> map9 = this.getDayPrizesExposeTime();
        Map<String, Integer> map10 = other.getDayPrizesExposeTime();
        if (this$dayPrizesExposeTime == null ? other$dayPrizesExposeTime != null : !this$dayPrizesExposeTime.equals(other$dayPrizesExposeTime)) {
            return false;
        }
        String string41 = this.getHistSkinsExposeTime();
        String string42 = other.getHistSkinsExposeTime();
        if (this$histSkinsExposeTime == null ? other$histSkinsExposeTime != null : !this$histSkinsExposeTime.equals(other$histSkinsExposeTime)) {
            return false;
        }
        String string43 = this.getWeekSkinsExposeTime();
        String string44 = other.getWeekSkinsExposeTime();
        if (this$weekSkinsExposeTime == null ? other$weekSkinsExposeTime != null : !this$weekSkinsExposeTime.equals(other$weekSkinsExposeTime)) {
            return false;
        }
        Map<String, Integer> map11 = this.getDaySkinsExposeTime();
        Map<String, Integer> map12 = other.getDaySkinsExposeTime();
        if (this$daySkinsExposeTime == null ? other$daySkinsExposeTime != null : !this$daySkinsExposeTime.equals(other$daySkinsExposeTime)) {
            return false;
        }
        String string45 = this.getHistActExposeTime();
        String string46 = other.getHistActExposeTime();
        if (this$histActExposeTime == null ? other$histActExposeTime != null : !this$histActExposeTime.equals(other$histActExposeTime)) {
            return false;
        }
        String string47 = this.getWeekActExposeTime();
        String string48 = other.getWeekActExposeTime();
        if (this$weekActExposeTime == null ? other$weekActExposeTime != null : !this$weekActExposeTime.equals(other$weekActExposeTime)) {
            return false;
        }
        Map<String, Integer> map13 = this.getDayActExposeTime();
        Map<String, Integer> map14 = other.getDayActExposeTime();
        if (this$dayActExposeTime == null ? other$dayActExposeTime != null : !this$dayActExposeTime.equals(other$dayActExposeTime)) {
            return false;
        }
        String string49 = this.getHistMainTitlesClickTime();
        String string50 = other.getHistMainTitlesClickTime();
        if (this$histMainTitlesClickTime == null ? other$histMainTitlesClickTime != null : !this$histMainTitlesClickTime.equals(other$histMainTitlesClickTime)) {
            return false;
        }
        String string51 = this.getWeekMainTitlesClickTime();
        String string52 = other.getWeekMainTitlesClickTime();
        if (this$weekMainTitlesClickTime == null ? other$weekMainTitlesClickTime != null : !this$weekMainTitlesClickTime.equals(other$weekMainTitlesClickTime)) {
            return false;
        }
        Map<String, Integer> map15 = this.getDayMainTitlesClickTime();
        Map<String, Integer> map16 = other.getDayMainTitlesClickTime();
        if (this$dayMainTitlesClickTime == null ? other$dayMainTitlesClickTime != null : !this$dayMainTitlesClickTime.equals(other$dayMainTitlesClickTime)) {
            return false;
        }
        String string53 = this.getHistSubTitlesClickTime();
        String string54 = other.getHistSubTitlesClickTime();
        if (this$histSubTitlesClickTime == null ? other$histSubTitlesClickTime != null : !this$histSubTitlesClickTime.equals(other$histSubTitlesClickTime)) {
            return false;
        }
        String string55 = this.getWeekSubTitlesClickTime();
        String string56 = other.getWeekSubTitlesClickTime();
        if (this$weekSubTitlesClickTime == null ? other$weekSubTitlesClickTime != null : !this$weekSubTitlesClickTime.equals(other$weekSubTitlesClickTime)) {
            return false;
        }
        Map<String, Integer> map17 = this.getDaySubTitlesClickTime();
        Map<String, Integer> map18 = other.getDaySubTitlesClickTime();
        if (this$daySubTitlesClickTime == null ? other$daySubTitlesClickTime != null : !this$daySubTitlesClickTime.equals(other$daySubTitlesClickTime)) {
            return false;
        }
        String string57 = this.getHistPrizesClickTime();
        String string58 = other.getHistPrizesClickTime();
        if (this$histPrizesClickTime == null ? other$histPrizesClickTime != null : !this$histPrizesClickTime.equals(other$histPrizesClickTime)) {
            return false;
        }
        String string59 = this.getWeekPrizesClickTime();
        String string60 = other.getWeekPrizesClickTime();
        if (this$weekPrizesClickTime == null ? other$weekPrizesClickTime != null : !this$weekPrizesClickTime.equals(other$weekPrizesClickTime)) {
            return false;
        }
        Map<String, Integer> map19 = this.getDayPrizesClickTime();
        Map<String, Integer> map20 = other.getDayPrizesClickTime();
        if (this$dayPrizesClickTime == null ? other$dayPrizesClickTime != null : !this$dayPrizesClickTime.equals(other$dayPrizesClickTime)) {
            return false;
        }
        String string61 = this.getHistSkinsClickTime();
        String string62 = other.getHistSkinsClickTime();
        if (this$histSkinsClickTime == null ? other$histSkinsClickTime != null : !this$histSkinsClickTime.equals(other$histSkinsClickTime)) {
            return false;
        }
        String string63 = this.getWeekSkinsClickTime();
        String string64 = other.getWeekSkinsClickTime();
        if (this$weekSkinsClickTime == null ? other$weekSkinsClickTime != null : !this$weekSkinsClickTime.equals(other$weekSkinsClickTime)) {
            return false;
        }
        Map<String, Integer> map21 = this.getDaySkinsClickTime();
        Map<String, Integer> map22 = other.getDaySkinsClickTime();
        if (this$daySkinsClickTime == null ? other$daySkinsClickTime != null : !this$daySkinsClickTime.equals(other$daySkinsClickTime)) {
            return false;
        }
        String string65 = this.getHistActClickTime();
        String string66 = other.getHistActClickTime();
        if (this$histActClickTime == null ? other$histActClickTime != null : !this$histActClickTime.equals(other$histActClickTime)) {
            return false;
        }
        String string67 = this.getWeekActClickTime();
        String string68 = other.getWeekActClickTime();
        if (this$weekActClickTime == null ? other$weekActClickTime != null : !this$weekActClickTime.equals(other$weekActClickTime)) {
            return false;
        }
        Map<String, Integer> map23 = this.getDayActClickTime();
        Map<String, Integer> map24 = other.getDayActClickTime();
        if (this$dayActClickTime == null ? other$dayActClickTime != null : !this$dayActClickTime.equals(other$dayActClickTime)) {
            return false;
        }
        String string69 = this.getHistMainTitlesOrderTime();
        String string70 = other.getHistMainTitlesOrderTime();
        if (this$histMainTitlesOrderTime == null ? other$histMainTitlesOrderTime != null : !this$histMainTitlesOrderTime.equals(other$histMainTitlesOrderTime)) {
            return false;
        }
        String string71 = this.getWeekMainTitlesOrderTime();
        String string72 = other.getWeekMainTitlesOrderTime();
        if (this$weekMainTitlesOrderTime == null ? other$weekMainTitlesOrderTime != null : !this$weekMainTitlesOrderTime.equals(other$weekMainTitlesOrderTime)) {
            return false;
        }
        Map<String, Integer> map25 = this.getDayMainTitlesOrderTime();
        Map<String, Integer> map26 = other.getDayMainTitlesOrderTime();
        if (this$dayMainTitlesOrderTime == null ? other$dayMainTitlesOrderTime != null : !this$dayMainTitlesOrderTime.equals(other$dayMainTitlesOrderTime)) {
            return false;
        }
        String string73 = this.getHistSubTitlesOrderTime();
        String string74 = other.getHistSubTitlesOrderTime();
        if (this$histSubTitlesOrderTime == null ? other$histSubTitlesOrderTime != null : !this$histSubTitlesOrderTime.equals(other$histSubTitlesOrderTime)) {
            return false;
        }
        String string75 = this.getWeekSubTitlesOrderTime();
        String string76 = other.getWeekSubTitlesOrderTime();
        if (this$weekSubTitlesOrderTime == null ? other$weekSubTitlesOrderTime != null : !this$weekSubTitlesOrderTime.equals(other$weekSubTitlesOrderTime)) {
            return false;
        }
        Map<String, Integer> map27 = this.getDaySubTitlesOrderTime();
        Map<String, Integer> map28 = other.getDaySubTitlesOrderTime();
        if (this$daySubTitlesOrderTime == null ? other$daySubTitlesOrderTime != null : !this$daySubTitlesOrderTime.equals(other$daySubTitlesOrderTime)) {
            return false;
        }
        String string77 = this.getHistPrizesOrderTime();
        String string78 = other.getHistPrizesOrderTime();
        if (this$histPrizesOrderTime == null ? other$histPrizesOrderTime != null : !this$histPrizesOrderTime.equals(other$histPrizesOrderTime)) {
            return false;
        }
        String string79 = this.getWeekPrizesOrderTime();
        String string80 = other.getWeekPrizesOrderTime();
        if (this$weekPrizesOrderTime == null ? other$weekPrizesOrderTime != null : !this$weekPrizesOrderTime.equals(other$weekPrizesOrderTime)) {
            return false;
        }
        Map<String, Integer> map29 = this.getDayPrizesOrderTime();
        Map<String, Integer> map30 = other.getDayPrizesOrderTime();
        if (this$dayPrizesOrderTime == null ? other$dayPrizesOrderTime != null : !this$dayPrizesOrderTime.equals(other$dayPrizesOrderTime)) {
            return false;
        }
        String string81 = this.getHistSkinsOrderTime();
        String string82 = other.getHistSkinsOrderTime();
        if (this$histSkinsOrderTime == null ? other$histSkinsOrderTime != null : !this$histSkinsOrderTime.equals(other$histSkinsOrderTime)) {
            return false;
        }
        String string83 = this.getWeekSkinsOrderTime();
        String string84 = other.getWeekSkinsOrderTime();
        if (this$weekSkinsOrderTime == null ? other$weekSkinsOrderTime != null : !this$weekSkinsOrderTime.equals(other$weekSkinsOrderTime)) {
            return false;
        }
        Map<String, Integer> map31 = this.getDaySkinsOrderTime();
        Map<String, Integer> map32 = other.getDaySkinsOrderTime();
        if (this$daySkinsOrderTime == null ? other$daySkinsOrderTime != null : !this$daySkinsOrderTime.equals(other$daySkinsOrderTime)) {
            return false;
        }
        String string85 = this.getHistActOrderTime();
        String string86 = other.getHistActOrderTime();
        if (this$histActOrderTime == null ? other$histActOrderTime != null : !this$histActOrderTime.equals(other$histActOrderTime)) {
            return false;
        }
        String string87 = this.getWeekActOrderTime();
        String string88 = other.getWeekActOrderTime();
        if (this$weekActOrderTime == null ? other$weekActOrderTime != null : !this$weekActOrderTime.equals(other$weekActOrderTime)) {
            return false;
        }
        Map<String, Integer> map33 = this.getDayActOrderTime();
        Map<String, Integer> map34 = other.getDayActOrderTime();
        if (this$dayActOrderTime == null ? other$dayActOrderTime != null : !this$dayActOrderTime.equals(other$dayActOrderTime)) {
            return false;
        }
        String string89 = this.getLaunchSequence();
        String string90 = other.getLaunchSequence();
        if (this$launchSequence == null ? other$launchSequence != null : !this$launchSequence.equals(other$launchSequence)) {
            return false;
        }
        String string91 = this.getMainTitleSequence();
        String string92 = other.getMainTitleSequence();
        if (this$mainTitleSequence == null ? other$mainTitleSequence != null : !this$mainTitleSequence.equals(other$mainTitleSequence)) {
            return false;
        }
        String string93 = this.getSubTitleSequence();
        String string94 = other.getSubTitleSequence();
        if (this$subTitleSequence == null ? other$subTitleSequence != null : !this$subTitleSequence.equals(other$subTitleSequence)) {
            return false;
        }
        String string95 = this.getPrizeSequence();
        String string96 = other.getPrizeSequence();
        if (this$prizeSequence == null ? other$prizeSequence != null : !this$prizeSequence.equals(other$prizeSequence)) {
            return false;
        }
        String string97 = this.getPrizeCategorySequence();
        String string98 = other.getPrizeCategorySequence();
        if (this$prizeCategorySequence == null ? other$prizeCategorySequence != null : !this$prizeCategorySequence.equals(other$prizeCategorySequence)) {
            return false;
        }
        String string99 = this.getSkinSequence();
        String string100 = other.getSkinSequence();
        return !(this$skinSequence == null ? other$skinSequence != null : !this$skinSequence.equals(other$skinSequence));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserActFeature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $userActiveDays = this.getUserActiveDays();
        result = result * 59 + ($userActiveDays == null ? 43 : ((Object)$userActiveDays).hashCode());
        Integer $activityRequest = this.getActivityRequest();
        result = result * 59 + ($activityRequest == null ? 43 : ((Object)$activityRequest).hashCode());
        Integer $weekActivityRequest = this.getWeekActivityRequest();
        result = result * 59 + ($weekActivityRequest == null ? 43 : ((Object)$weekActivityRequest).hashCode());
        Integer $dayActivityRequest = this.getDayActivityRequest();
        result = result * 59 + ($dayActivityRequest == null ? 43 : ((Object)$dayActivityRequest).hashCode());
        Integer $intervalActivityRequest = this.getIntervalActivityRequest();
        result = result * 59 + ($intervalActivityRequest == null ? 43 : ((Object)$intervalActivityRequest).hashCode());
        String $periodActivityRequest = this.getPeriodActivityRequest();
        result = result * 59 + ($periodActivityRequest == null ? 43 : $periodActivityRequest.hashCode());
        Integer $activityJoin = this.getActivityJoin();
        result = result * 59 + ($activityJoin == null ? 43 : ((Object)$activityJoin).hashCode());
        Integer $weekActivityJoin = this.getWeekActivityJoin();
        result = result * 59 + ($weekActivityJoin == null ? 43 : ((Object)$weekActivityJoin).hashCode());
        Integer $dayActivityJoin = this.getDayActivityJoin();
        result = result * 59 + ($dayActivityJoin == null ? 43 : ((Object)$dayActivityJoin).hashCode());
        Integer $intervalActivityJoin = this.getIntervalActivityJoin();
        result = result * 59 + ($intervalActivityJoin == null ? 43 : ((Object)$intervalActivityJoin).hashCode());
        String $periodActivityJoin = this.getPeriodActivityJoin();
        result = result * 59 + ($periodActivityJoin == null ? 43 : $periodActivityJoin.hashCode());
        Integer $activityPageStay = this.getActivityPageStay();
        result = result * 59 + ($activityPageStay == null ? 43 : ((Object)$activityPageStay).hashCode());
        String $launchTrade = this.getLaunchTrade();
        result = result * 59 + ($launchTrade == null ? 43 : $launchTrade.hashCode());
        String $weekLaunchTrade = this.getWeekLaunchTrade();
        result = result * 59 + ($weekLaunchTrade == null ? 43 : $weekLaunchTrade.hashCode());
        Map<String, Integer> $dayLaunchTrade = this.getDayLaunchTrade();
        result = result * 59 + ($dayLaunchTrade == null ? 43 : ((Object)$dayLaunchTrade).hashCode());
        Integer $intervalLaunchTrade = this.getIntervalLaunchTrade();
        result = result * 59 + ($intervalLaunchTrade == null ? 43 : ((Object)$intervalLaunchTrade).hashCode());
        String $periodLaunchTrade = this.getPeriodLaunchTrade();
        result = result * 59 + ($periodLaunchTrade == null ? 43 : $periodLaunchTrade.hashCode());
        Integer $avgLaunchStay = this.getAvgLaunchStay();
        result = result * 59 + ($avgLaunchStay == null ? 43 : ((Object)$avgLaunchStay).hashCode());
        String $lastLaunchTrade = this.getLastLaunchTrade();
        result = result * 59 + ($lastLaunchTrade == null ? 43 : $lastLaunchTrade.hashCode());
        Integer $clickLaunchTrade = this.getClickLaunchTrade();
        result = result * 59 + ($clickLaunchTrade == null ? 43 : ((Object)$clickLaunchTrade).hashCode());
        String $clickTrade = this.getClickTrade();
        result = result * 59 + ($clickTrade == null ? 43 : $clickTrade.hashCode());
        String $weekClickTrade = this.getWeekClickTrade();
        result = result * 59 + ($weekClickTrade == null ? 43 : $weekClickTrade.hashCode());
        Map<String, Integer> $dayClickTrade = this.getDayClickTrade();
        result = result * 59 + ($dayClickTrade == null ? 43 : ((Object)$dayClickTrade).hashCode());
        Integer $intervalClickTrade = this.getIntervalClickTrade();
        result = result * 59 + ($intervalClickTrade == null ? 43 : ((Object)$intervalClickTrade).hashCode());
        String $periodClickTrade = this.getPeriodClickTrade();
        result = result * 59 + ($periodClickTrade == null ? 43 : $periodClickTrade.hashCode());
        String $lastClickTrade = this.getLastClickTrade();
        result = result * 59 + ($lastClickTrade == null ? 43 : $lastClickTrade.hashCode());
        Integer $effectClickTrade = this.getEffectClickTrade();
        result = result * 59 + ($effectClickTrade == null ? 43 : ((Object)$effectClickTrade).hashCode());
        String $effectTrade = this.getEffectTrade();
        result = result * 59 + ($effectTrade == null ? 43 : $effectTrade.hashCode());
        String $weekEffectTrade = this.getWeekEffectTrade();
        result = result * 59 + ($weekEffectTrade == null ? 43 : $weekEffectTrade.hashCode());
        Map<String, Integer> $dayEffectTrade = this.getDayEffectTrade();
        result = result * 59 + ($dayEffectTrade == null ? 43 : ((Object)$dayEffectTrade).hashCode());
        Integer $intervalEffectTrade = this.getIntervalEffectTrade();
        result = result * 59 + ($intervalEffectTrade == null ? 43 : ((Object)$intervalEffectTrade).hashCode());
        String $periodEffectTrade = this.getPeriodEffectTrade();
        result = result * 59 + ($periodEffectTrade == null ? 43 : $periodEffectTrade.hashCode());
        String $lastEffectTrade = this.getLastEffectTrade();
        result = result * 59 + ($lastEffectTrade == null ? 43 : $lastEffectTrade.hashCode());
        Long $todayLaunch = this.getTodayLaunch();
        result = result * 59 + ($todayLaunch == null ? 43 : ((Object)$todayLaunch).hashCode());
        Long $historyLaunch = this.getHistoryLaunch();
        result = result * 59 + ($historyLaunch == null ? 43 : ((Object)$historyLaunch).hashCode());
        Long $todayActivityLaunch = this.getTodayActivityLaunch();
        result = result * 59 + ($todayActivityLaunch == null ? 43 : ((Object)$todayActivityLaunch).hashCode());
        Long $historyActivityLaunch = this.getHistoryActivityLaunch();
        result = result * 59 + ($historyActivityLaunch == null ? 43 : ((Object)$historyActivityLaunch).hashCode());
        String $lastLaunchTime = this.getLastLaunchTime();
        result = result * 59 + ($lastLaunchTime == null ? 43 : $lastLaunchTime.hashCode());
        String $lastActivityLaunchTime = this.getLastActivityLaunchTime();
        result = result * 59 + ($lastActivityLaunchTime == null ? 43 : $lastActivityLaunchTime.hashCode());
        String $lastActivityLaunchOrder = this.getLastActivityLaunchOrder();
        result = result * 59 + ($lastActivityLaunchOrder == null ? 43 : $lastActivityLaunchOrder.hashCode());
        String $lastActivityClickOrder = this.getLastActivityClickOrder();
        result = result * 59 + ($lastActivityClickOrder == null ? 43 : $lastActivityClickOrder.hashCode());
        String $lastLaunchOrder = this.getLastLaunchOrder();
        result = result * 59 + ($lastLaunchOrder == null ? 43 : $lastLaunchOrder.hashCode());
        String $lastClickOrder = this.getLastClickOrder();
        result = result * 59 + ($lastClickOrder == null ? 43 : $lastClickOrder.hashCode());
        String $lastActivity = this.getLastActivity();
        result = result * 59 + ($lastActivity == null ? 43 : $lastActivity.hashCode());
        String $lastAdvertMatchTag = this.getLastAdvertMatchTag();
        result = result * 59 + ($lastAdvertMatchTag == null ? 43 : $lastAdvertMatchTag.hashCode());
        Map<String, Long> $todayResourceLaunch = this.getTodayResourceLaunch();
        result = result * 59 + ($todayResourceLaunch == null ? 43 : ((Object)$todayResourceLaunch).hashCode());
        Map<String, String> $lastResourceLaunchTime = this.getLastResourceLaunchTime();
        result = result * 59 + ($lastResourceLaunchTime == null ? 43 : ((Object)$lastResourceLaunchTime).hashCode());
        Map<String, String> $lastResourceLaunchOrder = this.getLastResourceLaunchOrder();
        result = result * 59 + ($lastResourceLaunchOrder == null ? 43 : ((Object)$lastResourceLaunchOrder).hashCode());
        Map<String, String> $lastResourceClickOrder = this.getLastResourceClickOrder();
        result = result * 59 + ($lastResourceClickOrder == null ? 43 : ((Object)$lastResourceClickOrder).hashCode());
        Map<String, String> $lastResourceEffectOrder = this.getLastResourceEffectOrder();
        result = result * 59 + ($lastResourceEffectOrder == null ? 43 : ((Object)$lastResourceEffectOrder).hashCode());
        Map<String, Long> $todayResourceClickAdvertCount = this.getTodayResourceClickAdvertCount();
        result = result * 59 + ($todayResourceClickAdvertCount == null ? 43 : ((Object)$todayResourceClickAdvertCount).hashCode());
        Map<String, Long> $todayResourceEffectAdvertCount = this.getTodayResourceEffectAdvertCount();
        result = result * 59 + ($todayResourceEffectAdvertCount == null ? 43 : ((Object)$todayResourceEffectAdvertCount).hashCode());
        String $lastResource = this.getLastResource();
        result = result * 59 + ($lastResource == null ? 43 : $lastResource.hashCode());
        String $lastLaunchAccount = this.getLastLaunchAccount();
        result = result * 59 + ($lastLaunchAccount == null ? 43 : $lastLaunchAccount.hashCode());
        String $lastLaunchPlan = this.getLastLaunchPlan();
        result = result * 59 + ($lastLaunchPlan == null ? 43 : $lastLaunchPlan.hashCode());
        Set<Integer> $advertExposureSet = this.getAdvertExposureSet();
        result = result * 59 + ($advertExposureSet == null ? 43 : ((Object)$advertExposureSet).hashCode());
        Set<Integer> $advertClickSet = this.getAdvertClickSet();
        result = result * 59 + ($advertClickSet == null ? 43 : ((Object)$advertClickSet).hashCode());
        Set<Integer> $accountClickSet = this.getAccountClickSet();
        result = result * 59 + ($accountClickSet == null ? 43 : ((Object)$accountClickSet).hashCode());
        Set<String> $resourceClickSet = this.getResourceClickSet();
        result = result * 59 + ($resourceClickSet == null ? 43 : ((Object)$resourceClickSet).hashCode());
        Set<Integer> $tradeClickSet = this.getTradeClickSet();
        result = result * 59 + ($tradeClickSet == null ? 43 : ((Object)$tradeClickSet).hashCode());
        Set<Integer> $advertEffectSet = this.getAdvertEffectSet();
        result = result * 59 + ($advertEffectSet == null ? 43 : ((Object)$advertEffectSet).hashCode());
        Set<Integer> $accountEffectSet = this.getAccountEffectSet();
        result = result * 59 + ($accountEffectSet == null ? 43 : ((Object)$accountEffectSet).hashCode());
        Set<String> $resourceEffectSet = this.getResourceEffectSet();
        result = result * 59 + ($resourceEffectSet == null ? 43 : ((Object)$resourceEffectSet).hashCode());
        Set<Integer> $tradeEffectSet = this.getTradeEffectSet();
        result = result * 59 + ($tradeEffectSet == null ? 43 : ((Object)$tradeEffectSet).hashCode());
        Map<Integer, Long> $todayAdvertLaunch = this.getTodayAdvertLaunch();
        result = result * 59 + ($todayAdvertLaunch == null ? 43 : ((Object)$todayAdvertLaunch).hashCode());
        Map<Integer, Long> $todayAdvertClick = this.getTodayAdvertClick();
        result = result * 59 + ($todayAdvertClick == null ? 43 : ((Object)$todayAdvertClick).hashCode());
        Map<Integer, Long> $todayAdvertEffect = this.getTodayAdvertEffect();
        result = result * 59 + ($todayAdvertEffect == null ? 43 : ((Object)$todayAdvertEffect).hashCode());
        Map<Integer, Long> $historyAdvertLaunch = this.getHistoryAdvertLaunch();
        result = result * 59 + ($historyAdvertLaunch == null ? 43 : ((Object)$historyAdvertLaunch).hashCode());
        Map<Integer, Long> $historyAdvertClick = this.getHistoryAdvertClick();
        result = result * 59 + ($historyAdvertClick == null ? 43 : ((Object)$historyAdvertClick).hashCode());
        Map<Integer, Long> $historyAdvertEffect = this.getHistoryAdvertEffect();
        result = result * 59 + ($historyAdvertEffect == null ? 43 : ((Object)$historyAdvertEffect).hashCode());
        Integer $history30LaunchCount = this.getHistory30LaunchCount();
        result = result * 59 + ($history30LaunchCount == null ? 43 : ((Object)$history30LaunchCount).hashCode());
        Integer $history30ClickCount = this.getHistory30ClickCount();
        result = result * 59 + ($history30ClickCount == null ? 43 : ((Object)$history30ClickCount).hashCode());
        Integer $history30EffectCount = this.getHistory30EffectCount();
        result = result * 59 + ($history30EffectCount == null ? 43 : ((Object)$history30EffectCount).hashCode());
        Integer $todayLaunchCount = this.getTodayLaunchCount();
        result = result * 59 + ($todayLaunchCount == null ? 43 : ((Object)$todayLaunchCount).hashCode());
        Integer $todayClickCount = this.getTodayClickCount();
        result = result * 59 + ($todayClickCount == null ? 43 : ((Object)$todayClickCount).hashCode());
        Integer $todayEffectCount = this.getTodayEffectCount();
        result = result * 59 + ($todayEffectCount == null ? 43 : ((Object)$todayEffectCount).hashCode());
        String $oUIIds = this.getOUIIds();
        result = result * 59 + ($oUIIds == null ? 43 : $oUIIds.hashCode());
        String $oUILaunchPV = this.getOUILaunchPV();
        result = result * 59 + ($oUILaunchPV == null ? 43 : $oUILaunchPV.hashCode());
        String $oUIClickPv = this.getOUIClickPv();
        result = result * 59 + ($oUIClickPv == null ? 43 : $oUIClickPv.hashCode());
        String $oUIEffectPv = this.getOUIEffectPv();
        result = result * 59 + ($oUIEffectPv == null ? 43 : $oUIEffectPv.hashCode());
        Map<String, Long> $historyTradeLaunch = this.getHistoryTradeLaunch();
        result = result * 59 + ($historyTradeLaunch == null ? 43 : ((Object)$historyTradeLaunch).hashCode());
        Map<String, Long> $historyTradeClick = this.getHistoryTradeClick();
        result = result * 59 + ($historyTradeClick == null ? 43 : ((Object)$historyTradeClick).hashCode());
        Map<String, Long> $historyTradeEffect = this.getHistoryTradeEffect();
        result = result * 59 + ($historyTradeEffect == null ? 43 : ((Object)$historyTradeEffect).hashCode());
        Map<String, Map<String, Long>> $historyTradeCtrCvr = this.getHistoryTradeCtrCvr();
        result = result * 59 + ($historyTradeCtrCvr == null ? 43 : ((Object)$historyTradeCtrCvr).hashCode());
        String $clickCategory = this.getClickCategory();
        result = result * 59 + ($clickCategory == null ? 43 : $clickCategory.hashCode());
        String $weekClickCategory = this.getWeekClickCategory();
        result = result * 59 + ($weekClickCategory == null ? 43 : $weekClickCategory.hashCode());
        Map<String, Integer> $dayClickCategory = this.getDayClickCategory();
        result = result * 59 + ($dayClickCategory == null ? 43 : ((Object)$dayClickCategory).hashCode());
        Integer $intervalClickCategory = this.getIntervalClickCategory();
        result = result * 59 + ($intervalClickCategory == null ? 43 : ((Object)$intervalClickCategory).hashCode());
        String $periodClickCategory = this.getPeriodClickCategory();
        result = result * 59 + ($periodClickCategory == null ? 43 : $periodClickCategory.hashCode());
        Integer $avgLandpageStay = this.getAvgLandpageStay();
        result = result * 59 + ($avgLandpageStay == null ? 43 : ((Object)$avgLandpageStay).hashCode());
        String $lastClickCategory = this.getLastClickCategory();
        result = result * 59 + ($lastClickCategory == null ? 43 : $lastClickCategory.hashCode());
        Integer $effectClickCategory = this.getEffectClickCategory();
        result = result * 59 + ($effectClickCategory == null ? 43 : ((Object)$effectClickCategory).hashCode());
        String $lastClickBrand = this.getLastClickBrand();
        result = result * 59 + ($lastClickBrand == null ? 43 : $lastClickBrand.hashCode());
        Integer $issueEffectClickCategory = this.getIssueEffectClickCategory();
        result = result * 59 + ($issueEffectClickCategory == null ? 43 : ((Object)$issueEffectClickCategory).hashCode());
        String $effectCategory = this.getEffectCategory();
        result = result * 59 + ($effectCategory == null ? 43 : $effectCategory.hashCode());
        String $weekEffectCategory = this.getWeekEffectCategory();
        result = result * 59 + ($weekEffectCategory == null ? 43 : $weekEffectCategory.hashCode());
        Map<String, Integer> $dayEffectCategory = this.getDayEffectCategory();
        result = result * 59 + ($dayEffectCategory == null ? 43 : ((Object)$dayEffectCategory).hashCode());
        Integer $intervalEffectCategory = this.getIntervalEffectCategory();
        result = result * 59 + ($intervalEffectCategory == null ? 43 : ((Object)$intervalEffectCategory).hashCode());
        String $periodEffectCategory = this.getPeriodEffectCategory();
        result = result * 59 + ($periodEffectCategory == null ? 43 : $periodEffectCategory.hashCode());
        String $lastEffectCategory = this.getLastEffectCategory();
        result = result * 59 + ($lastEffectCategory == null ? 43 : $lastEffectCategory.hashCode());
        String $lastEffectBrand = this.getLastEffectBrand();
        result = result * 59 + ($lastEffectBrand == null ? 43 : $lastEffectBrand.hashCode());
        Integer $addressCount = this.getAddressCount();
        result = result * 59 + ($addressCount == null ? 43 : ((Object)$addressCount).hashCode());
        Integer $numberCount = this.getNumberCount();
        result = result * 59 + ($numberCount == null ? 43 : ((Object)$numberCount).hashCode());
        String $issueEffectCategory = this.getIssueEffectCategory();
        result = result * 59 + ($issueEffectCategory == null ? 43 : $issueEffectCategory.hashCode());
        String $weekIssueEffectCategory = this.getWeekIssueEffectCategory();
        result = result * 59 + ($weekIssueEffectCategory == null ? 43 : $weekIssueEffectCategory.hashCode());
        Integer $intervalIssueEffectCategory = this.getIntervalIssueEffectCategory();
        result = result * 59 + ($intervalIssueEffectCategory == null ? 43 : ((Object)$intervalIssueEffectCategory).hashCode());
        String $periodIssueEffectCategory = this.getPeriodIssueEffectCategory();
        result = result * 59 + ($periodIssueEffectCategory == null ? 43 : $periodIssueEffectCategory.hashCode());
        String $lastIssueEffectCategory = this.getLastIssueEffectCategory();
        result = result * 59 + ($lastIssueEffectCategory == null ? 43 : $lastIssueEffectCategory.hashCode());
        String $lastIssueEffectBrand = this.getLastIssueEffectBrand();
        result = result * 59 + ($lastIssueEffectBrand == null ? 43 : $lastIssueEffectBrand.hashCode());
        String $scoreEffectCategory = this.getScoreEffectCategory();
        result = result * 59 + ($scoreEffectCategory == null ? 43 : $scoreEffectCategory.hashCode());
        String $scoreIssueEffectCategory = this.getScoreIssueEffectCategory();
        result = result * 59 + ($scoreIssueEffectCategory == null ? 43 : $scoreIssueEffectCategory.hashCode());
        Integer $orderFee = this.getOrderFee();
        result = result * 59 + ($orderFee == null ? 43 : ((Object)$orderFee).hashCode());
        Integer $weekOrderFee = this.getWeekOrderFee();
        result = result * 59 + ($weekOrderFee == null ? 43 : ((Object)$weekOrderFee).hashCode());
        Integer $maxOrderFee = this.getMaxOrderFee();
        result = result * 59 + ($maxOrderFee == null ? 43 : ((Object)$maxOrderFee).hashCode());
        Integer $minOrderFee = this.getMinOrderFee();
        result = result * 59 + ($minOrderFee == null ? 43 : ((Object)$minOrderFee).hashCode());
        Integer $avgOrderFee = this.getAvgOrderFee();
        result = result * 59 + ($avgOrderFee == null ? 43 : ((Object)$avgOrderFee).hashCode());
        Integer $lastOrderFee = this.getLastOrderFee();
        result = result * 59 + ($lastOrderFee == null ? 43 : ((Object)$lastOrderFee).hashCode());
        Integer $zeroLaunch = this.getZeroLaunch();
        result = result * 59 + ($zeroLaunch == null ? 43 : ((Object)$zeroLaunch).hashCode());
        Integer $nonZeroLaunch = this.getNonZeroLaunch();
        result = result * 59 + ($nonZeroLaunch == null ? 43 : ((Object)$nonZeroLaunch).hashCode());
        Integer $zeroClick = this.getZeroClick();
        result = result * 59 + ($zeroClick == null ? 43 : ((Object)$zeroClick).hashCode());
        Integer $nonZeroClick = this.getNonZeroClick();
        result = result * 59 + ($nonZeroClick == null ? 43 : ((Object)$nonZeroClick).hashCode());
        Integer $zeroEffect = this.getZeroEffect();
        result = result * 59 + ($zeroEffect == null ? 43 : ((Object)$zeroEffect).hashCode());
        Integer $nonZeroEffect = this.getNonZeroEffect();
        result = result * 59 + ($nonZeroEffect == null ? 43 : ((Object)$nonZeroEffect).hashCode());
        Integer $zeroIssueEffect = this.getZeroIssueEffect();
        result = result * 59 + ($zeroIssueEffect == null ? 43 : ((Object)$zeroIssueEffect).hashCode());
        Integer $nonZeroIssueEffect = this.getNonZeroIssueEffect();
        result = result * 59 + ($nonZeroIssueEffect == null ? 43 : ((Object)$nonZeroIssueEffect).hashCode());
        Integer $vouchFailed = this.getVouchFailed();
        result = result * 59 + ($vouchFailed == null ? 43 : ((Object)$vouchFailed).hashCode());
        Integer $weekVouchFailed = this.getWeekVouchFailed();
        result = result * 59 + ($weekVouchFailed == null ? 43 : ((Object)$weekVouchFailed).hashCode());
        Integer $intervalVouchFailed = this.getIntervalVouchFailed();
        result = result * 59 + ($intervalVouchFailed == null ? 43 : ((Object)$intervalVouchFailed).hashCode());
        Integer $reject = this.getReject();
        result = result * 59 + ($reject == null ? 43 : ((Object)$reject).hashCode());
        Integer $weekReject = this.getWeekReject();
        result = result * 59 + ($weekReject == null ? 43 : ((Object)$weekReject).hashCode());
        Integer $intervalReject = this.getIntervalReject();
        result = result * 59 + ($intervalReject == null ? 43 : ((Object)$intervalReject).hashCode());
        Integer $complaint = this.getComplaint();
        result = result * 59 + ($complaint == null ? 43 : ((Object)$complaint).hashCode());
        Integer $weekComplaint = this.getWeekComplaint();
        result = result * 59 + ($weekComplaint == null ? 43 : ((Object)$weekComplaint).hashCode());
        Integer $intervalComplaint = this.getIntervalComplaint();
        result = result * 59 + ($intervalComplaint == null ? 43 : ((Object)$intervalComplaint).hashCode());
        Integer $addressException = this.getAddressException();
        result = result * 59 + ($addressException == null ? 43 : ((Object)$addressException).hashCode());
        Integer $weekAddressException = this.getWeekAddressException();
        result = result * 59 + ($weekAddressException == null ? 43 : ((Object)$weekAddressException).hashCode());
        Integer $intervalAddressException = this.getIntervalAddressException();
        result = result * 59 + ($intervalAddressException == null ? 43 : ((Object)$intervalAddressException).hashCode());
        Integer $numberEmpty = this.getNumberEmpty();
        result = result * 59 + ($numberEmpty == null ? 43 : ((Object)$numberEmpty).hashCode());
        Integer $weekNumberEmpty = this.getWeekNumberEmpty();
        result = result * 59 + ($weekNumberEmpty == null ? 43 : ((Object)$weekNumberEmpty).hashCode());
        Integer $intervalNumberEmpty = this.getIntervalNumberEmpty();
        result = result * 59 + ($intervalNumberEmpty == null ? 43 : ((Object)$intervalNumberEmpty).hashCode());
        Integer $cheat = this.getCheat();
        result = result * 59 + ($cheat == null ? 43 : ((Object)$cheat).hashCode());
        Integer $weekCheat = this.getWeekCheat();
        result = result * 59 + ($weekCheat == null ? 43 : ((Object)$weekCheat).hashCode());
        Integer $intervalCheat = this.getIntervalCheat();
        result = result * 59 + ($intervalCheat == null ? 43 : ((Object)$intervalCheat).hashCode());
        String $lastApp = this.getLastApp();
        result = result * 59 + ($lastApp == null ? 43 : $lastApp.hashCode());
        Long $lastVideoTime = this.getLastVideoTime();
        result = result * 59 + ($lastVideoTime == null ? 43 : ((Object)$lastVideoTime).hashCode());
        String $lastVideoChannel = this.getLastVideoChannel();
        result = result * 59 + ($lastVideoChannel == null ? 43 : $lastVideoChannel.hashCode());
        String $lastVideoInfo = this.getLastVideoInfo();
        result = result * 59 + ($lastVideoInfo == null ? 43 : $lastVideoInfo.hashCode());
        String $lastVideoCategory = this.getLastVideoCategory();
        result = result * 59 + ($lastVideoCategory == null ? 43 : $lastVideoCategory.hashCode());
        String $lastVideoArea = this.getLastVideoArea();
        result = result * 59 + ($lastVideoArea == null ? 43 : $lastVideoArea.hashCode());
        String $lastVideoYears = this.getLastVideoYears();
        result = result * 59 + ($lastVideoYears == null ? 43 : $lastVideoYears.hashCode());
        String $histEntrancesExposeTime = this.getHistEntrancesExposeTime();
        result = result * 59 + ($histEntrancesExposeTime == null ? 43 : $histEntrancesExposeTime.hashCode());
        String $weekEntrancesExposeTime = this.getWeekEntrancesExposeTime();
        result = result * 59 + ($weekEntrancesExposeTime == null ? 43 : $weekEntrancesExposeTime.hashCode());
        Map<String, Integer> $dayEntrancesExposeTime = this.getDayEntrancesExposeTime();
        result = result * 59 + ($dayEntrancesExposeTime == null ? 43 : ((Object)$dayEntrancesExposeTime).hashCode());
        String $materialExposeInterval = this.getMaterialExposeInterval();
        result = result * 59 + ($materialExposeInterval == null ? 43 : $materialExposeInterval.hashCode());
        String $materialExposePeriod = this.getMaterialExposePeriod();
        result = result * 59 + ($materialExposePeriod == null ? 43 : $materialExposePeriod.hashCode());
        Integer $cHistEntrancesExposeTime = this.getCHistEntrancesExposeTime();
        result = result * 59 + ($cHistEntrancesExposeTime == null ? 43 : ((Object)$cHistEntrancesExposeTime).hashCode());
        Integer $cWeekEntrancesExposeTime = this.getCWeekEntrancesExposeTime();
        result = result * 59 + ($cWeekEntrancesExposeTime == null ? 43 : ((Object)$cWeekEntrancesExposeTime).hashCode());
        Integer $cDayEntrancesExposeTime = this.getCDayEntrancesExposeTime();
        result = result * 59 + ($cDayEntrancesExposeTime == null ? 43 : ((Object)$cDayEntrancesExposeTime).hashCode());
        Integer $cMaterialExposeInterval = this.getCMaterialExposeInterval();
        result = result * 59 + ($cMaterialExposeInterval == null ? 43 : ((Object)$cMaterialExposeInterval).hashCode());
        String $histEntrancesClickTime = this.getHistEntrancesClickTime();
        result = result * 59 + ($histEntrancesClickTime == null ? 43 : $histEntrancesClickTime.hashCode());
        String $weekEntrancesClickTime = this.getWeekEntrancesClickTime();
        result = result * 59 + ($weekEntrancesClickTime == null ? 43 : $weekEntrancesClickTime.hashCode());
        Map<String, Integer> $dayEntrancesClickTime = this.getDayEntrancesClickTime();
        result = result * 59 + ($dayEntrancesClickTime == null ? 43 : ((Object)$dayEntrancesClickTime).hashCode());
        String $materialClickInterval = this.getMaterialClickInterval();
        result = result * 59 + ($materialClickInterval == null ? 43 : $materialClickInterval.hashCode());
        String $materialClickPeriod = this.getMaterialClickPeriod();
        result = result * 59 + ($materialClickPeriod == null ? 43 : $materialClickPeriod.hashCode());
        Integer $cHistEntrancesClickTime = this.getCHistEntrancesClickTime();
        result = result * 59 + ($cHistEntrancesClickTime == null ? 43 : ((Object)$cHistEntrancesClickTime).hashCode());
        Integer $cWeekEntrancesClickTime = this.getCWeekEntrancesClickTime();
        result = result * 59 + ($cWeekEntrancesClickTime == null ? 43 : ((Object)$cWeekEntrancesClickTime).hashCode());
        Integer $cDayEntrancesClickTime = this.getCDayEntrancesClickTime();
        result = result * 59 + ($cDayEntrancesClickTime == null ? 43 : ((Object)$cDayEntrancesClickTime).hashCode());
        Integer $cMaterialClickInterval = this.getCMaterialClickInterval();
        result = result * 59 + ($cMaterialClickInterval == null ? 43 : ((Object)$cMaterialClickInterval).hashCode());
        String $histMainTitlesExposeTime = this.getHistMainTitlesExposeTime();
        result = result * 59 + ($histMainTitlesExposeTime == null ? 43 : $histMainTitlesExposeTime.hashCode());
        String $weekMainTitlesExposeTime = this.getWeekMainTitlesExposeTime();
        result = result * 59 + ($weekMainTitlesExposeTime == null ? 43 : $weekMainTitlesExposeTime.hashCode());
        Map<String, Integer> $dayMainTitlesExposeTime = this.getDayMainTitlesExposeTime();
        result = result * 59 + ($dayMainTitlesExposeTime == null ? 43 : ((Object)$dayMainTitlesExposeTime).hashCode());
        String $histSubTitlesExposeTime = this.getHistSubTitlesExposeTime();
        result = result * 59 + ($histSubTitlesExposeTime == null ? 43 : $histSubTitlesExposeTime.hashCode());
        String $weekSubTitlesExposeTime = this.getWeekSubTitlesExposeTime();
        result = result * 59 + ($weekSubTitlesExposeTime == null ? 43 : $weekSubTitlesExposeTime.hashCode());
        Map<String, Integer> $daySubTitlesExposeTime = this.getDaySubTitlesExposeTime();
        result = result * 59 + ($daySubTitlesExposeTime == null ? 43 : ((Object)$daySubTitlesExposeTime).hashCode());
        String $histPrizesExposeTime = this.getHistPrizesExposeTime();
        result = result * 59 + ($histPrizesExposeTime == null ? 43 : $histPrizesExposeTime.hashCode());
        String $weekPrizesExposeTime = this.getWeekPrizesExposeTime();
        result = result * 59 + ($weekPrizesExposeTime == null ? 43 : $weekPrizesExposeTime.hashCode());
        Map<String, Integer> $dayPrizesExposeTime = this.getDayPrizesExposeTime();
        result = result * 59 + ($dayPrizesExposeTime == null ? 43 : ((Object)$dayPrizesExposeTime).hashCode());
        String $histSkinsExposeTime = this.getHistSkinsExposeTime();
        result = result * 59 + ($histSkinsExposeTime == null ? 43 : $histSkinsExposeTime.hashCode());
        String $weekSkinsExposeTime = this.getWeekSkinsExposeTime();
        result = result * 59 + ($weekSkinsExposeTime == null ? 43 : $weekSkinsExposeTime.hashCode());
        Map<String, Integer> $daySkinsExposeTime = this.getDaySkinsExposeTime();
        result = result * 59 + ($daySkinsExposeTime == null ? 43 : ((Object)$daySkinsExposeTime).hashCode());
        String $histActExposeTime = this.getHistActExposeTime();
        result = result * 59 + ($histActExposeTime == null ? 43 : $histActExposeTime.hashCode());
        String $weekActExposeTime = this.getWeekActExposeTime();
        result = result * 59 + ($weekActExposeTime == null ? 43 : $weekActExposeTime.hashCode());
        Map<String, Integer> $dayActExposeTime = this.getDayActExposeTime();
        result = result * 59 + ($dayActExposeTime == null ? 43 : ((Object)$dayActExposeTime).hashCode());
        String $histMainTitlesClickTime = this.getHistMainTitlesClickTime();
        result = result * 59 + ($histMainTitlesClickTime == null ? 43 : $histMainTitlesClickTime.hashCode());
        String $weekMainTitlesClickTime = this.getWeekMainTitlesClickTime();
        result = result * 59 + ($weekMainTitlesClickTime == null ? 43 : $weekMainTitlesClickTime.hashCode());
        Map<String, Integer> $dayMainTitlesClickTime = this.getDayMainTitlesClickTime();
        result = result * 59 + ($dayMainTitlesClickTime == null ? 43 : ((Object)$dayMainTitlesClickTime).hashCode());
        String $histSubTitlesClickTime = this.getHistSubTitlesClickTime();
        result = result * 59 + ($histSubTitlesClickTime == null ? 43 : $histSubTitlesClickTime.hashCode());
        String $weekSubTitlesClickTime = this.getWeekSubTitlesClickTime();
        result = result * 59 + ($weekSubTitlesClickTime == null ? 43 : $weekSubTitlesClickTime.hashCode());
        Map<String, Integer> $daySubTitlesClickTime = this.getDaySubTitlesClickTime();
        result = result * 59 + ($daySubTitlesClickTime == null ? 43 : ((Object)$daySubTitlesClickTime).hashCode());
        String $histPrizesClickTime = this.getHistPrizesClickTime();
        result = result * 59 + ($histPrizesClickTime == null ? 43 : $histPrizesClickTime.hashCode());
        String $weekPrizesClickTime = this.getWeekPrizesClickTime();
        result = result * 59 + ($weekPrizesClickTime == null ? 43 : $weekPrizesClickTime.hashCode());
        Map<String, Integer> $dayPrizesClickTime = this.getDayPrizesClickTime();
        result = result * 59 + ($dayPrizesClickTime == null ? 43 : ((Object)$dayPrizesClickTime).hashCode());
        String $histSkinsClickTime = this.getHistSkinsClickTime();
        result = result * 59 + ($histSkinsClickTime == null ? 43 : $histSkinsClickTime.hashCode());
        String $weekSkinsClickTime = this.getWeekSkinsClickTime();
        result = result * 59 + ($weekSkinsClickTime == null ? 43 : $weekSkinsClickTime.hashCode());
        Map<String, Integer> $daySkinsClickTime = this.getDaySkinsClickTime();
        result = result * 59 + ($daySkinsClickTime == null ? 43 : ((Object)$daySkinsClickTime).hashCode());
        String $histActClickTime = this.getHistActClickTime();
        result = result * 59 + ($histActClickTime == null ? 43 : $histActClickTime.hashCode());
        String $weekActClickTime = this.getWeekActClickTime();
        result = result * 59 + ($weekActClickTime == null ? 43 : $weekActClickTime.hashCode());
        Map<String, Integer> $dayActClickTime = this.getDayActClickTime();
        result = result * 59 + ($dayActClickTime == null ? 43 : ((Object)$dayActClickTime).hashCode());
        String $histMainTitlesOrderTime = this.getHistMainTitlesOrderTime();
        result = result * 59 + ($histMainTitlesOrderTime == null ? 43 : $histMainTitlesOrderTime.hashCode());
        String $weekMainTitlesOrderTime = this.getWeekMainTitlesOrderTime();
        result = result * 59 + ($weekMainTitlesOrderTime == null ? 43 : $weekMainTitlesOrderTime.hashCode());
        Map<String, Integer> $dayMainTitlesOrderTime = this.getDayMainTitlesOrderTime();
        result = result * 59 + ($dayMainTitlesOrderTime == null ? 43 : ((Object)$dayMainTitlesOrderTime).hashCode());
        String $histSubTitlesOrderTime = this.getHistSubTitlesOrderTime();
        result = result * 59 + ($histSubTitlesOrderTime == null ? 43 : $histSubTitlesOrderTime.hashCode());
        String $weekSubTitlesOrderTime = this.getWeekSubTitlesOrderTime();
        result = result * 59 + ($weekSubTitlesOrderTime == null ? 43 : $weekSubTitlesOrderTime.hashCode());
        Map<String, Integer> $daySubTitlesOrderTime = this.getDaySubTitlesOrderTime();
        result = result * 59 + ($daySubTitlesOrderTime == null ? 43 : ((Object)$daySubTitlesOrderTime).hashCode());
        String $histPrizesOrderTime = this.getHistPrizesOrderTime();
        result = result * 59 + ($histPrizesOrderTime == null ? 43 : $histPrizesOrderTime.hashCode());
        String $weekPrizesOrderTime = this.getWeekPrizesOrderTime();
        result = result * 59 + ($weekPrizesOrderTime == null ? 43 : $weekPrizesOrderTime.hashCode());
        Map<String, Integer> $dayPrizesOrderTime = this.getDayPrizesOrderTime();
        result = result * 59 + ($dayPrizesOrderTime == null ? 43 : ((Object)$dayPrizesOrderTime).hashCode());
        String $histSkinsOrderTime = this.getHistSkinsOrderTime();
        result = result * 59 + ($histSkinsOrderTime == null ? 43 : $histSkinsOrderTime.hashCode());
        String $weekSkinsOrderTime = this.getWeekSkinsOrderTime();
        result = result * 59 + ($weekSkinsOrderTime == null ? 43 : $weekSkinsOrderTime.hashCode());
        Map<String, Integer> $daySkinsOrderTime = this.getDaySkinsOrderTime();
        result = result * 59 + ($daySkinsOrderTime == null ? 43 : ((Object)$daySkinsOrderTime).hashCode());
        String $histActOrderTime = this.getHistActOrderTime();
        result = result * 59 + ($histActOrderTime == null ? 43 : $histActOrderTime.hashCode());
        String $weekActOrderTime = this.getWeekActOrderTime();
        result = result * 59 + ($weekActOrderTime == null ? 43 : $weekActOrderTime.hashCode());
        Map<String, Integer> $dayActOrderTime = this.getDayActOrderTime();
        result = result * 59 + ($dayActOrderTime == null ? 43 : ((Object)$dayActOrderTime).hashCode());
        String $launchSequence = this.getLaunchSequence();
        result = result * 59 + ($launchSequence == null ? 43 : $launchSequence.hashCode());
        String $mainTitleSequence = this.getMainTitleSequence();
        result = result * 59 + ($mainTitleSequence == null ? 43 : $mainTitleSequence.hashCode());
        String $subTitleSequence = this.getSubTitleSequence();
        result = result * 59 + ($subTitleSequence == null ? 43 : $subTitleSequence.hashCode());
        String $prizeSequence = this.getPrizeSequence();
        result = result * 59 + ($prizeSequence == null ? 43 : $prizeSequence.hashCode());
        String $prizeCategorySequence = this.getPrizeCategorySequence();
        result = result * 59 + ($prizeCategorySequence == null ? 43 : $prizeCategorySequence.hashCode());
        String $skinSequence = this.getSkinSequence();
        result = result * 59 + ($skinSequence == null ? 43 : $skinSequence.hashCode());
        return result;
    }

    public String toString() {
        return "UserActFeature(userActiveDays=" + this.getUserActiveDays() + ", activityRequest=" + this.getActivityRequest() + ", weekActivityRequest=" + this.getWeekActivityRequest() + ", dayActivityRequest=" + this.getDayActivityRequest() + ", intervalActivityRequest=" + this.getIntervalActivityRequest() + ", periodActivityRequest=" + this.getPeriodActivityRequest() + ", activityJoin=" + this.getActivityJoin() + ", weekActivityJoin=" + this.getWeekActivityJoin() + ", dayActivityJoin=" + this.getDayActivityJoin() + ", intervalActivityJoin=" + this.getIntervalActivityJoin() + ", periodActivityJoin=" + this.getPeriodActivityJoin() + ", activityPageStay=" + this.getActivityPageStay() + ", launchTrade=" + this.getLaunchTrade() + ", weekLaunchTrade=" + this.getWeekLaunchTrade() + ", dayLaunchTrade=" + this.getDayLaunchTrade() + ", intervalLaunchTrade=" + this.getIntervalLaunchTrade() + ", periodLaunchTrade=" + this.getPeriodLaunchTrade() + ", avgLaunchStay=" + this.getAvgLaunchStay() + ", lastLaunchTrade=" + this.getLastLaunchTrade() + ", clickLaunchTrade=" + this.getClickLaunchTrade() + ", clickTrade=" + this.getClickTrade() + ", weekClickTrade=" + this.getWeekClickTrade() + ", dayClickTrade=" + this.getDayClickTrade() + ", intervalClickTrade=" + this.getIntervalClickTrade() + ", periodClickTrade=" + this.getPeriodClickTrade() + ", lastClickTrade=" + this.getLastClickTrade() + ", effectClickTrade=" + this.getEffectClickTrade() + ", effectTrade=" + this.getEffectTrade() + ", weekEffectTrade=" + this.getWeekEffectTrade() + ", dayEffectTrade=" + this.getDayEffectTrade() + ", intervalEffectTrade=" + this.getIntervalEffectTrade() + ", periodEffectTrade=" + this.getPeriodEffectTrade() + ", lastEffectTrade=" + this.getLastEffectTrade() + ", todayLaunch=" + this.getTodayLaunch() + ", historyLaunch=" + this.getHistoryLaunch() + ", todayActivityLaunch=" + this.getTodayActivityLaunch() + ", historyActivityLaunch=" + this.getHistoryActivityLaunch() + ", lastLaunchTime=" + this.getLastLaunchTime() + ", lastActivityLaunchTime=" + this.getLastActivityLaunchTime() + ", lastActivityLaunchOrder=" + this.getLastActivityLaunchOrder() + ", lastActivityClickOrder=" + this.getLastActivityClickOrder() + ", lastLaunchOrder=" + this.getLastLaunchOrder() + ", lastClickOrder=" + this.getLastClickOrder() + ", lastActivity=" + this.getLastActivity() + ", lastAdvertMatchTag=" + this.getLastAdvertMatchTag() + ", todayResourceLaunch=" + this.getTodayResourceLaunch() + ", lastResourceLaunchTime=" + this.getLastResourceLaunchTime() + ", lastResourceLaunchOrder=" + this.getLastResourceLaunchOrder() + ", lastResourceClickOrder=" + this.getLastResourceClickOrder() + ", lastResourceEffectOrder=" + this.getLastResourceEffectOrder() + ", todayResourceClickAdvertCount=" + this.getTodayResourceClickAdvertCount() + ", todayResourceEffectAdvertCount=" + this.getTodayResourceEffectAdvertCount() + ", lastResource=" + this.getLastResource() + ", lastLaunchAccount=" + this.getLastLaunchAccount() + ", lastLaunchPlan=" + this.getLastLaunchPlan() + ", advertExposureSet=" + this.getAdvertExposureSet() + ", advertClickSet=" + this.getAdvertClickSet() + ", accountClickSet=" + this.getAccountClickSet() + ", resourceClickSet=" + this.getResourceClickSet() + ", tradeClickSet=" + this.getTradeClickSet() + ", advertEffectSet=" + this.getAdvertEffectSet() + ", accountEffectSet=" + this.getAccountEffectSet() + ", resourceEffectSet=" + this.getResourceEffectSet() + ", tradeEffectSet=" + this.getTradeEffectSet() + ", todayAdvertLaunch=" + this.getTodayAdvertLaunch() + ", todayAdvertClick=" + this.getTodayAdvertClick() + ", todayAdvertEffect=" + this.getTodayAdvertEffect() + ", historyAdvertLaunch=" + this.getHistoryAdvertLaunch() + ", historyAdvertClick=" + this.getHistoryAdvertClick() + ", historyAdvertEffect=" + this.getHistoryAdvertEffect() + ", history30LaunchCount=" + this.getHistory30LaunchCount() + ", history30ClickCount=" + this.getHistory30ClickCount() + ", history30EffectCount=" + this.getHistory30EffectCount() + ", todayLaunchCount=" + this.getTodayLaunchCount() + ", todayClickCount=" + this.getTodayClickCount() + ", todayEffectCount=" + this.getTodayEffectCount() + ", oUIIds=" + this.getOUIIds() + ", oUILaunchPV=" + this.getOUILaunchPV() + ", oUIClickPv=" + this.getOUIClickPv() + ", oUIEffectPv=" + this.getOUIEffectPv() + ", historyTradeLaunch=" + this.getHistoryTradeLaunch() + ", historyTradeClick=" + this.getHistoryTradeClick() + ", historyTradeEffect=" + this.getHistoryTradeEffect() + ", historyTradeCtrCvr=" + this.getHistoryTradeCtrCvr() + ", clickCategory=" + this.getClickCategory() + ", weekClickCategory=" + this.getWeekClickCategory() + ", dayClickCategory=" + this.getDayClickCategory() + ", intervalClickCategory=" + this.getIntervalClickCategory() + ", periodClickCategory=" + this.getPeriodClickCategory() + ", avgLandpageStay=" + this.getAvgLandpageStay() + ", lastClickCategory=" + this.getLastClickCategory() + ", effectClickCategory=" + this.getEffectClickCategory() + ", lastClickBrand=" + this.getLastClickBrand() + ", issueEffectClickCategory=" + this.getIssueEffectClickCategory() + ", effectCategory=" + this.getEffectCategory() + ", weekEffectCategory=" + this.getWeekEffectCategory() + ", dayEffectCategory=" + this.getDayEffectCategory() + ", intervalEffectCategory=" + this.getIntervalEffectCategory() + ", periodEffectCategory=" + this.getPeriodEffectCategory() + ", lastEffectCategory=" + this.getLastEffectCategory() + ", lastEffectBrand=" + this.getLastEffectBrand() + ", addressCount=" + this.getAddressCount() + ", numberCount=" + this.getNumberCount() + ", issueEffectCategory=" + this.getIssueEffectCategory() + ", weekIssueEffectCategory=" + this.getWeekIssueEffectCategory() + ", intervalIssueEffectCategory=" + this.getIntervalIssueEffectCategory() + ", periodIssueEffectCategory=" + this.getPeriodIssueEffectCategory() + ", lastIssueEffectCategory=" + this.getLastIssueEffectCategory() + ", lastIssueEffectBrand=" + this.getLastIssueEffectBrand() + ", scoreEffectCategory=" + this.getScoreEffectCategory() + ", scoreIssueEffectCategory=" + this.getScoreIssueEffectCategory() + ", orderFee=" + this.getOrderFee() + ", weekOrderFee=" + this.getWeekOrderFee() + ", maxOrderFee=" + this.getMaxOrderFee() + ", minOrderFee=" + this.getMinOrderFee() + ", avgOrderFee=" + this.getAvgOrderFee() + ", lastOrderFee=" + this.getLastOrderFee() + ", zeroLaunch=" + this.getZeroLaunch() + ", nonZeroLaunch=" + this.getNonZeroLaunch() + ", zeroClick=" + this.getZeroClick() + ", nonZeroClick=" + this.getNonZeroClick() + ", zeroEffect=" + this.getZeroEffect() + ", nonZeroEffect=" + this.getNonZeroEffect() + ", zeroIssueEffect=" + this.getZeroIssueEffect() + ", nonZeroIssueEffect=" + this.getNonZeroIssueEffect() + ", vouchFailed=" + this.getVouchFailed() + ", weekVouchFailed=" + this.getWeekVouchFailed() + ", intervalVouchFailed=" + this.getIntervalVouchFailed() + ", reject=" + this.getReject() + ", weekReject=" + this.getWeekReject() + ", intervalReject=" + this.getIntervalReject() + ", complaint=" + this.getComplaint() + ", weekComplaint=" + this.getWeekComplaint() + ", intervalComplaint=" + this.getIntervalComplaint() + ", addressException=" + this.getAddressException() + ", weekAddressException=" + this.getWeekAddressException() + ", intervalAddressException=" + this.getIntervalAddressException() + ", numberEmpty=" + this.getNumberEmpty() + ", weekNumberEmpty=" + this.getWeekNumberEmpty() + ", intervalNumberEmpty=" + this.getIntervalNumberEmpty() + ", cheat=" + this.getCheat() + ", weekCheat=" + this.getWeekCheat() + ", intervalCheat=" + this.getIntervalCheat() + ", lastApp=" + this.getLastApp() + ", lastVideoTime=" + this.getLastVideoTime() + ", lastVideoChannel=" + this.getLastVideoChannel() + ", lastVideoInfo=" + this.getLastVideoInfo() + ", lastVideoCategory=" + this.getLastVideoCategory() + ", lastVideoArea=" + this.getLastVideoArea() + ", lastVideoYears=" + this.getLastVideoYears() + ", histEntrancesExposeTime=" + this.getHistEntrancesExposeTime() + ", weekEntrancesExposeTime=" + this.getWeekEntrancesExposeTime() + ", dayEntrancesExposeTime=" + this.getDayEntrancesExposeTime() + ", materialExposeInterval=" + this.getMaterialExposeInterval() + ", materialExposePeriod=" + this.getMaterialExposePeriod() + ", cHistEntrancesExposeTime=" + this.getCHistEntrancesExposeTime() + ", cWeekEntrancesExposeTime=" + this.getCWeekEntrancesExposeTime() + ", cDayEntrancesExposeTime=" + this.getCDayEntrancesExposeTime() + ", cMaterialExposeInterval=" + this.getCMaterialExposeInterval() + ", histEntrancesClickTime=" + this.getHistEntrancesClickTime() + ", weekEntrancesClickTime=" + this.getWeekEntrancesClickTime() + ", dayEntrancesClickTime=" + this.getDayEntrancesClickTime() + ", materialClickInterval=" + this.getMaterialClickInterval() + ", materialClickPeriod=" + this.getMaterialClickPeriod() + ", cHistEntrancesClickTime=" + this.getCHistEntrancesClickTime() + ", cWeekEntrancesClickTime=" + this.getCWeekEntrancesClickTime() + ", cDayEntrancesClickTime=" + this.getCDayEntrancesClickTime() + ", cMaterialClickInterval=" + this.getCMaterialClickInterval() + ", histMainTitlesExposeTime=" + this.getHistMainTitlesExposeTime() + ", weekMainTitlesExposeTime=" + this.getWeekMainTitlesExposeTime() + ", dayMainTitlesExposeTime=" + this.getDayMainTitlesExposeTime() + ", histSubTitlesExposeTime=" + this.getHistSubTitlesExposeTime() + ", weekSubTitlesExposeTime=" + this.getWeekSubTitlesExposeTime() + ", daySubTitlesExposeTime=" + this.getDaySubTitlesExposeTime() + ", histPrizesExposeTime=" + this.getHistPrizesExposeTime() + ", weekPrizesExposeTime=" + this.getWeekPrizesExposeTime() + ", dayPrizesExposeTime=" + this.getDayPrizesExposeTime() + ", histSkinsExposeTime=" + this.getHistSkinsExposeTime() + ", weekSkinsExposeTime=" + this.getWeekSkinsExposeTime() + ", daySkinsExposeTime=" + this.getDaySkinsExposeTime() + ", histActExposeTime=" + this.getHistActExposeTime() + ", weekActExposeTime=" + this.getWeekActExposeTime() + ", dayActExposeTime=" + this.getDayActExposeTime() + ", histMainTitlesClickTime=" + this.getHistMainTitlesClickTime() + ", weekMainTitlesClickTime=" + this.getWeekMainTitlesClickTime() + ", dayMainTitlesClickTime=" + this.getDayMainTitlesClickTime() + ", histSubTitlesClickTime=" + this.getHistSubTitlesClickTime() + ", weekSubTitlesClickTime=" + this.getWeekSubTitlesClickTime() + ", daySubTitlesClickTime=" + this.getDaySubTitlesClickTime() + ", histPrizesClickTime=" + this.getHistPrizesClickTime() + ", weekPrizesClickTime=" + this.getWeekPrizesClickTime() + ", dayPrizesClickTime=" + this.getDayPrizesClickTime() + ", histSkinsClickTime=" + this.getHistSkinsClickTime() + ", weekSkinsClickTime=" + this.getWeekSkinsClickTime() + ", daySkinsClickTime=" + this.getDaySkinsClickTime() + ", histActClickTime=" + this.getHistActClickTime() + ", weekActClickTime=" + this.getWeekActClickTime() + ", dayActClickTime=" + this.getDayActClickTime() + ", histMainTitlesOrderTime=" + this.getHistMainTitlesOrderTime() + ", weekMainTitlesOrderTime=" + this.getWeekMainTitlesOrderTime() + ", dayMainTitlesOrderTime=" + this.getDayMainTitlesOrderTime() + ", histSubTitlesOrderTime=" + this.getHistSubTitlesOrderTime() + ", weekSubTitlesOrderTime=" + this.getWeekSubTitlesOrderTime() + ", daySubTitlesOrderTime=" + this.getDaySubTitlesOrderTime() + ", histPrizesOrderTime=" + this.getHistPrizesOrderTime() + ", weekPrizesOrderTime=" + this.getWeekPrizesOrderTime() + ", dayPrizesOrderTime=" + this.getDayPrizesOrderTime() + ", histSkinsOrderTime=" + this.getHistSkinsOrderTime() + ", weekSkinsOrderTime=" + this.getWeekSkinsOrderTime() + ", daySkinsOrderTime=" + this.getDaySkinsOrderTime() + ", histActOrderTime=" + this.getHistActOrderTime() + ", weekActOrderTime=" + this.getWeekActOrderTime() + ", dayActOrderTime=" + this.getDayActOrderTime() + ", launchSequence=" + this.getLaunchSequence() + ", mainTitleSequence=" + this.getMainTitleSequence() + ", subTitleSequence=" + this.getSubTitleSequence() + ", prizeSequence=" + this.getPrizeSequence() + ", prizeCategorySequence=" + this.getPrizeCategorySequence() + ", skinSequence=" + this.getSkinSequence() + ")";
    }
}

