/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline14dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline180dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline30dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOffline7dDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceFeatureOnlineDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDeviceLabelDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpAdxResourceDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpAppPackageDiDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.TBDmpSlotDiDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceFeatureParseV2
extends BaseParse {
    private static final Logger logger = LoggerFactory.getLogger(DeviceFeatureParseV2.class);

    public static Map<String, String> parse(DmpFeatureDto dmpFeatureDto, String externalAdBlockId) {
        HashMap<String, String> retMap = new HashMap<String, String>(100);
        if (dmpFeatureDto == null) {
            return retMap;
        }
        Map<String, String> labelDtoMap = DeviceFeatureParseV2.parseTBDeviceLabelDiDto(dmpFeatureDto.getLabelDto());
        retMap.putAll(labelDtoMap);
        Map<String, String> featureOnlineDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOnlineDiDto(dmpFeatureDto.getFeatureOnlineDto());
        retMap.putAll(featureOnlineDtoMap);
        Map<String, String> featureOffline7dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline7dDiDto(dmpFeatureDto.getFeatureOffline7dDto());
        retMap.putAll(featureOffline7dDtoMap);
        Map<String, String> featureOffline14dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline14dDiDto(dmpFeatureDto.getFeatureOffline14dDto());
        retMap.putAll(featureOffline14dDtoMap);
        Map<String, String> featureOffline30dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline30dDiDto(dmpFeatureDto.getFeatureOffline30dDto());
        retMap.putAll(featureOffline30dDtoMap);
        Map<String, String> featureOffline180dDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOffline180dDiDto(dmpFeatureDto.getFeatureOffline180dDto());
        retMap.putAll(featureOffline180dDtoMap);
        Map<String, String> featureOfflineUnionDtoMap = DeviceFeatureParseV2.parseTBDeviceFeatureOfflineUniondiDto(dmpFeatureDto.getFeatureOffline30dDto(), dmpFeatureDto.getFeatureOffline180dDto());
        retMap.putAll(featureOfflineUnionDtoMap);
        Map<String, String> adxResourceDtoMap = DeviceFeatureParseV2.parseTBDmpAdxResourceDiDto(dmpFeatureDto.getAdxResourceDto(), externalAdBlockId);
        retMap.putAll(adxResourceDtoMap);
        Map<String, String> slotDtoMap = DeviceFeatureParseV2.parseTBDmpSlotDiDto(dmpFeatureDto.getSlotDto());
        retMap.putAll(slotDtoMap);
        Map<String, String> appPackageDtoMap = DeviceFeatureParseV2.parseAppPackageDto(dmpFeatureDto.getAppPackageDto());
        retMap.putAll(appPackageDtoMap);
        return retMap;
    }

    private static Map<String, String> parseTBDeviceLabelDiDto(TBDeviceLabelDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1001", data.getT1001());
        DeviceFeatureParseV2.putMap(retMap, "fd_1002", data.getT1002());
        DeviceFeatureParseV2.putMap(retMap, "fd_1003", data.getT1003());
        DeviceFeatureParseV2.putMap(retMap, "fd_1004", data.getT1004());
        DeviceFeatureParseV2.putMap(retMap, "fd_1005", data.getT1005());
        DeviceFeatureParseV2.putMap(retMap, "fd_1006", data.getT1006());
        DeviceFeatureParseV2.putMap(retMap, "fd_1007", data.getT1007());
        DeviceFeatureParseV2.putMap(retMap, "fd_1008", data.getT1008());
        DeviceFeatureParseV2.putMap(retMap, "fd_1010", data.getT1010());
        DeviceFeatureParseV2.putMap(retMap, "fd_1011", data.getT1011());
        DeviceFeatureParseV2.putMap(retMap, "fd_1012", data.getT1012());
        if (data.getT1012() == null) {
            DeviceFeatureParseV2.putMap(retMap, "fd_1013", data.getT1001());
        } else {
            DeviceFeatureParseV2.putMap(retMap, "fd_1013", data.getT1012());
        }
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOnlineDiDto(TBDeviceFeatureOnlineDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1101", data.getT1101());
        DeviceFeatureParseV2.putMap(retMap, "fd_1102", data.getT1102());
        DeviceFeatureParseV2.putMap(retMap, "fd_1103", data.getT1103());
        DeviceFeatureParseV2.putMap(retMap, "fd_1104", data.getT1104());
        DeviceFeatureParseV2.putMap(retMap, "fd_1105", data.getT1105());
        DeviceFeatureParseV2.putMap(retMap, "fd_1106", data.getT1106());
        DeviceFeatureParseV2.putMap(retMap, "fd_1107", data.getT1107());
        DeviceFeatureParseV2.putMap(retMap, "fd_1108", data.getT1108());
        DeviceFeatureParseV2.putMap(retMap, "fd_1109", data.getT1109());
        DeviceFeatureParseV2.putMap(retMap, "fd_1110", data.getT1110());
        DeviceFeatureParseV2.putMap(retMap, "fd_1111", data.getT1111());
        DeviceFeatureParseV2.putMap(retMap, "fd_1112", data.getT1112());
        DeviceFeatureParseV2.putMap(retMap, "fd_1113", data.getT1113());
        DeviceFeatureParseV2.putMap(retMap, "fd_1114", data.getT1114());
        DeviceFeatureParseV2.putMap(retMap, "fd_1115", data.getT1115());
        DeviceFeatureParseV2.putMap(retMap, "fd_1116", data.getT1116());
        DeviceFeatureParseV2.putMap(retMap, "fd_1117", DeviceFeatureParseV2.getTopN(data.getT1117(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1118", DeviceFeatureParseV2.getTopN(data.getT1118(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1120", DeviceFeatureParseV2.getTopN(data.getT1120(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1105_01", MathUtil.log2p((Long)data.getT1105()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1107_01", MathUtil.log2p((Long)data.getT1107()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1108_01", MathUtil.log2p((Long)data.getT1108()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1108_02", BaseParse.bucket((Number)data.getT1108(), (Number[])BaseParse.dayClickRankBucket));
        DeviceFeatureParseV2.putMap(retMap, "fd_1106_02", BaseParse.bucket((Number)data.getT1106(), (Number[])BaseParse.dayLaunchRankBucket));
        DeviceFeatureParseV2.putMap(retMap, "fd_1117_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1117(), 99)));
        DeviceFeatureParseV2.putMap(retMap, "fd_1118_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1118(), 99)));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline7dDiDto(TBDeviceFeatureOffline7dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1701", data.getT1701());
        DeviceFeatureParseV2.putMap(retMap, "fd_1702", data.getT1702());
        DeviceFeatureParseV2.putMap(retMap, "fd_1703", data.getT1703());
        DeviceFeatureParseV2.putMap(retMap, "fd_1704", data.getT1704());
        DeviceFeatureParseV2.putMap(retMap, "fd_1705", data.getT1705());
        DeviceFeatureParseV2.putMap(retMap, "fd_1706", data.getT1706());
        DeviceFeatureParseV2.putMap(retMap, "fd_1707", data.getT1707());
        DeviceFeatureParseV2.putMap(retMap, "fd_1708", data.getT1708());
        DeviceFeatureParseV2.putMap(retMap, "fd_1709", DeviceFeatureParseV2.getTopN(data.getT1709(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1710", DeviceFeatureParseV2.getTopN(data.getT1710(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1705_01", MathUtil.log2p((Long)data.getT1705()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1707_01", MathUtil.log2p((Long)data.getT1707()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1708_01", MathUtil.log2p((Long)data.getT1708()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1709_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1709(), 99)));
        DeviceFeatureParseV2.putMap(retMap, "fd_1710_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1710(), 99)));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline14dDiDto(TBDeviceFeatureOffline14dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1201", data.getT1201());
        DeviceFeatureParseV2.putMap(retMap, "fd_1202", data.getT1202());
        DeviceFeatureParseV2.putMap(retMap, "fd_1203", data.getT1203());
        DeviceFeatureParseV2.putMap(retMap, "fd_1204", data.getT1204());
        DeviceFeatureParseV2.putMap(retMap, "fd_1205", data.getT1205());
        DeviceFeatureParseV2.putMap(retMap, "fd_1206", data.getT1206());
        DeviceFeatureParseV2.putMap(retMap, "fd_1207", data.getT1207());
        DeviceFeatureParseV2.putMap(retMap, "fd_1208", data.getT1208());
        DeviceFeatureParseV2.putMap(retMap, "fd_1209", DeviceFeatureParseV2.getTopN(data.getT1209(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1210", DeviceFeatureParseV2.getTopN(data.getT1210(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1212", DeviceFeatureParseV2.getTopN(data.getT1212(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1213", DeviceFeatureParseV2.getTopN(data.getT1213(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1214", DeviceFeatureParseV2.getTopN(data.getT1214(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1215", DeviceFeatureParseV2.getTopN(data.getT1215(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1205_01", MathUtil.log2p((Long)data.getT1205()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1207_01", MathUtil.log2p((Long)data.getT1207()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1208_01", MathUtil.log2p((Long)data.getT1208()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1209_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1209(), 99)));
        DeviceFeatureParseV2.putMap(retMap, "fd_1210_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1210(), 99)));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline30dDiDto(TBDeviceFeatureOffline30dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1801", data.getT1801());
        DeviceFeatureParseV2.putMap(retMap, "fd_1802", data.getT1802());
        DeviceFeatureParseV2.putMap(retMap, "fd_1803", data.getT1803());
        DeviceFeatureParseV2.putMap(retMap, "fd_1804", data.getT1804());
        DeviceFeatureParseV2.putMap(retMap, "fd_1805", data.getT1805());
        DeviceFeatureParseV2.putMap(retMap, "fd_1806", data.getT1806());
        DeviceFeatureParseV2.putMap(retMap, "fd_1807", data.getT1807());
        DeviceFeatureParseV2.putMap(retMap, "fd_1808", data.getT1808());
        DeviceFeatureParseV2.putMap(retMap, "fd_1809", DeviceFeatureParseV2.getTopN(data.getT1809(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1810", DeviceFeatureParseV2.getTopN(data.getT1810(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1805_01", MathUtil.log2p((Long)data.getT1805()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1807_01", MathUtil.log2p((Long)data.getT1807()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1808_01", MathUtil.log2p((Long)data.getT1808()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1809_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1809(), 99)));
        DeviceFeatureParseV2.putMap(retMap, "fd_1810_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1810(), 99)));
        return retMap;
    }

    private static Map<String, String> parseTBDeviceFeatureOffline180dDiDto(TBDeviceFeatureOffline180dDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1301", data.getT1301());
        DeviceFeatureParseV2.putMap(retMap, "fd_1302", data.getT1302());
        DeviceFeatureParseV2.putMap(retMap, "fd_1303", data.getT1303());
        DeviceFeatureParseV2.putMap(retMap, "fd_1304", data.getT1304());
        DeviceFeatureParseV2.putMap(retMap, "fd_1305", data.getT1305());
        DeviceFeatureParseV2.putMap(retMap, "fd_1306", data.getT1306());
        DeviceFeatureParseV2.putMap(retMap, "fd_1307", data.getT1307());
        DeviceFeatureParseV2.putMap(retMap, "fd_1308", data.getT1308());
        DeviceFeatureParseV2.putMap(retMap, "fd_1309", DeviceFeatureParseV2.getTopN(data.getT1309(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1310", DeviceFeatureParseV2.getTopN(data.getT1310(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1305_01", MathUtil.log2p((Long)data.getT1305()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1307_01", MathUtil.log2p((Long)data.getT1307()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1308_01", MathUtil.log2p((Long)data.getT1308()));
        DeviceFeatureParseV2.putMap(retMap, "fd_1308_02", BaseParse.bucket((Number)data.getT1308(), (Number[])BaseParse.clickRankBucket));
        DeviceFeatureParseV2.putMap(retMap, "fd_1310_02", BaseParse.bucket((Number)DeviceFeatureParseV2.getTopSum(data.getT1310(), 30), (Number[])BaseParse.effectRankBucket));
        DeviceFeatureParseV2.putMap(retMap, "fd_1309_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1309(), 99)));
        DeviceFeatureParseV2.putMap(retMap, "fd_1310_01", MathUtil.log2p((Long)DeviceFeatureParseV2.getTopSum(data.getT1310(), 99)));
        return retMap;
    }

    public static Map<String, String> parseTBDeviceFeatureOfflineUniondiDto(TBDeviceFeatureOffline30dDiDto data30di, TBDeviceFeatureOffline180dDiDto data180di) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data30di == null && data180di == null) {
            return retMap;
        }
        ArrayList<String> tradeConvertList = new ArrayList<String>();
        List<Object> tradeconvert1List30di = new ArrayList();
        List<Object> tradeconvert2List30di = new ArrayList();
        List<Object> tradeconvert1List180di = new ArrayList();
        List<Object> tradeconvert2List180di = new ArrayList();
        if (data30di != null) {
            tradeconvert1List30di = DeviceFeatureParseV2.getTopNV2(data30di.getT1809(), 5, "30_1_");
            tradeconvert2List30di = DeviceFeatureParseV2.getTopNV2(data30di.getT1810(), 5, "30_2_");
        }
        if (data180di != null) {
            tradeconvert1List180di = DeviceFeatureParseV2.getTopNV2(data180di.getT1309(), 5, "180_1_");
            tradeconvert2List180di = DeviceFeatureParseV2.getTopNV2(data180di.getT1310(), 5, "180_2_");
        }
        tradeConvertList.addAll(tradeconvert1List30di);
        tradeConvertList.addAll(tradeconvert2List30di);
        tradeConvertList.addAll(tradeconvert1List180di);
        tradeConvertList.addAll(tradeconvert2List180di);
        DeviceFeatureParseV2.putMap(retMap, "fd_1318", tradeConvertList);
        return retMap;
    }

    private static Map<String, String> parseTBDmpAdxResourceDiDto(TBDmpAdxResourceDiDto data, String externalAdBlockId) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null || externalAdBlockId == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1401_02", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1401(), data.getT1402(), 100, 0.05, externalAdBlockId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1402_03", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1402(), data.getT1403(), 100, 0.05, externalAdBlockId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1402_04", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1402(), data.getT1404(), 1000, 0.0015, externalAdBlockId));
        return retMap;
    }

    private static Map<String, String> parseTBDmpSlotDiDto(TBDmpSlotDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1501", DeviceFeatureParseV2.getTopN(data.getT1501(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1502", DeviceFeatureParseV2.getTopN(data.getT1502(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1503", DeviceFeatureParseV2.getTopN(data.getT1503(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1504", DeviceFeatureParseV2.getTopN(data.getT1504(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1505", DeviceFeatureParseV2.getTopN(data.getT1505(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506", DeviceFeatureParseV2.getTopN(data.getT1506(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1507", DeviceFeatureParseV2.getTopN(data.getT1507(), 1));
        DeviceFeatureParseV2.putMap(retMap, "fd_1508", DeviceFeatureParseV2.getTopN(data.getT1508(), 1));
        return retMap;
    }

    public static Map<String, String> parseTBDmpSlotDiDto(TBDmpSlotDiDto data, String advertId, String tradeId) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1501", DeviceFeatureParseV2.getTopN(data.getT1501(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1502", DeviceFeatureParseV2.getTopN(data.getT1502(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1503", DeviceFeatureParseV2.getTopN(data.getT1503(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1504", DeviceFeatureParseV2.getTopN(data.getT1504(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1505", DeviceFeatureParseV2.getTopN(data.getT1505(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506", DeviceFeatureParseV2.getTopN(data.getT1506(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1507", DeviceFeatureParseV2.getTopN(data.getT1507(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1508", DeviceFeatureParseV2.getTopN(data.getT1508(), 5));
        DeviceFeatureParseV2.putMap(retMap, "fd_1501_02", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1501(), data.getT1502(), 100, 0.5, advertId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1502_03", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1502(), data.getT1503(), 100, 0.03, advertId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1502_04", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1502(), data.getT1504(), 100, 0.03, advertId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1505_06", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1505(), data.getT1506(), 100, 0.5, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506_07", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1506(), data.getT1507(), 100, 0.03, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1506_08", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1506(), data.getT1508(), 100, 0.03, tradeId));
        return retMap;
    }

    private static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        return retMap;
    }

    public static Map<String, String> parseAppPackageDto(TBDmpAppPackageDiDto data, String tradeId) {
        HashMap<String, String> retMap = new HashMap<String, String>(10);
        if (data == null) {
            return retMap;
        }
        DeviceFeatureParseV2.putMap(retMap, "fd_1601_02", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1601(), data.getT1602(), 100, 0.5, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1602_03", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1602(), data.getT1603(), 100, 0.1, tradeId));
        DeviceFeatureParseV2.putMap(retMap, "fd_1602_04", DeviceFeatureParseV2.getMapRatioWithKey(data.getT1602(), data.getT1604(), 100, 0.01, tradeId));
        return retMap;
    }

    public static <T> void putMap(Map<String, String> map, String key, T value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Set<String> value) {
        if (value != null) {
            ArrayList<String> list2 = new ArrayList<String>();
            list2.addAll(value);
            map.put(key, String.join((CharSequence)",", list2));
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, Map<String, T> value) {
        if (value != null) {
            ArrayList<String> list2 = new ArrayList<String>();
            list2.addAll(value.keySet());
            map.put(key, String.join((CharSequence)",", list2));
        }
    }

    public static <T> void putMap(Map<String, String> map, String key, List<String> value) {
        if (value != null) {
            map.put(key, String.join((CharSequence)",", value));
        }
    }

    public static Map<String, Double> getMapRatio(Map<String, Long> map1, Map<String, Long> map2, int threshold, double biasRatio) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{map1, map2})) {
            return retMap;
        }
        for (Map.Entry<String, Long> entry : map1.entrySet()) {
            String key = entry.getKey();
            Long value1 = entry.getValue();
            Long value2 = map2.getOrDefault(key, 0L);
            Double ret = 0.0;
            if (value1 == null) {
                retMap.put(key, ret);
                continue;
            }
            ret = ((double)value2.longValue() + (double)threshold * biasRatio) / (double)(value1 + (long)threshold);
            ret = MathUtil.formatDouble((double)ret, (int)7);
            retMap.put(key, ret);
        }
        return retMap;
    }

    public static Double getMapRatioWithKey(Map<String, Long> map1, Map<String, Long> map2, int threshold, double biasRatio, String key) {
        Double ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{map1, map2})) {
            return ret;
        }
        Long value1 = map1.get(key);
        Long value2 = map2.getOrDefault(key, 0L);
        if (value1 != null && value1 > 50L) {
            ret = ((double)value2.longValue() + (double)threshold * biasRatio) / (double)(value1 + (long)threshold);
            ret = MathUtil.formatDouble((double)ret, (int)7);
        } else {
            ret = 0.0;
        }
        return ret;
    }

    public static List<String> getTopN(Map<String, Long> map, int n) {
        ArrayList<String> ret = new ArrayList<String>();
        if (AssertUtil.isEmpty(map)) {
            return ret;
        }
        ArrayList<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                }
                return 0;
            }
        });
        for (int i = 0; i < Math.min(list.size(), n); ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ret.add((String)e.getKey());
        }
        return ret;
    }

    public static Long getTopSum(Map<String, Long> map, int n) {
        Long ret = 0L;
        if (AssertUtil.isEmpty(map)) {
            return ret;
        }
        ArrayList<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                }
                return 0;
            }
        });
        for (int i = 0; i < Math.min(list.size(), n); ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ret = ret + (Long)e.getValue();
        }
        return ret;
    }

    public static List<String> getTopNV2(Map<String, Long> mp, int n, String tag) {
        ArrayList<String> ret = new ArrayList<String>();
        if (AssertUtil.isEmpty(mp)) {
            return ret;
        }
        ArrayList<Map.Entry<String, Long>> list1 = new ArrayList<Map.Entry<String, Long>>(mp.entrySet());
        Collections.sort(list1, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o1.getValue() != o2.getValue()) {
                    if (o1.getValue() == null) {
                        return 1;
                    }
                    if (o2.getValue() == null) {
                        return -1;
                    }
                    return o2.getValue().intValue() - o1.getValue().intValue();
                }
                return 0;
            }
        });
        for (int i = 0; i < Math.min(list1.size(), n); ++i) {
            Map.Entry e = (Map.Entry)list1.get(i);
            Integer rank = i + 1;
            String st = tag + (String)e.getKey() + "_" + rank.toString();
            ret.add(st);
        }
        return ret;
    }
}

