/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtaFeatureParse {
    public static final int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(RtaFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(RtaFeatureDo cf, DmpFeature dcf) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        try {
            if (cf != null) {
                String currentTimeMillis = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                Integer hour = LocalDateUtil.getHour((String)currentTimeMillis, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer weekDay = LocalDateUtil.getDayOfWeek((String)currentTimeMillis, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer isWeekend = weekDay >= 1 && weekDay <= 5 ? 0 : 1;
                retMap.put("f0001", DataUtil.Integer2String((Integer)hour));
                retMap.put("f0002", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f0003", DataUtil.Integer2String((Integer)isWeekend));
                retMap.put("f0004", DataUtil.featureFormat((String)cf.getExtIdeaId(), (String)cf.getExtIdeaIdOffline()));
                retMap.put("f0005", DataUtil.featureFormat((String)cf.getExtAdPlace(), (String)cf.getExtAdPlaceOffline()));
                retMap.put("f0006", DataUtil.featureFormat((String)cf.getExtAdvertGroupId(), (String)cf.getExtAdvertGroupIdOffline()));
                retMap.put("f0007", DataUtil.featureFormat((String)cf.getExtAdvertId(), (String)cf.getExtAdvertIdOffline()));
                retMap.put("f0008", DataUtil.featureFormat((String)cf.getExtAccountId(), (String)cf.getExtAccountIdOffline()));
                retMap.put("f0009", DataUtil.featureFormat((String)cf.getExtUnionSlotId(), (String)cf.getExtUnionSlotIdOffline()));
                retMap.put("f0010", DataUtil.featureFormat((String)cf.getExtPlatform(), (String)cf.getExtPlatformOffline()));
                retMap.put("f0104", cf.getIsp());
                retMap.put("f0105", cf.getCityIdPv180d());
                retMap.put("f0106", cf.getLastestCityId());
                retMap.put("f0107", cf.getLastestCityLevel());
                retMap.put("f0108", cf.getStayCityId());
                retMap.put("f0109", cf.getStayCityLevel());
                retMap.put("f0110", cf.getStayWorkRegionId());
                retMap.put("f0111", cf.getStayLiveRegionId());
                retMap.put("f0112", cf.getHomeCityId());
                retMap.put("f0113", cf.getHomeCityLevel());
                retMap.put("f0201", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv())));
                retMap.put("f0202", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv())));
                retMap.put("f0203", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv())));
                retMap.put("f0204", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv())));
                retMap.put("f0301", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserReqPv1d())));
                retMap.put("f0302", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv1d())));
                retMap.put("f0303", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv1d())));
                retMap.put("f0304", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv1d())));
                retMap.put("f0305", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv1d())));
                retMap.put("f0306", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserReqPv7d())));
                retMap.put("f0307", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv7d())));
                retMap.put("f0308", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv7d())));
                retMap.put("f0309", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv7d())));
                retMap.put("f0310", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv7d())));
                retMap.put("f0311", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserReqPv14d())));
                retMap.put("f0312", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv14d())));
                retMap.put("f0313", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv14d())));
                retMap.put("f0314", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv14d())));
                retMap.put("f0315", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv14d())));
                retMap.put("f0316", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserCvtPv1d())));
                retMap.put("f0317", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserConsume1d())));
                retMap.put("f0318", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserCvtPv7d())));
                retMap.put("f0319", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserConsume7d())));
                retMap.put("f0320", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserCvtPv14d())));
                retMap.put("f0321", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv14d())));
                retMap.put("f03001", DataUtil.Long2String((Long)cf.getUserReqPv1d()));
                retMap.put("f03002", DataUtil.Long2String((Long)cf.getUserExpPv1d()));
                retMap.put("f03003", DataUtil.Long2String((Long)cf.getUserActReqPv1d()));
                retMap.put("f03004", DataUtil.Long2String((Long)cf.getUserAdvLaunchPv1d()));
                retMap.put("f03005", DataUtil.Long2String((Long)cf.getUserAdvClkPv1d()));
                retMap.put("f03006", DataUtil.Long2String((Long)cf.getUserReqPv7d()));
                retMap.put("f03007", DataUtil.Long2String((Long)cf.getUserExpPv7d()));
                retMap.put("f03008", DataUtil.Long2String((Long)cf.getUserActReqPv7d()));
                retMap.put("f03009", DataUtil.Long2String((Long)cf.getUserAdvLaunchPv7d()));
                retMap.put("f03010", DataUtil.Long2String((Long)cf.getUserAdvClkPv7d()));
                retMap.put("f03011", DataUtil.Long2String((Long)cf.getUserReqPv14d()));
                retMap.put("f03012", DataUtil.Long2String((Long)cf.getUserExpPv14d()));
                retMap.put("f03013", DataUtil.Long2String((Long)cf.getUserActReqPv14d()));
                retMap.put("f03014", DataUtil.Long2String((Long)cf.getUserAdvLaunchPv14d()));
                retMap.put("f03015", DataUtil.Long2String((Long)cf.getUserAdvClkPv14d()));
                retMap.put("f03016", DataUtil.Long2String((Long)cf.getUserCvtPv1d()));
                retMap.put("f03017", DataUtil.Long2String((Long)cf.getUserConsume1d()));
                retMap.put("f03018", DataUtil.Long2String((Long)cf.getUserCvtPv7d()));
                retMap.put("f03019", DataUtil.Long2String((Long)cf.getUserConsume7d()));
                retMap.put("f03020", DataUtil.Long2String((Long)cf.getUserCvtPv14d()));
                retMap.put("f03021", DataUtil.Long2String((Long)cf.getUserAdvClkPv14d()));
                retMap.put("f0401", DataUtil.listToString(cf.getUser_exp_list()));
                retMap.put("f0402", DataUtil.listToString(cf.getUser_clk_list()));
                retMap.put("f0403", DataUtil.listToString(cf.getUser_act_req_list()));
                retMap.put("f0404", DataUtil.listToString(cf.getUser_act_join_list()));
                retMap.put("f0405", DataUtil.listToString(cf.getUser_adv_launch_list()));
                retMap.put("f0406", DataUtil.listToString(cf.getUser_adv_clk_list()));
                retMap.put("f0407", DataUtil.listToString(cf.getUser_adv_launch_trade_list()));
                retMap.put("f0408", DataUtil.listToString(cf.getUser_adv_clk_trade_list()));
            }
            if (dcf != null) {
                retMap.put("f0322", DataUtil.Long2String((Long)MathUtil.log1p((Long)dcf.getUserReqPv180d())));
                retMap.put("f0323", DataUtil.Long2String((Long)MathUtil.log1p((Long)dcf.getUserExpPv180d())));
                retMap.put("f0324", DataUtil.Long2String((Long)MathUtil.log1p((Long)dcf.getUserActReqPv180d())));
                retMap.put("f0325", DataUtil.Long2String((Long)MathUtil.log1p((Long)dcf.getUserAdvLaunchPv180d())));
                retMap.put("f0326", DataUtil.Long2String((Long)MathUtil.log1p((Long)dcf.getUserAdvClkPv180d())));
                retMap.put("f0327", DataUtil.Long2String((Long)MathUtil.log1p((Long)dcf.getUserCvtPv180d())));
                retMap.put("f0413", DataUtil.SetToString(dcf.getUserBackGroupidCurList()));
                retMap.put("f0414", DataUtil.SetToString(dcf.getUserBackResidCurList()));
                retMap.put("f0415", DataUtil.SetToString(dcf.getUserBackExtAppidCurList()));
                retMap.put("f0416", DataUtil.SetToString(dcf.getUserBackExtSlotidCurList()));
                retMap.put("f0417", DataUtil.SetToString(dcf.getUserExpGroupidCurList()));
                retMap.put("f0418", DataUtil.SetToString(dcf.getUserExpResidCurList()));
                retMap.put("f0419", DataUtil.SetToString(dcf.getUserExpExtAppidCurList()));
                retMap.put("f0420", DataUtil.SetToString(dcf.getUserExpExtSlotidCurList()));
                retMap.put("f0421", DataUtil.SetToString(dcf.getUserActReqGroupidCurList()));
                retMap.put("f0422", DataUtil.SetToString(dcf.getUserActReqResidCurList()));
                retMap.put("f0423", DataUtil.SetToString(dcf.getUserActReqExtAppidCurList()));
                retMap.put("f0424", DataUtil.SetToString(dcf.getUserActReqExtSlotidCurList()));
                retMap.put("f0425", DataUtil.SetToString(dcf.getUserActJoinGroupidCurList()));
                retMap.put("f0426", DataUtil.SetToString(dcf.getUserActJoinResidCurList()));
                retMap.put("f0427", DataUtil.SetToString(dcf.getUserActJoinExtAppidCurList()));
                retMap.put("f0428", DataUtil.SetToString(dcf.getUserActJoinExtSlotidCurList()));
                retMap.put("f0429", DataUtil.SetToString(dcf.getUserCoupClickGroupidCurList()));
                retMap.put("f0430", DataUtil.SetToString(dcf.getUserCoupClickResidCurList()));
                retMap.put("f0431", DataUtil.SetToString(dcf.getUserCoupClickExtAppidCurList()));
                retMap.put("f0432", DataUtil.SetToString(dcf.getUserCoupClickExtSlotidCurList()));
                retMap.put("f0433", DataUtil.SetToString(dcf.getUserConvGroupidCurList()));
                retMap.put("f0434", DataUtil.SetToString(dcf.getUserConvResidCurList()));
                retMap.put("f0435", DataUtil.SetToString(dcf.getUserConvExtAppidCurList()));
                retMap.put("f0436", DataUtil.SetToString(dcf.getUserConvExtSlotidCurList()));
                retMap.put("f0437", DataUtil.SetToString(dcf.getUserReqGroupid1dList()));
                retMap.put("f0438", DataUtil.SetToString(dcf.getUserReqResid1dList()));
                retMap.put("f0439", DataUtil.SetToString(dcf.getUserReqExtAppid1dList()));
                retMap.put("f0440", DataUtil.SetToString(dcf.getUserReqExtSlotid1dList()));
                retMap.put("f0441", DataUtil.SetToString(dcf.getUserBackGroupid1dList()));
                retMap.put("f0442", DataUtil.SetToString(dcf.getUserBackResid1dList()));
                retMap.put("f0443", DataUtil.SetToString(dcf.getUserBackExtAppid1dList()));
                retMap.put("f0444", DataUtil.SetToString(dcf.getUserBackExtSlotid1dList()));
                retMap.put("f0445", DataUtil.SetToString(dcf.getUserExpGroupid1dList()));
                retMap.put("f0446", DataUtil.SetToString(dcf.getUserExpResid1dList()));
                retMap.put("f0447", DataUtil.SetToString(dcf.getUserExpExtAppid1dList()));
                retMap.put("f0448", DataUtil.SetToString(dcf.getUserExpExtSlotid1dList()));
                retMap.put("f0449", DataUtil.SetToString(dcf.getUserActReqGroupid1dList()));
                retMap.put("f0450", DataUtil.SetToString(dcf.getUserActReqResid1dList()));
                retMap.put("f0451", DataUtil.SetToString(dcf.getUserActReqExtAppid1dList()));
                retMap.put("f0452", DataUtil.SetToString(dcf.getUserActReqExtSlotid1dList()));
                retMap.put("f0453", DataUtil.SetToString(dcf.getUserActJoinGroupid1dList()));
                retMap.put("f0454", DataUtil.SetToString(dcf.getUserActJoinResid1dList()));
                retMap.put("f0455", DataUtil.SetToString(dcf.getUserActJoinExtAppid1dList()));
                retMap.put("f0456", DataUtil.SetToString(dcf.getUserActJoinExtSlotid1dList()));
                retMap.put("f0457", DataUtil.SetToString(dcf.getUserCoupClickGroupid1dList()));
                retMap.put("f0458", DataUtil.SetToString(dcf.getUserCoupClickResid1dList()));
                retMap.put("f0459", DataUtil.SetToString(dcf.getUserCoupClickExtAppid1dList()));
                retMap.put("f0460", DataUtil.SetToString(dcf.getUserCoupClickExtSlotid1dList()));
                retMap.put("f0461", DataUtil.SetToString(dcf.getUserConvGroupid1dList()));
                retMap.put("f0462", DataUtil.SetToString(dcf.getUserConvResid1dList()));
                retMap.put("f0463", DataUtil.SetToString(dcf.getUserConvExtAppid1dList()));
                retMap.put("f0464", DataUtil.SetToString(dcf.getUserConvExtSlotid1dList()));
                retMap.put("f0465", DataUtil.SetToString(dcf.getUserReqGroupid7dList()));
                retMap.put("f0466", DataUtil.SetToString(dcf.getUserReqResid7dList()));
                retMap.put("f0467", DataUtil.SetToString(dcf.getUserReqExtAppid7dList()));
                retMap.put("f0468", DataUtil.SetToString(dcf.getUserReqExtSlotid7dList()));
                retMap.put("f0469", DataUtil.SetToString(dcf.getUserBackGroupid7dList()));
                retMap.put("f0470", DataUtil.SetToString(dcf.getUserBackResid7dList()));
                retMap.put("f0471", DataUtil.SetToString(dcf.getUserBackExtAppid7dList()));
                retMap.put("f0472", DataUtil.SetToString(dcf.getUserBackExtSlotid7dList()));
                retMap.put("f0473", DataUtil.SetToString(dcf.getUserExpGroupid7dList()));
                retMap.put("f0474", DataUtil.SetToString(dcf.getUserExpResid7dList()));
                retMap.put("f0475", DataUtil.SetToString(dcf.getUserExpExtAppid7dList()));
                retMap.put("f0476", DataUtil.SetToString(dcf.getUserExpExtSlotid7dList()));
                retMap.put("f0477", DataUtil.SetToString(dcf.getUserActReqGroupid7dList()));
                retMap.put("f0478", DataUtil.SetToString(dcf.getUserActReqResid7dList()));
                retMap.put("f0479", DataUtil.SetToString(dcf.getUserActReqExtAppid7dList()));
                retMap.put("f0480", DataUtil.SetToString(dcf.getUserActReqExtSlotid7dList()));
                retMap.put("f0481", DataUtil.SetToString(dcf.getUserActJoinGroupid7dList()));
                retMap.put("f0482", DataUtil.SetToString(dcf.getUserActJoinResid7dList()));
                retMap.put("f0483", DataUtil.SetToString(dcf.getUserActJoinExtAppid7dList()));
                retMap.put("f0484", DataUtil.SetToString(dcf.getUserActJoinExtSlotid7dList()));
                retMap.put("f0485", DataUtil.SetToString(dcf.getUserCoupClickGroupid7dList()));
                retMap.put("f0486", DataUtil.SetToString(dcf.getUserCoupClickResid7dList()));
                retMap.put("f0487", DataUtil.SetToString(dcf.getUserCoupClickExtAppid7dList()));
                retMap.put("f0488", DataUtil.SetToString(dcf.getUserCoupClickExtSlotid7dList()));
                retMap.put("f0489", DataUtil.SetToString(dcf.getUserConvGroupid7dList()));
                retMap.put("f0490", DataUtil.SetToString(dcf.getUserConvResid7dList()));
                retMap.put("f0491", DataUtil.SetToString(dcf.getUserConvExtAppid7dList()));
                retMap.put("f0492", DataUtil.SetToString(dcf.getUserConvExtSlotid7dList()));
            }
        }
        catch (Exception e) {
            logger.error("RtaFeatureParse.generateFeatureMapStatic error:", (Throwable)e);
        }
        return retMap;
    }
}

