package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.*;

/**
 * Created by pc on 2019/2/21.
 */
public class ActivityFeatureParse extends BaseParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(ActivityFeatureParse.class);


    public static Map<String, String> generateFeatureMapStatic(ActContextFeatureDoV3 contextFeatureDoV2,
                                                               UserFeatureDoV2 userFeatureDoV2

    ) {

        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);

        Map<String, String> contextFeature = parseContextFeature(contextFeatureDoV2);
        retMap.putAll(contextFeature);


        Map<String, String> userFeature = parseUserFeature(userFeatureDoV2);
        retMap.putAll(userFeature);

        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActFeatureDoV3 data, UserFeatureDoV2 data2, ActContextFeatureDoV3 data3) {

        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);

        retMap = parseActFeature(data, data2, data3);
        return retMap;
    }


    /**
     * 活动信息
     *
     * @param data
     * @return
     */
    public static Map<String, String> parseActFeature(ActFeatureDoV3 data, UserFeatureDoV2 data2, ActContextFeatureDoV3 data3) {

        Map<String, String> retMap = new HashMap<>(16);

        putMapNotNull(retMap, "ft300301", data.getActivityId());//活动id（当前活动）


        if (data.getActivityPage() != null) {
            putMapNotNull(retMap, "ft300304", data.getActivityPage());//自定义活动ID（主活动ID）
        }

        putMapNotNull(retMap, "ft300305", data.getActivitySkinType());// 活动皮肤ID/Name（玩法，大转盘/翻牌子/扭蛋机等）
        putMapNotNull(retMap, "ft300309", data.getActivitySkinType2());//活动玩法/：刮卡/大转盘/翻牌子/扭蛋机等）

        //todo 待新增

        putMapNotNull(retMap, "ft300311", data.getActTradeTag());  //1、适用场景标签，休闲游戏-经营养成、休闲游戏-答题解密；格式：1,3

        putMapNotNull(retMap, "ft300312", data.getActCrowdTag()); //2、人群标签；女性、男性等；格式：1,3

        putMapNotNull(retMap, "ft300313", data.getActInteresteTag()); //3、权益标签；红包、话费、手机等；格式：1,3  映射：939-红包，941-话费，942-手机

        putMapNotNull(retMap, "ft300314", data.getActStyleTag()); //4、设计风格标签；扁平、电商、卡通等；格式：1,3

        putMapNotNull(retMap, "ft300315", data.getActSeasonTag()); //5、季节标签；春、夏、秋、冬；格式：1,3

        putMapNotNull(retMap, "ft300316", data.getActFestivalTag());//6、节日标签；双十一、双十二、春节等；格式：1,3

        putMapNotNull(retMap, "ft300317", ActFeatureDoV3.interestTagValid(data.getActInteresteTag(), data3.getExtMaterialTitle()));//7、活动利益点与外部素材广告语利益点是否一致


        /**
         * 用户行为与活动交叉特征
         */
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data2.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        List<String> userActReqList = userBehaviorSubFeature.getUserActReqList();

        if (AssertUtil.isAllNotEmpty(data.getActivityId(), userActReqList)) {
            String hisLastActivity = userActReqList.get(userActReqList.size() - 1);
            if (hisLastActivity != null) {
                Long hisLastActivityLong = Long.valueOf(hisLastActivity);
                if (data.getActivityId().equals(hisLastActivityLong)) {
                    retMap.put("ft110910", "1");//上一次活动访问，与当前活动是否相同、
                }
            }

        }
        return retMap;
    }


    /**
     * 上下文信息
     *
     * @param data
     * @return
     */
    public static Map<String, String> parseContextFeature(ActContextFeatureDoV3 data) {
        Map<String, String> retMap = new HashMap<>(64);
        if (data != null) {
            retMap=data.parse();
        }
        return retMap;
    }


    /**
     * 用户信息
     *
     * @param data
     * @return
     */
    public static Map<String, String> parseUserFeature(UserFeatureDoV2 data) {

        Map<String, String> retMap = new HashMap<>(64);


        UserProfileSubFeature userProfileFeature = Optional.ofNullable(data.getUserProfileSubFeature()).orElse(new UserProfileSubFeature());
        /**
         * 一、基础属性
         */
        putMapNotNull(retMap, "ft100001", data.getOneId());//
        putMapNotNull(retMap, "ft100103", userProfileFeature.getMarital());//婚育情况
        putMapNotNull(retMap, "ft100106", userProfileFeature.getAge());//dmp年龄
        putMapNotNull(retMap, "ft100107", userProfileFeature.getGender());//dmp性别

        /**
         * 二、百度兴趣标签
         */
        putMapNotNull(retMap, "ft100501", userProfileFeature.getBdFirstTag());// 百度兴趣标签 1级
        putMapNotNull(retMap, "ft100502", userProfileFeature.getBdSecondTag());// 百度兴趣标签 2级
        putMapNotNull(retMap, "ft1005031", userProfileFeature.getBdThirdTag());// 百度兴趣标签 3级
        putMapNotNull(retMap, "ft100504", userProfileFeature.getBdFourthTag());// 百度兴趣标签 4级


        /**
         * 三、安装信息
         */
        // app 分箱
//        putMapNotNull(retMap, "ft100601", DataConverter.map2Bucket2Str(userProfileFeature.getAppInstallFirstTag(), cntBucket));// app安装一级分类
//        putMapNotNull(retMap, "ft100602", DataConverter.map2Bucket2Str(userProfileFeature.getAppInstallSecondTag(), cntBucket));// app安装二级分类

        putMapNotNull(retMap, "ft100603", userProfileFeature.getAppInstall());// app安装

        /**
         * 四、用户历史行为
         */

        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());

//        putMapNotNull(retMap, "ft110000", DataConverter.bucket(userBehaviorSubFeature.getUserActiveDays(), cntBucket));// 历史最早发券距今天数


        // 实时用户统计特征
        retMap.put("f0201", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserExpPv())));       // 用户当天入口曝光次数
        retMap.put("f0202", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserActReqPv())));    // 用户当天活动访问次数
        retMap.put("f0203", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvLaunchPv()))); // 用户当天发券次数
        retMap.put("f0204", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvClkPv())));    // 用户当天券计费点击次数
        //todo
        retMap.put("f0205", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserCvtPv())));    // 用户当天券目标转化次数

        // todo
        // 用户当日序列特征(截断到20个）
        retMap.put("f0413", DataUtil.listToString(userBehaviorSubFeature.getUserActReqList()));          // 用户当天活动id访问列表
        retMap.put("f0417", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList())); // 用户当天券行业id曝光列表
        retMap.put("f0418", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList()));    // 用户当天券行业id计费点击列表


        // 用户历史统计特征
        retMap.put("f0301", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserReqPv1d())));        // 用户历史1天请求次数
        retMap.put("f0302", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserExpPv1d())));        // 用户历史1天入口曝光次数
        retMap.put("f0303", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserActReqPv1d())));     // 用户历史1天活动访问次数
        retMap.put("f0304", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvLaunchPv1d())));  // 用户历史1天发券次数
        retMap.put("f0305", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvClkPv1d())));     // 用户历史1天券计费点击次数
        retMap.put("f0316", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserCvtPv1d())));        // 用户历史1天目标转化次数

        retMap.put("f0311", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserReqPv14d())));       // 用户历史14天请求次数
        retMap.put("f0312", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserExpPv14d())));       // 用户历史14天入口曝光次数
        retMap.put("f0313", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserActReqPv14d())));    // 用户历史14天活动访问次数
        retMap.put("f0314", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvLaunchPv14d()))); // 用户历史14天发券次数
        retMap.put("f0315", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvClkPv14d())));    // 用户历史14天券计费点击次数
        retMap.put("f0320", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserCvtPv14d())));       // 用户历史14天目标转化次数

        retMap.put("f0341", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserReqPv180d())));       // 用户历史180天请求次数
        retMap.put("f0342", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserExpPv180d())));       // 用户历史180天入口曝光次数
        retMap.put("f0343", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserActReqPv180d())));    // 用户历史180天活动访问次数
        retMap.put("f0344", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvLaunchPv180d()))); // 用户历史180天发券次数
        retMap.put("f0345", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserAdvClkPv180d())));    // 用户历史180天券计费点击次数
        retMap.put("f0350", DataUtil.Long2String(MathUtil.log1p(userBehaviorSubFeature.getUserCvtPv180d())));       // 用户历史180天目标转化次数

        // 用户历史序列特征(截断到20个）
        retMap.put("f0403", DataUtil.listToString(userBehaviorSubFeature.getUserActReqList14d()));          // 用户历史活动id访问列表
        retMap.put("f0407", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList14d())); // 用户历史券行业id曝光列表
        retMap.put("f0408", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList14d()));    // 用户历史券行业id计费点击列表


        return retMap;
    }


    public static void main(String[] args) {
        List<String> reqList = new ArrayList<>();
        reqList.add("100");
        reqList.add("101");

        Long activityId = 101L;
        String hisLastActivity = reqList.get(reqList.size() - 1);

        Long hisLastActivityLong = Long.valueOf(hisLastActivity);

        System.out.println("hisLastActivit=" + hisLastActivity);
        System.out.println("hisLastActivityLong=" + hisLastActivityLong);

        System.out.println("hisLastActivit=" + activityId.equals(hisLastActivity));
        System.out.println("hisLastActivityLong=" + activityId.equals(hisLastActivityLong));
    }
}


