package cn.com.duiba.nezha.alg.feature.parse.v2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.parse.RtaFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdxContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdxFeatureDoV3;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by pc on 2019/2/21.
 */
public class AdxFeatureParseV2 extends BaseParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(AdxFeatureParseV2.class);


    public static Map<String, String> generateFeatureMapStatic(AdContextFeatureDoV3 contextDo, DmpFeatureDto dmpFeatureDto
    ) {

        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);

        if (contextDo == null) {
            return retMap;
        }
        Map<String, String> deviceFeatureMap = DeviceFeatureParseV2.parse(dmpFeatureDto, contextDo.getExternalAdBlockId());
        retMap.putAll(deviceFeatureMap);

        return retMap;
    }

}


