package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

@Data
public class CvrStatDo {
    /**
     * 计费点击PV（过去3天）
     */
    private Long click3Day;

    /**
     * 后端类型转化PV Map（过去3天）
     */
    private Map<String, Long> convertMap3Day;

    /**
     * 计费点击PV（昨天+当天）
     */
    private Long click1Day;

    /**
     * 后端类型转化PV Map（昨天+当天）
     */
    private Map<String, Long> convertMap1Day;

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CvrStatDo.class);

    private static Double calWilsonScore(Long baseCnt, Long targetCnt, double faithLevel) {
        if (baseCnt == null || targetCnt == null) return null;

        if (baseCnt <= 0 || targetCnt <= 0 || baseCnt < targetCnt) return null;

        double ratio = targetCnt * 1.0 / baseCnt;
        double faithSquare = faithLevel * faithLevel;

        return (ratio + (faithSquare / (2 * baseCnt)) - faithLevel * Math.sqrt(4 * baseCnt * ratio * (1 - ratio) + faithSquare) / (2 * baseCnt)) / (1 + faithSquare / baseCnt);
    }

    public static void main(String[] args) {
        long click = 43L;
        long convert = 2L;

        double cvr = convert * 1.0 / click;
        Double wilsonScore = calWilsonScore(click, convert, 2);

        System.out.println(cvr);
        System.out.println(wilsonScore);
    }

    public Map<String, Double> getCvrMap(long days) {
        Map<String, Long> convertMap = days == 1 ? convertMap1Day : convertMap3Day;

        if (AssertUtil.isAnyEmpty(convertMap)) {
            return null;
        }

        HashMap<String, Double> cvrMap = new HashMap<>();

        for (String subtype : convertMap.keySet()) {
            cvrMap.put(subtype, getCvrBySubType(subtype, days));
        }

        return cvrMap;
    }

    public Map<String, Double> getMergeCvrMap(long threshold1Day, double weight1Day, double weight3Day) {
        HashMap<String, Double> mergeCvrMap = new HashMap<>();

        // 合并所有后端类型
        HashSet<String> subtypeSet = new HashSet<>();
        if (convertMap1Day != null)
            subtypeSet.addAll(convertMap1Day.keySet());
        if (convertMap3Day != null)
            subtypeSet.addAll(convertMap3Day.keySet());

        for (String subtype : subtypeSet) {
            mergeCvrMap.put(subtype, getMergeCvrBySubType(subtype, threshold1Day, weight1Day, weight3Day));
        }

        return mergeCvrMap;
    }

    public Long getConvertPv1DayBySubType(String subtype) {
        return convertMap1Day == null ? null : convertMap1Day.get(subtype);
    }

    public Long getConvertPv3DayBySubType(String subtype) {
        return convertMap3Day == null ? null : convertMap3Day.get(subtype);
    }

    public Double getMergeCvrBySubType(String subtype, long threshold1Day, double weight1Day, double weight3Day) {
        Long convertPv1Day = getConvertPv1DayBySubType(subtype);

        if (convertPv1Day != null && convertPv1Day > threshold1Day) {
            // 当天转化数据充分，返回当天后端转化率
            return getCvrBySubType(subtype, 1L);
        } else {
            // 融合1天和3天的转化率
            Double cvr1Day = getCvrBySubType(subtype, 1L);
            Double cvr3Day = getCvrBySubType(subtype, 3L);

            if (cvr1Day != null && cvr3Day != null && weight1Day != 0 && weight3Day != 0) {
                return (weight1Day * cvr1Day + weight3Day * cvr3Day) / (weight1Day + weight3Day);
            } else {
                return cvr1Day != null ? cvr1Day : cvr3Day;
            }
        }
    }


    public Double getCvrBySubType(String subtype, long days) {
        Long convertPv = days == 1 ? getConvertPv1DayBySubType(subtype) : getConvertPv3DayBySubType(subtype);
        Long clickPv = days == 1 ? click1Day : click3Day;

        // 95% 置信区间下界
        Double cvr = calWilsonScore(clickPv, convertPv, 2);

        if (cvr != null && (Double.isInfinite(cvr) || Double.isNaN(cvr))) {
            if (new Random().nextDouble() < 0.00001) {
                logger.info("invalid cvr value. convert: " + convertPv + ", click: " + click1Day);
            }
            return null;
        }

        return DataUtil.formatDouble(cvr, 6);
    }

    public Double getDcvrSafely(String deepType,Integer day) {
        try {
            return getDcvr(deepType,day);
        }
        catch (Exception e) {
            logger.info("exception when get dcvr",e);
            return null;
        }
    }

    public Double getDcvr(String deepType,Integer day) {
        if (AssertUtil.isAnyEmpty(convertMap3Day, convertMap1Day, deepType, day)) {
            return null;
        }
        Double result;
        Long clickCnt=null;
        Long deepCnt=null;
        if (day==1) {
            clickCnt=click1Day;
            deepCnt=convertMap1Day.getOrDefault(deepType,null);
        }
        else if (day==3) {
            clickCnt=click3Day;
            deepCnt=convertMap3Day.getOrDefault(deepType,null);
        }

        if (AssertUtil.isAnyEmpty(clickCnt,deepCnt)) {
            return null;
        }
        if (clickCnt==0L) {
            return null;
        }
        result=1.0*deepCnt/clickCnt;
        return DataUtil.formatDouble(result, 6);

    }

    public Long getConvertCntSafely(String convertType,Integer day) {
        try {
            return getConvertCnt(convertType, day);
        }
        catch (Exception e) {
            logger.info("exception when get convert count",e);
            return null;
        }

    }

    public Long getConvertCnt(String convertType,Integer day) {
        if (AssertUtil.isAnyEmpty(convertMap3Day, convertMap1Day,convertType, day)) {
            return null;
        }
        if (day==1) {
            return convertMap1Day.getOrDefault(convertType,null);
        }
        else if (day==3) {
            return convertMap3Day.getOrDefault(convertType,null);
        }
        else {
            return null;
        }
    }

}
