/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.BaseParse;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserBehaviorSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2.sub.UserProfileSubFeature;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActContextFeatureDoV3;
import cn.com.duiba.nezha.alg.feature.vo.v2023.ActFeatureDoV3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFeatureParse
extends BaseParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(ActivityFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(ActContextFeatureDoV3 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        Map<String, String> contextFeature = ActivityFeatureParse.parseContextFeature(contextFeatureDoV2);
        retMap.putAll(contextFeature);
        Map<String, String> userFeature = ActivityFeatureParse.parseUserFeature(userFeatureDoV2);
        retMap.putAll(userFeature);
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActFeatureDoV3 data, UserFeatureDoV2 data2, ActContextFeatureDoV3 data3) {
        HashMap<String, String> retMap = new HashMap(F_MAX_SIZE);
        retMap = ActivityFeatureParse.parseActFeature(data, data2, data3);
        return retMap;
    }

    public static Map<String, String> parseActFeature(ActFeatureDoV3 data, UserFeatureDoV2 data2, ActContextFeatureDoV3 data3) {
        String hisLastActivity;
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        ActivityFeatureParse.putMapNotNull(retMap, "ft300301", data.getActivityId());
        if (data.getActivityPage() != null) {
            ActivityFeatureParse.putMapNotNull(retMap, "ft300304", data.getActivityPage());
        }
        ActivityFeatureParse.putMapNotNull(retMap, "ft300305", data.getActivitySkinType());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300309", data.getActivitySkinType2());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300311", data.getActTradeTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300312", data.getActCrowdTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300313", data.getActInteresteTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300314", data.getActStyleTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300315", data.getActSeasonTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300316", data.getActFestivalTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft300317", ActFeatureDoV3.interestTagValid(data.getActInteresteTag(), data3.getExtMaterialTitle()));
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data2.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        List<String> userActReqList = userBehaviorSubFeature.getUserActReqList();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{data.getActivityId(), userActReqList}) && (hisLastActivity = userActReqList.get(userActReqList.size() - 1)) != null) {
            Long hisLastActivityLong = Long.valueOf(hisLastActivity);
            if (data.getActivityId().equals(hisLastActivityLong)) {
                retMap.put("ft110910", "1");
            }
        }
        return retMap;
    }

    public static Map<String, String> parseContextFeature(ActContextFeatureDoV3 data) {
        Map<String, String> retMap = new HashMap<String, String>(64);
        if (data != null) {
            retMap = data.parse();
        }
        return retMap;
    }

    public static Map<String, String> parseUserFeature(UserFeatureDoV2 data) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        UserProfileSubFeature userProfileFeature = Optional.ofNullable(data.getUserProfileSubFeature()).orElse(new UserProfileSubFeature());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100001", data.getOneId());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100103", userProfileFeature.getMarital());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100106", userProfileFeature.getAge());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100107", userProfileFeature.getGender());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100501", userProfileFeature.getBdFirstTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100502", userProfileFeature.getBdSecondTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft1005031", userProfileFeature.getBdThirdTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100504", userProfileFeature.getBdFourthTag());
        ActivityFeatureParse.putMapNotNull(retMap, "ft100603", userProfileFeature.getAppInstall());
        UserBehaviorSubFeature userBehaviorSubFeature = Optional.ofNullable(data.getUserActSubFeature()).orElse(new UserBehaviorSubFeature());
        retMap.put("f0201", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv())));
        retMap.put("f0202", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv())));
        retMap.put("f0203", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv())));
        retMap.put("f0204", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv())));
        retMap.put("f0205", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv())));
        retMap.put("f0413", DataUtil.listToString(userBehaviorSubFeature.getUserActReqList()));
        retMap.put("f0417", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList()));
        retMap.put("f0418", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList()));
        retMap.put("f0301", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv1d())));
        retMap.put("f0302", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv1d())));
        retMap.put("f0303", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv1d())));
        retMap.put("f0304", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv1d())));
        retMap.put("f0305", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv1d())));
        retMap.put("f0316", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv1d())));
        retMap.put("f0311", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv14d())));
        retMap.put("f0312", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv14d())));
        retMap.put("f0313", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv14d())));
        retMap.put("f0314", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv14d())));
        retMap.put("f0315", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv14d())));
        retMap.put("f0320", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv14d())));
        retMap.put("f0341", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserReqPv180d())));
        retMap.put("f0342", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserExpPv180d())));
        retMap.put("f0343", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserActReqPv180d())));
        retMap.put("f0344", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvLaunchPv180d())));
        retMap.put("f0345", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserAdvClkPv180d())));
        retMap.put("f0350", DataUtil.Long2String((Long)MathUtil.log1p((Long)userBehaviorSubFeature.getUserCvtPv180d())));
        retMap.put("f0403", DataUtil.listToString(userBehaviorSubFeature.getUserActReqList14d()));
        retMap.put("f0407", DataUtil.listToString(userBehaviorSubFeature.getUserAdvLaunchTradeList14d()));
        retMap.put("f0408", DataUtil.listToString(userBehaviorSubFeature.getUserAdvClkTradeList14d()));
        return retMap;
    }

    public static void main(String[] args) {
        ArrayList<String> reqList = new ArrayList<String>();
        reqList.add("100");
        reqList.add("101");
        Long activityId = 101L;
        String hisLastActivity = (String)reqList.get(reqList.size() - 1);
        Long hisLastActivityLong = Long.valueOf(hisLastActivity);
        System.out.println("hisLastActivit=" + hisLastActivity);
        System.out.println("hisLastActivityLong=" + hisLastActivityLong);
        System.out.println("hisLastActivit=" + activityId.equals(hisLastActivity));
        System.out.println("hisLastActivityLong=" + activityId.equals(hisLastActivityLong));
    }
}

