/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.vo.ActSubTitleNameParseVo;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActTitleFeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(ActTitleFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(ActTitleFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f201001", DataUtil.Long2String((Long)cf.getAppId()));
                retMap.put("f108002", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f312001", DataUtil.Long2String((Long)cf.getDsm2A()));
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f311001", DataUtil.Long2String((Long)cf.getActivityPage()));
                retMap.put("f315001", DataUtil.Long2String((Long)cf.getActivitySkin()));
                retMap.put("f4010030", DataUtil.Long2String((Long)cf.getAreaCode()));
                Long regionLevel = FeatureBaseParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = FeatureBaseParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                Integer hour = LocalDateUtil.getHour((LocalDateTime)LocalDateTime.now());
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = LocalDateUtil.getDayOfWeek((LocalDateTime)LocalDateTime.now());
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActTitleFeatureDo cf, ActTitleFeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f316001", DataUtil.Long2String((Long)cf.getActivityTitleId()));
                retMap.put("f317001", DataUtil.Long2String((Long)cf.getActivitySubTitleId()));
                retMap.put("f318001", DataUtil.Long2String((Long)cf.getActivityTitleTagId()));
                retMap.put("f319001", DataUtil.Long2String((Long)cf.getActivitySubTitleTagId()));
                retMap.put("f320001", cf.getActivityTitleName());
                retMap.put("f321001", cf.getActivitySubTitleName());
                ActSubTitleNameParseVo actSubTitleNameParseVo = FeatureBaseParse.parseActTitleName(cf.getActivitySubTitleName());
                retMap.put("f321002", DataUtil.Long2String((Long)actSubTitleNameParseVo.getWeekTypeNums()));
                retMap.put("f321003", DataUtil.Long2String((Long)actSubTitleNameParseVo.getFestivalTypeNums()));
                retMap.put("f321004", DataUtil.Long2String((Long)actSubTitleNameParseVo.getAreaTypeNums()));
                retMap.put("f321005", DataUtil.Long2String((Long)actSubTitleNameParseVo.getDynamicTypeNums()));
                retMap.put("f321006", DataUtil.Long2String((Long)actSubTitleNameParseVo.getSize()));
                ActSubTitleNameParseVo actTitleNameParseVo = FeatureBaseParse.parseActTitleName(cf.getActivityTitleName());
                retMap.put("f321007", DataUtil.Long2String((Long)actTitleNameParseVo.getSize()));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static void main(String[] args) {
    }
}

