/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.ActSubTitleNameParseVo;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBaseParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(FeatureBaseParse.class);
    public static Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};
    public static int[] titleLengthBucket = new int[]{2, 4, 6, 8, 10, 100};

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static ActSubTitleNameParseVo parseActTitleName(String subName) {
        ActSubTitleNameParseVo ret = new ActSubTitleNameParseVo();
        if (subName != null) {
            int size = subName.length();
            Long areaTypeNums = 0L;
            Long festivalTypeNums = 0L;
            Long weekTypeNums = 0L;
            Long prizeTypeNums = 0L;
            Long typeNums = 0L;
            if (subName.contains("\u5730\u57df")) {
                areaTypeNums = 1L;
                typeNums = typeNums + 1L;
            }
            if (subName.contains("\u8282\u65e5")) {
                festivalTypeNums = 1L;
                typeNums = typeNums + 1L;
            }
            if (subName.contains("\u5468\u51e0")) {
                weekTypeNums = 1L;
                typeNums = typeNums + 1L;
            }
            if (subName.contains("\u5956\u54c1")) {
                prizeTypeNums = 1L;
                typeNums = typeNums + 1L;
            }
            Long sizeBucket = FeatureBaseParse.bucket((long)size + 0L, titleLengthBucket);
            ret.setSize(sizeBucket);
            ret.setAreaTypeNums(areaTypeNums);
            ret.setDynamicTypeNums(typeNums);
            ret.setFestivalTypeNums(festivalTypeNums);
            ret.setWeekTypeNums(weekTypeNums);
            ret.setPrizeTypeNums(prizeTypeNums);
        }
        return ret;
    }

    public static Integer getTimeStampToHour(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getHour((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        LocalDateTime localDate;
        Date date;
        Integer ret = null;
        if (timeStamp != null && (date = new Date(timeStamp)) != null && (localDate = LocalDateUtil.dateToLocal((Date)date)) != null) {
            ret = LocalDateUtil.getDayOfWeek((LocalDateTime)localDate);
        }
        return ret;
    }

    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis((String)currentTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        }
        return ret;
    }

    public static String getFloat2String(Float src) {
        String ret = null;
        if (src != null) {
            ret = Float.toString(src.floatValue());
        }
        return ret;
    }

    public static Long getObject2Long(Object src) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)src)) {
            ret = DataUtil.string2Long((String)String.valueOf(src));
        }
        return ret;
    }

    public static Long getIdeaExpTime(Long ideaId, Map<Long, Object> expTimeMap) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ideaId, expTimeMap})) {
            Long cnt = FeatureBaseParse.getObject2Long(expTimeMap.get(ideaId));
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L));
        }
        return ret;
    }

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }

    public static Long getImeiDayTimes(String imei, Long timesLimit, Map<String, Long> timesMap) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{imei, timesMap})) {
            Long cnt = timesMap.get(imei);
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= timesLimit ? cnt : Long.valueOf(99L));
        }
        return ret;
    }

    public static Long getResoDayTimes(Long resoId, String imei, Long timesLimit, Map<String, Long> timesMap) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{imei, resoId, timesMap})) {
            String statKey = DataUtil.Long2String((Long)resoId) + "_" + imei;
            Long cnt = timesMap.get(statKey);
            ret = cnt == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= timesLimit ? cnt : Long.valueOf(99L));
        }
        return ret;
    }

    public static Integer getLength(String idList) {
        Object[] idArr;
        Integer ret = 0;
        if (AssertUtil.isNotEmpty((String)idList) && AssertUtil.isNotEmpty((Object[])(idArr = idList.split(",")))) {
            ret = idArr.length;
        }
        return ret;
    }

    public static String getLengthLevel(String idList, Integer limit, Integer interval) {
        Integer len;
        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{idList, limit, interval}) && (len = FeatureBaseParse.getLength(idList)) > 0) {
            ret = interval == 1 ? Integer.valueOf(len > limit ? limit + 1 : len) : Integer.valueOf(len > limit ? limit / interval + 2 : len / interval + 1);
        }
        return DataUtil.Integer2String((Integer)ret);
    }
}

