package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;

@Data
public class PrizeFeature implements Serializable {

    // 奖品
    private String prizeId;
    private Double componentOrdPrizeHistClick; //f313010 奖品历史点击率
    private Double componentOrdPrizeWeekClick; //f313011 奖品一周点击率
    private Double componentOrdPrizeDayClick;  //f313012 奖品当日点击率
    private Double componentOrdPrizeHistOrder; //f313013 奖品历史转化率
    private Double componentOrdPrizeWeekOrder; //f313014 奖品一周转化率
    private Double componentOrdPrizeDayOrder;  //f313015 奖品当日转化率
    private String componentPrizeTradeCategory; //f313016 行业标签
    private Double prizeHistConsumer; //f313017 历史每UV消耗
    private Double prizeWeekConsumer; //f313018 一周每UV消耗
    private Double prizeDayConsumer; //f313019 当日每UV消耗
    private String prizeEmbedding; //f313010 Embedding


    // 用户组件活动参与
    private Integer cHistPrizesExposeTime; //f493007 当前奖品历史重复曝光次数
    private Integer cWeekPrizesExposeTime;   //f493008 当前奖品一周重复曝光次数
    private Integer cDayPrizesExposeTime; //f493009 当前奖品当日重复曝光次数
    private Integer cHistPrizesClickTime; //f494007 当前奖品一周重复参与次数
    private Integer cWeekPrizesClickTime;   //f494008 当前奖品历史重复参与次数
    private Integer cDayPrizesClickTime; //f494009 当前奖品当日重复参与次数
    private Integer cHistPrizesOrderTime; //f494007 当前奖品一周重复参与次数
    private Integer cWeekPrizesOrderTime;   //f494008 当前奖品历史重复参与次数
    private Integer cDayPrizesOrderTime; //f494009 当前奖品当日重复参与次数


}
