package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;

@Data
public class RoutineActFeature implements Serializable {

    private String routineActId;
    private Double routineActHistClick;    //f301002 常规活动历史点击率
    private Double routineActWeekClick;    //f301003 常规活动一周点击率
    private Double routineActHistOrder;  //f301004 常规活动历史转化率
    private Double routineActWeekOrder; //f301005 常规活动一周转化率
    private String routineActTradeVisitTime;   //f301006 行业标签（媒体）访问次数
    private String routineActTradeClickTime;    //f301007 行业标签（媒体）参与次数
    private String routineActActType;   //f301008 活动类型
    private Double routineActHistConsumer; // 历史每UV消耗
    private Double routineActWeekConsumer; // 一周每UV消耗
    private Double routineActDayConsumer; // 当日每UV消耗
    private String routineActEmbedding; // Embedding

    private Integer autoFirstLaunchStatus; // 自动首次出券状态
    private Integer encStatus; // 增值状态
    private Integer layerStatus; // 广告定制弹层状态
    private Integer actPreLaunchDTOStatus; // 预出券状态
    private Integer actPreLaunchDTONum; // 预出券数量
    private String actPreLaunchDTOIndustryTagName; // 行业名称
    private Integer planAdvertFeatureDTODirectStatus; // 定制白名单开关 0-关 1-开
    private Integer planAdvertFeatureDTODirectModeStatus; // 仅投优投开关  1仅投放定制广告券列表，2优先投放定制广告券列表

}
