/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureUtil;
import cn.com.duiba.nezha.alg.feature.vo.CoderFeature;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureCoderBase {
    private static final Logger logger = LoggerFactory.getLogger(FeatureCoderBase.class);

    public static int getVectorSize(List<Integer> pLenList) {
        Integer tmp;
        int ret = 0;
        if (pLenList != null && pLenList.size() > 0 && (tmp = pLenList.get(pLenList.size() - 1)) != null) {
            ret = tmp;
        }
        return ret;
    }

    public static Set<Integer> getId(int fSize, int fId, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet<Integer> ret = new HashSet<Integer>();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        indices.add(pLen + fId);
        ret.add(pLen + fId);
        values.add(1.0);
        pLenList.add(pLen + fSize);
        return ret;
    }

    public static List<Integer> getIdWithSeq(int fSize, int fId, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        indices.add(pLen + fId);
        ret.add(pLen + fId);
        values.add(1.0);
        pLenList.add(pLen + fSize);
        return ret;
    }

    public static Set<Integer> getId(int fId) throws Exception {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(fId);
        return ret;
    }

    public static List<Integer> getIdWithSeq(int fId) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(fId);
        return ret;
    }

    public static Set<Integer> getIds(int fSize, int pFNums, int[] sFIds, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet<Integer> ret = new HashSet<Integer>();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        if (sFIds != null && sFIds.length > 0) {
            double weight = MathUtil.reciprocalOfN((Integer)sFIds.length);
            for (int i = 0; i < sFIds.length; ++i) {
                Integer newId = pLen + sFIds[i];
                indices.add(newId);
                ret.add(newId);
                values.add(weight);
            }
        }
        pLenList.add(pLen + pFNums * fSize);
        return ret;
    }

    public static List<Integer> getIdsWithSeq(int fSize, int pFNums, int[] sFIds, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        if (sFIds != null && sFIds.length > 0) {
            double weight = MathUtil.reciprocalOfN((Integer)sFIds.length);
            for (int i = 0; i < sFIds.length; ++i) {
                Integer newId = pLen + sFIds[i];
                indices.add(newId);
                ret.add(newId);
                values.add(weight);
            }
        }
        pLenList.add(pLen + pFNums * fSize);
        return ret;
    }

    public static Set<Integer> getIds(int[] sFIds) throws Exception {
        HashSet<Integer> ret = new HashSet<Integer>();
        if (sFIds != null && sFIds.length > 0) {
            for (int i = 0; i < sFIds.length; ++i) {
                int fId = sFIds[i];
                ret.add(fId);
            }
        }
        return ret;
    }

    public static List<Integer> getIdsWithSeq(int[] sFIds) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (sFIds != null && sFIds.length > 0) {
            for (int i = 0; i < sFIds.length; ++i) {
                int fId = sFIds[i];
                ret.add(fId);
            }
        }
        return ret;
    }

    public static Set<Integer> getDenseId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fSize, fId, pLenList, indices, values);
    }

    public static List<Integer> getDenseIdWithSeq(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);
        return FeatureCoderBase.getIdWithSeq(fSize, fId, pLenList, indices, values);
    }

    public static Set<Integer> getSubId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fSize, fId, pLenList, indices, values);
    }

    public static List<Integer> getSubIdWithSeq(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase.getIdWithSeq(fSize, fId, pLenList, indices, values);
    }

    public static Set<Integer> getSubId(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fId);
    }

    public static List<Integer> getSubIdWithSeq(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase.getIdWithSeq(fId);
    }

    public static Set<Integer> getDenseId(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fId);
    }

    public static List<Integer> getDenseIdWithSeq(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);
        return FeatureCoderBase.getIdWithSeq(fId);
    }

    public static Set<Integer> getSubIds(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);
        return FeatureCoderBase.getIds(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getSubIdsWithSeq(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIdsWithSeq(feature, fStrs, fSize);
        return FeatureCoderBase.getIdsWithSeq(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getSubIds(String feature, String fStr, String seq, int fSize) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static List<Integer> getSubIdsWithSeq(String feature, String fStr, String seq, int fSize) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIdsWithSeq(feature, fStrs, fSize);
        return FeatureCoderBase.getIdsWithSeq(sFIds);
    }

    public static Set<Integer> getHashSubId(String feature, String fStr, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, fSize, pNums);
        return FeatureCoderBase.getIds(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getHashSubIdWithSeq(String feature, String fStr, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int[] sFIds = FeatureUtil.getHashSubFIdNotSort(feature, fStr, fSize, pNums);
        return FeatureCoderBase.getIdsWithSeq(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getHashSubId(String feature, String fStr, int fSize, int pNums) throws Exception {
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, fSize, pNums);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static List<Integer> getHashSubIdWithSeq(String feature, String fStr, int fSize, int pNums) throws Exception {
        int[] sFIds = FeatureUtil.getHashSubFIdNotSort(feature, fStr, fSize, pNums);
        return FeatureCoderBase.getIdsWithSeq(sFIds);
    }

    public static Set<Integer> getHashSubIds(String feature, String fStr, String seq, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet ret = new HashSet();
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, fSize, pNums);
        return FeatureCoderBase.getIds(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getHashSubIds(String feature, String fStr, String seq, int fSize, int pNums) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, fSize, pNums);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static List<Integer> getHashSubIdsWithSeq(String feature, String fStr, String seq, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet ret = new HashSet();
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIdsWithSeq(feature, fStrs, fSize, pNums);
        return FeatureCoderBase.getIdsWithSeq(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getHashSubIdsWithSeq(String feature, String fStr, String seq, int fSize, int pNums) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIdsWithSeq(feature, fStrs, fSize, pNums);
        return FeatureCoderBase.getIdsWithSeq(sFIds);
    }

    public static Set<Integer> getDictSubId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase.getId(fSize, fId, pLenList, indices, values);
    }

    public static Set<Integer> getDictSubId(String feature, String fStr, int fSize, Map<String, Integer> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase.getId(fId);
    }

    public static List<Integer> getDictSubIdWithSeq(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase.getIdWithSeq(fSize, fId, pLenList, indices, values);
    }

    public static List<Integer> getDictSubIdWithSeq(String feature, String fStr, int fSize, Map<String, Integer> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase.getIdWithSeq(fId);
    }

    public static Set<Integer> getDictSubIds(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fDict);
        return FeatureCoderBase.getIds(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getDictSubIds(String feature, String fStr, String seq, int fSize, Map<String, Integer> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fDict);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static List<Integer> getDictSubIdsWithSeq(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIdsWithSeq(feature, fStrs, fSize, fDict);
        return FeatureCoderBase.getIdsWithSeq(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getDictSubIdsWithSeq(String feature, String fStr, String seq, int fSize, Map<String, Integer> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIdsWithSeq(feature, fStrs, fSize, fDict);
        return FeatureCoderBase.getIdsWithSeq(sFIds);
    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<Integer> pLenList, List<String> fields) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{indices, values, pLenList})) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }
        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];
        for (int i = 0; i < indices.size(); ++i) {
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        return new Feature(pLen, indices, values2, fields);
    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<String> fields, int size) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{indices, values, fields})) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }
        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];
        for (int i = 0; i < indices.size(); ++i) {
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }
        return new Feature(size, indices, values2, fields);
    }

    public static CoderFeature getId(int fSize, String field, int fId, int startIndex) throws Exception {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<String> fields = new ArrayList<String>();
        HashSet<Integer> fieldsSet = new HashSet<Integer>();
        Integer newId = startIndex + fId;
        indices.add(newId);
        values.add(1.0);
        fields.add(field);
        fieldsSet.add(newId);
        return new CoderFeature(fSize, startIndex + fSize, indices, values, fields, fieldsSet);
    }

    public static CoderFeature getIds(int fSize, String field, int pFNums, int[] sFIds, int startIndex) throws Exception {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<String> fields = new ArrayList<String>();
        HashSet<Integer> fieldsSet = new HashSet<Integer>();
        if (sFIds != null && sFIds.length > 0) {
            double weight = MathUtil.reciprocalOfN((Integer)sFIds.length);
            for (int i = 0; i < sFIds.length; ++i) {
                Integer newId = startIndex + sFIds[i];
                indices.add(newId);
                values.add(weight);
                fields.add(field);
                fieldsSet.add(newId);
            }
        }
        return new CoderFeature(fSize, startIndex + pFNums * fSize, indices, values, fields, fieldsSet);
    }

    public static CoderFeature getDenseId(String field, String fStr, int fSize, int startIndex) throws Exception {
        int fId = FeatureUtil.getDenseFId(field, fStr, fSize);
        return FeatureCoderBase.getId(fSize, field, fId, startIndex);
    }

    public static CoderFeature getSubId(String field, String fStr, int fSize, int startIndex) throws Exception {
        int fId = FeatureUtil.getSubFId(field, fStr, fSize);
        return FeatureCoderBase.getId(fSize, field, fId, startIndex);
    }

    public static CoderFeature getSubIds(String field, String fStr, String seq, int fSize, int startIndex) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(field, fStrs, fSize);
        return FeatureCoderBase.getIds(fSize, field, 1, sFIds, startIndex);
    }

    public static CoderFeature getHashSubId(String field, String fStr, int fSize, int pNums, int startIndex) throws Exception {
        int[] sFIds = FeatureUtil.getHashSubFId(field, fStr, fSize, pNums);
        return FeatureCoderBase.getIds(fSize, field, pNums, sFIds, startIndex);
    }

    public static CoderFeature getHashSubIds(String field, String fStr, String seq, int fSize, int pNums, int startIndex) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(field, fStrs, fSize, pNums);
        return FeatureCoderBase.getIds(fSize, field, pNums, sFIds, startIndex);
    }

    public static CoderFeature getDictSubId(String field, String fStr, int fSize, int startIndex, Map<String, Integer> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(field, fStr, fSize, fDict);
        return FeatureCoderBase.getId(fSize, field, fId, startIndex);
    }

    public static CoderFeature getDictSubIds(String field, String fStr, String seq, int fSize, int startIndex, Map<String, Integer> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIds(field, fStrs, fSize, fDict);
        return FeatureCoderBase.getIds(fSize, field, 1, sFIds, startIndex);
    }

    public static Feature toFeatureNew(int size, List<Integer> indices, List<Double> values, List<String> fields) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{indices, values})) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }
        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];
        for (int i = 0; i < indices.size(); ++i) {
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }
        return new Feature(size, indices, values2, fields);
    }
}

