/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.MaterialContextFeature;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeature;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.SlotFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotMaterialFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserMaterialFeature;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialFeatureParse {
    private static final Logger logger = LoggerFactory.getLogger(MaterialFeatureParse.class);
    public static int F_MAX_SIZE = 64;
    public static int[] sexpWeekBucket = new int[]{0, 5, 17, 61, 170, 286, 650, 2446, 14211, 277794};
    public static int[] sexpDayBucket = new int[]{0, 3, 10, 24, 40, 75, 161, 795, 27479, 120623};
    public static int[] sclickWeekBucket = new int[]{0, 1, 2, 4, 9, 19, 61, 164, 1165, 8893};
    public static int[] sclickDayBucket = new int[]{0, 1, 1, 2, 3, 9, 24, 140, 1231, 2740};
    public static int[] expWeekBucket = new int[]{0, 3, 10, 46, 156, 369, 875, 4103, 36319, 431986};
    public static int[] expDayBucket = new int[]{0, 3, 9, 24, 43, 87, 201, 1626, 47910, 126840};
    public static int[] clickWeekBucket = new int[]{0, 1, 3, 7, 14, 44, 123, 379, 3391, 14571};
    public static int[] clickDayBucket = new int[]{0, 1, 2, 3, 4, 10, 35, 199, 1501, 4698};
    public static int[] convertCntBucket = new int[]{0, 1, 2, 5, 10, 20, 50, 100, 500, 1000, 2000};
    public static int[] bconvertCntBucket = new int[]{0, 1, 2, 5, 10, 20, 50, 100, 500, 1000, 2000};
    public static double[] userCtrBucket = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 1.0};
    public static double[] slotCtrBucket = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 1.0};
    public static int[] timeBucket = new int[]{0, 1, 3, 5, 10, 15, 20, 50};

    public static Map<String, String> generateFeatureMapStatic(MaterialFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                UserFeature userFeature = Optional.ofNullable(cf.getUserFeature()).orElse(new UserFeature());
                retMap.put("f451001", userFeature.getSex());
                retMap.put("f451002", userFeature.getAge());
                retMap.put("f451003", userFeature.getMarry());
                retMap.put("f451004", userFeature.getConsumeLevel());
                retMap.put("f451005", userFeature.getPermanentProvince());
                retMap.put("f451006", userFeature.getPermanentCity());
                retMap.put("f9902", userFeature.getAppList());
                retMap.put("f9801", userFeature.getSigList());
                if (userFeature.getExpDayMaterials() != null) {
                    List<String> expDayMaterials = Arrays.asList(userFeature.getExpDayMaterials().split(","));
                    retMap.put("f390001", MaterialFeatureParse.subList(expDayMaterials));
                } else {
                    retMap.put("f390001", "null");
                }
                if (userFeature.getClickDayMaterials() != null) {
                    List<String> clickDayMaterials = Arrays.asList(userFeature.getClickDayMaterials().split(","));
                    retMap.put("f390002", MaterialFeatureParse.subList(clickDayMaterials));
                } else {
                    retMap.put("f390002", "null");
                }
                retMap.put("f390003", MaterialFeatureParse.sortSubList(userFeature.getExpWeekMaterials()));
                retMap.put("f390004", MaterialFeatureParse.sortSubList(userFeature.getClickWeekMaterials()));
                SlotFeature slotFeature = Optional.ofNullable(cf.getSlotFeature()).orElse(new SlotFeature());
                retMap.put("f108001", DataUtil.Long2String((Long)slotFeature.getSlotId()));
                retMap.put("f109001", DataUtil.Long2String((Long)slotFeature.getSlotType()));
                retMap.put("f201001", DataUtil.Long2String((Long)slotFeature.getAppId()));
                retMap.put("f205001", slotFeature.getAppIndustryTagPid());
                retMap.put("f205002", slotFeature.getAppIndustryTagId());
                MaterialContextFeature contextFeature = Optional.ofNullable(cf.getMaterialContextFeature()).orElse(new MaterialContextFeature());
                retMap.put("f501001", contextFeature.getUa());
                retMap.put("f503001", DataUtil.Long2String((Long)contextFeature.getCityId()));
                retMap.put("f503003", contextFeature.getProvinceCode());
                retMap.put("f504001", contextFeature.getModel());
                retMap.put("f390017", contextFeature.getExposeHour());
                retMap.put("f390018", contextFeature.getExposeWeekDay());
                retMap.put("f390019", contextFeature.getExposeHolidays());
            }
        }
        catch (Exception e) {
            logger.error("MaterialFeatureParse.generateFeatureMapStatic error:", (Throwable)e);
            logger.error(JSONObject.toJSONString((Object)cf));
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(MaterialFeatureDo cf, MaterialFeatureDo staticCf, Long materialId) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (cf == null) {
            return retMap;
        }
        try {
            if (MapUtils.isNotEmpty(cf.getMaterialFeatureMap()) && cf.getMaterialFeatureMap().get(materialId) != null) {
                MaterialFeature materialFeature = cf.getMaterialFeatureMap().get(materialId);
                retMap.put("f390000", DataUtil.Long2String((Long)materialId));
                retMap.put("f390005", materialFeature.getCustomization());
                retMap.put("f390006", materialFeature.getIndustry());
                retMap.put("f390007", materialFeature.getSlotNature());
                retMap.put("f390008", materialFeature.getDesignHue());
                retMap.put("f390047", materialFeature.getStrategy());
                retMap.put("f390048", materialFeature.getRewardElement());
                retMap.put("f390049", materialFeature.getDesignType());
                retMap.put("f390009", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getExposeWeekCnt(), expWeekBucket)));
                retMap.put("f390010", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getClickWeekCnt(), clickWeekBucket)));
                retMap.put("f390011", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getConvertWeekCnt(), convertCntBucket)));
                retMap.put("f390012", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getBConvertWeekCnt(), bconvertCntBucket)));
                retMap.put("f390013", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getExposeDayCnt(), expDayBucket)));
                retMap.put("f390014", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(materialFeature.getClickDayCnt(), clickDayBucket)));
                Double weekCtr = MaterialFeatureParse.calWilsonScore(materialFeature.getExposeWeekCnt(), materialFeature.getClickWeekCnt());
                Double dayCtr = MaterialFeatureParse.calWilsonScore(materialFeature.getExposeDayCnt(), materialFeature.getClickDayCnt());
                retMap.put("f390042", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(weekCtr, userCtrBucket)));
                retMap.put("f390043", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(dayCtr, userCtrBucket)));
            }
            if (MapUtils.isNotEmpty(cf.getUserMaterialFeatureMap()) && cf.getUserMaterialFeatureMap().get(materialId) != null) {
                UserMaterialFeature umFeature = cf.getUserMaterialFeatureMap().get(materialId);
                retMap.put("f390020", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUExposeHistCnt(), 100L)));
                retMap.put("f390021", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUExposeWeekCnt(), 100L)));
                retMap.put("f390022", MaterialFeatureParse.bucket(umFeature.getUExposeInterval(), timeBucket).toString());
                retMap.put("f390023", DataUtil.Long2String((Long)umFeature.getUExposePeriod()));
                retMap.put("f390024", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUClickHistCnt(), 100L)));
                retMap.put("f390025", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUClickWeekCnt(), 100L)));
                retMap.put("f390026", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUClickDayCnt(), 100L)));
                retMap.put("f390027", DataUtil.Long2String((Long)MaterialFeatureParse.min(umFeature.getUExposeDayCnt(), 100L)));
                retMap.put("f390028", MaterialFeatureParse.bucket(umFeature.getUClickInterval(), timeBucket).toString());
                retMap.put("f390029", DataUtil.Long2String((Long)umFeature.getUClickPeriod()));
                Double uhisCtr = MaterialFeatureParse.calWilsonScore(umFeature.getUExposeHistCnt(), umFeature.getUClickHistCnt());
                Double uweekCtr = MaterialFeatureParse.calWilsonScore(umFeature.getUExposeWeekCnt(), umFeature.getUClickWeekCnt());
                retMap.put("f390044", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(uhisCtr, userCtrBucket)));
            }
            if (MapUtils.isNotEmpty(cf.getSlotMaterialFeatureMap()) && cf.getSlotMaterialFeatureMap().get(materialId) != null) {
                SlotMaterialFeature smFeature = cf.getSlotMaterialFeatureMap().get(materialId);
                retMap.put("f390030", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotClickDayCnt(), sclickDayBucket)));
                retMap.put("f390031", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotClickWeekCnt(), sclickWeekBucket)));
                retMap.put("f390032", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotExposeWeekCnt(), sexpWeekBucket)));
                retMap.put("f390033", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotExposeDayCnt(), sexpDayBucket)));
                retMap.put("f390034", DataUtil.Long2String((Long)smFeature.getSlotExposePeriod()));
                retMap.put("f390035", DataUtil.Long2String((Long)smFeature.getSlotClickPeriod()));
                retMap.put("f390036", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotConvertHistCnt(), convertCntBucket)));
                retMap.put("f390037", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotBConvertHistCnt(), bconvertCntBucket)));
                retMap.put("f390038", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotConvertWeekCnt(), convertCntBucket)));
                retMap.put("f390039", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(smFeature.getSlotBConvertWeekCnt(), bconvertCntBucket)));
                Double sweekCtr = MaterialFeatureParse.calWilsonScore(smFeature.getSlotExposeWeekCnt(), smFeature.getSlotClickWeekCnt());
                Double sdayCtr = MaterialFeatureParse.calWilsonScore(smFeature.getSlotExposeDayCnt(), smFeature.getSlotClickDayCnt());
                retMap.put("f390045", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(sweekCtr, slotCtrBucket)));
                retMap.put("f390046", DataUtil.Long2String((Long)MaterialFeatureParse.bucket(sdayCtr, slotCtrBucket)));
            }
        }
        catch (Exception e) {
            logger.error("MaterialFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    private static double calWilsonScore(Long exposeCnt, Long clickCnt) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{exposeCnt, clickCnt})) {
            return 0.0;
        }
        if (exposeCnt == 0L) {
            return 0.0;
        }
        double ratio = (double)clickCnt.longValue() * 1.0 / (double)exposeCnt.longValue();
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * exposeCnt) - faithLevel * Math.sqrt((double)(4L * exposeCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * exposeCnt)) / (1.0 + faithSquare / (double)exposeCnt.longValue());
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = Math.round(MaterialFeatureParse.log(lvalue.doubleValue(), 500.0));
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static Integer level(Long value, Long base, Integer min, Integer max) {
        Integer ret = null;
        if (value != null && value > 0L) {
            ret = Math.round(value / base);
            ret = Math.max(Math.min(ret, max), min);
        }
        return ret;
    }

    public static Long min(Long value, Long base) {
        if (AssertUtil.isEmpty((Object)value)) {
            return 0L;
        }
        if (value >= base) {
            value = base;
        }
        return value;
    }

    public static String subList(List<String> list) {
        if (AssertUtil.isEmpty(list)) {
            return null;
        }
        List<String> subList = list;
        if (list.size() > 30) {
            subList = subList.subList(list.size() - 30, list.size());
            return StringUtils.strip((String)subList.toString().replace(" ", ""), (String)"[]");
        }
        return StringUtils.strip((String)list.toString().replace(" ", ""), (String)"[]");
    }

    public static String sortSubList(String string) {
        if (AssertUtil.isEmpty((String)string)) {
            return null;
        }
        List<String> list = Arrays.asList(string.split(","));
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String[] array1 = o1.split("-");
                String[] array2 = o2.split("-");
                return array1[0].compareTo(array2[0]);
            }
        });
        ArrayList<String> newArray = new ArrayList<String>();
        for (String s : list) {
            if (s.split("-").length >= 2) {
                newArray.add(s.split("-")[1]);
                continue;
            }
            newArray.add(s);
        }
        return MaterialFeatureParse.subList(newArray);
    }

    public static void main(String[] args) {
        String string0 = "20100724201049-0716,20200727201101-01182,20250723201243-187751,20200723201049-716,20200723201101-1182,20200723201243-18751,20300723201349-7716,20200723201101-1182,20200723200843-187571,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-11782,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-1182,20200723111243-18751,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-7146,20200723101901-1182,20200723201243-187251,20200723201349-716,20200723201101-1182,20200723200843-18751,20200723201049-716,20200723201901-11282,20200723201243-18751,20200723201349-716,20200723201101-1182,20200723200843-187251,20200723201049-7126,20200723201901-1182,20200723201243-18751,20200723201349-716,20200723201101-11822,20200723200843-187521,20200723201049-7126,20200723201901-1182,20200723201243-18752";
        String string = "1,2,2,3,2,2,2,2,1,2,3,4,5,6,7,56,6,7,8,89,12,3,4,5,1,2,3,45,89,78,76,56,56,43,53,2,2";
        System.out.println(MaterialFeatureParse.sortSubList(string0));
        String str = "1,2,2,3,2,2,2,2,1,2,3,4,5,6,7,56,6,7,8,89,12,3,4,5,1,2,3,45,89,78,76,56,56,43,53,2,2";
        List<String> list = Arrays.asList(str.split(","));
        System.out.println(MaterialFeatureParse.subList(list));
    }
}

