/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.type;

import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;
import cn.com.duiba.nezha.alg.feature.coder.FeatureUtil;
import cn.com.duiba.nezha.alg.feature.vo.CoderFeature;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureBaseType
implements Serializable {
    private static final long serialVersionUID = -8781145506799969883L;
    public String name;
    public int codeType;
    public int subLen;
    public int hashNums;
    public String seq;
    public Map<String, Integer> dictList;
    public int denseLen;

    public FeatureBaseType() {
    }

    public FeatureBaseType(String name, int codeType, int subLen, int hashNums, String seq, Map<String, Integer> dictList) {
        this.name = name;
        this.codeType = codeType;
        this.hashNums = hashNums;
        this.subLen = subLen;
        this.seq = seq;
        this.dictList = dictList;
    }

    public String getName() {
        return this.name;
    }

    public int getCodeType() {
        return this.codeType;
    }

    public int getSubLen() {
        return this.subLen;
    }

    public int getHashNums() {
        return this.hashNums;
    }

    public String getSeq() {
        return this.seq;
    }

    public Map<String, Integer> getDictList() {
        return this.dictList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCodeType(int codeType) {
        this.codeType = codeType;
    }

    public void setSubLen(int subLen) {
        this.subLen = subLen;
    }

    public void setHashNums(int hashNums) {
        this.hashNums = hashNums;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public void setDictList(Map<String, Integer> dictList) {
        this.dictList = dictList;
    }

    public int getDenseLen() {
        return this.denseLen;
    }

    public void setDenseLen(int denseLen) {
        this.denseLen = denseLen;
    }

    public Set<Integer> code(String featureValue, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = null;
        if (this.codeType == 10) {
            ret = FeatureCoderBase.getSubId(this.name, featureValue, this.subLen, pLenList, indices, values);
        }
        if (this.codeType == 11) {
            ret = FeatureCoderBase.getSubIds(this.name, featureValue, this.seq, this.subLen, pLenList, indices, values);
        }
        if (this.codeType == 20) {
            ret = FeatureCoderBase.getHashSubId(this.name, featureValue, this.subLen, this.hashNums, pLenList, indices, values);
        }
        if (this.codeType == 21) {
            ret = FeatureCoderBase.getHashSubIds(this.name, featureValue, this.seq, this.subLen, this.hashNums, pLenList, indices, values);
        }
        if (this.codeType == 30) {
            ret = FeatureCoderBase.getDictSubId(this.name, featureValue, this.subLen, pLenList, indices, values, this.dictList);
        }
        if (this.codeType == 31) {
            ret = FeatureCoderBase.getDictSubIds(this.name, featureValue, this.seq, this.subLen, pLenList, indices, values, this.dictList);
        }
        if (this.codeType == 99) {
            ret = FeatureCoderBase.getDenseId(this.name, featureValue, this.subLen, pLenList, indices, values);
        }
        return ret;
    }

    public CoderFeature codeNew(String featureValue, int startIndex) throws Exception {
        CoderFeature ret = null;
        if (this.codeType == 10) {
            ret = FeatureCoderBase.getSubId(this.name, featureValue, this.subLen, startIndex);
        }
        if (this.codeType == 11) {
            ret = FeatureCoderBase.getSubIds(this.name, featureValue, this.seq, this.subLen, startIndex);
        }
        if (this.codeType == 20) {
            ret = FeatureCoderBase.getHashSubId(this.name, featureValue, this.subLen, this.hashNums, startIndex);
        }
        if (this.codeType == 21) {
            ret = FeatureCoderBase.getHashSubIds(this.name, featureValue, this.seq, this.subLen, this.hashNums, startIndex);
        }
        if (this.codeType == 30) {
            ret = FeatureCoderBase.getDictSubId(this.name, featureValue, this.subLen, startIndex, this.dictList);
        }
        if (this.codeType == 31) {
            ret = FeatureCoderBase.getDictSubIds(this.name, featureValue, this.seq, this.subLen, startIndex, this.dictList);
        }
        if (this.codeType == 99) {
            ret = FeatureCoderBase.getDenseId(this.name, featureValue, this.subLen, startIndex);
        }
        return ret;
    }

    public Set<Integer> code(String featureValue) throws Exception {
        Set<Integer> ret = null;
        if (this.codeType == 10) {
            ret = FeatureCoderBase.getSubId(this.name, featureValue, this.subLen);
        }
        if (this.codeType == 11) {
            ret = FeatureCoderBase.getSubIds(this.name, featureValue, this.seq, this.subLen);
        }
        if (this.codeType == 20) {
            ret = FeatureCoderBase.getHashSubId(this.name, featureValue, this.subLen, this.hashNums);
        }
        if (this.codeType == 21) {
            ret = FeatureCoderBase.getHashSubIds(this.name, featureValue, this.seq, this.subLen, this.hashNums);
        }
        if (this.codeType == 30) {
            ret = FeatureCoderBase.getDictSubId(this.name, featureValue, this.subLen, this.dictList);
        }
        if (this.codeType == 31) {
            ret = FeatureCoderBase.getDictSubIds(this.name, featureValue, this.seq, this.subLen, this.dictList);
        }
        if (this.codeType == 99) {
            ret = FeatureCoderBase.getDenseId(this.name, featureValue, this.subLen);
        }
        return ret;
    }

    public List<Integer> codeWithSeq(String featureValue) throws Exception {
        List<Integer> ret = null;
        if (this.codeType == 10) {
            ret = FeatureCoderBase.getSubIdWithSeq(this.name, featureValue, this.subLen);
        }
        if (this.codeType == 11) {
            ret = FeatureCoderBase.getSubIdsWithSeq(this.name, featureValue, this.seq, this.subLen);
        }
        if (this.codeType == 20) {
            ret = FeatureCoderBase.getHashSubIdWithSeq(this.name, featureValue, this.subLen, this.hashNums);
        }
        if (this.codeType == 21) {
            ret = FeatureCoderBase.getHashSubIdsWithSeq(this.name, featureValue, this.seq, this.subLen, this.hashNums);
        }
        if (this.codeType == 30) {
            ret = FeatureCoderBase.getDictSubIdWithSeq(this.name, featureValue, this.subLen, this.dictList);
        }
        if (this.codeType == 31) {
            ret = FeatureCoderBase.getDictSubIdsWithSeq(this.name, featureValue, this.seq, this.subLen, this.dictList);
        }
        if (this.codeType == 99) {
            ret = FeatureCoderBase.getDenseIdWithSeq(this.name, featureValue, this.subLen);
        }
        return ret;
    }

    public Set<String> parseFeatureValues(String featureValue) throws Exception {
        String[] features;
        HashSet<String> ret = new HashSet<String>();
        System.out.println(this.codeType);
        if (this.codeType == 10 || this.codeType == 20 || this.codeType == 30) {
            ret.add(featureValue);
        }
        if ((this.codeType == 11 || this.codeType == 21 || this.codeType == 31) && (features = FeatureUtil.toFeatures(featureValue, this.seq)) != null && features.length > 0) {
            for (int i = 0; i < features.length; ++i) {
                ret.add(features[i]);
            }
        }
        if (this.codeType == 99) {
            ret.add(featureValue);
        }
        return ret;
    }

    public static void main(String[] args) {
        Integer F_MAX_SIZE = 1000;
        try {
            Set<Integer> subIds = FeatureCoderBase.getSubIds("", "0,3,14", ",", 10);
            System.out.println(subIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

