package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.enums.AdxTypeEnum;
import cn.com.duiba.nezha.alg.feature.vo.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * Created by pc on 2019/2/21.
 */
public class FeatureBaseParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureBaseParse.class);

    public static Integer[] HUABEI_REGION = {80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = {81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = {82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = {83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = {84, 44, 45, 46};
    public static Integer[] XINAN_REGION = {85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = {86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = {87, 71, 8100, 8200};

    public static Integer[] FIRST_TIER_CITY = {11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = {1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = {1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};


    public static int[] titleLengthBucket = {2, 4, 6, 8, 10, 100};


    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    /**
     * 分桶函数2
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    public static ActSubTitleNameParseVo parseActTitleName(String subName) {
        ActSubTitleNameParseVo ret = new ActSubTitleNameParseVo();

        if (subName != null) {
            int size = subName.length();
            Long areaTypeNums = 0L;
            Long festivalTypeNums = 0L;
            Long weekTypeNums = 0L;
            Long prizeTypeNums =0L;
            Long typeNums = 0L;

            if (subName.contains("地域")) {
                areaTypeNums = 1L;
                typeNums += 1;
            }

            if (subName.contains("节日")) {
                festivalTypeNums = 1L;
                typeNums += 1;
            }

            if (subName.contains("周几")) {
                weekTypeNums = 1L;
                typeNums += 1;
            }

            if (subName.contains("奖品")) {
                prizeTypeNums = 1L;
                typeNums += 1;
            }

            Long sizeBucket = bucket(size + 0L, titleLengthBucket);

            ret.setSize(sizeBucket);
            ret.setAreaTypeNums(areaTypeNums);
            ret.setDynamicTypeNums(typeNums);
            ret.setFestivalTypeNums(festivalTypeNums);
            ret.setWeekTypeNums(weekTypeNums);
            ret.setPrizeTypeNums(prizeTypeNums);

        }

        return ret;
    }


    public static Integer getTimeStampToHour(Long timeStamp) {
        Integer ret = null;
        if (timeStamp != null) {
            Date date = new Date(timeStamp);

            if (date != null) {
                LocalDateTime localDate = LocalDateUtil.dateToLocal(date);

                if (localDate != null) {
                    ret = LocalDateUtil.getHour(localDate);

                }
            }
        }
        return ret;
    }


    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        Integer ret = null;
        if (timeStamp != null) {
            Date date = new Date(timeStamp);

            if (date != null) {
                LocalDateTime localDate = LocalDateUtil.dateToLocal(date);

                if (localDate != null) {
                    ret = LocalDateUtil.getDayOfWeek(localDate);

                }
            }
        }
        return ret;
    }


    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis(currentTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        }
        return ret;
    }


    public static String getFloat2String(Float src) {
        String ret = null;
        if (src != null) {
            ret = Float.toString(src);
        }
        return ret;

    }


    public static Long getObject2Long(Object src) {
        Long ret = null;
        if (AssertUtil.isNotEmpty(src)) {
            ret = DataUtil.string2Long(String.valueOf(src));
        }
        return ret;

    }


    //该创意+设备号的当天累计曝光次数 f5010040
    public static Long getIdeaExpTime(Long ideaId, Map<Long, Object> expTimeMap) {

        Long ret = null;

        if (AssertUtil.isAllNotEmpty(ideaId, expTimeMap)) {

            Long cnt = getObject2Long(expTimeMap.get(ideaId));
            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= 7) {
                ret = cnt;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }


    //根据areaCode解析地区级别（华北/东北/华东/华中/华南/西南/西北/港澳） f4010031
    public static Long getRegionLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt(Long.valueOf(areaCode / 100));
            }

            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }

        }

        return ret;
    }


    //根据areaCode解析城市级别（一线/二线/三线） f4010032
    public static Long getTierCityLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);

            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }

        }

        return ret;
    }


    // 设备号 当天竞价次数/当天曝光次数
    public static Long getImeiDayTimes(String imei, Long timesLimit, Map<String, Long> timesMap) {

        Long ret = 0L;

        if (AssertUtil.isAllNotEmpty(imei, timesMap)) {

            Long cnt = timesMap.get(imei);

            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= timesLimit) {
                ret = cnt;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }


    // 资源位id+设备号  当天竞价次数/当天曝光次数
    public static Long getResoDayTimes(Long resoId, String imei, Long timesLimit, Map<String, Long> timesMap) {

        Long ret = 0L;

        if (AssertUtil.isAllNotEmpty(imei, resoId, timesMap)) {

            String statKey = DataUtil.Long2String(resoId) + "_" + imei;
            Long cnt = timesMap.get(statKey);

            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= timesLimit) {
                ret = cnt;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }


    // 获取列表长度
    public static Integer getLength(String idList) {

        Integer ret = 0;
        if (AssertUtil.isNotEmpty(idList)) {
            String idArr[] = idList.split(",");

            if (AssertUtil.isNotEmpty(idArr)){
                ret = idArr.length;
            }
        }

        return ret;
    }


    // 获取列表长度--分段
    public static String getLengthLevel(String idList, Integer limit, Integer interval) {

        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty(idList, limit, interval)) {
            Integer len = getLength(idList);

            if (len > 0) {

                if (interval == 1) {
                    ret = len > limit ? (limit + 1) : len;

                } else {
                    ret = len > limit ? ((int) (limit / interval) + 2) : ((int) (len / interval) + 1);

                }
            }
        }

        return DataUtil.Integer2String(ret);
    }


    // 获取列表长度--分段
    public static String getLengthLevel(String idList, Integer limit1, Integer limit2, Integer interval) {

        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty(idList, limit1, limit2, interval)) {
            Integer len = getLength(idList);

            if (len <= limit1) {
                ret = len;

            } else {

                if (interval == 1) {
                    ret = len > limit2 ? (limit2 + 1) : len;

                } else {
                    ret = len > limit2 ?
                            ((int) (limit1 - limit1 / interval + limit2 / interval + 2))
                            : ((int) (limit1 - limit1 / interval + len / interval + 1));

                }

            }
        }

        return DataUtil.Integer2String(ret);
    }


    // dmp数据获取方式兼容（value1--新，value2--旧）
    public static String getDmpData(String value1, String value2) {

        String ret = value1;
        if (AssertUtil.isEmpty(value1) && AssertUtil.isNotEmpty(value2)) {
            ret = value2;
        }
        return ret;
    }

    // dmp数据获取方式兼容（value1--新，value2--旧）
    public static Long getDmpData(Long value1, Long value2) {

        Long ret = value1;
        if (AssertUtil.isNotEmpty(value2)) {
            if (AssertUtil.isEmpty(value1)) {
                ret = value2;

            }  else if (value2 > value1) {
                ret = value2;

            }
        }
        return ret;
    }


    // 用户行为映射规则
    public static String getClickTimesLevel(Long times) {

        Long ret = 0L;
        if (AssertUtil.isNotEmpty(times) && times >= 1L) {

            ret = times <= 7 ? times : 8;
        }
        return DataUtil.Long2String(ret);
    }


    public static String getExpTimesLevel(Long times) {

        Long ret = 0L;
        if (AssertUtil.isNotEmpty(times) && times >= 1L) {

          ret = times <= 10 ? times :
                  (times <= 20 ? (11 + (long)(times-10) / 2) :
                  (times <= 50 ? (17 + (long)(times-20) / 5) : 24));
        }
        return DataUtil.Long2String(ret);
    }


    public static String getBidTimesLevel(Long times) {

        Long ret = 0L;
        if (AssertUtil.isNotEmpty(times) && times >= 1L) {

            ret = times <= 10 ? times :
                    (times <= 50 ? (11 + (long)(times-10) / 5) :
                    (times <= 100 ? (20 + (long)(times-50) / 10) :
                    (times <= 200 ? (26 + (long)(times-100) / 20) : 32)));
        }
        return DataUtil.Long2String(ret);
    }


    // 用户行为映射规则
    public static Long getCntLevel(Long cnt, Long limit) {

        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty(cnt, limit)) {
            if (cnt == null || cnt < 1L) {
                ret = 0L;
            } else if (cnt <= limit) {
                ret = cnt;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }


    // dmp类目特征解析
    public static String getCategoryLevel(String catList, Integer limit, Integer interval) {

        String ret = null;

        if (AssertUtil.isAllNotEmpty(catList, limit, interval)) {

            String[] catArr = catList.split(",");

            Long[] retArr =  new Long[catArr.length];

            for (int i = 0; i < catArr.length; ++i) {

                Long level = 1L;
                Long value = DataUtil.string2Long(catArr[i]);

                if (AssertUtil.isNotEmpty(value) && value > 0) {
                    if (interval == 1) {
                        level = value > limit ? (limit + 2) : (value + 1);

                    } else {
                        level = value > limit ? ((long) (limit / interval) + 3) : ((long) (value / interval) + 2);

                    }
                }

                if (interval == 1) {
                    retArr[i] = i * (limit + 2L) + level;

                } else {
                    retArr[i] = i * (limit / interval + 3L) + level;
                }

            }

            ret = StringUtils.join(retArr,",");

        }
        return ret;
    }




    // dmp类目特征解析
    public static String getAppVectorLevel(String catList, Integer limit) {

        String ret = null;

        if (AssertUtil.isAllNotEmpty(catList, limit)) {

            String[] catArr = catList.split(",");

            Long[] retArr = new Long[catArr.length];

            for (int i = 0; i < catArr.length; ++i) {

                Long level = 1L;
                Long value = Math.round(DataUtil.string2Double(catArr[i])/0.5 * 100);

                if (AssertUtil.isNotEmpty(value) && value > 0) {
                    level = value;
                    retArr[i] = i * limit + level;

                }
            }

            ret = StringUtils.join(retArr, ",");

            }
            return ret;
        }


    // 用户交叉行为映射规则
    public static String getCrossLevel(Long cnt1, Long cnt2) {

        Long ret = 0L;
        if (AssertUtil.isNotEmpty(cnt1) && cnt1 > 0L) {
            ret = 1L;

            if (AssertUtil.isNotEmpty(cnt2) && cnt2 > 0L ) {
                ret = 2L;
            }

        } else {
            if (AssertUtil.isNotEmpty(cnt2) && cnt2 > 0L ) {
                ret = 3L;
            }

        }
        return DataUtil.Long2String(ret);
    }


    // 用户交叉行为映射值
    public static String getExpClickCrossValue(Long click, Long exp) {

        Long ret = 0L;
        Long clickLevel = DataUtil.string2Long(getClickTimesLevel(click));
        Long expLevel = DataUtil.string2Long(getExpTimesLevel(exp));

        if (AssertUtil.isAllNotEmpty(clickLevel, expLevel)) {
            ret = (clickLevel + 1) * 1000 + expLevel;
        }

        return DataUtil.Long2String(ret);
    }


    // 用户交叉行为映射值
    public static String getComCrossValue(Long id, Long click, Long exp) {

        String ret = null;
        String crossLevel = getExpClickCrossValue(click, exp);
        if (AssertUtil.isAllNotEmpty(id, crossLevel)) {
            ret = DataUtil.Long2String(id) + "&" + crossLevel;
        }

        return ret;
    }


    // adx特定数据获取
    public static String getAnyValue(Integer adxType,
                                     String aiQiYi, String mgTv, String baiDu) {
        String ret = null;

        if (AssertUtil.isNotEmpty(adxType)) {
            if (AdxTypeEnum.I_QI_YI.getType().equals(adxType)) {
                ret = aiQiYi;

            } else if (AdxTypeEnum.MONGO_TV.getType().equals(adxType)) {
                ret = mgTv;

            } else if (AdxTypeEnum.BAIDU_ALLIANCE.getType().equals(adxType)) {
                ret = baiDu;

            }
        }
        return ret;
    }


    // adx特定数据获取
    public static String getAnyValue(Integer adxType,
                                     Integer aiQiYi, Integer mgTv, Integer baiDu) {
        Integer ret = null;

        if (AssertUtil.isNotEmpty(adxType)) {
            if (AdxTypeEnum.I_QI_YI.getType().equals(adxType)) {
                ret = aiQiYi;

            } else if (AdxTypeEnum.MONGO_TV.getType().equals(adxType)) {
                ret = mgTv;

            } else if (AdxTypeEnum.BAIDU_ALLIANCE.getType().equals(adxType)) {
                ret = baiDu;

            }
        }
        return DataUtil.Integer2String(ret);
    }



    // adx特定数据获取
    public static String getCrossAnyValue(Integer adxType, Long groupId,
                                          Integer aiQiYi, Integer mgTv, Integer baiDu) {
        String retCross = null;
        Integer ret = null;

        if (AssertUtil.isNotEmpty(adxType)) {
            if (AdxTypeEnum.I_QI_YI.getType().equals(adxType)) {
                ret = aiQiYi;

            } else if (AdxTypeEnum.MONGO_TV.getType().equals(adxType)) {
                ret = mgTv;

            } else if (AdxTypeEnum.BAIDU_ALLIANCE.getType().equals(adxType)) {
                ret = baiDu;

            }
        }

        if (AssertUtil.isAllNotEmpty(groupId, ret)) {
            retCross = DataUtil.Long2String(groupId) + "&" +  DataUtil.Integer2String(ret);
        }

        return retCross;
    }



    // adx特定数据获取
    public static String getCrossAnyValuePlus(Integer adxType, Long groupId,
                                              Integer aiQiYi, Integer mgTv, String baiDu) {
        String retCross = null;
        String ret = null;

        if (AssertUtil.isNotEmpty(groupId)) {
            if (AdxTypeEnum.I_QI_YI.getType().equals(adxType)) {
                ret = DataUtil.Integer2String(aiQiYi);

            } else if (AdxTypeEnum.MONGO_TV.getType().equals(adxType)) {
                ret = DataUtil.Integer2String(mgTv);

            } else if (AdxTypeEnum.BAIDU_ALLIANCE.getType().equals(adxType)) {
                ret = baiDu;

            }
        }

        if (AssertUtil.isAllNotEmpty(groupId, ret)) {
            retCross = DataUtil.Long2String(groupId) + "&" + ret;
        }

        return retCross;
    }


    /**
     * 缺失情况，重置为defaultValue
     *
     * @param value
     * @param defaultValue
     * @return 默认值
     */
    public static String nullToDefault(String value, String defaultValue) {

        String ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }


    // adx特定数据获取
    public static String getMaterialFeature(List<AdxIdeaMaterialDo> materialList, String tag) {

        StringBuilder sb = new StringBuilder();

        if (AssertUtil.isNotEmpty(materialList)) {

            int size = materialList.size();
            for (int ind = 0; ind < size; ind++) {

                String id = null;
                AdxIdeaMaterialDo materialDo = materialList.get(ind);
                if (AssertUtil.isAllNotEmpty(materialDo, tag)) {

                    if (tag.equals("materialId")) {
                        id = DataUtil.Long2String(materialDo.getMaterialId());
                    } else if (tag.equals("effectType")) {
                        id = materialDo.getEffectType();
                    } else if (tag.equals("figureType")) {
                        id = materialDo.getFigureType();
                    } else if (tag.equals("customType")) {
                        id = materialDo.getCustomType();
                    } else if (tag.equals("materialIndustryTag")) {
                        id = materialDo.getMaterialIndustryTag();
                    } else if (tag.equals("slotType")) {
                        id = materialDo.getSlotType();
                    } else if (tag.equals("materialStrategy")) {
                        id = materialDo.getMaterialStrategy();
                    } else if (tag.equals("prizeElement")) {
                        id = materialDo.getPrizeElement();
                    } else if (tag.equals("designColor")) {
                        id = materialDo.getDesignColor();
                    } else if (tag.equals("designStyle")) {
                        id = materialDo.getDesignStyle();
                    } else if (tag.equals("dynamicEffect")) {
                        id = materialDo.getDynamicEffect();
                    } else if (tag.equals("textElement")) {
                        id = materialDo.getTextElement();
                    } else if (tag.equals("activityTool")) {
                        id = materialDo.getActivityTool();
                    } else if (tag.equals("season")) {
                        id = materialDo.getSeason();
                    } else if (tag.equals("festival")) {
                        id = materialDo.getFestival();
                    } else if (tag.equals("timing")) {
                        id = materialDo.getTiming();
                    } else if (tag.equals("scene")) {
                        id = materialDo.getScene();
                    }
                }

                String str = DataUtil.Integer2String(ind + 1) + '&' + nullToDefault(id, "-1");

                //逗号拼接
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(str);
            }
        }

        String ret = sb.toString();
        return ret;
    }


    /** dmp-用户性别数据获取方式兼容（value1--新，value2--旧）
     *  男:010101; 女:010102; 偏男:010103; 偏女:010104; 未知:010105;
     */
    public static String getDmpSexData(String value1, String value2) {

        String ret = value1;
        if (AssertUtil.isNotEmpty(value2)) {

            if (value2.equals("M")) {
                ret = "010101";
            } else if (value2.equals("F")) {
                ret = "010102";
            }
        }
        return nullToDefault(ret, "010105");
    }

}