package cn.com.duiba.nezha.alg.feature.vo;

import java.io.Serializable;
import lombok.Data;

/**
 * adx创意素材特征
 */

@Data
public class AdxIdeaMaterialDo implements Serializable {

    private static final long serialVersionUID = 1825123147647706974L;

    /**
     * 创意素材id
     */
    private Long materialId;

    /**
     * 素材效果分类（动态，静态，视频）
     */
    private String effectType;

    /**
     * 素材类型（单图，组图）
     */
    private String figureType;

    /**
     *  是否定制
     */
    private String customType;

    /**
     * 素材行业标签
     */
    private String materialIndustryTag;

    /**
     * 广告位性质
     */
    private String slotType;

    /**
     * 优质素材策略
     */
    private String materialStrategy;

    /**
     * 奖品元素
     */
    private String prizeElement;

    /**
     * 设计色调
     */
    private String designColor;

    /**
     * 设计风格
     */
    private String designStyle;

    /**
     * 设计动效
     */
    private String dynamicEffect;

    /**
     * 文案元素
     */
    private String textElement;

    /**
     *  活动工具
     */
    private String activityTool;

    /**
     * 季节标签
     */
    private String season;

    /**
     * 节日标签
     */
    private String festival;

    /**
     * 时间标签（周末，月初，月中，月末）
     */
    private String timing;

    /**
     * 使用场景
     */
    private String scene;
}
