/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AppFeature;
import cn.com.duiba.nezha.alg.feature.vo.ComponentInfo;
import cn.com.duiba.nezha.alg.feature.vo.DpFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialContextFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserFeature;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpFeatureParse {
    private static final Logger logger = LoggerFactory.getLogger(DpFeatureParse.class);
    public static int F_MAX_SIZE = 64;
    public static int[] userBehaviorBucket = new int[]{0, 1, 3, 5, 10, 15, 35, 50, 80};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = new int[]{1, 4, 8};
    public static double[] statCtrBucket = new double[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = new double[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static int[] slotMaterialTagExposeDayBucket = new int[]{3, 6, 10, 20, 50, 100, 500, 2000, 10000, 750000};
    public static int[] slotMaterialTagExposeHisBucket = new int[]{3, 12, 37, 103, 282, 843, 2612, 10716, 65838, 4978025};
    public static double[] userConBucket = new double[]{0.01, 0.05, 0.1, 0.5, 1.0, 3.0, 5.0, 10.0, 50.0, 100.0};
    public static double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static int[] slotSkinTypeExposeDayBucket = new int[]{1, 2, 5, 20, 80, 300, 1000, 2000, 8000, 30000};
    public static int[] slotSkinTypeExposeSevenBucket = new int[]{1, 4, 15, 63, 219, 770, 2293, 7241, 32396, 1026962};
    public static int[] slotSkinTypeExposeHisBucket = new int[]{1, 2, 4, 18, 111, 547, 2695, 11694, 57077, 3085582};
    public static int[] slotSkinTypeClickDayBucket = new int[]{1, 2, 3, 9, 28, 88, 180, 400, 1500, 5000};
    public static int[] slotSkinTypeClickSevenBucket = new int[]{2, 8, 24, 80, 272, 717, 1911, 5349, 22938, 864145};
    public static int[] slotSkinTypeClickHisBucket = new int[]{1, 4, 14, 54, 217, 896, 3155, 10601, 44939, 2458473};
    public static int[] slotRewardTagExposeDayBucket = new int[]{1, 2, 4, 8, 15, 30, 75, 220, 1200, 6000};
    public static int[] slotRewardTagExposeSevenBucket = new int[]{2, 4, 7, 14, 27, 58, 146, 507, 3001, 153710};
    public static int[] slotRewardTagExposeHisBucket = new int[]{2, 4, 9, 19, 39, 87, 226, 799, 6388, 448837};
    public static int[] slotRewardTagClickDayBucket = new int[]{1, 2, 3, 5, 10, 23, 60, 150, 800, 4800};
    public static int[] slotRewardTagClickSevenBucket = new int[]{2, 3, 7, 12, 23, 55, 132, 387, 2239, 126967};
    public static int[] slotRewardTagClickHisBucket = new int[]{2, 4, 9, 17, 35, 79, 199, 637, 4440, 220232};
    public static int[] appSkinTypeExposeDayBucket = new int[]{1, 2, 9, 35, 120, 400, 1200, 5000, 22000, 65000};
    public static int[] appSkinTypeExposeSevenBucket = new int[]{1, 3, 17, 83, 335, 1263, 3725, 12053, 59810, 1666682};
    public static int[] appSkinTypeExposeHisBucket = new int[]{1, 3, 17, 156, 823, 2025, 4229, 17325, 102025, 3854952};
    public static int[] appSkinTypeClickDayBucket = new int[]{1, 3, 9, 30, 100, 350, 700, 2100, 8500, 20000};
    public static int[] appSkinTypeClickSevenBucket = new int[]{2, 10, 34, 128, 408, 1058, 3607, 9581, 39887, 1055972};
    public static int[] appSkinTypeClickHisBucket = new int[]{1, 4, 18, 85, 356, 1317, 4375, 18299, 83998, 3017636};
    public static int[] appRewardTagExposeDayBucket = new int[]{1, 2, 5, 8, 15, 33, 120, 450, 2500, 100000};
    public static int[] appRewardTagExposeSevenBucket = new int[]{2, 4, 9, 17, 35, 82, 223, 837, 5324, 289787};
    public static int[] appRewardTagExposeHisBucket = new int[]{2, 4, 9, 23, 49, 119, 340, 1274, 11159, 682999};
    public static int[] appRewardTagClickDayBucket = new int[]{1, 2, 3, 5, 10, 23, 60, 150, 1000, 48000};
    public static int[] appRewardTagClickSevenBucket = new int[]{2, 4, 8, 15, 29, 70, 187, 599, 3560, 177802};
    public static int[] appRewardTagClickHisBucket = new int[]{2, 5, 10, 20, 42, 100, 303, 1025, 7421, 399933};
    public static Map<String, Integer> actSkinTypeCodes = new HashMap<String, Integer>(){
        {
            this.put("1", 0);
            this.put("2", 1);
            this.put("3", 2);
            this.put("4", 3);
            this.put("5", 4);
            this.put("6", 5);
            this.put("7", 6);
            this.put("8", 7);
            this.put("9", 8);
            this.put("10", 9);
            this.put("11", 10);
            this.put("12", 11);
            this.put("13", 12);
            this.put("14", 13);
            this.put("15", 14);
            this.put("16", 15);
            this.put("17", 16);
            this.put("18", 17);
            this.put("19", 18);
            this.put("20", 19);
            this.put("21", 20);
            this.put("22", 21);
            this.put("23", 22);
            this.put("24", 23);
            this.put("25", 24);
            this.put("26", 25);
            this.put("27", 26);
            this.put("28", 27);
            this.put("29", 28);
            this.put("30", 29);
            this.put("31", 30);
            this.put("32", 31);
            this.put("33", 32);
        }
    };
    public static Map<String, Integer> actRewardCodes = new HashMap<String, Integer>(){
        {
            this.put("29", 0);
            this.put("30", 1);
            this.put("31", 2);
            this.put("32", 3);
            this.put("33", 4);
            this.put("34", 5);
            this.put("35", 6);
            this.put("36", 7);
            this.put("37", 8);
            this.put("38", 9);
            this.put("39", 10);
            this.put("40", 11);
            this.put("41", 12);
            this.put("42", 13);
            this.put("43", 14);
        }
    };
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            this.put("8", 0);
            this.put("14", 1);
            this.put("15", 2);
            this.put("21", 3);
            this.put("20", 4);
            this.put("3", 5);
            this.put("5", 6);
            this.put("12", 7);
            this.put("2", 8);
            this.put("1", 9);
            this.put("24", 10);
            this.put("6", 11);
            this.put("7", 12);
            this.put("11", 13);
            this.put("13", 14);
            this.put("18", 15);
            this.put("22", 16);
            this.put("4", 17);
            this.put("17", 18);
            this.put("25", 19);
            this.put("10", 20);
            this.put("23", 21);
            this.put("9", 22);
            this.put("19", 23);
            this.put("16", 24);
        }
    };

    public static Map<String, String> generateDpFeatureMap(DpFeatureDo dpFeatureDo) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (dpFeatureDo != null) {
                Map<String, ComponentInfo> userToSlotRewardTagMap;
                Map<String, ComponentInfo> userToSlotActSkinMap;
                Map<String, ComponentInfo> appToRewardTagMap;
                Map<String, ComponentInfo> appToActSkinMap;
                Map<String, ComponentInfo> slotToRewardTagMap;
                Map<String, ComponentInfo> slotToActSkinMap;
                Map<String, ComponentInfo> userToRewardTagMap;
                UserFeature userFeature = Optional.ofNullable(dpFeatureDo.getUserFeature()).orElse(new UserFeature());
                Map<String, Map<String, Long>> ubpMap = DpFeatureParse.getUserBehavioralPreference(userFeature.getUIIds(), userFeature.getUILaunchPV(), userFeature.getUIClickPv(), userFeature.getUIEffectPv());
                DpFeatureParse.putMapNotNull(retMap, "f808001", DpFeatureParse.getUserBehavioralPreference(2, "ctr", ubpMap, null));
                DpFeatureParse.putMapNotNull(retMap, "f808002", DpFeatureParse.getUserBehavioralPreference(2, "cvr", ubpMap, null));
                SlotActFeature slotActFeature = Optional.ofNullable(dpFeatureDo.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject weekCtrTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekCtrTrade());
                DpFeatureParse.putMapNotNull(retMap, "f212003", DpFeatureParse.getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
                JSONObject weekCvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekCvrTrade());
                DpFeatureParse.putMapNotNull(retMap, "f214003", DpFeatureParse.getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
                retMap.put("f451004", userFeature.getConsumeLevel());
                retMap.put("f451006", userFeature.getPermanentCity());
                retMap.put("f9902", userFeature.getAppList());
                retMap.put("f9801", userFeature.getSigList());
                SlotFeature slotFeature = Optional.ofNullable(dpFeatureDo.getSlotFeature()).orElse(new SlotFeature());
                retMap.put("f108001", DataUtil.Long2String((Long)slotFeature.getSlotId()));
                AppFeature appFeature = Optional.ofNullable(dpFeatureDo.getAppFeature()).orElse(new AppFeature());
                retMap.put("f201001", DataUtil.Long2String((Long)appFeature.getAppId()));
                retMap.put("f205001", appFeature.getAppIndustryTagPid());
                retMap.put("f205002", appFeature.getAppIndustryTagId());
                MaterialContextFeature contextFeature = Optional.ofNullable(dpFeatureDo.getMaterialContextFeature()).orElse(new MaterialContextFeature());
                retMap.put("f503001", DataUtil.Long2String((Long)contextFeature.getCityId()));
                retMap.put("f503003", contextFeature.getProvinceCode());
                retMap.put("f504001", contextFeature.getModel());
                retMap.put("f411001", FeatureParse.bucket(userFeature.getActivityRequest(), cntBucket).toString());
                retMap.put("f411002", FeatureParse.bucket(userFeature.getWeekActivityRequest(), cntBucket).toString());
                retMap.put("f411004", FeatureParse.bucket(userFeature.getIntervalActivityRequest(), cntBucket).toString());
                retMap.put("f411005", userFeature.getPeriodActivityRequest());
                retMap.put("f412001", FeatureParse.bucket(userFeature.getActivityJoin(), cntBucket).toString());
                retMap.put("f412002", FeatureParse.bucket(userFeature.getWeekActivityJoin(), cntBucket).toString());
                retMap.put("f412004", FeatureParse.bucket(userFeature.getIntervalActivityJoin(), cntBucket).toString());
                retMap.put("f412005", userFeature.getPeriodActivityJoin());
                Map clickTraceActMap = DataUtil.stringToMap((String)userFeature.getClickTrade(), (Object)0);
                retMap.put("f414001", DpFeatureParse.getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
                Map weekClickTradeActMap = DataUtil.stringToMap((String)userFeature.getWeekClickTrade(), (Object)0);
                retMap.put("f414002", DpFeatureParse.getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
                retMap.put("f414004", FeatureParse.bucket(userFeature.getIntervalClickTrade(), cntBucket).toString());
                retMap.put("f414005", userFeature.getPeriodClickTrade());
                retMap.put("f414007", userFeature.getLastClickTrade());
                Map effectTradeActMap = DataUtil.stringToMap((String)userFeature.getEffectTrade(), (Object)0);
                retMap.put("f415001", DpFeatureParse.getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
                Map weekEffectTradeActMap = DataUtil.stringToMap((String)userFeature.getWeekEffectTrade(), (Object)0);
                retMap.put("f415002", DpFeatureParse.getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
                retMap.put("f415004", FeatureParse.bucket(userFeature.getIntervalEffectTrade(), cntBucket).toString());
                retMap.put("f415005", userFeature.getPeriodEffectTrade());
                retMap.put("f415007", userFeature.getLastEffectTrade());
                Map<String, ComponentInfo> userToActSkinMap = userFeature.getUserToActSkinMap();
                if (!AssertUtil.isEmpty(userToActSkinMap)) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(userToActSkinMap);
                    retMap.put("f391013", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391014", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391015", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391016", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391017", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391018", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(userToRewardTagMap = userFeature.getUserToRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(userToRewardTagMap);
                    retMap.put("f391019", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391020", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391021", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391022", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391023", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391024", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(slotToActSkinMap = slotFeature.getSlotToActSkinMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(slotToActSkinMap);
                    retMap.put("f391031", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, slotSkinTypeExposeDayBucket));
                    retMap.put("f391032", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, slotSkinTypeExposeSevenBucket));
                    retMap.put("f391033", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, slotSkinTypeExposeHisBucket));
                    retMap.put("f391034", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, slotSkinTypeClickDayBucket));
                    retMap.put("f391035", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, slotSkinTypeClickSevenBucket));
                    retMap.put("f391036", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, slotSkinTypeClickHisBucket));
                }
                if (!AssertUtil.isEmpty(slotToRewardTagMap = slotFeature.getSlotToRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(slotToRewardTagMap);
                    retMap.put("f391037", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, slotRewardTagExposeDayBucket));
                    retMap.put("f391038", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, slotRewardTagExposeSevenBucket));
                    retMap.put("f391039", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, slotRewardTagExposeHisBucket));
                    retMap.put("f391040", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, slotRewardTagClickDayBucket));
                    retMap.put("f391041", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, slotRewardTagClickSevenBucket));
                    retMap.put("f391042", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, slotRewardTagClickHisBucket));
                }
                if (!AssertUtil.isEmpty(appToActSkinMap = appFeature.getAppToActSkinMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(appToActSkinMap);
                    retMap.put("f391049", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actSkinTypeCodes, appSkinTypeExposeDayBucket));
                    retMap.put("f391050", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, appSkinTypeExposeSevenBucket));
                    retMap.put("f391051", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, appSkinTypeExposeHisBucket));
                    retMap.put("f391052", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actSkinTypeCodes, appSkinTypeClickDayBucket));
                    retMap.put("f391053", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, appSkinTypeClickSevenBucket));
                    retMap.put("f391054", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, appSkinTypeClickHisBucket));
                }
                if (!AssertUtil.isEmpty(appToRewardTagMap = appFeature.getAppToRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(appToRewardTagMap);
                    retMap.put("f391055", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(0), actRewardCodes, appRewardTagExposeDayBucket));
                    retMap.put("f391056", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, appRewardTagExposeSevenBucket));
                    retMap.put("f391057", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, appRewardTagExposeHisBucket));
                    retMap.put("f391058", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(3), actRewardCodes, appRewardTagClickDayBucket));
                    retMap.put("f391059", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, appRewardTagClickSevenBucket));
                    retMap.put("f391060", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, appRewardTagClickHisBucket));
                }
                if (!AssertUtil.isEmpty(userToSlotActSkinMap = slotFeature.getUserToSlotActSkinMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(userToSlotActSkinMap);
                    retMap.put("f391065", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391066", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391067", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actSkinTypeCodes, userBehaviorBucket));
                    retMap.put("f391068", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actSkinTypeCodes, userBehaviorBucket));
                }
                if (!AssertUtil.isEmpty(userToSlotRewardTagMap = slotFeature.getUserToSlotRewardTagMap())) {
                    Map<Integer, Map<String, Integer>> splitTimeMap = DpFeatureParse.getSplitTimeMap(userToSlotRewardTagMap);
                    retMap.put("f391069", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(1), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391070", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(2), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391071", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(4), actRewardCodes, userBehaviorBucket));
                    retMap.put("f391072", DpFeatureParse.getUserCategoryActLevelByBucket(splitTimeMap.get(5), actRewardCodes, userBehaviorBucket));
                }
            }
        }
        catch (Exception e) {
            logger.error("MaterialFeatureParse.generateFeatureMapStatic error:", (Throwable)e);
            logger.error(JSONObject.toJSONString((Object)dpFeatureDo));
        }
        return retMap;
    }

    public static Map<String, String> generateDpFeatureDynamic(DpFeatureDo dpFeatureDo) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (dpFeatureDo != null) {
            DpFeatureParse.putMapNotNull(retMap, "f241001", DataUtil.Long2String((Long)DpFeatureParse.bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActHistOrder(), userCvrBucket)));
            DpFeatureParse.putMapNotNull(retMap, "f241002", DataUtil.Long2String((Long)DpFeatureParse.bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActWeekOrder(), userCvrBucket)));
            DpFeatureParse.putMapNotNull(retMap, "f241003", DataUtil.Long2String((Long)DpFeatureParse.bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActDayOrder(), userCvrBucket)));
            DpFeatureParse.putMapNotNull(retMap, "f242001", DataUtil.Long2String((Long)DpFeatureParse.bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActHistConsumer(), userConBucket)));
            DpFeatureParse.putMapNotNull(retMap, "f242002", DataUtil.Long2String((Long)DpFeatureParse.bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActWeekConsumer(), userConBucket)));
            DpFeatureParse.putMapNotNull(retMap, "f242003", DataUtil.Long2String((Long)DpFeatureParse.bucket(dpFeatureDo.getRoutineActFeature().getCAppSlotActDayConsumer(), userConBucket)));
        }
        return retMap;
    }

    public static Map<String, String> generateDpFeatureDynamic(DpFeatureDo dpFeatureDo, Long activityId) {
        Map<String, String> retMap = DpFeatureParse.generateDpFeatureDynamic(dpFeatureDo);
        String routineActId = activityId.toString();
        if (!AssertUtil.isEmpty((String)routineActId)) {
            retMap.put("f301001", routineActId);
        }
        return retMap;
    }

    public static void putMapNotNull(Map<String, String> map, String key, String value) {
        if (map == null || StringUtils.isBlank((String)value)) {
            return;
        }
        map.put(key, value);
    }

    public static String subList(List<String> list) {
        if (AssertUtil.isEmpty(list)) {
            return null;
        }
        List<String> subList = list;
        if (list.size() > 30) {
            subList = subList.subList(list.size() - 30, list.size());
            return StringUtils.strip((String)subList.toString().replace(" ", ""), (String)"[]");
        }
        return StringUtils.strip((String)list.toString().replace(" ", ""), (String)"[]");
    }

    public static String sortSubList(String string) {
        if (AssertUtil.isEmpty((String)string)) {
            return null;
        }
        List<String> list = Arrays.asList(string.split(","));
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String[] array1 = o1.split("-");
                String[] array2 = o2.split("-");
                return array1[0].compareTo(array2[0]);
            }
        });
        ArrayList<String> newArray = new ArrayList<String>();
        for (String s : list) {
            if (s.split("-").length >= 2) {
                newArray.add(s.split("-")[1]);
                continue;
            }
            newArray.add(s);
        }
        return DpFeatureParse.subList(newArray);
    }

    private static Map<Integer, Map<String, Integer>> getSplitTimeMap(Map<String, ComponentInfo> componentInfoMap) {
        HashMap<Integer, Map<String, Integer>> splitMap = new HashMap<Integer, Map<String, Integer>>();
        for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
            String key = entry.getKey();
            ComponentInfo componentInfo = entry.getValue();
            Map firstMap = splitMap.getOrDefault(0, new HashMap());
            Map secMap = splitMap.getOrDefault(1, new HashMap());
            Map thirdMap = splitMap.getOrDefault(2, new HashMap());
            Map fourthMap = splitMap.getOrDefault(3, new HashMap());
            Map fifthMap = splitMap.getOrDefault(4, new HashMap());
            Map sixthMap = splitMap.getOrDefault(5, new HashMap());
            firstMap.put(key, DpFeatureParse.getValue(componentInfo.getCurrDayExpCnt()));
            secMap.put(key, DpFeatureParse.getValue(componentInfo.getCurrDayClickCnt()));
            thirdMap.put(key, DpFeatureParse.getValue(componentInfo.getLastSevenDaysExpCnt()));
            fourthMap.put(key, DpFeatureParse.getValue(componentInfo.getLastSevenDaysClickCnt()));
            fifthMap.put(key, DpFeatureParse.getValue(componentInfo.getHisExpCnt()));
            sixthMap.put(key, DpFeatureParse.getValue(componentInfo.getHisClickCnt()));
            splitMap.put(0, firstMap);
            splitMap.put(1, thirdMap);
            splitMap.put(2, fifthMap);
            splitMap.put(3, secMap);
            splitMap.put(4, fourthMap);
            splitMap.put(5, sixthMap);
        }
        return splitMap;
    }

    private static Integer getValue(Integer num) {
        if (num != null) {
            return num;
        }
        return 0;
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {
        String ret = null;
        try {
            Object tag;
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String((Long)ubpMap.get(statType).get("0"));
            }
            if (dimType == 1 && ubpMap != null && (tag = DpFeatureParse.getTag(tags)) != null) {
                ret = ubpMap.get(statType).get(tag) + "";
                if (((String)tag).length() == 10 && ret == null) {
                    String string = ((String)tag).substring(0, 5);
                    ret = DataUtil.Long2String((Long)ubpMap.get(statType).get(string));
                }
            }
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry entry : ubpMap.get(statType).entrySet()) {
                    String string = (String)entry.getKey() + "_" + entry.getValue() + ",";
                    ret = ret + string;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                HashMap<Long, Long> levelCntMap = new HashMap<Long, Long>();
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag2 = entry.getKey();
                    Long ctrLevel = DpFeatureParse.bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel == null || tag2 == "0") continue;
                    if (!levelCntMap.containsKey(ctrLevel)) {
                        levelCntMap.put(ctrLevel, 0L);
                    }
                    levelCntMap.put(ctrLevel, (Long)levelCntMap.get(ctrLevel) + 1L);
                }
                for (Map.Entry entry : levelCntMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Long cntLevel = DpFeatureParse.bucket((Long)entry.getValue(), cntBucket);
                    String v = (Long)entry.getKey() * 100L + cntLevel + ",";
                    ret = ret + v;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getTag(String tags) {
        Object[] tagArr;
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tags) && AssertUtil.isNotEmpty((Object[])(tagArr = tags.split(",")))) {
            for (int i = 0; i < tagArr.length; ++i) {
                String tmp = DpFeatureParse.validTag((String)tagArr[i]);
                if (tmp == null) continue;
                ret = DpFeatureParse.validTag((String)tagArr[i]);
            }
        }
        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tag) && tag.contains(".")) {
            ret = tag;
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds, String uILaunchPv, String uIClickPv, String uIEffectPv) {
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{uIIds, uILaunchPv, uIClickPv, uIEffectPv})) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");
            if (uIIdsArr.length > 0 && uIIdsArr.length == uILaunchPvArr.length && uIIdsArr.length == uIClickPvArr.length && uIIdsArr.length == uIEffectPvArr.length) {
                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;
                for (int i = 0; i < uIIdsArr.length; ++i) {
                    String id = uIIdsArr[i];
                    Long launchPv = DataUtil.str2Long((String)uILaunchPvArr[i], (Long)0L);
                    Long clickPv = DataUtil.str2Long((String)uIClickPvArr[i], (Long)0L);
                    Long effectPv = DataUtil.str2Long((String)uIEffectPvArr[i], (Long)0L);
                    Double ctr = DpFeatureParse.getCtrOrCvr(launchPv, clickPv);
                    Double cvr = DpFeatureParse.getCtrOrCvr(clickPv, effectPv);
                    Long ctrBucketLevel = DpFeatureParse.bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = DpFeatureParse.bucket(cvr, userCvrBucket);
                    ((Map)ret.get("ctr")).put(id, ctrBucketLevel);
                    ((Map)ret.get("cvr")).put(id, cvrBucketLevel);
                    launchAccPv = launchAccPv + launchPv;
                    clickAccPv = clickAccPv + clickPv;
                    effectAccPv = effectAccPv + effectPv;
                }
                Double ctr = DpFeatureParse.getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = DpFeatureParse.getCtrOrCvr(clickAccPv, effectAccPv);
                Long ctrBucketLevel = DpFeatureParse.bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = DpFeatureParse.bucket(cvr, userCvrBucket);
                ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
                ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
            }
        }
        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + DpFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cateKey : actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + DpFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }
}

