package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import javax.xml.crypto.Data;
import java.time.LocalDateTime;
import java.util.*;

/**
 * @author lijingzhe
 * @description DPA活动解析
 * @date 2020/6/17
 */
public class DPAActFeatureParse {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DPAActFeatureParse.class);

    public static int F_MAX_SIZE = 64;
    public static int[] cntBucket = {0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = {1, 4, 8};
    public static double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userConBucket = {0.01, 0.05, 0.1, 0.5, 1, 3, 5, 10, 50, 100};
    public static int[] videoDurationBucket = {0, 15, 30, 60, 5*60, 10*60, 15*60, 30*60, 45*60, 60*60, 90*60, 120*60};
    public static double[] cntRatioBucket = {0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
    public static double[] statCtrBucket = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static int[] cateScoreBucket = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20};

    public static Integer[] HUABEI_REGION = {80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = {81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = {82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = {83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = {84, 44, 45, 46};
    public static Integer[] XINAN_REGION = {85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = {86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = {87, 71, 8100, 8200};

    public static Integer[] FIRST_TIER_CITY = {11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = {1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = {1309,1303,1502,2202,3207,3209,3305,3412,3509,3611,3708,3703,4114,4110,4210,4307,4306,4407,4408,4601,5107,6104,1304,1302,1501,2306,3212,3210,3403,3407,3503,3607,3609,3713,4103,4107,4108,4206,4304,4302,4452,4412,4503,4602,5203,6301,1310,1305,2103,3208,3213,3211,3411,3402,3506,3604,3717,3710,4113,4115,4211,4205,4303,4451,4405,4404,4502,5106,5303,6401};


    public static Map<String, String> generateFeatureMapStatic(DPAActFeatureDo dpa) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if (dpa != null) {
            putMapNotNull(retMap, "f108001",DataUtil.Long2String(dpa.getSlotId()));
            putMapNotNull(retMap, "f201001",DataUtil.Long2String(dpa.getAppId()));
            putMapNotNull(retMap, "f501001", dpa.getUa());
            putMapNotNull(retMap, "f503001",DataUtil.Long2String(dpa.getAreaCode()));
            putMapNotNull(retMap, "f505001", dpa.getPriceSection());
            // 素材特征
            putMapNotNull(retMap, "390000", DataUtil.Long2String(dpa.getMaterialId()));
            /*
             * 地域解析
             */
            Long regionLevel = getRegionLevel(dpa.getAreaCode());
            putMapNotNull(retMap, "f401001", DataUtil.Long2String(regionLevel)); // 地区级别（华北/东北/华东/华中/华南/西南/西北/港澳）
            Long tierCityLevel = getTierCityLevel(dpa.getAreaCode());
            putMapNotNull(retMap, "f401002", DataUtil.Long2String(tierCityLevel)); // 城市级别（一线/二线/三线）

            Integer hour= LocalDateUtil.getHour(LocalDateTime.now());
            putMapNotNull(retMap, "f502001", DataUtil.Integer2String(hour)); // 访问请求创建时间-小时

            Integer weekDay = LocalDateUtil.getDayOfWeek(LocalDateTime.now());
            putMapNotNull(retMap, "f502002", DataUtil.Integer2String(weekDay)); // 访问请求创建时间-星期几
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapSlotAct(SlotActFeature slotActFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(slotActFeature != null) {
            // 点击
            JSONObject clickCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioTrade());
            putMapNotNull(retMap, "f211001", getUserCategoryActLevelByBucket(clickCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject clickCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioAccount());
            putMapNotNull(retMap, "f211002", getUserCategoryActLevelByBucket(clickCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject weekClickCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioTrade());
            putMapNotNull(retMap, "f211003", getUserCategoryActLevelByBucket(weekClickCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject weekClickCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioAccount());
            putMapNotNull(retMap, "f211004", getUserCategoryActLevelByBucket(weekClickCntRatioAccountMap, accountCodes, cntRatioBucket));

            JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
            putMapNotNull(retMap, "f212001", getUserCategoryActLevelByBucket(ctrTradeMap, tradeCodes, statCtrBucket));
            JSONObject ctrAccountMap = DataUtil.stringToJson(slotActFeature.getCtrAccount());
            putMapNotNull(retMap, "f212002", getUserCategoryActLevelByBucket(ctrAccountMap, accountCodes, statCtrBucket));
            JSONObject weekCtrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCtrTrade());
            putMapNotNull(retMap, "f212003", getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
            JSONObject weekCtrAccountMap = DataUtil.stringToJson(slotActFeature.getWeekCtrAccount());
            putMapNotNull(retMap, "f212004", getUserCategoryActLevelByBucket(weekCtrAccountMap, accountCodes, statCtrBucket));

            // 前端转化
            JSONObject convertCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioTrade());
            putMapNotNull(retMap, "f213001", getUserCategoryActLevelByBucket(convertCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject convertCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioAccount());
            putMapNotNull(retMap, "f213002", getUserCategoryActLevelByBucket(convertCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject weekConvertCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioTrade());
            putMapNotNull(retMap, "f213003", getUserCategoryActLevelByBucket(weekConvertCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject weekConvertCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioAccount());
            putMapNotNull(retMap, "f213004", getUserCategoryActLevelByBucket(weekConvertCntRatioAccountMap, accountCodes, cntRatioBucket));

            JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
            putMapNotNull(retMap, "f214001", getUserCategoryActLevelByBucket(cvrTradeMap, tradeCodes, statCvrBucket));
            JSONObject cvrAccountMap = DataUtil.stringToJson(slotActFeature.getCvrAccount());
            putMapNotNull(retMap, "f214002", getUserCategoryActLevelByBucket(cvrAccountMap, accountCodes, statCvrBucket));
            JSONObject weekCvrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCvrTrade());
            putMapNotNull(retMap, "f214003", getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
            JSONObject weekCvrAccountMap = DataUtil.stringToJson(slotActFeature.getWeekCvrAccount());
            putMapNotNull(retMap, "f214004", getUserCategoryActLevelByBucket(weekCvrAccountMap, accountCodes, statCvrBucket));

            //广告位消耗配置，只包含不受活动配置影响的配置信息
            putMapNotNull(retMap, "f820001", DataUtil.Integer2String(slotActFeature.getInterceptorStatus()));
            putMapNotNull(retMap, "f820002", DataUtil.Integer2String(slotActFeature.getBuoyStatus()));
            putMapNotNull(retMap, "f820003", DataUtil.Integer2String(slotActFeature.getRecommendStatus()));
            //增值需要结合活动信息判断
//            putMapNotNull(retMap, "f820004", DataUtil.Integer2String(slotActFeature.getEncStatus()));

            // 流量行为 -- 活动参与
            // 活动类型
//            JSONObject appSlotActsCateHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateHistClick());
//            putMapNotNull(retMap, "f230001", getCategoryJsonByBucket(appSlotActsCateHistClick, userCtrBucket));
//
//            JSONObject appSlotActsCateWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateWeekClick());
//            putMapNotNull(retMap, "f230002", getCategoryJsonByBucket(appSlotActsCateWeekClick, userCtrBucket));
//
//            putMapNotNull(retMap, "f230003", getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayClick(), userCtrBucket));
//
//            // 主标题
//            JSONObject appSlotMainTitlesHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesHistClick());
//            putMapNotNull(retMap, "f230004", getCategoryJsonByBucket(appSlotMainTitlesHistClick, userCtrBucket));
//
//            JSONObject appSlotMainTitlesWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesWeekClick());
//            putMapNotNull(retMap, "f230005", getCategoryJsonByBucket(appSlotMainTitlesWeekClick, userCtrBucket));
//
//            putMapNotNull(retMap, "f230006", getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayClick(), userCtrBucket));
//
//            // 副标题
//            JSONObject appSlotSubTitlesHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesHistClick());
//            putMapNotNull(retMap, "f230007", getCategoryJsonByBucket(appSlotSubTitlesHistClick, userCtrBucket));
//
//            JSONObject appSlotSubTitlesWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesWeekClick());
//            putMapNotNull(retMap, "f230008", getCategoryJsonByBucket(appSlotSubTitlesWeekClick, userCtrBucket));
//
//            putMapNotNull(retMap, "f230009", getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayClick(), userCtrBucket));
//
//            // 奖品
//            JSONObject appSlotPrizeHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeHistClick());
//            putMapNotNull(retMap, "f230010", getCategoryJsonByBucket(appSlotPrizeHistClick, userCtrBucket));
//
//            JSONObject appSlotPrizeWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeWeekClick());
//            putMapNotNull(retMap, "f230011", getCategoryJsonByBucket(appSlotPrizeWeekClick, userCtrBucket));
//
//            putMapNotNull(retMap, "f230012", getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayClick(), userCtrBucket));
//
            // 活动皮肤
//            JSONObject appSlotSkinCateHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateHistClick());
//            putMapNotNull(retMap, "f230013", getCategoryJsonByBucket(appSlotSkinCateHistClick, userCtrBucket));
//
//            JSONObject appSlotSkinCateWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateWeekClick());
//            putMapNotNull(retMap, "f230014", getCategoryJsonByBucket(appSlotSkinCateWeekClick, userCtrBucket));
//
//            putMapNotNull(retMap, "f230015", getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayClick(), userCtrBucket));
//
//            // 历史不同行业标签（媒体）类型上的参与率
//            JSONObject appSlotMediaCateHistClick = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateHistClick());
//            putMapNotNull(retMap, "f230016", getCategoryJsonByBucket(appSlotMediaCateHistClick, userCtrBucket));
//
//            JSONObject appSlotMediaCateWeekClick = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateWeekClick());
//            putMapNotNull(retMap, "f230017", getCategoryJsonByBucket(appSlotMediaCateWeekClick, userCtrBucket));
//
//            putMapNotNull(retMap, "f230018", getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayClick(), userCtrBucket));








            // 落地页转化/活动访问
            // 活动类型
//            JSONObject appSlotActsCateHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateHistOrder());
//            putMapNotNull(retMap, "f231001", getCategoryJsonByBucket(appSlotActsCateHistOrder, userCvrBucket));
//
//            JSONObject appSlotActsCateWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateWeekOrder());
//            putMapNotNull(retMap, "f231002", getCategoryJsonByBucket(appSlotActsCateWeekOrder, userCvrBucket));
//
//            putMapNotNull(retMap, "f231003", getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayOrder(), userCvrBucket));
//
//            // 主标题
//            JSONObject appSlotMainTitlesHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesHistOrder());
//            putMapNotNull(retMap, "f231004", getCategoryJsonByBucket(appSlotMainTitlesHistOrder, userCvrBucket));
//
//            JSONObject appSlotMainTitlesWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesWeekOrder());
//            putMapNotNull(retMap, "f231005", getCategoryJsonByBucket(appSlotMainTitlesWeekOrder, userCvrBucket));
//
//            putMapNotNull(retMap, "f231006", getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayOrder(), userCvrBucket));
//
//            // 副标题
//            JSONObject appSlotSubTitlesHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesHistOrder());
//            putMapNotNull(retMap, "f231007", getCategoryJsonByBucket(appSlotSubTitlesHistOrder, userCvrBucket));
//
//            JSONObject appSlotSubTitlesWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesWeekOrder());
//            putMapNotNull(retMap, "f231008", getCategoryJsonByBucket(appSlotSubTitlesWeekOrder, userCvrBucket));
//
//            putMapNotNull(retMap, "f231009", getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayOrder(), userCvrBucket));
//
//            // 奖品
//            JSONObject appSlotPrizeHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeHistOrder());
//            putMapNotNull(retMap, "f231010", getCategoryJsonByBucket(appSlotPrizeHistOrder, userCvrBucket));
//
//            JSONObject appSlotPrizeWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeWeekOrder());
//            putMapNotNull(retMap, "f231011", getCategoryJsonByBucket(appSlotPrizeWeekOrder, userCvrBucket));
//
//            putMapNotNull(retMap, "f231012", getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayOrder(), userCvrBucket));
//
//            // 活动皮肤
//            JSONObject appSlotSkinCateHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateHistOrder());
//            putMapNotNull(retMap, "f231013", getCategoryJsonByBucket(appSlotSkinCateHistOrder, userCvrBucket));
//
//            JSONObject appSlotSkinCateWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateWeekOrder());
//            putMapNotNull(retMap, "f231014", getCategoryJsonByBucket(appSlotSkinCateWeekOrder, userCvrBucket));
//
//            putMapNotNull(retMap, "f231015", getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayOrder(), userCvrBucket));
//
//            // 历史不同行业标签（媒体）类型上的参与率
//            JSONObject appSlotMediaCateHistOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateHistOrder());
//            putMapNotNull(retMap, "f231016", getCategoryJsonByBucket(appSlotMediaCateHistOrder, userCvrBucket));
//
//            JSONObject appSlotMediaCateWeekOrder = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateWeekOrder());
//            putMapNotNull(retMap, "f231017", getCategoryJsonByBucket(appSlotMediaCateWeekOrder, userCvrBucket));
//
//            putMapNotNull(retMap, "f231018", getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayOrder(), userCvrBucket));


            // 实时落地页转化/活动访问
            // 活动类型
            // 实时活动参与


            // 奖品





//            // 消耗
//            // 活动类型
//            JSONObject appSlotActsCateHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateHistConsumer());
//            putMapNotNull(retMap, "f232001", getCategoryJsonByBucket(appSlotActsCateHistConsumer, userConBucket));
//
//            JSONObject appSlotActsCateWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotActsCateWeekConsumer());
//            putMapNotNull(retMap, "f232002", getCategoryJsonByBucket(appSlotActsCateWeekConsumer, userConBucket));
//
//            putMapNotNull(retMap, "f232003", getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayConsumer(), userConBucket));
//
//            // 主标题
//            JSONObject appSlotMainTitlesHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesHistConsumer());
//            putMapNotNull(retMap, "f232004", getCategoryJsonByBucket(appSlotMainTitlesHistConsumer, userConBucket));
//
//            JSONObject appSlotMainTitlesWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotMainTitlesWeekConsumer());
//            putMapNotNull(retMap, "f232005", getCategoryJsonByBucket(appSlotMainTitlesWeekConsumer, userConBucket));
//
//            putMapNotNull(retMap, "f232006", getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayConsumer(), userConBucket));
//
//            // 副标题
//            JSONObject appSlotSubTitlesHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesHistConsumer());
//            putMapNotNull(retMap, "f232007", getCategoryJsonByBucket(appSlotSubTitlesHistConsumer, userConBucket));
//
//            JSONObject appSlotSubTitlesWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotSubTitlesWeekConsumer());
//            putMapNotNull(retMap, "f232008", getCategoryJsonByBucket(appSlotSubTitlesWeekConsumer, userConBucket));
//
//            putMapNotNull(retMap, "f232009", getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayConsumer(), userConBucket));
//
//            // 奖品
//            JSONObject appSlotPrizeHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeHistConsumer());
//            putMapNotNull(retMap, "f232010", getCategoryJsonByBucket(appSlotPrizeHistConsumer, userConBucket));
//
//            JSONObject appSlotPrizeWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotPrizeWeekConsumer());
//            putMapNotNull(retMap, "f232011", getCategoryJsonByBucket(appSlotPrizeWeekConsumer, userConBucket));
//
//            putMapNotNull(retMap, "f232012", getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayConsumer(), userConBucket));
//
//            // 活动皮肤
//            JSONObject appSlotSkinCateHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateHistConsumer());
//            putMapNotNull(retMap, "f232013", getCategoryJsonByBucket(appSlotSkinCateHistConsumer, userConBucket));
//
//            JSONObject appSlotSkinCateWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotSkinCateWeekConsumer());
//            putMapNotNull(retMap, "f232014", getCategoryJsonByBucket(appSlotSkinCateWeekConsumer, userConBucket));
//
//            putMapNotNull(retMap, "f232015", getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayConsumer(), userConBucket));
//
//            // 历史不同行业标签（媒体）类型上的参与率
//            JSONObject appSlotMediaCateHistConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateHistConsumer());
//            putMapNotNull(retMap, "f232016", getCategoryJsonByBucket(appSlotMediaCateHistConsumer, userConBucket));
//
//            JSONObject appSlotMediaCateWeekConsumer = DataUtil.stringToJson(slotActFeature.getAppSlotMediaCateWeekConsumer());
//            putMapNotNull(retMap, "f232017", getCategoryJsonByBucket(appSlotMediaCateWeekConsumer, userConBucket));
//
//            putMapNotNull(retMap, "f232018", getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayConsumer(), userConBucket));

            // 实时 UV消耗
            // 活动类型


            // 行业点击率
//            putMapNotNull(retMap, "f211005", getCategoryMapByBucket(slotActFeature.getDayTradeClickPart(), userCtrBucket));
//            putMapNotNull(retMap, "f211006", getCategoryMapByBucket(slotActFeature.getDayAccountClickPart(), userCtrBucket));
//            putMapNotNull(retMap, "f212005", getCategoryMapByBucket(slotActFeature.getDayTradeClickPart(), userCtrBucket));
//            putMapNotNull(retMap, "f212006", getCategoryMapByBucket(slotActFeature.getDayAccountClickPart(), userCtrBucket));
//            putMapNotNull(retMap, "f213005", getCategoryMapByBucket(slotActFeature.getDayTradeOrderPart(), userCvrBucket));
//            putMapNotNull(retMap, "f213006", getCategoryMapByBucket(slotActFeature.getDayAccountOrderPart(), userCvrBucket));
//            putMapNotNull(retMap, "f214005", getCategoryMapByBucket(slotActFeature.getDayTradeOrderRate(), userCvrBucket));
//            putMapNotNull(retMap, "f214006", getCategoryMapByBucket(slotActFeature.getDayAccountOrderRate(), userCvrBucket));

        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapUserProfile(UserProfileFeature userProfileFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(userProfileFeature != null) {
            putMapNotNull(retMap, "f451001", userProfileFeature.getSex());
            putMapNotNull(retMap, "f451002", userProfileFeature.getAge());
            putMapNotNull(retMap, "f451003", userProfileFeature.getMarry());
            putMapNotNull(retMap, "f451004", userProfileFeature.getConsumeLevel());
            Map<String, Integer> appCatePrefMap = DataUtil.stringToMap(userProfileFeature.getAppCatePref(), 0);
            putMapNotNull(retMap, "f461001", getUserCategoryActLevelByBucket(appCatePrefMap, appCodes, cntBucket));
            Map<String, Integer> recentAppCatePrefMap = DataUtil.stringToMap(userProfileFeature.getRecentAppCatePref(), 0);
            putMapNotNull(retMap, "f461002", getUserCategoryActLevelByBucket(recentAppCatePrefMap, appCodes, cntBucket));
            Map<String, Integer> recentTextCatePrefMap = DataUtil.stringToMap(userProfileFeature.getRecentTextCatePref(), 0);
            putMapNotNull(retMap, "f461004", getUserCategoryActLevelByBucket(recentTextCatePrefMap, msgSigCodes, cntBucket));
            Map<String, Integer> keywordCatePrefMap = DataUtil.stringToMap(userProfileFeature.getKeywordCatePref(), 0);
            putMapNotNull(retMap, "f461005", getUserCategoryActLevelByBucket(keywordCatePrefMap, keywordCodes, cntBucket));
            putMapNotNull(retMap, "f461011", userProfileFeature.getRecentVideoKeywordPref());
            Map<String, Integer> scoreCateInterestMap = DataUtil.stringToMap(userProfileFeature.getScoreCateInterest(), 0);
            putMapNotNull(retMap, "f471003", getUserCategoryActLevelByBucket(scoreCateInterestMap, resourceCodes, cateScoreBucket));
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapBase(FeatureDo fd) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(fd != null) {
//            putMapNotNull(retMap, "f9921", fd.getUICtr());
//            putMapNotNull(retMap, "f9922", fd.getUICvr());
//            putMapNotNull(retMap, "f9923", fd.getUUnICtr());
//            putMapNotNull(retMap, "f9924", fd.getUUnICvr());
            Map<String, Map<String, Long>> ubpMap = getUserBehavioralPreference(
                    fd.getUIIds(), fd.getUILaunchPV(), fd.getUIClickPv(), fd.getUIEffectPv());

            putMapNotNull(retMap, "f808001", getUserBehavioralPreference(2, "ctr", ubpMap, null));
//            putMapNotNull(retMap, "f809001", getUserBehavioralPreference(0, "ctr", ubpMap, null));
//            putMapNotNull(retMap, "f811001", getUserBehavioralPreference(3, "ctr", ubpMap, null));
            putMapNotNull(retMap, "f808002", getUserBehavioralPreference(2, "cvr", ubpMap, null));
//            putMapNotNull(retMap, "f809002", getUserBehavioralPreference(0, "cvr", ubpMap, null));
//            putMapNotNull(retMap, "f811002", getUserBehavioralPreference(3, "cvr", ubpMap, null));

        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapUserAct(UserActFeature userActFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(userActFeature != null) {
            // 生命周期
            putMapNotNull(retMap, "f410001", DataUtil.Long2String(bucket(userActFeature.getUserActiveDays(), cntBucket)));

            // 活动访问
            putMapNotNull(retMap, "f411001", DataUtil.Long2String(bucket(userActFeature.getActivityRequest(), cntBucket)));
            putMapNotNull(retMap, "f411002", DataUtil.Long2String(bucket(userActFeature.getWeekActivityRequest(), cntBucket)));
            putMapNotNull(retMap, "f411003", DataUtil.Long2String(bucket(userActFeature.getDayActivityRequest(), cntBucket)));
            putMapNotNull(retMap, "f411004", DataUtil.Long2String(bucket(userActFeature.getIntervalActivityRequest(), cntBucket)));
            putMapNotNull(retMap, "f411005", userActFeature.getPeriodActivityRequest());

            // 活动参与
            putMapNotNull(retMap, "f412001", DataUtil.Long2String(bucket(userActFeature.getActivityJoin(), cntBucket)));
            putMapNotNull(retMap, "f412002", DataUtil.Long2String(bucket(userActFeature.getWeekActivityJoin(), cntBucket)));
            putMapNotNull(retMap, "f412003", DataUtil.Long2String(bucket(userActFeature.getDayActivityJoin(), cntBucket)));
            putMapNotNull(retMap, "f412004", DataUtil.Long2String(bucket(userActFeature.getIntervalActivityJoin(), cntBucket)));
            putMapNotNull(retMap, "f412005", userActFeature.getPeriodActivityJoin());

            // 点击
            Map<String, Integer> clickTraceActMap = DataUtil.stringToMap(userActFeature.getClickTrade(), 0);
            putMapNotNull(retMap, "f414001", getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
            Map<String, Integer> weekClickTradeActMap = DataUtil.stringToMap(userActFeature.getWeekClickTrade(), 0);
            putMapNotNull(retMap, "f414002", getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
            putMapNotNull(retMap, "f414003", getUserCategoryActLevelByBucket(userActFeature.getDayClickTrade(), tradeCodes, cntBucket));
            putMapNotNull(retMap, "f414004", DataUtil.Long2String(bucket(userActFeature.getIntervalClickTrade(), cntBucket)));
            putMapNotNull(retMap, "f414005", userActFeature.getPeriodClickTrade());
            putMapNotNull(retMap, "f414007", userActFeature.getLastClickTrade());
            putMapNotNull(retMap, "f414008", DataUtil.Integer2String(userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade()));

            // 转化
            Map<String, Integer> effectTradeActMap = DataUtil.stringToMap(userActFeature.getEffectTrade(), 0);
            putMapNotNull(retMap, "f415001", getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
            Map<String, Integer> weekEffectTradeActMap = DataUtil.stringToMap(userActFeature.getWeekEffectTrade(), 0);
            putMapNotNull(retMap, "f415002", getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
            putMapNotNull(retMap, "f415003", getUserCategoryActLevelByBucket(userActFeature.getDayEffectTrade(), tradeCodes, cntBucket));
            putMapNotNull(retMap, "f415004", DataUtil.Long2String(bucket(userActFeature.getIntervalEffectTrade(), cntBucket)));
            putMapNotNull(retMap, "f415005", userActFeature.getPeriodEffectTrade());
            putMapNotNull(retMap, "f415007", userActFeature.getLastEffectTrade());

            putMapNotNull(retMap, "f462002", DataUtil.Long2String(bucket(userActFeature.getLastVideoTime(), videoDurationBucket)));
            putMapNotNull(retMap, "f462003", userActFeature.getLastVideoChannel());
            putMapNotNull(retMap, "f462004", userActFeature.getLastVideoInfo());

//            // --- DPA 2期
//            // 用户素材曝光行为
//            JSONObject histEntrancesExposeTime = DataUtil.stringToJson(userActFeature.getHistEntrancesExposeTime());
//            putMapNotNull(retMap, "f481001", getCategoryJsonByBucket(histEntrancesExposeTime, cntBucket));
//
//            JSONObject weekEntrancesExposeTime = DataUtil.stringToJson(userActFeature.getWeekEntrancesExposeTime());
//            putMapNotNull(retMap, "f481002", getCategoryJsonByBucket(weekEntrancesExposeTime, cntBucket));
//
//            putMapNotNull(retMap, "f481003", getCategoryMapByBucket(userActFeature.getDayEntrancesExposeTime(), cntBucket));
//
//            JSONObject materialExposeInterval = DataUtil.stringToJson(userActFeature.getMaterialExposeInterval());
//            putMapNotNull(retMap, "f481004", getCategoryJsonByBucket(materialExposeInterval, cntBucket));
//

            // 用户素材曝光行为
            // 活动类型
//            putMapNotNull(retMap, "f491001", DataUtil.Long2String(bucket(userActFeature.getCHistEntrancesExposeTime(), cntBucket)));
//
//            putMapNotNull(retMap, "f491002", DataUtil.Long2String(bucket(userActFeature.getCWeekEntrancesExposeTime(), cntBucket)));
//
//            putMapNotNull(retMap, "f491003", DataUtil.Long2String(bucket(userActFeature.getCDayEntrancesExposeTime(), cntBucket)));
//
//            putMapNotNull(retMap, "f491004", DataUtil.Long2String(bucket(userActFeature.getCMaterialExposeInterval(), cntBucket)));

//            JSONObject materialExposePeriod = DataUtil.stringToJson(userActFeature.getMaterialExposePeriod());
//            putMapNotNull(retMap, "f481005", getStringsToBuckets(materialExposePeriod, 7));
//
//            // 用户素材点击行为
//            JSONObject histEntrancesClickTime = DataUtil.stringToJson(userActFeature.getHistEntrancesClickTime());
//            putMapNotNull(retMap, "f482001", getCategoryJsonByBucket(histEntrancesClickTime, cntBucket));
//
//            JSONObject weekEntrancesClickTime = DataUtil.stringToJson(userActFeature.getWeekEntrancesClickTime());
//            putMapNotNull(retMap, "f482002", getCategoryJsonByBucket(weekEntrancesClickTime, cntBucket));
//
//            putMapNotNull(retMap, "f482003", getCategoryMapByBucket(userActFeature.getDayEntrancesClickTime(), cntBucket));
//
//            JSONObject materialClickInterval = DataUtil.stringToJson(userActFeature.getMaterialClickInterval());
//            putMapNotNull(retMap, "f482004", getCategoryJsonByBucket(materialClickInterval, cntBucket));
//
//            JSONObject materialClickPeriod = DataUtil.stringToJson(userActFeature.getMaterialClickPeriod());
//            putMapNotNull(retMap, "f482005", getStringsToBuckets(materialClickPeriod, 7));


            // 用户素材点击行为
//            putMapNotNull(retMap, "f492001", DataUtil.Long2String(bucket(userActFeature.getCHistEntrancesClickTime(), cntBucket)));
//
//            putMapNotNull(retMap, "f492002", DataUtil.Long2String(bucket(userActFeature.getCWeekEntrancesClickTime(), cntBucket)));
//
//            putMapNotNull(retMap, "f492003", DataUtil.Long2String(bucket(userActFeature.getCDayEntrancesClickTime(), cntBucket)));
//
//            putMapNotNull(retMap, "f492004", DataUtil.Long2String(bucket(userActFeature.getCMaterialClickInterval(), cntBucket)));

//            // 用户组件曝光
//            // 主标题
//            JSONObject histMainTitlesExposeTime = DataUtil.stringToJson(userActFeature.getHistMainTitlesExposeTime());
//            putMapNotNull(retMap, "f483001", getCategoryJsonByBucket(histMainTitlesExposeTime, cntBucket));
//
//            JSONObject weekMainTitlesExposeTime = DataUtil.stringToJson(userActFeature.getWeekMainTitlesExposeTime());
//            putMapNotNull(retMap, "f483001", getCategoryJsonByBucket(weekMainTitlesExposeTime, cntBucket));
//
//            putMapNotNull(retMap, "f483003", getCategoryMapByBucket(userActFeature.getDayMainTitlesExposeTime(), cntBucket));
//
//            // 副标题
//            JSONObject histSubTitlesExposeTime = DataUtil.stringToJson(userActFeature.getHistSubTitlesExposeTime());
//            putMapNotNull(retMap, "f483004", getCategoryJsonByBucket(histSubTitlesExposeTime, cntBucket));
//
//            JSONObject weekSubTitlesExposeTime = DataUtil.stringToJson(userActFeature.getWeekSubTitlesExposeTime());
//            putMapNotNull(retMap, "f483005", getCategoryJsonByBucket(weekSubTitlesExposeTime, cntBucket));
//
//            putMapNotNull(retMap, "f483006", getCategoryMapByBucket(userActFeature.getDaySubTitlesExposeTime(), cntBucket));
//
//            // 奖品
//            JSONObject histPrizesExposeTime = DataUtil.stringToJson(userActFeature.getHistPrizesExposeTime());
//            putMapNotNull(retMap, "f483007", getCategoryJsonByBucket(histPrizesExposeTime, cntBucket));
//
//            JSONObject weekPrizesExposeTime = DataUtil.stringToJson(userActFeature.getWeekPrizesExposeTime());
//            putMapNotNull(retMap, "f483008", getCategoryJsonByBucket(weekPrizesExposeTime, cntBucket));
//
//            putMapNotNull(retMap, "f483009", getCategoryMapByBucket(userActFeature.getDayPrizesExposeTime(), cntBucket));
//
//            // 皮肤
//            JSONObject histSkinsExposeTime = DataUtil.stringToJson(userActFeature.getHistSkinsExposeTime());
//            putMapNotNull(retMap, "f483010", getCategoryJsonByBucket(histSkinsExposeTime, cntBucket));
//
//            JSONObject weekSkinsExposeTime = DataUtil.stringToJson(userActFeature.getWeekSkinsExposeTime());
//            putMapNotNull(retMap, "f483011", getCategoryJsonByBucket(weekSkinsExposeTime, cntBucket));
//
//            putMapNotNull(retMap, "f483012", getCategoryMapByBucket(userActFeature.getDaySkinsExposeTime(), cntBucket));
//




//            // 用户组件活动参与
//            // 主标题
//            JSONObject histMainTitlesClickTime = DataUtil.stringToJson(userActFeature.getHistMainTitlesClickTime());
//            putMapNotNull(retMap, "f484001", getCategoryJsonByBucket(histMainTitlesClickTime, cntBucket));
//
//            JSONObject weekMainTitlesClickTime = DataUtil.stringToJson(userActFeature.getWeekMainTitlesClickTime());
//            putMapNotNull(retMap, "f484001", getCategoryJsonByBucket(weekMainTitlesClickTime, cntBucket));
//
//            putMapNotNull(retMap, "f484003", getCategoryMapByBucket(userActFeature.getDayMainTitlesClickTime(), cntBucket));
//
//            // 副标题
//            JSONObject histSubTitlesClickTime = DataUtil.stringToJson(userActFeature.getHistSubTitlesClickTime());
//            putMapNotNull(retMap, "f484004", getCategoryJsonByBucket(histSubTitlesClickTime, cntBucket));
//
//            JSONObject weekSubTitlesClickTime = DataUtil.stringToJson(userActFeature.getWeekSubTitlesClickTime());
//            putMapNotNull(retMap, "f484005", getCategoryJsonByBucket(weekSubTitlesClickTime, cntBucket));
//
//            putMapNotNull(retMap, "f484006", getCategoryMapByBucket(userActFeature.getDaySubTitlesClickTime(), cntBucket));
//
//            // 奖品
//            JSONObject histPrizesClickTime = DataUtil.stringToJson(userActFeature.getHistPrizesClickTime());
//            putMapNotNull(retMap, "f484007", getCategoryJsonByBucket(histPrizesClickTime, cntBucket));
//
//            JSONObject weekPrizesClickTime = DataUtil.stringToJson(userActFeature.getWeekPrizesClickTime());
//            putMapNotNull(retMap, "f484008", getCategoryJsonByBucket(weekPrizesClickTime, cntBucket));
//
//            putMapNotNull(retMap, "f484009", getCategoryMapByBucket(userActFeature.getDayPrizesClickTime(), cntBucket));
//
//            // 皮肤
//            JSONObject histSkinsClickTime = DataUtil.stringToJson(userActFeature.getHistSkinsClickTime());
//            putMapNotNull(retMap, "f484010", getCategoryJsonByBucket(histSkinsClickTime, cntBucket));
//
//            JSONObject weekSkinsClickTime = DataUtil.stringToJson(userActFeature.getWeekSkinsClickTime());
//            putMapNotNull(retMap, "f484011", getCategoryJsonByBucket(weekSkinsClickTime, cntBucket));
//
//            putMapNotNull(retMap, "f484012", getCategoryMapByBucket(userActFeature.getDaySkinsClickTime(), cntBucket));

            // 用户组件曝光



//            // 用户组件落地页转化
//            // 主标题
//            JSONObject histMainTitlesOrderTime = DataUtil.stringToJson(userActFeature.getHistMainTitlesOrderTime());
//            putMapNotNull(retMap, "f485001", getCategoryJsonByBucket(histMainTitlesOrderTime, cntBucket));
//
//            JSONObject weekMainTitlesOrderTime = DataUtil.stringToJson(userActFeature.getWeekMainTitlesOrderTime());
//            putMapNotNull(retMap, "f485002", getCategoryJsonByBucket(weekMainTitlesOrderTime, cntBucket));
//
//            putMapNotNull(retMap, "f485003", getCategoryMapByBucket(userActFeature.getDayMainTitlesOrderTime(), cntBucket));
//
//            // 副标题
//            JSONObject histSubTitlesOrderTime = DataUtil.stringToJson(userActFeature.getHistSubTitlesOrderTime());
//            putMapNotNull(retMap, "f485004", getCategoryJsonByBucket(histSubTitlesOrderTime, cntBucket));
//
//            JSONObject weekSubTitlesOrderTime = DataUtil.stringToJson(userActFeature.getWeekSubTitlesOrderTime());
//            putMapNotNull(retMap, "f485005", getCategoryJsonByBucket(weekSubTitlesOrderTime, cntBucket));
//
//            putMapNotNull(retMap, "f485006", getCategoryMapByBucket(userActFeature.getDaySubTitlesOrderTime(), cntBucket));
//
//            // 奖品
//            JSONObject histPrizesOrderTime = DataUtil.stringToJson(userActFeature.getHistPrizesOrderTime());
//            putMapNotNull(retMap, "f485007", getCategoryJsonByBucket(histPrizesOrderTime, cntBucket));
//
//            JSONObject weekPrizesOrderTime = DataUtil.stringToJson(userActFeature.getWeekPrizesOrderTime());
//            putMapNotNull(retMap, "f485008", getCategoryJsonByBucket(weekPrizesOrderTime, cntBucket));
//
//            putMapNotNull(retMap, "f485009", getCategoryMapByBucket(userActFeature.getDayPrizesOrderTime(), cntBucket));
//
//            // 皮肤
//            JSONObject histSkinsOrderTime = DataUtil.stringToJson(userActFeature.getHistSkinsOrderTime());
//            putMapNotNull(retMap, "f485010", getCategoryJsonByBucket(histSkinsOrderTime, cntBucket));
//
//            JSONObject weekSkinsOrderTime = DataUtil.stringToJson(userActFeature.getWeekSkinsOrderTime());
//            putMapNotNull(retMap, "f485011", getCategoryJsonByBucket(weekSkinsOrderTime, cntBucket));
//
//            putMapNotNull(retMap, "f485012", getCategoryMapByBucket(userActFeature.getDaySkinsOrderTime(), cntBucket));
            // 用户组件曝光


        }

        return retMap;
    }

    public static Map<String, String> generateInterceptFeaturemapDynamic(CandidateInterceptDo candidateInterceptDo){
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if(retMap != null) {
            putMapNotNull(retMap, "f301001", DataUtil.Long2String(candidateInterceptDo.getActivityId()));
            putMapNotNull(retMap, "f240001", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActHistClick(), userCtrBucket)));
            putMapNotNull(retMap, "f240002", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActWeekClick(), userCtrBucket)));
            putMapNotNull(retMap, "f240003", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActDayClick(), userCtrBucket)));

            putMapNotNull(retMap, "f241001", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActHistOrder(), userCvrBucket)));
            putMapNotNull(retMap, "f241002", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActWeekOrder(), userCvrBucket)));
            putMapNotNull(retMap, "f241003", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActDayOrder(), userCvrBucket)));

            putMapNotNull(retMap, "f242001", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActHistConsumer(), userConBucket)));
            putMapNotNull(retMap, "f242002", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActWeekConsumer(), userConBucket)));
            putMapNotNull(retMap, "f242003", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCAppSlotActDayConsumer(), userConBucket)));

            putMapNotNull(retMap, "f493013", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCHistActExposeTime(), cntBucket)));
            putMapNotNull(retMap, "f493014", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCWeekActExposeTime(), cntBucket)));
            putMapNotNull(retMap, "f493015", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCDayActExposeTime(), cntBucket)));

            putMapNotNull(retMap, "f494013", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCHistActClickTime(), cntBucket)));
            putMapNotNull(retMap, "f494014", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCWeekActClickTime(), cntBucket)));
            putMapNotNull(retMap, "f494015", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCDayActClickTime(), cntBucket)));

            putMapNotNull(retMap, "f495013", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCHistActOrderTime(), cntBucket)));
            putMapNotNull(retMap, "f495014", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCWeekActOrderTime(), cntBucket)));
            putMapNotNull(retMap, "f495015", DataUtil.Long2String(bucket(candidateInterceptDo.getRoutineActFeature().getCDayActOrderTime(), cntBucket)));

            // 奖品
            List<PrizeDo> prizeDos = candidateInterceptDo.getPrizeGroup();
            for (int i = 0; i < prizeDos.size() && i < 6; i++) {
                putMapNotNull(retMap, String.format("f3320%s1", i+1), DataUtil.Long2String(prizeDos.get(i).getId()));
                putMapNotNull(retMap, String.format("f3320%s2", i+1), DataUtil.Long2String(prizeDos.get(i).isAd() ? 1L : 2L));
                putMapNotNull(retMap, String.format("f3320%s3", i+1), prizeDos.get(i).getAdTagId());
                PrizeFeature prizeFeature = prizeDos.get(i).getPrizeFeature();
                if (prizeFeature != null) {
                    putMapNotNull(retMap, String.format("f3530%s0", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeHistClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s1", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeWeekClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s2", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeDayClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s3", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeHistOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s4", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeWeekOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s5", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeDayOrder(), userCvrBucket)));
                    JSONObject componentPrizeTradeCategory = DataUtil.stringToJson(prizeFeature.getComponentPrizeTradeCategory());
                    putMapNotNull(retMap, String.format("f3530%s6", i+1), getStringsToBuckets(componentPrizeTradeCategory, 100));
//                    putMapNotNull(retMap, String.format("f3530%s7", i+1), DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleHistConsumer(), userConBucket)));
//                    putMapNotNull(retMap, String.format("f3530%s8", i+1), DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleWeekConsumer(), userConBucket)));
//                    putMapNotNull(retMap, String.format("f3530%s9", i+1), DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleDayConsumer(), userConBucket)));
//                    putMapNotNull(retMap, String.format("f3530%s0", i+1), dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleEmbedding());
                    // 奖品
                    putMapNotNull(retMap, String.format("f4930%s7", i+1), DataUtil.Long2String(bucket(prizeFeature.getCHistPrizesExposeTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4930%s8", i+1), DataUtil.Long2String(bucket(prizeFeature.getCWeekPrizesExposeTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4930%s9", i+1), DataUtil.Long2String(bucket(prizeFeature.getCDayPrizesExposeTime(), cntBucket)));

                    putMapNotNull(retMap, String.format("f4940%s7", i+1), DataUtil.Long2String(bucket(prizeFeature.getCHistPrizesClickTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4940%s8", i+1), DataUtil.Long2String(bucket(prizeFeature.getCWeekPrizesClickTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4940%s9", i+1), DataUtil.Long2String(bucket(prizeFeature.getCDayPrizesClickTime(), cntBucket)));

                    putMapNotNull(retMap, String.format("f4950%s7", i+1), DataUtil.Long2String(bucket(prizeFeature.getCHistPrizesOrderTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4950%s8", i+1), DataUtil.Long2String(bucket(prizeFeature.getCWeekPrizesOrderTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4950%s9", i+1), DataUtil.Long2String(bucket(prizeFeature.getCDayPrizesOrderTime(), cntBucket)));

                    // 奖品
                    putMapNotNull(retMap, String.format("f240%s10", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeHistClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f240%s11", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeWeekClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f240%s12", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeDayClick(), userCtrBucket)));

                    putMapNotNull(retMap, String.format("f241%s10", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeHistOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f241%s11", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeWeekOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f241%s12", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeDayOrder(), userCvrBucket)));

                    putMapNotNull(retMap, String.format("f242%s10", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeHistConsumer(), userConBucket)));
                    putMapNotNull(retMap, String.format("f242%s11", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeWeekConsumer(), userConBucket)));
                    putMapNotNull(retMap, String.format("f242%s12", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeDayConsumer(), userConBucket)));

                    SkinFeature skinFeature = candidateInterceptDo.getSkinFeature();
                    if (skinFeature != null) {
                        putMapNotNull(retMap, "f493010", DataUtil.Long2String(bucket(skinFeature.getCHistSkinsExposeTime(), cntBucket)));
                        putMapNotNull(retMap, "f493011", DataUtil.Long2String(bucket(skinFeature.getCWeekSkinsExposeTime(), cntBucket)));
                        putMapNotNull(retMap, "f493012", DataUtil.Long2String(bucket(skinFeature.getCDaySkinsExposeTime(), cntBucket)));

                        putMapNotNull(retMap, "f494010", DataUtil.Long2String(bucket(skinFeature.getCHistSkinsClickTime(), cntBucket)));
                        putMapNotNull(retMap, "f494011", DataUtil.Long2String(bucket(skinFeature.getCWeekSkinsClickTime(), cntBucket)));
                        putMapNotNull(retMap, "f494012", DataUtil.Long2String(bucket(skinFeature.getCDaySkinsClickTime(), cntBucket)));

                        putMapNotNull(retMap, "f495010", DataUtil.Long2String(bucket(skinFeature.getCHistSkinsOrderTime(), cntBucket)));
                        putMapNotNull(retMap, "f495011", DataUtil.Long2String(bucket(skinFeature.getCWeekSkinsOrderTime(), cntBucket)));
                        putMapNotNull(retMap, "f495012", DataUtil.Long2String(bucket(skinFeature.getCDaySkinsOrderTime(), cntBucket)));
                        // 活动皮肤
                        putMapNotNull(retMap, "f240013", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinHistClick(), userCtrBucket)));
                        putMapNotNull(retMap, "f240014", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinWeekClick(), userCtrBucket)));
                        putMapNotNull(retMap, "f240015", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinDayClick(), userCtrBucket)));

                        putMapNotNull(retMap, "f241013", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinHistOrder(), userCvrBucket)));
                        putMapNotNull(retMap, "f241014", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinWeekOrder(), userCvrBucket)));
                        putMapNotNull(retMap, "f241015", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinDayOrder(), userCvrBucket)));

                        putMapNotNull(retMap, "f242013", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinHistConsumer(), userConBucket)));
                        putMapNotNull(retMap, "f242014", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinWeekConsumer(), userConBucket)));
                        putMapNotNull(retMap, "f242015", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinDayConsumer(), userConBucket)));
                    }
                }

            }
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(DPAActFeatureDo dpa){
        return generateFeatureMapDynamic(dpa,null);
    }

    public static Map<String, String> generateFeatureMapDynamic(DPAActFeatureDo dpa, SlotActFeature slotActFeature) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        if (dpa.getCandidateActivityDo() != null) {
            putMapNotNull(retMap, "f301001", DataUtil.Long2String(dpa.getCandidateActivityDo().getActivityId()));
            putMapNotNull(retMap, "f331001", DataUtil.Long2String(dpa.getCandidateActivityDo().getSkinId()));
            putMapNotNull(retMap, "f331002", DataUtil.Long2String(dpa.getCandidateActivityDo().getTitleId()));
            putMapNotNull(retMap, "f331003", DataUtil.Long2String(dpa.getCandidateActivityDo().getSubTitleId()));
            putMapNotNull(retMap, "f331005", dpa.getCandidateActivityDo().getTitleTagId());
            putMapNotNull(retMap, "f331006", dpa.getCandidateActivityDo().getSubTitleTagId());

            putMapNotNull(retMap, "f240001", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActHistClick(), userCtrBucket)));
            putMapNotNull(retMap, "f240002", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActWeekClick(), userCtrBucket)));
            putMapNotNull(retMap, "f240003", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActDayClick(), userCtrBucket)));

            putMapNotNull(retMap, "f241001", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActHistOrder(), userCvrBucket)));
            putMapNotNull(retMap, "f241002", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActWeekOrder(), userCvrBucket)));
            putMapNotNull(retMap, "f241003", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActDayOrder(), userCvrBucket)));

            putMapNotNull(retMap, "f242001", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActHistConsumer(), userConBucket)));
            putMapNotNull(retMap, "f242002", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActWeekConsumer(), userConBucket)));
            putMapNotNull(retMap, "f242003", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActDayConsumer(), userConBucket)));

            // 活动
            putMapNotNull(retMap, "f493013", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCHistActExposeTime(), cntBucket)));
            putMapNotNull(retMap, "f493014", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCWeekActExposeTime(), cntBucket)));
            putMapNotNull(retMap, "f493015", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCDayActExposeTime(), cntBucket)));

            putMapNotNull(retMap, "f494013", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCHistActClickTime(), cntBucket)));
            putMapNotNull(retMap, "f494014", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCWeekActClickTime(), cntBucket)));
            putMapNotNull(retMap, "f494015", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCDayActClickTime(), cntBucket)));

            putMapNotNull(retMap, "f495013", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCHistActOrderTime(), cntBucket)));
            putMapNotNull(retMap, "f495014", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCWeekActOrderTime(), cntBucket)));
            putMapNotNull(retMap, "f495015", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getCDayActOrderTime(), cntBucket)));

            //消耗配置
            RoutineActFeature routineActFeature = dpa.getCandidateActivityDo().getRoutineActFeature();
            if(routineActFeature != null){
                putMapNotNull(retMap, "f820005", DataUtil.Integer2String(routineActFeature.getAutoFirstLaunchStatus()));
                putMapNotNull(retMap, "f820006", DataUtil.Integer2String(routineActFeature.getLayerStatus()));
                if(slotActFeature != null){
                    Integer encStatus = routineActFeature.getEncStatus();
                    putMapNotNull(retMap, "820004", DataUtil.Integer2String(encStatus));
                }
            }

//            // 常规活动
//            putMapNotNull(retMap, "f341002", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f341003", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f341004", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f341005", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekOrder(), userCvrBucket)));
//            JSONObject routineActTradeVisitTime = DataUtil.stringToJson(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActTradeVisitTime());
//            putMapNotNull(retMap, "f341006", getCategoryJsonByBucket(routineActTradeVisitTime, cntBucket));
//            JSONObject routineActTradeClickTime = DataUtil.stringToJson(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActTradeClickTime());
//            putMapNotNull(retMap, "f341007", getCategoryJsonByBucket(routineActTradeClickTime, cntBucket));
//            putMapNotNull(retMap, "f341008", dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActActType());
//            putMapNotNull(retMap, "f341009", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f341010", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f341011", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActDayConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f341012", dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActEmbedding());
//
//
//            // 主标题
//            JSONObject componentMainTitleCategory = DataUtil.stringToJson(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleCategory());
//            putMapNotNull(retMap, "f351001", getStringsToBuckets(componentMainTitleCategory, 1000));
//
//            putMapNotNull(retMap, "f351002", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f351003", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f351004", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f351005", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f351006", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f351007", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f351009", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f351010", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f351011", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f351012", dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleEmbedding());
            TitleFeature mainTitleFeature = dpa.getCandidateActivityDo().getMainTitleFeature();
            if (mainTitleFeature != null) {
                putMapNotNull(retMap, "f493001", DataUtil.Long2String(bucket(mainTitleFeature.getCHistTitlesExposeTime(), cntBucket)));
                putMapNotNull(retMap, "f493002", DataUtil.Long2String(bucket(mainTitleFeature.getCWeekTitlesExposeTime(), cntBucket)));
                putMapNotNull(retMap, "f493003", DataUtil.Long2String(bucket(mainTitleFeature.getCDayTitlesExposeTime(), cntBucket)));

                putMapNotNull(retMap, "f494001", DataUtil.Long2String(bucket(mainTitleFeature.getCHistTitlesClickTime(), cntBucket)));
                putMapNotNull(retMap, "f494002", DataUtil.Long2String(bucket(mainTitleFeature.getCWeekTitlesClickTime(), cntBucket)));
                putMapNotNull(retMap, "f494003", DataUtil.Long2String(bucket(mainTitleFeature.getCDayTitlesClickTime(), cntBucket)));

                putMapNotNull(retMap, "f495001", DataUtil.Long2String(bucket(mainTitleFeature.getCHistTitlesOrderTime(), cntBucket)));
                putMapNotNull(retMap, "f495002", DataUtil.Long2String(bucket(mainTitleFeature.getCWeekTitlesOrderTime(), cntBucket)));
                putMapNotNull(retMap, "f495003", DataUtil.Long2String(bucket(mainTitleFeature.getCDayTitlesOrderTime(), cntBucket)));

                // 主标题
                putMapNotNull(retMap, "f240004", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesHistClick(), userCtrBucket)));
                putMapNotNull(retMap, "f240005", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesWeekClick(), userCtrBucket)));
                putMapNotNull(retMap, "f240006", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesDayClick(), userCtrBucket)));

                putMapNotNull(retMap, "f241004", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesHistOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241005", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesWeekOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241006", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesDayOrder(), userCvrBucket)));

                putMapNotNull(retMap, "f242004", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesHistConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242005", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesWeekConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242006", DataUtil.Long2String(bucket(mainTitleFeature.getCAppSlotTitlesDayConsumer(), userConBucket)));
            }


//            // 副标题
//            JSONObject componentSubTitleCategory = DataUtil.stringToJson(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleCategory());
//            putMapNotNull(retMap, "f352001", getStringsToBuckets(componentSubTitleCategory, 1000));
//
//            putMapNotNull(retMap, "f352002", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f352003", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f352004", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f352005", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f352006", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f352007", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f352009", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f352010", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f352011", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f352012", dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleEmbedding());
            TitleFeature subTitleFeature = dpa.getCandidateActivityDo().getSubTitleFeature();
            if (subTitleFeature != null) {
                putMapNotNull(retMap, "f493004", DataUtil.Long2String(bucket(subTitleFeature.getCHistTitlesExposeTime(), cntBucket)));
                putMapNotNull(retMap, "f493005", DataUtil.Long2String(bucket(subTitleFeature.getCWeekTitlesExposeTime(), cntBucket)));
                putMapNotNull(retMap, "f493006", DataUtil.Long2String(bucket(subTitleFeature.getCDayTitlesExposeTime(), cntBucket)));

                putMapNotNull(retMap, "f494004", DataUtil.Long2String(bucket(subTitleFeature.getCHistTitlesClickTime(), cntBucket)));
                putMapNotNull(retMap, "f494005", DataUtil.Long2String(bucket(subTitleFeature.getCWeekTitlesClickTime(), cntBucket)));
                putMapNotNull(retMap, "f494006", DataUtil.Long2String(bucket(subTitleFeature.getCDayTitlesClickTime(), cntBucket)));

                putMapNotNull(retMap, "f495004", DataUtil.Long2String(bucket(subTitleFeature.getCHistTitlesOrderTime(), cntBucket)));
                putMapNotNull(retMap, "f495005", DataUtil.Long2String(bucket(subTitleFeature.getCWeekTitlesOrderTime(), cntBucket)));
                putMapNotNull(retMap, "f495006", DataUtil.Long2String(bucket(subTitleFeature.getCDayTitlesOrderTime(), cntBucket)));

                // 副标题
                putMapNotNull(retMap, "f240007", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesHistClick(), userCtrBucket)));
                putMapNotNull(retMap, "f240008", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesWeekClick(), userCtrBucket)));
                putMapNotNull(retMap, "f240009", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesDayClick(), userCtrBucket)));

                putMapNotNull(retMap, "f241007", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesHistOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241008", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesWeekOrder(), userConBucket)));
                putMapNotNull(retMap, "f241009", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesDayOrder(), userCvrBucket)));

                putMapNotNull(retMap, "f242007", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesHistConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242008", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesWeekConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242009", DataUtil.Long2String(bucket(subTitleFeature.getCAppSlotTitlesDayConsumer(), userConBucket)));
            }

            // 奖品
            List<PrizeDo> prizeDos = dpa.getCandidateActivityDo().getPrizeGroup();
            for (int i = 0; i < prizeDos.size() && i < 6; i++) {
                putMapNotNull(retMap, String.format("f3320%s1", i+1), DataUtil.Long2String(prizeDos.get(i).getId()));
                putMapNotNull(retMap, String.format("f3320%s2", i+1), DataUtil.Long2String(prizeDos.get(i).isAd() ? 1L : 2L));
                putMapNotNull(retMap, String.format("f3320%s3", i+1), prizeDos.get(i).getAdTagId());
                PrizeFeature prizeFeature = prizeDos.get(i).getPrizeFeature();
                if (prizeFeature != null) {
                    putMapNotNull(retMap, String.format("f3530%s0", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeHistClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s1", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeWeekClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s2", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeDayClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s3", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeHistOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s4", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeWeekOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f3530%s5", i+1), DataUtil.Long2String(bucket(prizeFeature.getComponentOrdPrizeDayOrder(), userCvrBucket)));
                    JSONObject componentPrizeTradeCategory = DataUtil.stringToJson(prizeFeature.getComponentPrizeTradeCategory());
                    putMapNotNull(retMap, String.format("f3530%s6", i+1), getStringsToBuckets(componentPrizeTradeCategory, 100));
//                    putMapNotNull(retMap, String.format("f3530%s7", i+1), DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleHistConsumer(), userConBucket)));
//                    putMapNotNull(retMap, String.format("f3530%s8", i+1), DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleWeekConsumer(), userConBucket)));
//                    putMapNotNull(retMap, String.format("f3530%s9", i+1), DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleDayConsumer(), userConBucket)));
//                    putMapNotNull(retMap, String.format("f3530%s0", i+1), dpa.getCandidateActivityDo().getPrizeFeature().getComponentTitleEmbedding());
                    // 奖品
                    putMapNotNull(retMap, String.format("f4930%s7", i+1), DataUtil.Long2String(bucket(prizeFeature.getCHistPrizesExposeTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4930%s8", i+1), DataUtil.Long2String(bucket(prizeFeature.getCWeekPrizesExposeTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4930%s9", i+1), DataUtil.Long2String(bucket(prizeFeature.getCDayPrizesExposeTime(), cntBucket)));

                    putMapNotNull(retMap, String.format("f4940%s7", i+1), DataUtil.Long2String(bucket(prizeFeature.getCHistPrizesClickTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4940%s8", i+1), DataUtil.Long2String(bucket(prizeFeature.getCWeekPrizesClickTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4940%s9", i+1), DataUtil.Long2String(bucket(prizeFeature.getCDayPrizesClickTime(), cntBucket)));

                    putMapNotNull(retMap, String.format("f4950%s7", i+1), DataUtil.Long2String(bucket(prizeFeature.getCHistPrizesOrderTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4950%s8", i+1), DataUtil.Long2String(bucket(prizeFeature.getCWeekPrizesOrderTime(), cntBucket)));
                    putMapNotNull(retMap, String.format("f4950%s9", i+1), DataUtil.Long2String(bucket(prizeFeature.getCDayPrizesOrderTime(), cntBucket)));

                    // 奖品
                    putMapNotNull(retMap, String.format("f240%s10", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeHistClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f240%s11", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeWeekClick(), userCtrBucket)));
                    putMapNotNull(retMap, String.format("f240%s12", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeDayClick(), userCtrBucket)));

                    putMapNotNull(retMap, String.format("f241%s10", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeHistOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f241%s11", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeWeekOrder(), userCvrBucket)));
                    putMapNotNull(retMap, String.format("f241%s12", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeDayOrder(), userCvrBucket)));

                    putMapNotNull(retMap, String.format("f242%s10", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeHistConsumer(), userConBucket)));
                    putMapNotNull(retMap, String.format("f242%s11", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeWeekConsumer(), userConBucket)));
                    putMapNotNull(retMap, String.format("f242%s12", i+1), DataUtil.Long2String(bucket(prizeFeature.getCAppSlotPrizeDayConsumer(), userConBucket)));
                }

            }


//            // 皮肤
//            putMapNotNull(retMap, "f354001", dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinCategory());
//            putMapNotNull(retMap, "f354004", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinHistClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f354005", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinWeekClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f354006", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinDayClick(), userCtrBucket)));
//            putMapNotNull(retMap, "f354007", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinHistOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f354008", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinWeekOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f354009", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinDayOrder(), userCvrBucket)));
//            putMapNotNull(retMap, "f354013", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getSkinHistConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f354010", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getSkinWeekConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f354011", DataUtil.Long2String(bucket(dpa.getCandidateActivityDo().getSkinFeature().getSkinDayConsumer(), userConBucket)));
//            putMapNotNull(retMap, "f354012", dpa.getCandidateActivityDo().getSkinFeature().getSkinEmbedding());
            // 皮肤
            SkinFeature skinFeature = dpa.getCandidateActivityDo().getSkinFeature();
            if (skinFeature != null) {
                putMapNotNull(retMap, "f493010", DataUtil.Long2String(bucket(skinFeature.getCHistSkinsExposeTime(), cntBucket)));
                putMapNotNull(retMap, "f493011", DataUtil.Long2String(bucket(skinFeature.getCWeekSkinsExposeTime(), cntBucket)));
                putMapNotNull(retMap, "f493012", DataUtil.Long2String(bucket(skinFeature.getCDaySkinsExposeTime(), cntBucket)));

                putMapNotNull(retMap, "f494010", DataUtil.Long2String(bucket(skinFeature.getCHistSkinsClickTime(), cntBucket)));
                putMapNotNull(retMap, "f494011", DataUtil.Long2String(bucket(skinFeature.getCWeekSkinsClickTime(), cntBucket)));
                putMapNotNull(retMap, "f494012", DataUtil.Long2String(bucket(skinFeature.getCDaySkinsClickTime(), cntBucket)));

                putMapNotNull(retMap, "f495010", DataUtil.Long2String(bucket(skinFeature.getCHistSkinsOrderTime(), cntBucket)));
                putMapNotNull(retMap, "f495011", DataUtil.Long2String(bucket(skinFeature.getCWeekSkinsOrderTime(), cntBucket)));
                putMapNotNull(retMap, "f495012", DataUtil.Long2String(bucket(skinFeature.getCDaySkinsOrderTime(), cntBucket)));
                // 活动皮肤
                putMapNotNull(retMap, "f240013", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinHistClick(), userCtrBucket)));
                putMapNotNull(retMap, "f240014", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinWeekClick(), userCtrBucket)));
                putMapNotNull(retMap, "f240015", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinDayClick(), userCtrBucket)));

                putMapNotNull(retMap, "f241013", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinHistOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241014", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinWeekOrder(), userCvrBucket)));
                putMapNotNull(retMap, "f241015", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinDayOrder(), userCvrBucket)));

                putMapNotNull(retMap, "f242013", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinHistConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242014", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinWeekConsumer(), userConBucket)));
                putMapNotNull(retMap, "f242015", DataUtil.Long2String(bucket(skinFeature.getCAppSlotSkinDayConsumer(), userConBucket)));
            }

        }
        return retMap;
    }

    //根据areaCode解析地区级别（华北/东北/华东/华中/华南/西南/西北/港澳） f4010031
    public static Long getRegionLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);
            if ( areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area =  DataUtil.toInt(areaCode / 100);
            }

            if (Arrays.asList(HUABEI_REGION).contains(area)) { ret = 80L; }
            else if (Arrays.asList(DONGBEI_REGION).contains(area)) { ret = 81L; }
            else if (Arrays.asList(HUADONG_REGION).contains(area)) { ret = 82L; }
            else if (Arrays.asList(HUAZHONG_REGION).contains(area)) { ret = 83L; }
            else if (Arrays.asList(HUANAN_REGION).contains(area)) { ret = 84L; }
            else if (Arrays.asList(XINAN_REGION).contains(area)) { ret = 85L; }
            else if (Arrays.asList(XIBEI_REGION).contains(area)) { ret = 86L; }
            else if (Arrays.asList(HMT_REGION).contains(area)) { ret = 87L; }

        }

        return ret;
    }

    //根据areaCode解析城市级别（一线/二线/三线） f4010032
    public static Long getTierCityLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);

            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) { ret = 1L; }
            else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) { ret = 2L; }
            else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) { ret = 3L; }

        }

        return ret;
    }

    // 行业标签编码
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            put("8",0);
            put( "14",1);
            put( "15",2);
            put( "21",3);
            put( "20",4);
            put( "3",5);
            put( "5",6);
            put( "12",7);
            put( "2",8);
            put( "1",9);
            put( "24",10);
            put( "6",11);
            put( "7",12);
            put( "11",13);
            put( "13",14);
            put( "18",15);
            put( "22",16);
            put( "4",17);
            put( "17",18);
            put( "25",19);
            put( "10",20);
            put( "23",21);
            put( "9",22);
            put( "19",23);
            put( "16",24);
        }
    };

    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数2
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数3
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    //
    public static String getCategoryMapByBucket(Map<String, Integer> actMap, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Integer> entry: actMap.entrySet()) {
                Integer cateKey = Integer.parseInt(entry.getKey());
                Integer cateValue = entry.getValue();
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }


    public static String getStringsToBuckets(JSONObject actMap, Integer limit) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cKey: actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = cateKey * limit + cateValue;
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    public static String getCategoryMapByBucket(Map<String, Double> actMap, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Double> entry: actMap.entrySet()) {
                Integer cateKey = Integer.parseInt(entry.getKey());
                Double cateValue = entry.getValue();
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }


    //
    public static String getCategoryJsonByBucket(JSONObject actMap, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cKey: actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    public static String getCategoryJsonByBucket(JSONObject actMap, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap)) return null;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cKey: actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Double cateValue = actMap.getDouble(cKey);
                long value = cateKey * buckets.length + bucket(cateValue, buckets);
                tmp.add(value);
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (Map.Entry<String, Integer> entry: actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);
                    tmp.add(value);
                }
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        ArrayList<Long> tmp = new ArrayList<>();

        try {
            for (String cateKey: actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);
                    tmp.add(value);
                }
            }
        } catch (Exception e) {
            return null;
        }

        return StringUtils.join(tmp, ",");
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {

        String ret = null;
        try {
            // 全局
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String(ubpMap.get(statType).get("0"));


            }
            // 当前广告
            if (dimType == 1 && ubpMap != null) {
                String tag = getTag(tags);

                if (tag != null) {
                    ret = ubpMap.get(statType).get(tag) + "";

                    if (tag.length() == 10 && ret == null) {
                        String sTag = tag.substring(0, 5);
                        ret = DataUtil.Long2String(ubpMap.get(statType).get(sTag));
                    }


                }
            }

            // 其他行业
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String v = entry.getKey() + "_" + entry.getValue() + ",";
                    ret += v;
                }

                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


            //统计计数
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {

                ret = "";
                Map<Long, Long> levelCntMap = new HashMap<>();

//                System.out.println("statType=" + statType);

//                for (long i = 0; i < ctrAndCvrLevelBucket.length + 2; i++) {
//                    levelCntMap.put(i, 0L);
//                }


                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag = entry.getKey();
                    Long ctrLevel = bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel != null && tag != "0") {
                        if (!levelCntMap.containsKey(ctrLevel)) {
                            levelCntMap.put(ctrLevel, 0L);
                        }
                        levelCntMap.put(ctrLevel, levelCntMap.get(ctrLevel) + 1);
//                        System.out.println("entry.getValue()=" + entry.getValue() + ",ctrLevel=" + ctrLevel + ",+1");
                    }
                }

                for (Map.Entry<Long, Long> entry : levelCntMap.entrySet()) {
                    if (entry.getKey() != null && entry.getValue() != null) {

                        Long cntLevel = bucket(entry.getValue(), cntBucket);
//                        System.out.println("entry.getKey()=" + entry.getKey() + "entry.getValue()=" + entry.getValue() + ",cntLevel=" + cntLevel + "+1");
                        String v = entry.getKey() * 100 + cntLevel + ",";
                        ret += v;
                    }

                }


                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static String getTag(String tags) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tags)) {
            String[] tagArr = tags.split(",");
            if (AssertUtil.isNotEmpty(tagArr)) {
                for (int i = 0; i < tagArr.length; i++) {
                    String tmp = validTag(tagArr[i]);
                    if (tmp != null) {
                        ret = validTag(tagArr[i]);
                    }

                }
            }
        }

        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tag)) {
            if (tag.contains(".")) {
                ret = tag;
            }
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds,
                                                                             String uILaunchPv,
                                                                             String uIClickPv,
                                                                             String uIEffectPv) {
        Map<String, Map<String, Long>> ret = new HashMap<>();
        ret.put("ctr", new HashMap<String, Long>());
        ret.put("cvr", new HashMap<String, Long>());
        if (AssertUtil.isAllNotEmpty(uIIds, uILaunchPv, uIClickPv, uIEffectPv)) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");

            if (uIIdsArr.length > 0 &&
                    uIIdsArr.length == uILaunchPvArr.length &&
                    uIIdsArr.length == uIClickPvArr.length &&
                    uIIdsArr.length == uIEffectPvArr.length) {

                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;


                for (int i = 0; i < uIIdsArr.length; i++) {
                    String id = uIIdsArr[i];
//                    System.out.println("uIIdsArr[i]=" + uIIdsArr[i]);
//                    System.out.println("uILaunchPvArr[i]=" + uILaunchPvArr[i]);
//                    System.out.println("uIClickPvArr[i]=" + uIClickPvArr[i]);
//                    System.out.println("uIEffectPvArr[i]=" + uIEffectPvArr[i]);

                    Long launchPv = DataUtil.str2Long(uILaunchPvArr[i], 0L);
                    Long clickPv = DataUtil.str2Long(uIClickPvArr[i], 0L);
                    Long effectPv = DataUtil.str2Long(uIEffectPvArr[i], 0L);

//                    System.out.println("launchPv=" + launchPv);
//                    System.out.println("clickPv=" + clickPv);
//                    System.out.println("effectPv=" + effectPv);

                    Double ctr = getCtrOrCvr(launchPv, clickPv);
                    Double cvr = getCtrOrCvr(clickPv, effectPv);

                    Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                    ret.get("ctr").put(id, ctrBucketLevel);
                    ret.get("cvr").put(id, cvrBucketLevel);

                    launchAccPv += launchPv;
                    clickAccPv += clickPv;
                    effectAccPv += effectPv;

                }
                Double ctr = getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = getCtrOrCvr(clickAccPv, effectAccPv);

                Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                ret.get("ctr").put("0", ctrBucketLevel);
                ret.get("cvr").put("0", cvrBucketLevel);

            }


        }

        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);

        return ret;
    }

    // 广告主编码
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>(){
        {
            put("18125",0);
            put("18943",1);
            put("22005",2);
            put("21563",3);
            put("17196",4);
            put("29815",5);
            put("27419",6);
            put("25874",7);
            put("30539",8);
            put("27295",9);
            put("30037",10);
            put("24035",11);
            put("23882",12);
            put("29932",13);
            put("19317",14);
            put("10971",15);
            put("27486",16);
            put("12311",17);
            put("22597",18);
            put("21330",19);
            put("26598",20);
            put("30371",21);
            put("19941",22);
            put("27605",23);
            put("17270",24);
            put("12234",25);
            put("17878",26);
            put("28257",27);
            put("30632",28);
            put("25991",29);
            put("30701",30);
            put("30336",31);
            put("12796",32);
            put("29379",33);
            put("30495",34);
            put("29758",35);
            put("19316",36);
            put("14355",37);
            put("29001",38);
            put("30126",39);
            put("30892",40);
            put("26320",41);
            put("18489",42);
            put("14164",43);
            put("24696",44);
            put("28941",45);
            put("30511",46);
            put("5713",47);
            put("30928",48);
            put("19761",49);
            put("30592",50);
            put("30081",51);
            put("28769",52);
            put("29788",53);
            put("21133",54);
            put("30679",55);
            put("30393",56);
            put("26323",57);
            put("29336",58);
            put("29935",59);
            put("29030",60);
            put("26550",61);
            put("30394",62);
            put("30823",63);
            put("28466",64);
            put("8340",65);
            put("30460",66);
            put("30739",67);
            put("26048",68);
            put("30765",69);
            put("30596",70);
            put("25809",71);
            put("30808",72);
            put("30605",73);
            put("27165",74);
            put("30868",75);
            put("30518",76);
            put("29408",77);
            put("30601",78);
            put("30900",79);
            put("25984",80);
            put("27568",81);
            put("23937",82);
            put("15334",83);
            put("30345",84);
            put("26595",85);
            put("8154",86);
            put("28264",87);
            put("30848",88);
            put("13566",89);
            put("26726",90);
            put("8302",91);
            put("29406",92);
            put("16315",93);
            put("30625",94);
            put("20619",95);
            put("28528",96);
            put("30253",97);
            put("29808",98);
            put("30809",99);
            put("6286",100);
            put("22757",101);
            put("9876",102);
            put("24779",103);
            put("25806",104);
            put("30929",105);
            put("30956",106);
            put("30691",107);
            put("29706",108);
            put("29651",109);
            put("30438",110);
            put("27911",111);
            put("30493",112);
            put("29519",113);
            put("30220",114);
            put("30812",115);
            put("27684",116);
            put("30636",117);
            put("17638",118);
            put("28594",119);
            put("29558",120);
            put("27463",121);
            put("28925",122);
            put("28420",123);
            put("30099",124);
            put("28523",125);
            put("30688",126);
            put("28432",127);
            put("18028",128);
            put("6209",129);
            put("30783",130);
            put("22412",131);
            put("30684",132);
            put("30621",133);
            put("30734",134);
            put("30807",135);
            put("30794",136);
            put("28180",137);
            put("28544",138);
            put("30186",139);
            put("24090",140);
            put("30111",141);
            put("8657",142);
            put("23977",143);
            put("29491",144);
            put("30327",145);
            put("30249",146);
            put("23461",147);
            put("28597",148);
            put("30498",149);
            put("30109",150);
            put("30279",151);
            put("30100",152);
            put("30732",153);
            put("23031",154);
            put("30497",155);
            put("25886",156);
            put("27453",157);
            put("29845",158);
            put("30378",159);
            put("30257",160);
            put("28881",161);
            put("27241",162);
            put("30219",163);
            put("22006",164);
            put("30217",165);
            put("25215",166);
            put("19217",167);
            put("28515",168);
            put("30185",169);
            put("29858",170);
            put("27452",171);
            put("18089",172);
            put("30411",173);
            put("26151",174);
            put("29699",175);
            put("29889",176);
            put("30573",177);
            put("30017",178);
            put("2292",179);
            put("29427",180);
            put("30560",181);
            put("30626",182);
            put("28628",183);
            put("29534",184);
            put("30515",185);
            put("30023",186);
            put("30374",187);
            put("21271",188);
            put("27321",189);
            put("30290",190);
            put("28643",191);
            put("14356",192);
            put("23880",193);
            put("30836",194);
            put("30569",195);
            put("29900",196);
            put("29879",197);
            put("30499",198);
            put("29894",199);
            put("28970",200);
            put("21944",201);
            put("30705",202);
            put("30187",203);
            put("28503",204);
            put("29028",205);
            put("30128",206);
            put("30182",207);
            put("30237",208);
            put("29448",209);
            put("30825",210);
            put("27884",211);
            put("27932",212);
            put("30704",213);
            put("30695",214);
            put("30461",215);
            put("30218",216);
            put("29862",217);
            put("25509",218);
            put("30329",219);
            put("26077",220);
            put("25495",221);
            put("30115",222);
            put("27002",223);
            put("30935",224);
            put("23469",225);
            put("30331",226);
            put("30188",227);
            put("24296",228);
            put("22042",229);
            put("7962",230);
            put("323",231);
            put("30272",232);
            put("18071",233);
            put("18072",234);
            put("8220",235);
            put("8331",236);
            put("23680",237);
            put("6419",238);
        }
    };

    // App类目编码
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>(){
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
        }
    };

    // 签名类目编码
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>(){
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
            put("31", 31);
            put("32", 32);
            put("33", 33);
            put("34", 34);
            put("35", 35);
            put("36", 36);
            put("37", 37);
            put("38", 38);
            put("39", 39);
            put("40", 40);
            put("41", 41);
            put("42", 42);
            put("43", 43);
        }
    };

    // 关键词类目编码
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>(){
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
        }
    };

    // 视频类目编码 videoCate
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>(){
        {
            put("1273152", 0);
            put("1273153", 1);
            put("1273154", 2);
            put("1273155", 3);
            put("1273158", 4);
            put("1273163", 5);
            put("1273166", 6);
            put("1273190", 7);
            put("1273380", 8);
            put("1273399", 9);
            put("1275055", 10);
            put("1275060", 11);
            put("1275378", 12);
            put("1275381", 13);
            put("1275605", 14);
            put("1275609", 15);
            put("1275699", 16);
            put("1275850", 17);
            put("1276159", 18);
            put("1276427", 19);
            put("1277341", 20);
            put("1277350", 21);
            put("1277354", 22);
            put("1277360", 23);
            put("1277373", 24);
            put("1278212", 25);
            put("1279265", 26);
            put("1279863", 27);
            put("1281970", 28);
            put("1281978", 29);
            put("1282468", 30);
            put("1282983", 31);
            put("1283091", 32);
            put("1283242", 33);
            put("1284864", 34);
            put("1284891", 35);
            put("1284979", 36);
            put("1288586", 37);
            put("1289618", 38);
            put("1289633", 39);
            put("1289641", 40);
            put("1289642", 41);
            put("1291079", 42);
            put("1307098", 43);
            put("1307103", 44);
            put("1308055", 45);
            put("1310272", 46);
            put("1310276", 47);
            put("1311366", 48);
            put("1316217", 49);
            put("1323164", 50);
            put("1333414", 51);
            put("1343852", 52);
            put("1345203", 53);
            put("1345206", 54);
            put("1345801", 55);
            put("1347029", 56);
            put("1348464", 57);
            put("1348469", 58);
            put("1348589", 59);
            put("1348767", 60);
            put("1351397", 61);
            put("1362094", 62);
            put("1392855", 63);
            put("1399467", 64);
            put("1457705", 65);
            put("1506926", 66);
            put("1509530", 67);
            put("1652670", 68);
            put("1657117", 69);
            put("1657120", 70);
            put("1786669", 71);
            put("1791134", 72);
            put("1887279", 73);
            put("2289121", 74);
            put("2289182", 75);
            put("2289191", 76);
            put("2289194", 77);
            put("2289198", 78);
            put("2400701", 79);
            put("2422552", 80);
            put("2423962", 81);
            put("2425625", 82);
            put("2454957", 83);
            put("2456790", 84);
            put("2456802", 85);
            put("2456895", 86);
            put("2466968", 87);
            put("2469508", 88);
            put("2485369", 89);
            put("2577550", 90);
            put("2818641", 91);
            put("2820598", 92);
            put("2821045", 93);
            put("2821232", 94);
            put("2821234", 95);
            put("2823069", 96);
            put("2824674", 97);
            put("2825127", 98);
            put("2825132", 99);
            put("2825152", 100);
            put("2825153", 101);
            put("2825156", 102);
            put("2825165", 103);
            put("2825674", 104);
            put("2828097", 105);
            put("2829161", 106);
            put("2829647", 107);
            put("2830002", 108);
            put("2830311", 109);
            put("2830346", 110);
            put("2830613", 111);
            put("2830805", 112);
            put("2831234", 113);
            put("2831373", 114);
            put("2831480", 115);
            put("2832492", 116);
            put("2833635", 117);
            put("2834198", 118);
            put("2834248", 119);
            put("2834252", 120);
            put("2834254", 121);
            put("2834359", 122);
            put("2834697", 123);
            put("2834810", 124);
            put("2834931", 125);
            put("2835040", 126);
            put("2835116", 127);
            put("2835117", 128);
            put("2835164", 129);
            put("2835165", 130);
            put("2835495", 131);
            put("2835521", 132);
            put("2835645", 133);
            put("2835728", 134);
            put("2835738", 135);
            put("2835744", 136);
            put("2836094", 137);
            put("2836607", 138);
            put("2836677", 139);
            put("2837050", 140);
            put("2837679", 141);
            put("2837825", 142);
            put("2838438", 143);
            put("2838626", 144);
            put("2838627", 145);
            put("2838628", 146);
            put("2838680", 147);
            put("2839215", 148);
            put("2839217", 149);
            put("2839264", 150);
            put("2839388", 151);
            put("2840307", 152);
            put("2840460", 153);
            put("2840461", 154);
            put("2840492", 155);
            put("2840499", 156);
            put("2840500", 157);
            put("2840501", 158);
            put("2840502", 159);
            put("2840504", 160);
            put("2840944", 161);
            put("2841365", 162);
            put("2841425", 163);
            put("2841426", 164);
            put("2844458", 165);
            put("2844459", 166);
            put("2844461", 167);
            put("2844477", 168);
            put("2844488", 169);
            put("2844489", 170);
            put("2845047", 171);
            put("2847235", 172);
            put("2847874", 173);
            put("2847916", 174);
            put("2848190", 175);
            put("2848215", 176);
            put("2848229", 177);
            put("2848330", 178);
            put("2849576", 179);
            put("2850987", 180);
            put("2859501", 181);
            put("2859502", 182);
            put("2859503", 183);
            put("2859504", 184);
            put("2859505", 185);
            put("2859506", 186);
            put("2859507", 187);
            put("2859508", 188);
            put("2859509", 189);
            put("2859510", 190);
            put("2859511", 191);
            put("2859512", 192);
            put("2859513", 193);
            put("2859588", 194);
            put("2859785", 195);
            put("2860991", 196);
            put("2860992", 197);
            put("2923465", 198);
            put("2923466", 199);
            put("2924524", 200);
            put("2924526", 201);
            put("2924527", 202);
            put("2924539", 203);
            put("2924541", 204);
            put("2924542", 205);
            put("2924543", 206);
            put("2924965", 207);
            put("2924966", 208);
            put("2924967", 209);
            put("2924968", 210);
            put("2924969", 211);
            put("2924970", 212);
        }
    };

    // 视频频道编码 videoChannel
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            put("aiqiyi--1", 0);
            put("aiqiyi-0", 1);
            put("aiqiyi-1", 2);
            put("aiqiyi-10", 3);
            put("aiqiyi-11", 4);
            put("aiqiyi-12", 5);
            put("aiqiyi-13", 6);
            put("aiqiyi-14", 7);
            put("aiqiyi-15", 8);
            put("aiqiyi-16", 9);
            put("aiqiyi-17", 10);
            put("aiqiyi-18", 11);
            put("aiqiyi-19", 12);
            put("aiqiyi-2", 13);
            put("aiqiyi-20", 14);
            put("aiqiyi-21", 15);
            put("aiqiyi-22", 16);
            put("aiqiyi-23", 17);
            put("aiqiyi-24", 18);
            put("aiqiyi-25", 19);
            put("aiqiyi-26", 20);
            put("aiqiyi-27", 21);
            put("aiqiyi-28", 22);
            put("aiqiyi-29", 23);
            put("aiqiyi-3", 24);
            put("aiqiyi-30", 25);
            put("aiqiyi-30003", 26);
            put("aiqiyi-30005", 27);
            put("aiqiyi-30008", 28);
            put("aiqiyi-30010", 29);
            put("aiqiyi-31", 30);
            put("aiqiyi-32", 31);
            put("aiqiyi-33", 32);
            put("aiqiyi-34", 33);
            put("aiqiyi-4", 34);
            put("aiqiyi-40004", 35);
            put("aiqiyi-49999", 36);
            put("aiqiyi-5", 37);
            put("aiqiyi-6", 38);
            put("aiqiyi-7", 39);
            put("aiqiyi-8", 40);
            put("aiqiyi-9", 41);
            put("aiqiyi-97", 42);
            put("aiqiyi-99", 43);
            put("mango-0", 44);
            put("mango-1", 45);
            put("mango-105", 46);
            put("mango-111", 47);
            put("mango-116", 48);
            put("mango-117", 49);
            put("mango-120", 50);
            put("mango-2", 51);
            put("mango-20", 52);
            put("mango-3", 53);
            put("mango-50", 54);
        }
    };

    // 资源标签编码
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>(){
        {
            put( "07.23.0008",0);
            put( "07.23.0019",1);
            put( "07.23.0010",2);
            put( "07.24.0001",3);
            put( "07.23.0013",4);
            put( "07.23.0018",5);
            put( "07.23.0009",6);
            put( "07.23.0030",7);
            put( "07.23.0012",8);
            put( "07.23.0036",9);
            put( "07.23.0021",10);
        }
    };


    /**
     * 将非空值放入map
     */
    public static void putMapNotNull(Map<String, String> map, String key, String value) {

        if (map == null || StringUtils.isBlank(value)) {
            return;
        }

        map.put(key, value);
    }


    public static void main(String[] args) {
        DPAFeature dpa = new DPAFeature();
//        dpa.setHistEntrancesExposeTime("{\"1\": 1, \"2\": 2}");
//        Map<String, String> retMap = generateDPAFeature(dpa);
//        System.out.println(retMap.toString());
    }
}


