/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.stat;

import cn.com.duiba.nezha.alg.stat.dto.CorrectStatDto;
import cn.com.duiba.nezha.alg.stat.utils.AssertUtil;
import cn.com.duiba.nezha.alg.stat.utils.MathUtil;
import cn.com.duiba.nezha.alg.stat.utils.MergerUtil;
import java.util.Map;

public class CorrectStatMerger {
    public static CorrectStatDto dimMerge(CorrectStatDto dimDto, CorrectStatDto globalDto) throws Exception {
        CorrectStatDto ret = null;
        if (globalDto != null && globalDto.getCtrLaunchCnt() > 10L) {
            ret = globalDto;
        }
        if (dimDto != null && dimDto.getCtrLaunchCnt() > 10L) {
            ret = dimDto;
        }
        return ret;
    }

    public static CorrectStatDto intervalMerge(Map<Long, CorrectStatDto> correctStatDtoHourMap, Map<Long, CorrectStatDto> correctStatDtoDayMap) throws Exception {
        CorrectStatDto ret = null;
        if (AssertUtil.isAllEmpty(correctStatDtoHourMap, correctStatDtoDayMap)) {
            return ret;
        }
        ret = new CorrectStatDto();
        CorrectStatDto hourMergeDto = CorrectStatMerger.statMerge(correctStatDtoHourMap, 6, 1L);
        CorrectStatDto dayMergeDto = CorrectStatMerger.statMerge(correctStatDtoDayMap, 3, 2L);
        long hourCtrLaunchCnt = 0L;
        long hourCvrLaunchCnt = 0L;
        double hourPreCtrAcc = 0.0;
        double hourPreCvrAcc = 0.0;
        double hourStatCtrAcc = 0.0;
        double hourStatCvrAcc = 0.0;
        long dayCtrLaunchCnt = 0L;
        long dayCvrLaunchCnt = 0L;
        double dayPreCtrAcc = 0.0;
        double dayPreCvrAcc = 0.0;
        double dayStatCtrAcc = 0.0;
        double dayStatCvrAcc = 0.0;
        if (hourMergeDto != null) {
            hourCtrLaunchCnt = MathUtil.tolong(hourMergeDto.getCtrLaunchCnt());
            hourCvrLaunchCnt = MathUtil.tolong(hourMergeDto.getCvrLaunchCnt());
            hourPreCtrAcc = MathUtil.toddouble(hourMergeDto.getPreCtrAcc());
            hourPreCvrAcc = MathUtil.toddouble(hourMergeDto.getPreCvrAcc());
            hourStatCtrAcc = MathUtil.toddouble(hourMergeDto.getStatCtrAcc());
            hourStatCvrAcc = MathUtil.toddouble(hourMergeDto.getStatCvrAcc());
        }
        if (dayMergeDto != null) {
            dayCtrLaunchCnt = MathUtil.tolong(dayMergeDto.getCtrLaunchCnt());
            dayCvrLaunchCnt = MathUtil.tolong(dayMergeDto.getCvrLaunchCnt());
            dayPreCtrAcc = MathUtil.toddouble(dayMergeDto.getPreCtrAcc());
            dayPreCvrAcc = MathUtil.toddouble(dayMergeDto.getPreCvrAcc());
            dayStatCtrAcc = MathUtil.toddouble(dayMergeDto.getStatCtrAcc());
            dayStatCvrAcc = MathUtil.toddouble(dayMergeDto.getStatCvrAcc());
        }
        Double historyPreCtrAvg = MergerUtil.getCtrWithBias(dayPreCtrAcc, dayCtrLaunchCnt, 100L, null, 100L, 6);
        Double historyPreCvrAvg = MergerUtil.getCtrWithBias(dayPreCvrAcc, dayCvrLaunchCnt, 100L, null, 100L, 6);
        Double historyStatCtrAvg = MergerUtil.getCtrWithBias(dayStatCtrAcc, dayCtrLaunchCnt, 100L, null, 100L, 6);
        Double historyStatCvrAvg = MergerUtil.getCtrWithBias(dayStatCvrAcc, dayCvrLaunchCnt, 100L, null, 100L, 6);
        Double hourPreCtrAvg = MergerUtil.getCtrWithBias(hourPreCtrAcc, hourCtrLaunchCnt, 100L, historyPreCtrAvg, 100L, 6);
        Double hourPreCvrAvg = MergerUtil.getCtrWithBias(hourPreCvrAcc, hourCvrLaunchCnt, 100L, historyPreCvrAvg, 100L, 6);
        Double hourStatCtrAvg = MergerUtil.getCtrWithBias(hourStatCtrAcc, hourCtrLaunchCnt, 100L, historyStatCtrAvg, 100L, 6);
        Double hourStatCvrAvg = MergerUtil.getCtrWithBias(hourStatCvrAcc, hourCvrLaunchCnt, 100L, historyStatCvrAvg, 100L, 6);
        ret.setCtrLaunchCnt(hourCtrLaunchCnt);
        ret.setCvrLaunchCnt(hourCvrLaunchCnt);
        ret.setPreCtrAcc(hourPreCtrAcc);
        ret.setPreCvrAcc(hourPreCvrAcc);
        ret.setStatCtrAcc(hourStatCtrAcc);
        ret.setStatCvrAcc(hourStatCvrAcc);
        ret.setPreCtrAvg(hourPreCtrAvg);
        ret.setPreCvrAvg(hourPreCvrAvg);
        ret.setStatCtrAvg(hourStatCtrAvg);
        ret.setStatCvrAvg(hourStatCvrAvg);
        return ret;
    }

    private static CorrectStatDto statMerge(Map<Long, CorrectStatDto> statDtoMap, int upLimit, Long type) throws Exception {
        CorrectStatDto ret = null;
        if (AssertUtil.isEmpty(statDtoMap) || type == null) {
            return ret;
        }
        ret = new CorrectStatDto();
        Long weightCnt = 0L;
        Long ctrLaunchCnt = 0L;
        Long cvrLaunchCnt = 0L;
        Double preCtrAcc = 0.0;
        Double preCvrAcc = 0.0;
        Double statCtrAcc = 0.0;
        Double statCvrAcc = 0.0;
        int i = 0;
        for (Map.Entry<Long, CorrectStatDto> entry : statDtoMap.entrySet()) {
            Long index = entry.getKey();
            Long weight = CorrectStatMerger.mergeWeight(index, type, upLimit);
            CorrectStatDto dto = entry.getValue();
            if (weight == null || dto == null) continue;
            weightCnt = weightCnt + weight;
            ctrLaunchCnt = MathUtil.add(MathUtil.dot(dto.getCtrLaunchCnt(), weight), ctrLaunchCnt);
            cvrLaunchCnt = MathUtil.add(MathUtil.dot(dto.getCvrLaunchCnt(), weight), cvrLaunchCnt);
            preCtrAcc = MathUtil.add(MathUtil.dot(dto.getPreCtrAcc(), weight), preCtrAcc);
            preCvrAcc = MathUtil.add(MathUtil.dot(dto.getPreCvrAcc(), weight), preCvrAcc);
            statCtrAcc = MathUtil.add(MathUtil.dot(dto.getStatCtrAcc(), weight), statCtrAcc);
            statCvrAcc = MathUtil.add(MathUtil.dot(dto.getStatCvrAcc(), weight), statCvrAcc);
            ++i;
        }
        ret.setCtrLaunchCnt(MathUtil.division(ctrLaunchCnt, (Long)(weightCnt / (long)i)));
        ret.setCvrLaunchCnt(MathUtil.division(cvrLaunchCnt, (Long)(weightCnt / (long)i)));
        ret.setPreCtrAcc(MathUtil.division(preCtrAcc, (Long)(weightCnt / (long)i), 5));
        ret.setPreCvrAcc(MathUtil.division(preCvrAcc, (Long)(weightCnt / (long)i), 5));
        ret.setStatCtrAcc(MathUtil.division(statCtrAcc, (Long)(weightCnt / (long)i), 5));
        ret.setStatCvrAcc(MathUtil.division(statCvrAcc, (Long)(weightCnt / (long)i), 5));
        return ret;
    }

    private static Long mergeWeight(long lastNum, Long type, long upLimit) {
        Long ret = 1L;
        if (lastNum > upLimit) {
            return ret;
        }
        if (type.equals(1L)) {
            ret = MergerUtil.hourMergeWeight(lastNum);
        }
        if (type.equals(2L)) {
            ret = MergerUtil.dayMergeWeight(lastNum);
        }
        return ret;
    }
}

