package cn.com.duiba.nezha.alg.stat;
//import cn.com.duiba.nezha.alg.api.vo.PreDcvrStatInfo;

import cn.com.duiba.nezha.alg.api.vo.PreDcvrStatInfo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;

import java.io.Serializable;

/**
 * predcvr-统计对象
 */
public class DcvrStatMerger implements Serializable {


    /**
     * 统计数据融合
     *
     * @param pastStatInfo    历史
     * @param currentStatInfo 当前
     * @return
     */
    public static PreDcvrStatInfo merge(PreDcvrStatInfo pastStatInfo, PreDcvrStatInfo currentStatInfo) {

        PreDcvrStatInfo ret = new PreDcvrStatInfo();
        if (pastStatInfo == null) {
            pastStatInfo = new PreDcvrStatInfo();
        }

        if (currentStatInfo == null) {
            currentStatInfo = new PreDcvrStatInfo();
        }

        ret = currentStatInfo;

        Double decayFactor = getDecayFactor(pastStatInfo.getPastPV(), currentStatInfo.getCurrentPV());
        Long pv = mergeNew(pastStatInfo.getPastPV(), currentStatInfo.getCurrentPV(), decayFactor);
        Double sum = mergeNew(pastStatInfo.getPastSum(), currentStatInfo.getCurrentSum(), decayFactor);
        Double squareSum = mergeNew(pastStatInfo.getPastSquareSum(), currentStatInfo.getCurrentSquareSum(), decayFactor);

        ret.setPastPV(pv);
        ret.setPastSum(sum);
        ret.setPastSquareSum(squareSum);

        updateMeanAndSD(ret, pv, sum, squareSum);


        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));

        return ret;
    }


    /**
     * @param pv
     * @param sum
     * @param squareSum
     */
    public static void updateMeanAndSD(PreDcvrStatInfo preDcvrStatInfo, Long pv, Double sum, Double squareSum) {


        if (preDcvrStatInfo != null) {

            /**
             * 置信统计约束
             */
            if (pv > 5000 && sum > 0.001 && squareSum > 0.0001) {
                Double mean = sum / pv;
                Double variance = squareSum / (pv - 1) - mean * mean;

                Double sd = Math.sqrt(variance);


                /**
                 * 范围约束
                 */
                mean = MathUtil.stdwithBoundary(mean, 0.03, 0.9);

                sd = MathUtil.stdwithBoundary(sd, 0.01, 0.3);

                preDcvrStatInfo.setMergeMean(DataUtil.formatDouble(mean, 4));


                preDcvrStatInfo.setMergeSD(DataUtil.formatDouble(sd, 4));
            }


        }


    }


    /**
     * 融合
     *
     * @param passValue
     * @param currentValue
     * @param decayFactor
     * @return
     */
    public static Long mergeNew(Long passValue, Long currentValue, Double decayFactor) {

        Long ret = null;
        if (passValue == null) {
            passValue = 0L;
        }
        if (currentValue == null) {
            currentValue = 0L;
        }

        if (decayFactor == null) {

            ret = passValue + currentValue;
        } else {
            ret = DataUtil.double2Long(decayFactor * passValue + currentValue);
        }


        return ret;

    }

    /**
     * 融合
     *
     * @param passValue
     * @param currentValue
     * @param decayFactor
     * @return
     */
    public static Double mergeNew(Double passValue, Double currentValue, Double decayFactor) {
        Double ret = null;
        if (passValue == null) {
            passValue = 0.0;
        }
        if (currentValue == null) {
            currentValue = 0.0;
        }

        if (decayFactor == null) {
            ret = passValue + currentValue;
        } else {
            ret = decayFactor * passValue + currentValue;
        }
        return ret;

    }

    /**
     * 计算衰减因子
     *
     * @param pastPv
     * @param currentPv
     * @return
     */
    public static Double getDecayFactor(Long pastPv, Long currentPv) {
        Double ret = 0.0;

        if (pastPv == null || pastPv < 10000) {

            // 1、无历史累计 或 历史累计不足 ，不衰减 返回空
            ret = null;
        } else {
            // 2、历史累计正常，衰减

            if (currentPv == null || currentPv < 1000) {
                ret = 0.98;
            } else {
                ret = 0.96;
            }
        }

        return ret;
    }


    public static void main(String[] args) {

        PreDcvrStatInfo pastStatInfo = new PreDcvrStatInfo();
        pastStatInfo.setPastPV(10000L);
        pastStatInfo.setPastSum(1000.0);
        pastStatInfo.setPastSquareSum(10.0);


        PreDcvrStatInfo currentStatInfo = new PreDcvrStatInfo();
        currentStatInfo.setCurrentPV(10000L);
        currentStatInfo.setCurrentSum(78.99388096 * 50);
        currentStatInfo.setCurrentSquareSum(33.64200558 * 50);

        PreDcvrStatInfo ret = merge(null, currentStatInfo);
        System.out.println(JSON.toJSONString(ret));

        for (int i = 0; i < 10; i++) {
            ret = merge(ret, currentStatInfo);
            System.out.println(JSON.toJSONString(ret));
        }


    }
}
