/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.feature;

import cn.com.duiba.nezha.compute.feature.FeatureCoderBase;
import cn.com.duiba.nezha.compute.feature.constant.FeatureListConstant;
import cn.com.duiba.nezha.compute.feature.enums.FeatureEnumC1;
import cn.com.duiba.nezha.compute.feature.vo.Feature;
import cn.com.duiba.nezha.compute.feature.vo.FeatureBaseCode;
import cn.com.duiba.nezha.compute.feature.vo.FeatureCodeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureCoder
extends FeatureCoderBase {
    public static Feature featureCode(Map<String, String> featureMap, List<FeatureBaseCode> codeList) {
        Feature feature = null;
        try {
            if (codeList != null) {
                ArrayList<FeatureCodeInfo> list = new ArrayList<FeatureCodeInfo>();
                for (FeatureBaseCode f : codeList) {
                    String value = featureMap.getOrDefault(f.getName(), null);
                    FeatureCodeInfo info = new FeatureCodeInfo(f.getName(), f.getCodeType(), f.getSubLen(), f.getHashNums(), value);
                    list.add(info);
                }
                feature = FeatureCoder.code(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return feature;
    }

    public static List<FeatureBaseCode> getFeatureCode(String modelId) {
        ArrayList<FeatureBaseCode> list = new ArrayList<FeatureBaseCode>();
        try {
            for (FeatureEnumC1 f : FeatureListConstant.getFLC1001()) {
                FeatureBaseCode info = new FeatureBaseCode();
                info.setName(f.getName());
                info.setCodeType(f.getCodeType());
                info.setSubLen(f.getSubLen());
                info.setHashNums(f.getHashNums());
                list.add(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Map<String, FeatureBaseCode> getFeatureCodeMap(String modelId) {
        HashMap<String, FeatureBaseCode> map = new HashMap<String, FeatureBaseCode>();
        try {
            for (FeatureEnumC1 f : FeatureListConstant.getFLC1001()) {
                FeatureBaseCode info = new FeatureBaseCode();
                info.setName(f.getName());
                info.setCodeType(f.getCodeType());
                info.setSubLen(f.getSubLen());
                info.setHashNums(f.getHashNums());
                map.put(f.getName(), info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Feature featureCode(Map<String, String> featureMap, String modelId) {
        Feature feature = null;
        try {
            List<FeatureBaseCode> list = FeatureCoder.getFeatureCode(modelId);
            if (list != null) {
                feature = FeatureCoder.featureCode(featureMap, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return feature;
    }

    public static Feature code(List<FeatureCodeInfo> list) throws Exception {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Long> pLenList = new ArrayList<Long>();
        for (FeatureCodeInfo info : list) {
            if (info.codeType == 10) {
                FeatureCoderBase.getSubId(info.name, info.value, info.subLen, pLenList, indices, values);
            }
            if (info.codeType == 11) {
                FeatureCoderBase.getSubIds(info.name, info.value, ",", info.subLen, pLenList, indices, values);
            }
            if (info.codeType == 20) {
                FeatureCoderBase.getHashSubId(info.name, info.value, info.subLen, info.hashNums, pLenList, indices, values);
            }
            if (info.codeType == 21) {
                FeatureCoderBase.getHashSubIds(info.name, info.value, ",", info.subLen, info.hashNums, pLenList, indices, values);
            }
            if (info.codeType == 30) {
                FeatureCoderBase.getDictSubId(info.name, info.value, info.subLen, pLenList, indices, values);
            }
            if (info.codeType != 31) continue;
            FeatureCoderBase.getDictSubIds(info.name, info.value, ",", info.subLen, pLenList, indices, values);
        }
        return FeatureCoderBase.toFeature(indices, values, pLenList);
    }
}

