/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.feature;

import cn.com.duiba.nezha.compute.core.util.AssertUtil;
import cn.com.duiba.nezha.compute.feature.FeatureUtil;
import cn.com.duiba.nezha.compute.feature.constant.FeatureMapConstant;
import cn.com.duiba.nezha.compute.feature.vo.Feature;
import java.util.List;
import java.util.Map;

public class FeatureCoderBase {
    public static int getVectorSize(List<Long> pLenList) {
        Long tmp;
        int ret = 0;
        if (pLenList != null && pLenList.size() > 0 && (tmp = pLenList.get(pLenList.size() - 1)) != null) {
            ret = tmp.intValue();
        }
        return ret;
    }

    public static void getSubId(String feature, String fStr, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        indices.add(pLen + fId);
        values.add(1.0);
        pLenList.add(0L + (long)pLen + (long)fSize);
    }

    public static void getSubIds(String feature, String fStr, String seq, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);
        for (int i = 0; i < sFIds.length; ++i) {
            int fId = pLen + sFIds[i];
            indices.add(pLen + fId);
            values.add(1.0 / (double)sFIds.length);
        }
        pLenList.add(0L + (long)pLen + (long)fSize);
    }

    public static void getHashSubId(String feature, String fStr, int pFSize, int pFNums, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, pFSize, pFNums);
        for (int i = 0; i < pFNums; ++i) {
            int fId = pLen + sFIds[i];
            indices.add(pLen + fId);
            values.add(1.0 / (double)pFNums);
        }
        pLenList.add(0L + (long)pLen + (long)(pFNums * pFSize));
    }

    public static void getHashSubIds(String feature, String fStr, String seq, int pFSize, int pFNums, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, pFSize, pFNums);
        for (int i = 0; i < pFNums; ++i) {
            int fId = pLen + sFIds[i];
            indices.add(pLen + fId);
            values.add(1.0 / (double)pFNums);
        }
        pLenList.add(0L + (long)pLen + (long)(pFNums * pFSize));
    }

    public static void getDictSubId(String feature, String fStr, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        Map<String, Long> fMap = FeatureMapConstant.getFeatureIdxMap(feature);
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fMap);
        indices.add(pLen + fId);
        values.add(1.0);
        pLenList.add(0L + (long)pLen + (long)fSize);
    }

    public static void getDictSubIds(String feature, String fStr, String seq, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        Map<String, Long> fMap = FeatureMapConstant.getFeatureIdxMap(feature);
        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fMap);
        for (int i = 0; i < sFIds.length; ++i) {
            int fId = pLen + sFIds[i];
            indices.add(pLen + fId);
            values.add(1.0 / (double)sFIds.length);
        }
        pLenList.add(0L + (long)pLen + (long)fSize);
    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<Long> pLenList) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{indices, values, pLenList})) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }
        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }
        int[] indices2 = new int[indices.size()];
        double[] values2 = new double[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indices2[i] = indices.get(i);
            values2[i] = values.get(i);
        }
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        return new Feature(pLen, indices2, values2);
    }
}

