/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.feature.constant;

import java.util.HashMap;
import java.util.Map;

public class FeatureMapConstant {
    public static String[] F501001 = new String[]{"android", "ios", "unknow"};
    public static String[] F505001 = new String[]{"0-599", "600-1099", "1100-1699", "1700-2699", "2700-4499", "4500+"};
    public static Map<String, Map<String, Long>> cacheMap = new HashMap<String, Map<String, Long>>();

    public static Map<String, Long> getFeatureIdxMap(String feature) throws Exception {
        Map<String, Long> fMap = FeatureMapConstant.getFeatureCacheMap(feature);
        if (fMap == null) {
            FeatureMapConstant.setFeatureCacheMap(feature);
        }
        return FeatureMapConstant.getFeatureCacheMap(feature);
    }

    public static int getIdx(String feature, String str) throws Exception {
        int ret = 0;
        Map<String, Long> fMap = FeatureMapConstant.getFeatureIdxMap(feature);
        Long tmp = fMap.getOrDefault(str, 0L);
        if (tmp != null) {
            ret = tmp.intValue();
        }
        return ret;
    }

    public static void setFeatureCacheMap(String feature) throws Exception {
        switch (feature) {
            case "f501001": {
                FeatureMapConstant.setFeatureCacheMap(feature, F501001);
                break;
            }
            case "f505001": {
                FeatureMapConstant.setFeatureCacheMap(feature, F505001);
                break;
            }
            default: {
                throw new Exception("setFeatureCacheMap default,invalid");
            }
        }
    }

    public static void setFeatureCacheMap(String feature, String[] fList) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < fList.length; ++i) {
            map.put(fList[i], (long)i + 1L);
        }
        cacheMap.put(feature, map);
    }

    public static Map<String, Long> getFeatureCacheMap(String feature) {
        return cacheMap.get(feature);
    }
}

