package com.duiba.rcmd.material;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BayesianMaterial {
    private ArrayList<Double> rewards;
    private ArrayList<Double> counts;
    private ArrayList<Double> alphas;
    private ArrayList<Double> betas;
    private int numMachines;
    private  ArrayList<Double> maxG ;
    private  ArrayList<Double> maxH;
    private double decay = 1;

     static class Constant{
        static double RT_REWARD_WEIGHT = 0;
        static double MIN_REWARD = 0.01;
        static long MAX_CLICK = 1000;
        static long DISCOUNT = 2;
        static double DECAY = 0.90;  //1000次以前的观察，无效
    }

    //这个info只是临时数据，只对当前这个列表数据进行处理,然后把结果累加进activityInfo中去。
     class Info{
        long id;
        double gctr; // global全局ctr
        double gexp; // 全局曝光
        double hctr; // 历史ctr
        double hexp; // 历史曝光
        double rctr; // 实时ctr
        double rexp; // 实时曝光
    }
    public double[] getTotalCtrAndExpAndClick(List<Long> exp,List<Long> click){
        double result[] = {0.0d, 0.0d, 0.0d};
        if (exp.size() != click.size())
        {
            return result;
        }
        double totalExp = 0;
        double totalClick = 0;
        for(int i = 0;i < exp.size();++i){

            totalExp += exp.get(i) == null?0 : exp.get(i);
            totalClick += click.get(i) == null?0 : click.get(i);
        }
        totalExp = totalExp == 0?1:totalExp;
        result[0] = totalExp;
        result[1] = totalClick;
        result[2] = totalClick/totalExp;
        System.out.print("totalExp="+totalExp);
        System.out.print("totalClick="+totalClick);
        System.out.print("totalClick/totalExp = "+totalClick/totalExp);
        return result;

    }
    public HashMap<Long,Info> initialization(ArrayList<Materialnfo> MaterialnfoList){
        //1、init
        clear();
        maxH = new ArrayList<Double>();
        this.decay = BayesianMaterial.Constant.DECAY;
        numMachines = MaterialnfoList.size();  //策略个数
        HashMap<Long,Info> mMap = new HashMap();  //每个 activityId 对应的该策略点击率等信息.这个新建的也会保留上一次的信息
        //2、info  对 当前的每个活动的列表数据进行处理，info的更新或者写入
        int countMaxg = 0;
        for(Materialnfo materialnfo: MaterialnfoList)  //循环每个策略
        {


            double result[] = getTotalCtrAndExpAndClick(materialnfo.exposure,materialnfo.click);
            double exposure = result[0];  ///最近1小时的总曝光
            double click = result[1];  //最近1小时的总点击次数
            double ctr = result[2];  //最近1小时的点击率

            //System.out.println("click= "+click);
            //System.out.println("activity"+activity.activityId + " lastclick= "+activity.lastClick);

            materialnfo.his_click = materialnfo.his_click + ctr;  //activity.lastClick是指上一次的点击率。此处加上本次的点击率
//            System.out.print("his_click="+materialnfo.his_click);
//            System.out.print("ctr="+ctr);
            materialnfo.his_exposures = materialnfo.his_exposures + 1;  //这个动作也将此次结果写进了固定的activityInfo中
            double hisCtr = getCtr(materialnfo.his_exposures,materialnfo.his_click);//截止上一次的累计曝光次数和累计点击率计算的累计ctr
            System.out.println("ctr ctr="+ctr);
            //System.out.println( "if contain activity1 "+mMap.containsKey(1l)); //为什么第二次循环开始这里会含有之前的key

            BayesianMaterial.Info info = mMap.containsKey(materialnfo.materialId) ? mMap.get(materialnfo.materialId) : new BayesianMaterial.Info();//为什么循环时这里mMap会含有历史数据？

            //System.out.println(" id= "+info.id + " info-hctr = "+info.hctr);


            maxH.add(0.01);

            info.hctr = hisCtr;
            info.hexp = materialnfo.his_exposures;
            if(info.hexp > 50)
                maxH.set(countMaxg,Math.max(hisCtr, maxH.get(countMaxg)));
            info.rexp = exposure;
            info.id = materialnfo.materialId;
            mMap.put(materialnfo.materialId,info);
            //System.out.println("mMap= "+mMap.get(1l).rctr);
            countMaxg += 1;
            //System.out.println("new  " + " id= "+info.id + " info-hctr = "+info.hctr);

        }


        return  mMap;

    }


    public Materialnfo selectActivity(ArrayList<Materialnfo> MaterialnfoList)
    {
        HashMap<Long,Info> mMap = this.initialization(MaterialnfoList);

        //3、update
        int countMaxg = 0;
        for(Materialnfo materialnfo: MaterialnfoList) {
            double exposure = mMap.get(materialnfo.materialId).rexp;


            if(exposure > 0) {
                double reward =  BayesianMaterial.Constant.MIN_REWARD;  //设定回报最小值
//                double confidence = activity.lastExposure > 200 ? 1 : activity.lastExposure/200;  //最后一次曝光大于200 置信度为1，否则为曝光量/200的值
//                reward = confidence * Math.min(mMap.get(activity.activityId).hctr * 0.5 / maxH, 0.5) ;
//                System.out.println("countMaxg="+countMaxg);
                reward = Math.min(mMap.get(materialnfo.materialId).hctr, 1) ;
                System.out.println("mMap.get(materialnfo.materialId).hctr ="+mMap.get(materialnfo.materialId).hctr);
//                System.out.println("reward***="+mMap.get(materialnfo.materialId).hctr +" "+ maxH.get(countMaxg));
                reward = Math.max(reward, BayesianMaterial.Constant.MIN_REWARD);



                //init
                if(materialnfo.count < 5)
                {
                    materialnfo.count = 5;
                    materialnfo.reward = mMap.get(materialnfo.materialId).hctr  * materialnfo.count;
                }
//                materialnfo.reward = materialnfo.reward * decay + reward;
//                materialnfo.reward = 1 + materialnfo.reward;


                materialnfo.alpha = materialnfo.alpha==0?1:materialnfo.alpha;
                materialnfo.beta = materialnfo.beta==0?1:materialnfo.beta;

                materialnfo.count = materialnfo.count  + 1.0;

                materialnfo.reward = materialnfo.reward * decay + reward;
                System.out.println("materialnfo.reward="+materialnfo.reward);
                materialnfo.count = materialnfo.count * decay + 1.0;



                materialnfo.alpha = 1.0 + materialnfo.reward;
                materialnfo.beta = 1.0 + (materialnfo.count - materialnfo.reward);
                countMaxg++;
            }

            rewards.add(materialnfo.reward);  //每一个活动的预期回报列表
            counts.add(materialnfo.count);
            alphas.add(materialnfo.alpha);     //每一个活动的alpha值列表
            betas.add(materialnfo.beta);

        }

        //3、select  选择最优的活动
        Materialnfo materialnfo = MaterialnfoList.get(selectMachine());  //通过每个策略最新的alphas，beta值，计算当前的beta分布下的概率值，取最大的这个概率值当做被筛选的活动
        List<Materialnfo> result = new ArrayList<>();
        result.add(materialnfo);
        mMap.clear();
        return materialnfo;
    }


    private void clear()
    {
        rewards = new ArrayList<Double>();
        counts = new ArrayList<Double>();
        alphas = new ArrayList<Double>();
        betas = new ArrayList<Double>();
    }


    /*对各个备选策略的后验Beta分布采样得到当次最优策略*/
    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0;
        for (int i = 0; i < numMachines; i++) {
            System.out.println(i+"alphas= "+alphas.get(i) );
            System.out.println(i+"betas= "+betas.get(i) );
            double theta =  com.duiba.rcmd.material.BetaDistributionMaterial.BetaDist(alphas.get(i), betas.get(i));  //一次选择每个策略，计算这个策略的beta分布返回值，选择值大的这个
            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }
        return selectMachine;  //返回的是最优素材的序号
    }

    private double getCtr(double exp, double clk)
    {
        return exp > 0 ? clk / exp : 0;
    }

    private double sum(ArrayList<Long> list){
        double sum = 0;
        for(Long val: list)
        {
            sum += val;
        }
        return sum;
    }


}
