/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.rcmd.material;

import com.duiba.rcmd.material.BayesianMaterial;
import com.duiba.rcmd.material.BetaDistributionMaterial;
import com.duiba.rcmd.material.Materialnfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BayesianMaterialUpdateInit {
    private ArrayList<Double> rewards;
    private ArrayList<Double> counts;
    private ArrayList<Double> alphas;
    private ArrayList<Double> betas;
    private int numMachines;
    private ArrayList<Double> maxG;
    private double maxH;
    private double decay = 1.0;

    public double[] getTotalCtrAndExpAndClick(List<Long> exp, List<Long> click) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        if (exp.size() != click.size()) {
            return result;
        }
        double totalExp = 0.0;
        double totalClick = 0.0;
        for (int i = 0; i < exp.size(); ++i) {
            totalExp += exp.get(i) == null ? 0.0 : (double)exp.get(i).longValue();
            totalClick += click.get(i) == null ? 0.0 : (double)click.get(i).longValue();
        }
        result[0] = totalExp = totalExp == 0.0 ? 183.0 : totalExp;
        result[1] = totalClick == 0.0 ? 95.0 : totalClick;
        result[2] = totalClick / totalExp;
        return result;
    }

    public HashMap<Long, Info> initialization(ArrayList<Materialnfo> MaterialnfoList) {
        this.clear();
        this.maxH = 0.01;
        this.decay = Constant.DECAY;
        this.numMachines = MaterialnfoList.size();
        HashMap<Long, Info> mMap = new HashMap<Long, Info>();
        int countMaxg = 0;
        for (Materialnfo materialnfo : MaterialnfoList) {
            double[] result = this.getTotalCtrAndExpAndClick(materialnfo.exposure, materialnfo.click);
            double exposure = result[0];
            double click = result[1];
            double ctr = result[2];
            if (materialnfo.his_click > (double)BayesianMaterial.Constant.MAX_CLICK) {
                materialnfo.his_click /= (double)BayesianMaterial.Constant.DISCOUNT;
                materialnfo.his_exposures /= (double)BayesianMaterial.Constant.DISCOUNT;
            }
            materialnfo.his_click += ctr;
            materialnfo.his_exposures += 1.0;
            double hisCtr = this.getCtr(materialnfo.his_exposures, materialnfo.his_click);
            System.out.println("materialId=" + materialnfo.materialId + " hisCtr=" + hisCtr);
            Info info = mMap.containsKey(materialnfo.materialId) ? mMap.get(materialnfo.materialId) : new Info();
            info.hctr = hisCtr;
            info.hexp = materialnfo.his_exposures;
            if (info.hexp > 50.0) {
                this.maxH = Math.max(hisCtr, this.maxH);
            }
            info.rexp = exposure;
            info.id = materialnfo.materialId;
            mMap.put(materialnfo.materialId, info);
            ++countMaxg;
        }
        return mMap;
    }

    public Materialnfo selectActivity(ArrayList<Materialnfo> MaterialnfoList) {
        HashMap<Long, Info> mMap = this.initialization(MaterialnfoList);
        int countMaxg = 0;
        for (Materialnfo materialnfo : MaterialnfoList) {
            double exposure = mMap.get((Object)Long.valueOf((long)materialnfo.materialId)).rexp;
            if (exposure > 0.0) {
                double reward = Constant.MIN_REWARD;
                reward = Math.min(mMap.get((Object)Long.valueOf((long)materialnfo.materialId)).hctr, 1.0);
                reward = Math.min(reward, 1.0);
                reward = Math.max(reward, Constant.MIN_REWARD);
                if (materialnfo.count < 5.0) {
                    materialnfo.count = 5.0;
                    materialnfo.reward = mMap.get((Object)Long.valueOf((long)materialnfo.materialId)).hctr * materialnfo.count;
                }
                materialnfo.alpha = materialnfo.alpha == 0.0 ? 95.0 : materialnfo.alpha;
                materialnfo.beta = materialnfo.beta == 0.0 ? 88.0 : materialnfo.beta;
                materialnfo.count += 1.0;
                materialnfo.reward = materialnfo.reward * this.decay + reward;
                materialnfo.count = materialnfo.count * this.decay + 1.0;
                materialnfo.alpha = 1.0 + materialnfo.reward;
                materialnfo.beta = 1.0 + (materialnfo.count - materialnfo.reward);
                ++countMaxg;
            }
            this.rewards.add(materialnfo.reward);
            this.counts.add(materialnfo.count);
            this.alphas.add(materialnfo.alpha);
            this.betas.add(materialnfo.beta);
        }
        Materialnfo materialnfo = MaterialnfoList.get(this.selectMachine());
        ArrayList<Materialnfo> result = new ArrayList<Materialnfo>();
        result.add(materialnfo);
        mMap.clear();
        return materialnfo;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistributionMaterial.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(ArrayList<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    class Info {
        long id;
        double gctr;
        double gexp;
        double hctr;
        double hexp;
        double rctr;
        double rexp;

        Info() {
        }
    }

    static class Constant {
        static double RT_REWARD_WEIGHT = 0.0;
        static double MIN_REWARD = 0.1;
        static long MAX_CLICK = 1000L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

