package cn.com.duiba.nezha.compute.alg;


import cn.com.duiba.nezha.compute.api.dto.AdvertModelEntity;
import cn.com.duiba.nezha.compute.api.enums.SerializerEnum;
import cn.com.duiba.nezha.compute.api.dict.CategoryFeatureDict;
import cn.com.duiba.nezha.compute.alg.util.CategoryFeatureDictUtil;
import cn.com.duiba.nezha.compute.alg.util.LogisticRegressionModelUtil;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by pc on 2016/12/22.
 */
public class AdvertCtrLogisticRegression implements Serializable, IAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(AdvertCtrLogisticRegression.class);
    private CategoryFeatureDictUtil categoryFeatureDictUtil = null;
    private LogisticRegressionModelUtil logisticRegressionModelUtil = null;
    private List<String> featureIdxList = null;

    public AdvertCtrLogisticRegression() {
    }

    public AdvertCtrLogisticRegression(String featureIdxList, String dict, String modelStr, SerializerEnum serializerEnum) {
        setFeatureDict(dict, serializerEnum);
        setModel(modelStr, serializerEnum);
        setFeatureIdxList(featureIdxList, serializerEnum);
    }

    public AdvertCtrLogisticRegression(AdvertModelEntity entity) {
        SerializerEnum serializerEnum = entity.getSerializerId() == SerializerEnum.KRYO.getIndex() ? SerializerEnum.KRYO : SerializerEnum.JAVA_ORIGINAL;
        setFeatureDict(entity.getFeatureDictStr(), serializerEnum);
        setModel(entity.getModelStr(), serializerEnum);
        setFeatureIdxList(entity.getFeatureIdxListStr(), serializerEnum);
    }

    public List<String> getFeatureIdxList() {
        if (this.featureIdxList == null) {
            return null;
        } else {
            return this.featureIdxList;
        }
    }


    public CategoryFeatureDictUtil getDictUtil() {
        if (this.categoryFeatureDictUtil == null) {
            this.categoryFeatureDictUtil = new CategoryFeatureDictUtil();
        }
        return this.categoryFeatureDictUtil;
    }

    public LogisticRegressionModelUtil getModelUtil() {
        if (this.logisticRegressionModelUtil == null) {
            this.logisticRegressionModelUtil = new LogisticRegressionModelUtil();
        }
        return this.logisticRegressionModelUtil;
    }

    public void setFeatureDict(CategoryFeatureDict dict) {
        getDictUtil().setFeatureDict(dict);
    }

    public void setFeatureDict(String dict, SerializerEnum serializerEnum) {
        getDictUtil().setFeatureDict(dict, serializerEnum);
    }

    public void setModel(LogisticRegressionModel model) {
        getModelUtil().setModel(model);
    }

    public void setModel(String modelStr, SerializerEnum serializerEnum) {
        getModelUtil().setModel(modelStr, serializerEnum);
    }


    public void setFeatureIdxList(List<String> featureIdxList) {

        this.featureIdxList = featureIdxList;
    }

    public void setFeatureIdxList(String featureIdxStr, SerializerEnum serializerEnum) {

        this.featureIdxList = getDictUtil().getFeatureIdxList(featureIdxStr, serializerEnum);

    }

    public String getFeatureIdxListStr(SerializerEnum serializerEnum) {
        return getDictUtil().featureIdxList2Str(getFeatureIdxList(), serializerEnum);
    }

    public String getFeatureDictStr(SerializerEnum serializerEnum) {
        return getDictUtil().getFeatureDictStr(serializerEnum);
    }

    public String getModelStr(SerializerEnum serializerEnum) {

        return getModelUtil().getModelStr(serializerEnum);
    }


    public Double predict(List<String> categoryList) {
        Double ret = null;
        try {
            SparseVector sv = getDictUtil().oneHotSparseVectorEncode(getFeatureIdxList(), categoryList);
            if (sv != null) {
                ret = getModelUtil().predict(sv);
            }
        } catch (Exception e) {
            logger.error("predict happend error", e);
        }
        return ret;
    }

    public Double predict(Map<String, String> categoryMap) {
        Double ret = null;
        try {

            SparseVector sv = getDictUtil().oneHotSparseVectorEncodeWithMap(getFeatureIdxList(), categoryMap);
            if (sv != null) {
                ret = getModelUtil().predict(sv);
            }
        } catch (Exception e) {
            logger.error("predict happend error", e);
        }

        return ret;
    }

    public Double predict2(Map<String, String> categoryMap) {
        Double ret = null;
        try {

            double[] sv = getDictUtil().oneHotDoubleEncodeWithMap(getFeatureIdxList(), categoryMap);


            if (sv != null) {
                ret = getModelUtil().predict(Vectors.dense(sv));
            }
        } catch (Exception e) {
            logger.error("predict happend error", e);
        }

        return ret;
    }


}
