package cn.com.duiba.nezha.compute.alg;


import cn.com.duiba.nezha.compute.alg.util.CategoryFeatureDictUtil;
import cn.com.duiba.nezha.compute.alg.util.FMModelUtil;
import cn.com.duiba.nezha.compute.api.dict.CategoryFeatureDict;
import cn.com.duiba.nezha.compute.api.dto.AdvertModelEntity;
import cn.com.duiba.nezha.compute.api.enums.SerializerEnum;
import cn.com.duiba.nezha.compute.mllib.model.SparseFMModel;
import org.apache.spark.mllib.linalg.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by pc on 2016/12/22.
 */
public class  BaseAlgorithm implements Serializable{
    private static final Logger logger = LoggerFactory.getLogger(BaseAlgorithm.class);
    private CategoryFeatureDictUtil categoryFeatureDictUtil = null;
    private List<String> featureIdxList = null;


    public BaseAlgorithm() {
    }

    public BaseAlgorithm(String featureIdxList, String dict, String modelStr, SerializerEnum serializerEnum) {
        setFeatureDict(dict, serializerEnum);
        setModel(modelStr, serializerEnum);
        setFeatureIdxList(featureIdxList, serializerEnum);
    }

    public BaseAlgorithm(AdvertModelEntity entity) {
        SerializerEnum serializerEnum = entity.getSerializerId() == SerializerEnum.KRYO.getIndex() ? SerializerEnum.KRYO : SerializerEnum.JAVA_ORIGINAL;
        setFeatureDict(entity.getFeatureDictStr(), serializerEnum);
        setModel(entity.getModelStr(), serializerEnum);
        setFeatureIdxList(entity.getFeatureIdxListStr(), serializerEnum);
    }

    public List<String> getFeatureIdxList() {
        if (this.featureIdxList == null) {
            return null;
        } else {
            return this.featureIdxList;
        }
    }


    public CategoryFeatureDictUtil getDictUtil() {
        if (this.categoryFeatureDictUtil == null) {
            this.categoryFeatureDictUtil = new CategoryFeatureDictUtil();
        }
        return this.categoryFeatureDictUtil;
    }


    public void setFeatureDict(CategoryFeatureDict dict) {
        getDictUtil().setFeatureDict(dict);
    }

    public void setFeatureDict(String dict, SerializerEnum serializerEnum) {
        getDictUtil().setFeatureDict(dict, serializerEnum);
    }

    public void setModel(SparseFMModel model) {
    }

    public void setModel(String modelStr, SerializerEnum serializerEnum) {
    }


    public void setFeatureIdxList(List<String> featureIdxList) {

        this.featureIdxList = featureIdxList;
    }

    public void setFeatureIdxList(String featureIdxStr, SerializerEnum serializerEnum) {

        this.featureIdxList = getDictUtil().getFeatureIdxList(featureIdxStr, serializerEnum);

    }

    public String getFeatureIdxListStr(SerializerEnum serializerEnum) {
        return getDictUtil().featureIdxList2Str(getFeatureIdxList(), serializerEnum);
    }

    public String getFeatureDictStr(SerializerEnum serializerEnum) {
        return getDictUtil().getFeatureDictStr(serializerEnum);
    }

    public String getModelStr(SerializerEnum serializerEnum) {

        return "this model";

    }


}
