/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.alg;

import cn.com.duiba.nezha.compute.alg.ModelPredRectifier;
import cn.com.duiba.nezha.compute.alg.vo.BackendAdvertStatDo;
import cn.com.duiba.nezha.compute.alg.vo.StatDo;
import cn.com.duiba.nezha.compute.common.util.AssertUtil;
import cn.com.duiba.nezha.compute.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class BackendOptimizer {
    public static Map<String, Double> backendTypePriorityMap = new HashMap<String, Double>();

    public static Map<Long, BackendAdvertStatDo> getBackendAdvertStatInfo(Map<Long, StatDo> appAdvertStatMap, Map<Long, StatDo> globalAdvertStatMap) {
        HashMap<Long, BackendAdvertStatDo> ret = new HashMap<Long, BackendAdvertStatDo>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{globalAdvertStatMap})) {
            if (appAdvertStatMap == null) {
                appAdvertStatMap = new HashMap<Long, StatDo>();
            }
            for (Map.Entry<Long, StatDo> entry : globalAdvertStatMap.entrySet()) {
                Long advertId = entry.getKey();
                StatDo globalStatDo = entry.getValue();
                StatDo appStatDo = appAdvertStatMap.get(advertId);
                String type = BackendOptimizer.getTaskBackendType(globalStatDo);
                if (type == null) continue;
                BackendAdvertStatDo backendAdvertStatDo = new BackendAdvertStatDo();
                backendAdvertStatDo.setAdvertId(advertId);
                backendAdvertStatDo.setBackendType(type);
                backendAdvertStatDo.setAvgBackendCvr(BackendOptimizer.getTaskBackendCvr(globalStatDo, type));
                backendAdvertStatDo.setCBackendCvr(BackendOptimizer.getTaskBackendCvr(appStatDo, type));
                ret.put(advertId, backendAdvertStatDo);
            }
        }
        return ret;
    }

    public static Map<Long, Double> getBackendAdvertInfo(Map<Long, Double> advertPreInfo, Map<Long, BackendAdvertStatDo> advertStatInfo) {
        HashMap<Long, Double> ret = new HashMap<Long, Double>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertPreInfo, advertStatInfo})) {
            for (Map.Entry<Long, BackendAdvertStatDo> entry : advertStatInfo.entrySet()) {
                Double mergeCvr;
                Double optFactor;
                Long advertId = entry.getKey();
                BackendAdvertStatDo backendAdvertStatDo = entry.getValue();
                Double preBackendCvr = advertPreInfo.get(advertId);
                if (backendAdvertStatDo == null || preBackendCvr == null || (optFactor = BackendOptimizer.getBackendOptFactor(mergeCvr = BackendOptimizer.getMergeBackendCvr(backendAdvertStatDo.getCBackendCvr(), preBackendCvr), backendAdvertStatDo.getAvgBackendCvr())) == null) continue;
                ret.put(advertId, optFactor);
            }
        }
        return ret;
    }

    public static Double getBackendOptFactor(Double mergeCvr, Double avgCvr) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{mergeCvr, avgCvr})) {
            Double ratio = (mergeCvr + 0.001) / (avgCvr + 0.001);
            ret = ratio <= 1.0 ? ModelPredRectifier.sigmoidWithZoomAndIntervalMap(ratio - 0.25, 0.1, 1.0, 20.0) : (ratio <= 2.0 ? Double.valueOf(1.05) : Double.valueOf(1.1));
        }
        return ret;
    }

    public static Double getMergeBackendCvr(Double statCvr, Double preCvr) {
        Double ret = null;
        if (statCvr != null && preCvr != null) {
            ret = 0.1 * statCvr + 0.9 * preCvr;
        }
        return ret;
    }

    public static Double getTaskBackendCvr(StatDo statDo, String backendType) {
        Double ret = null;
        if (statDo != null && backendType != null) {
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 30L && AssertUtil.isNotEmpty(backendCntMap)) {
                Long cnt = backendCntMap.get(backendType);
                if (cnt == null) {
                    cnt = 0L;
                }
                ret = DataUtil.division((Long)cnt, (Long)actClickCnt, (int)4);
            }
        }
        return ret;
    }

    public static String getTaskBackendType(StatDo statDo) {
        String ret = null;
        if (statDo != null) {
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 50L && AssertUtil.isNotEmpty(backendCntMap)) {
                HashMap<String, Double> filterMap = new HashMap<String, Double>();
                for (Map.Entry<String, Long> entry : backendCntMap.entrySet()) {
                    String type = entry.getKey();
                    Long cnt = entry.getValue();
                    Double weight = backendTypePriorityMap.get(type);
                    if (cnt == null || cnt < 10L || weight == null) continue;
                    filterMap.put(type, (double)cnt.longValue() * weight);
                }
                ret = BackendOptimizer.getValueTopOneFromMap(filterMap);
            }
        }
        return ret;
    }

    public static String getValueTopOneFromMap(Map<String, Double> map) {
        String ret = null;
        if (AssertUtil.isNotEmpty(map)) {
            Double maxValue = 1.0;
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                Double val = entry.getValue();
                if (val == null || !(val > maxValue)) continue;
                maxValue = val;
                ret = entry.getKey();
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        StatDo statDo = new StatDo();
        statDo.setAdvertId(1L);
        statDo.setActClickCnt(40L);
        HashMap<String, Long> bcMap = new HashMap<String, Long>();
        bcMap.put("3", 4L);
        statDo.setBackendCntMap(bcMap);
        HashMap<Long, StatDo> appAdvertStatMap = new HashMap<Long, StatDo>();
        appAdvertStatMap.put(1L, statDo);
        StatDo statDo2 = new StatDo();
        statDo2.setAdvertId(1L);
        statDo2.setActClickCnt(300L);
        HashMap<String, Long> bcMap2 = new HashMap<String, Long>();
        bcMap2.put("1", 40L);
        bcMap2.put("3", 50L);
        statDo2.setBackendCntMap(bcMap2);
        HashMap<Long, StatDo> globalAdvertStatMap = new HashMap<Long, StatDo>();
        globalAdvertStatMap.put(1L, statDo2);
        Map<Long, BackendAdvertStatDo> ret1 = BackendOptimizer.getBackendAdvertStatInfo(appAdvertStatMap, globalAdvertStatMap);
        System.out.println("ret1=" + JSON.toJSONString(ret1));
        HashMap<Long, Double> advertPreInfo = new HashMap<Long, Double>();
        advertPreInfo.put(1L, 0.1);
        Map<Long, Double> ret2 = BackendOptimizer.getBackendAdvertInfo(advertPreInfo, ret1);
        System.out.println("ret2=" + JSON.toJSONString(ret2));
    }

    static {
        backendTypePriorityMap.put("1", 1.0);
        backendTypePriorityMap.put("2", 1.0);
        backendTypePriorityMap.put("3", 1.0);
        backendTypePriorityMap.put("4", 1.0);
        backendTypePriorityMap.put("5", 1.0);
        backendTypePriorityMap.put("6", 1.0);
        backendTypePriorityMap.put("7", 1.0);
        backendTypePriorityMap.put("8", 1.0);
    }
}

