/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.alg.util;

import cn.com.duiba.nezha.compute.api.enums.SerializerEnum;
import cn.com.duiba.nezha.compute.common.util.serialize.KryoUtil;
import cn.com.duiba.nezha.compute.common.util.serialize.SerializeTool;
import java.io.Serializable;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogisticRegressionModelUtil
implements Serializable {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final long serialVersionUID = -316102112618444922L;
    private LogisticRegressionModel model = null;

    public void setModel(LogisticRegressionModel model) {
        this.model = model;
    }

    public void setModel(String modelStr, SerializerEnum serializerEnum) {
        this.model = this.getModel(modelStr, serializerEnum);
    }

    public LogisticRegressionModel getModel() {
        return this.model;
    }

    public LogisticRegressionModel getModel(String src, SerializerEnum serializerEnum) {
        LogisticRegressionModel ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = (LogisticRegressionModel)SerializeTool.getObjectFromString((String)src);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = (LogisticRegressionModel)KryoUtil.deserializationObject((String)src, LogisticRegressionModel.class);
        }
        return ret;
    }

    public String getModelStr(LogisticRegressionModel model, SerializerEnum serializerEnum) {
        String ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = SerializeTool.object2String((Object)model);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.serializationObject((Serializable)model);
        }
        return ret;
    }

    public String getModelStr(SerializerEnum serializerEnum) {
        return this.getModelStr(this.model, serializerEnum);
    }

    public Double predict(Vector data) {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().predict(data);
    }
}

