/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.alg;

import cn.com.duiba.nezha.compute.alg.IAlgorithm;
import cn.com.duiba.nezha.compute.alg.util.CategoryFeatureDictUtil;
import cn.com.duiba.nezha.compute.alg.util.FMModelUtil;
import cn.com.duiba.nezha.compute.api.PredResultVo;
import cn.com.duiba.nezha.compute.api.dict.CategoryFeatureDict;
import cn.com.duiba.nezha.compute.api.dto.AdvertModelEntity;
import cn.com.duiba.nezha.compute.api.enums.SerializerEnum;
import cn.com.duiba.nezha.compute.mllib.model.SparseFMModel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.spark.mllib.linalg.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMbac
implements Serializable,
IAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(FMbac.class);
    private CategoryFeatureDictUtil categoryFeatureDictUtil = null;
    private FMModelUtil modelUtil = null;
    private List<String> featureIdxList = null;

    public FMbac() {
    }

    public FMbac(String featureIdxList, String dict, String modelStr, SerializerEnum serializerEnum) {
        this.setFeatureDict(dict, serializerEnum);
        this.setModel(modelStr, serializerEnum);
        this.setFeatureIdxList(featureIdxList, serializerEnum);
    }

    public FMbac(AdvertModelEntity entity) {
        SerializerEnum serializerEnum = entity.getSerializerId() == SerializerEnum.KRYO.getIndex() ? SerializerEnum.KRYO : SerializerEnum.JAVA_ORIGINAL;
        this.setFeatureDict(entity.getFeatureDictStr(), serializerEnum);
        this.setModel(entity.getModelStr(), serializerEnum);
        this.setFeatureIdxList(entity.getFeatureIdxListStr(), serializerEnum);
    }

    public List<String> getFeatureIdxList() {
        if (this.featureIdxList == null) {
            return null;
        }
        return this.featureIdxList;
    }

    public CategoryFeatureDictUtil getDictUtil() {
        if (this.categoryFeatureDictUtil == null) {
            this.categoryFeatureDictUtil = new CategoryFeatureDictUtil();
        }
        return this.categoryFeatureDictUtil;
    }

    public FMModelUtil getModelUtil() {
        if (this.modelUtil == null) {
            this.modelUtil = new FMModelUtil();
        }
        return this.modelUtil;
    }

    public void setFeatureDict(CategoryFeatureDict dict) {
        this.getDictUtil().setFeatureDict(dict);
    }

    public void setFeatureDict(String dict, SerializerEnum serializerEnum) {
        this.getDictUtil().setFeatureDict(dict, serializerEnum);
    }

    public void setModel(SparseFMModel model) {
        this.getModelUtil().setModel(model);
    }

    public void setModel(String modelStr, SerializerEnum serializerEnum) {
        this.getModelUtil().setModel(modelStr, serializerEnum);
    }

    public void setFeatureIdxList(List<String> featureIdxList) {
        this.featureIdxList = featureIdxList;
    }

    public void setFeatureIdxList(String featureIdxStr, SerializerEnum serializerEnum) {
        this.featureIdxList = this.getDictUtil().getFeatureIdxList(featureIdxStr, serializerEnum);
    }

    public String getFeatureIdxListStr(SerializerEnum serializerEnum) {
        return this.getDictUtil().featureIdxList2Str(this.getFeatureIdxList(), serializerEnum);
    }

    public String getFeatureDictStr(SerializerEnum serializerEnum) {
        return this.getDictUtil().getFeatureDictStr(serializerEnum);
    }

    public String getModelStr(SerializerEnum serializerEnum) {
        return this.getModelUtil().getModelStr(serializerEnum);
    }

    @Override
    public Double predict(List<String> categoryList) {
        Double ret = null;
        try {
            SparseVector sv = this.getDictUtil().oneHotSparseVectorEncode(this.getFeatureIdxList(), categoryList);
            if (sv != null) {
                ret = this.getModelUtil().predict(sv);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    @Override
    public Double predict(Map<String, String> categoryMap) {
        Double ret = null;
        try {
            SparseVector sv = this.getDictUtil().oneHotSparseVectorEncodeWithMap(this.getFeatureIdxList(), categoryMap);
            if (sv != null) {
                ret = this.getModelUtil().predict(sv);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    @Override
    public PredResultVo predictWithInfo(Map<String, String> categoryMap) {
        PredResultVo ret = new PredResultVo();
        return ret;
    }

    public Double predictWithVector(SparseVector vector) {
        Double ret = null;
        try {
            if (vector != null) {
                System.out.println("vector " + vector);
                ret = this.getModelUtil().predict(vector);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }
}

