/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.alg;

import cn.com.duiba.nezha.compute.api.dto.CorrectionInfo;
import cn.com.duiba.nezha.compute.api.dto.NezhaStatDto;
import cn.com.duiba.nezha.compute.api.enums.PredRectifierEnum;
import cn.com.duiba.nezha.compute.common.util.AssertUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class ModelPredRectifier {
    private static Logger logger = Logger.getLogger(ModelPredRectifier.class);

    public static void getCorrectionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(Double.valueOf(1.0));
            info.setReconstructionFactor(Double.valueOf(1.0));
            ModelPredRectifier.setCorrectionFactor(info, PredRectifierEnum.COR);
        }
    }

    public static void getCorrectionReconstructionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(Double.valueOf(1.0));
            info.setReconstructionFactor(Double.valueOf(1.0));
            ModelPredRectifier.setCorrectionFactor(info, PredRectifierEnum.REC);
            ModelPredRectifier.setReconstructionFactor(info);
        }
    }

    public static void setCorrectionFactor(CorrectionInfo info, PredRectifierEnum predRectifierEnum) throws Exception {
        if (info == null) {
            logger.warn((Object)"setCorrectionFactor input invalid,with info = null");
            return;
        }
        if (info.getCurrentPreValue() == null) {
            logger.warn((Object)"setCorrectionFactor input invalid,with info.getCurrentPreValue() = null");
            return;
        }
        if (info.getCurrentPreValue() < 1.0E-10) {
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Double avgPreValue = null;
        Double avgFeedbackValue = null;
        Double vUpperLimit = null;
        Double vLowerLimit = null;
        Double fUpperLimit = null;
        Double fLowerLimit = null;
        Long launchCnt = 0L;
        if (type.equals(1L)) {
            avgPreValue = nezhaStatDto.getPreCtrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            launchCnt = nezhaStatDto.getCtrLaunchCnt();
            vUpperLimit = 0.9999;
            vLowerLimit = 0.01;
            fUpperLimit = 3.0;
            fLowerLimit = 0.2;
        }
        if (type.equals(2L)) {
            avgPreValue = nezhaStatDto.getPreCvrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            launchCnt = nezhaStatDto.getCvrLaunchCnt();
            vUpperLimit = 0.9999;
            vLowerLimit = 5.0E-4;
            fUpperLimit = 3.0;
            fLowerLimit = 0.2;
        }
        Double newCurrentPreValue = ModelPredRectifier.correctionValue(currentPreValue, avgPreValue, avgFeedbackValue, vLowerLimit, vUpperLimit, predRectifierEnum);
        Double currentPreFactor = ModelPredRectifier.noiseSmoother(newCurrentPreValue / currentPreValue, fLowerLimit, fUpperLimit);
        info.setCorrectionFactor(currentPreFactor);
    }

    public static void setReconstructionFactor(CorrectionInfo info) throws Exception {
        if (info == null) {
            logger.warn((Object)"setReconstructionFactor input invalid,with info = null");
            return;
        }
        if (info.getCurrentPreValue() == null) {
            logger.warn((Object)"setReconstructionFactor input invalid,with info.getCurrentPreValue() = null");
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Long launchCnt = 0L;
        Double avgFeedbackValue = null;
        Double lowerLimit = null;
        Double upperLimit = null;
        Double midVal = null;
        Double zoom = null;
        Double fBratio = null;
        boolean isCtr = true;
        if (type.equals(1L)) {
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            lowerLimit = 0.1;
            upperLimit = 1.0;
            midVal = 0.04;
            zoom = 40.0;
            fBratio = 0.1;
        }
        if (type.equals(2L)) {
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            lowerLimit = 0.1;
            upperLimit = 1.0;
            midVal = 0.04;
            zoom = 40.0;
            fBratio = 0.1;
            isCtr = false;
        }
        Double correctionFactor = info.getCorrectionFactor();
        Double newCurrentPreValue = currentPreValue * correctionFactor;
        Double reconstructionValue = ModelPredRectifier.reconstructionValue(isCtr, newCurrentPreValue, avgFeedbackValue, fBratio, zoom, midVal, lowerLimit, upperLimit);
        Double reconstructionFactor = ModelPredRectifier.noiseSmoother(reconstructionValue / newCurrentPreValue, 0.2, 1.5);
        info.setReconstructionFactor(reconstructionFactor);
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            logger.warn((Object)("noiseSmoother input invalid,with upperLimit=" + upperLimit + ",lowerLimit=" + lowerLimit));
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static Double correctionValue(Double currentPreValue, Double avgPreValue, Double avgFeedbackValue, Double lowerLimit, Double upperLimit, PredRectifierEnum predRectifierEnum) throws Exception {
        Double ret = currentPreValue;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{currentPreValue, avgPreValue, avgFeedbackValue, upperLimit, lowerLimit})) {
            return ret;
        }
        if (currentPreValue > 0.0 && avgPreValue > 0.0 && avgFeedbackValue > 0.0) {
            Double lndValue = ModelPredRectifier.noiseSmoother(currentPreValue * avgFeedbackValue / avgPreValue, lowerLimit, upperLimit);
            Double ndValue = ModelPredRectifier.noiseSmoother(currentPreValue + avgFeedbackValue - avgPreValue, lowerLimit, upperLimit);
            ret = avgPreValue > avgFeedbackValue ? Double.valueOf(Math.max(lndValue, ndValue)) : Double.valueOf(Math.min(lndValue, ndValue));
            ret = 0.8 * ret + 0.19999999999999996 * currentPreValue;
        }
        return ret;
    }

    public static Double reconstructionValue(boolean isCtr, Double newCurrentPreValue, Double avgFeedbackValue, double fBratio, double zoom, double midVal, double lowerLimit, double upperLimit) throws Exception {
        Double ret = newCurrentPreValue;
        Double inhibitoryFactor = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{newCurrentPreValue, avgFeedbackValue})) {
            return ret;
        }
        if (newCurrentPreValue > 0.0 && avgFeedbackValue > 1.0E-4) {
            if (newCurrentPreValue < avgFeedbackValue && !isCtr) {
                Double ratio = (newCurrentPreValue + 0.001) / (avgFeedbackValue + 0.001);
                inhibitoryFactor = ModelPredRectifier.sigmoidWithZoomAndIntervalMap(ratio - 0.25, 0.2, 1.0, 15.0);
            }
            if (newCurrentPreValue >= 2.0 * avgFeedbackValue && !isCtr) {
                inhibitoryFactor = 1.05;
            }
            Double mergeVal = (1.0 - fBratio) * newCurrentPreValue + fBratio * avgFeedbackValue;
            Double reconstructionFactor = 1.0;
            if (mergeVal < 0.5) {
                reconstructionFactor = ModelPredRectifier.sigmoidWithZoomAndIntervalMap(mergeVal - midVal, lowerLimit, upperLimit, zoom) + 0.001 * (1.0 - ret);
            }
            if (mergeVal >= 0.6) {
                reconstructionFactor = 1.05;
            }
            ret = ret * inhibitoryFactor * reconstructionFactor;
        }
        return ret;
    }

    public static Double sigmoidWithZoomAndIntervalMap(double x, double lowerLimit, double upperLimit, double zoom) {
        return lowerLimit + (upperLimit - lowerLimit) * ModelPredRectifier.sigmoidWithZoom(x, zoom);
    }

    public static Double sigmoidWithZoom(double x, double zoom) {
        return ModelPredRectifier.sigmoid(x * zoom);
    }

    public static Double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static void main(String[] args) {
        try {
            NezhaStatDto nezhaStatDto = new NezhaStatDto();
            nezhaStatDto.setAdvertId(Long.valueOf(13675L));
            nezhaStatDto.setCtrLaunchCnt(Long.valueOf(1000000L));
            nezhaStatDto.setCvrLaunchCnt(Long.valueOf(1000000L));
            nezhaStatDto.setAlgType(Long.valueOf(206L));
            nezhaStatDto.setAppId(Long.valueOf(20453L));
            nezhaStatDto.setPreCtrAvg(Double.valueOf(0.15));
            nezhaStatDto.setStatCtrAvg(Double.valueOf(0.14));
            nezhaStatDto.setPreCvrAvg(Double.valueOf(0.16));
            nezhaStatDto.setStatCvrAvg(Double.valueOf(0.09));
            CorrectionInfo info = new CorrectionInfo();
            info.setAdvertId(Long.valueOf(13675L));
            info.setType(Long.valueOf(1L));
            info.setCurrentPreValue(Double.valueOf(0.059));
            info.setNezhaStatDto(nezhaStatDto);
            ModelPredRectifier.getCorrectionReconstructionFactor(Arrays.asList(info));
            System.out.println("testGetCorrectionFactor CTR info.getCorrectionFactor()" + info.getCorrectionFactor());
            System.out.println("testGetCorrectionFactor CTR info.getReconstructionFactor()" + info.getReconstructionFactor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

