package cn.com.duiba.nezha.compute.api.cachekey;

/**
 * Created by pc on 2017/2/17.
 */
public class AdvertStatKey {

    public static final String HBASE_PROFIX = "nz_ad_stat_"; //

    public static final String STAT_PROFIX = "nz_ad_stat_"; //

    public static final String CTR_STAT_PROFIX = "nz_ad_ctr_stat_"; //

    public static final String CTR_STAT_DIM_PROFIX = "nz_ad_stat_dim_"; //

    public static String getAdvertStatRowKey(String advertId,
                                             String advertType,
                                             String advertStatDimType,
                                             String statDimId) {

        return HBASE_PROFIX + advertId + "_" +
                advertType + "_" +
                advertStatDimType + "_" +
                statDimId + "_";
    }

    public static String getAdvertStatESKey(String advertId,
                                               String advertType,
                                               String advertStatDimType,
                                               String statDimId) {

        return STAT_PROFIX + advertId + "_" +
                advertType + "_" +
                advertStatDimType + "_" +
                statDimId + "_";
    }

    public static String getAdvertCtrStatESKey(String advertId,
                                                  String advertType,
                                                  String advertStatDimType,
                                                  String statDimId,
                                                  String statIntervalId) {

        return CTR_STAT_PROFIX + advertId + "_" +
                advertType + "_" +
                advertStatDimType + "_" +
                statDimId + "_" +
                statIntervalId + "_";


    }

    public static String getAdvertStatRedisKey(String statDimId) {
        return CTR_STAT_DIM_PROFIX + statDimId + "_";
    }



    public static String getAdvertStatMongoDbKey(String advertId,String appId) {
        return CTR_STAT_DIM_PROFIX + appId + "_"+advertId;
    }

    public static String getAdvertStatMongoDbKey(Long advertId,Long appId) {
        return CTR_STAT_DIM_PROFIX + appId + "_"+advertId;
    }

}
