package cn.com.duiba.nezha.compute.api.cachekey;


/**
 * Created by pc on 2017/2/17.
 */
public class AdvertStatKey {

    public static final String HBASE_PROFIX = "nz_ad_stat_"; //

    public static final String STAT_PROFIX = "nz_ad_stat_"; //

    public static final String CHEAK_PROFIX = "nz_ad_cheak_"; //

    public static final String CTR_STAT_PROFIX = "nz_ad_ctr_stat_"; //

    public static final String STAT_DIM_PROFIX = "nz_ad_stat_dim_"; //

    public static String getAdvertStatRowKey(String advertId,
                                             String materialId,
                                             String advertType,
                                             String advertStatDimType,
                                             String statDimId) {

        String ret = HBASE_PROFIX + advertId + "_" +
                advertType + "_" +
                advertStatDimType + "_" +
                statDimId + "_";

        if (materialId != null) {
            ret = HBASE_PROFIX + advertId + "_" +
                    advertType + "_" +
                    advertStatDimType + "_" +
                    statDimId + "_" + materialId;
        }
        return ret;
    }


    public static String getAdvertStatStatusKey() {

        String ret = CHEAK_PROFIX + "_stat_update_time_";
        return ret;
    }


    public static String getAdvertStatESKey(String advertId,
                                            String advertType,
                                            String advertStatDimType,
                                            String statDimId) {

        return STAT_PROFIX + advertId + "_" +
                advertType + "_" +
                advertStatDimType + "_" +
                statDimId + "_";
    }

    public static String getAdvertCtrStatESKey(String advertId,
                                               String advertType,
                                               String advertStatDimType,
                                               String statDimId,
                                               String statIntervalId) {

        return CTR_STAT_PROFIX + advertId + "_" +
                advertType + "_" +
                advertStatDimType + "_" +
                statDimId + "_" +
                statIntervalId + "_";


    }

    public static String getAdvertStatRedisKey(String statDimId) {
        return STAT_DIM_PROFIX + statDimId + "_";
    }


    public static String getAdvertStatMongoDbKey(String advertId, String materialId, String appId) {

        String ret = STAT_DIM_PROFIX + appId + "_" + advertId;

        if (materialId != null) {
            ret = STAT_DIM_PROFIX + appId + "_" + advertId + "_" + materialId;
        }
        return ret;
    }

    public static String getAdvertStatMongoDbKey(String advertId, String appId) {

        return getAdvertStatMongoDbKey(advertId, null, appId);
    }


}
