/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.dict.CategoryFeatureDict;
import cn.com.duiba.nezha.compute.common.util.CategoryFeatureDictUtil;
import cn.com.duiba.nezha.compute.common.util.LogisticRegressionModelUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvertCtrLogisticRegression
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AdvertCtrLogisticRegression.class);
    private CategoryFeatureDictUtil categoryFeatureDictUtil = null;
    private LogisticRegressionModelUtil logisticRegressionModelUtil = null;
    private List<String> featureIdxList = null;

    public AdvertCtrLogisticRegression() {
    }

    public AdvertCtrLogisticRegression(String featureIdxList, String dict, String modelStr) {
        this.setFeatureDict(dict);
        this.setModel(modelStr);
        this.setFeatureIdxList(featureIdxList);
    }

    public List<String> getFeatureIdxList() {
        if (this.featureIdxList == null) {
            return null;
        }
        return this.featureIdxList;
    }

    public CategoryFeatureDictUtil getDictUtil() {
        if (this.categoryFeatureDictUtil == null) {
            this.categoryFeatureDictUtil = new CategoryFeatureDictUtil();
        }
        return this.categoryFeatureDictUtil;
    }

    public LogisticRegressionModelUtil getModelUtil() {
        if (this.logisticRegressionModelUtil == null) {
            this.logisticRegressionModelUtil = new LogisticRegressionModelUtil();
        }
        return this.logisticRegressionModelUtil;
    }

    public void setFeatureDict(CategoryFeatureDict dict) {
        this.getDictUtil().setFeatureDict(dict);
    }

    public void setFeatureDict(String dict) {
        this.getDictUtil().setFeatureDict(dict);
    }

    public void setModel(LogisticRegressionModel model) {
        this.getModelUtil().setModel(model);
    }

    public void setModel(String modelStr) {
        this.getModelUtil().setModel(modelStr);
    }

    public void setFeatureIdxList(List<String> featureIdxList) {
        this.featureIdxList = featureIdxList;
    }

    public void setFeatureIdxList(String featureIdxStr) {
        this.featureIdxList = this.getDictUtil().getFeatureIdxList(featureIdxStr);
    }

    public String getFeatureIdxListStr() {
        return this.getDictUtil().featureIdxList2Str(this.getFeatureIdxList());
    }

    public String getFeatureDictStr() {
        return this.getDictUtil().getFeatureDictStr();
    }

    public String getModelStr() {
        return this.getModelUtil().getModelStr();
    }

    public Double predict(List<String> categoryList) {
        Double ret = null;
        try {
            Vector value;
            double[] doubleRet = this.getDictUtil().oneHotDoubleEncode(this.getFeatureIdxList(), categoryList);
            if (doubleRet != null && (value = Vectors.dense((double[])doubleRet)) != null) {
                ret = this.getModelUtil().predict(value);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    public Double predict(Map<String, String> categoryMap) {
        Double ret = null;
        try {
            Vector value;
            double[] doubleRet = this.getDictUtil().oneHotDoubleEncodeWithMap(this.getFeatureIdxList(), categoryMap);
            if (doubleRet != null && (value = Vectors.dense((double[])doubleRet)) != null) {
                ret = this.getModelUtil().predict(value);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    public Double getFeatureStatus(Map<String, String> categoryMap) {
        Double ret = null;
        try {
            Vector value;
            double[] doubleRet = this.getDictUtil().oneHotDoubleEncodeWithMap(this.getFeatureIdxList(), categoryMap);
            if (doubleRet != null && (value = Vectors.dense((double[])doubleRet)) != null) {
                ret = this.getModelUtil().predict(value);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }
}

