/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.util.es;

import cn.com.duiba.nezha.compute.common.AssertUtil;
import cn.com.duiba.nezha.compute.common.util.es.ESConfig;
import cn.com.duiba.nezha.compute.common.util.es.ESPool;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.unit.TimeValue;

public class ElasticSearchUtil {
    private ESConfig esConfig;
    private int TTLTime = 518400;
    private static ElasticSearchUtil instance = null;

    public ElasticSearchUtil(ESConfig esConfig) {
        this.esConfig = esConfig;
    }

    private TransportClient getClient() {
        TransportClient client = null;
        try {
            client = ESPool.getClient(this.esConfig);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return client;
    }

    public <T> IndexResponse indexT(String index, String type, String keyId, T t) {
        IndexResponse response = null;
        try {
            response = this.indexT(index, type, keyId, t, this.TTLTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public <T> IndexResponse indexT(String index, String type, String keyId, T t, int ttl) {
        IndexResponse response = null;
        try {
            String jsonValue = JSON.toJSONString(t);
            response = this.index(index, type, keyId, jsonValue, ttl);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public IndexResponse index(String index, String type, String keyId, String jsonValue, int ttl) {
        IndexResponse response = null;
        try {
            if (AssertUtil.isAllNotEmpty(index, type, keyId, jsonValue)) {
                response = (IndexResponse)((IndexRequestBuilder)this.getClient().prepareIndex(index, type).setId(keyId).setSource(jsonValue).setTTL(TimeValue.timeValueMinutes((long)ttl)).setTimeout(TimeValue.timeValueSeconds((long)5L))).execute().actionGet();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public IndexResponse index(String index, String type, String keyId, String jsonValue) {
        IndexResponse response = null;
        try {
            if (AssertUtil.isAllNotEmpty(index, type, keyId)) {
                response = this.index(index, type, keyId, jsonValue, this.TTLTime);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public <T> BulkResponse multiIndexT(String index, String type, Map<String, T> jsonValueMap, int bulkSize) {
        BulkResponse bulkResponse = null;
        try {
            bulkResponse = this.multiIndexT(index, type, jsonValueMap, bulkSize, this.TTLTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public <T> BulkResponse multiIndexT(String index, String type, Map<String, T> tMap, int bulkSize, int ttl) {
        BulkResponse bulkResponse = null;
        try {
            HashMap<String, String> jsonValueMap = new HashMap<String, String>();
            if (tMap != null) {
                for (Map.Entry<String, T> entry : tMap.entrySet()) {
                    String keyId = entry.getKey();
                    T t = entry.getValue();
                    String jsonValue = JSON.toJSONString(t);
                    if (jsonValue == null) continue;
                    jsonValueMap.put(keyId, jsonValue);
                }
                bulkResponse = this.multiIndex(index, type, jsonValueMap, bulkSize, ttl);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public BulkResponse multiIndex(String index, String type, Map<String, String> jsonValueMap, int bulkSize) {
        BulkResponse bulkResponse = null;
        try {
            BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
            if (jsonValueMap != null) {
                bulkResponse = this.multiIndex(index, type, jsonValueMap, bulkSize, this.TTLTime);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public BulkResponse multiIndex(String index, String type, Map<String, String> jsonValueMap, int bulkSize, int ttl) {
        BulkResponse bulkResponse = null;
        try {
            BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
            int count = 0;
            if (jsonValueMap != null) {
                for (Map.Entry<String, String> entry : jsonValueMap.entrySet()) {
                    String keyId = entry.getKey();
                    String jsonValue = entry.getValue();
                    if (jsonValue == null) continue;
                    bulkRequest.add(((IndexRequestBuilder)this.getClient().prepareIndex(index, type).setId(keyId).setSource(jsonValue).setTimeout(TimeValue.timeValueSeconds((long)5L))).setTTL(TimeValue.timeValueMinutes((long)ttl)));
                    if (count % this.getBulkSize(bulkSize) == 0) {
                        bulkRequest.execute().actionGet();
                    }
                    ++count;
                }
                bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public <T> UpdateResponse upsertT(String index, String type, String keyId, T t) {
        UpdateResponse response = null;
        try {
            String jsonValue = JSON.toJSONString(t);
            response = this.upsert(index, type, keyId, jsonValue, this.TTLTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public <T> UpdateResponse upsertT(String index, String type, String keyId, T t, int ttl) {
        UpdateResponse response = null;
        try {
            String jsonValue = JSON.toJSONString(t);
            response = this.upsert(index, type, keyId, jsonValue, ttl);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public UpdateResponse update(String index, String type, String keyId, String jsonValue) {
        UpdateResponse response = null;
        try {
            response = (UpdateResponse)this.getClient().prepareUpdate(index, type, keyId).setDoc(jsonValue).get();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public UpdateResponse upsert(String index, String type, String keyId, String jsonValue) {
        UpdateResponse response = null;
        try {
            response = this.upsert(index, type, keyId, jsonValue, this.TTLTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public UpdateResponse upsert(String index, String type, String keyId, String jsonValue, int ttl) {
        UpdateResponse response = null;
        try {
            if (AssertUtil.isAllNotEmpty(index, type, keyId, jsonValue)) {
                response = (UpdateResponse)((UpdateRequestBuilder)this.getClient().prepareUpdate(index, type, keyId).setDoc(jsonValue).setUpsert(jsonValue).setTimeout(TimeValue.timeValueSeconds((long)2L))).setTtl(TimeValue.timeValueMinutes((long)ttl)).execute().actionGet();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public BulkResponse multiUpsert(String index, String type, Map<String, String> jsonValueMap, int bulkSize, int ttl) {
        BulkResponse bulkResponse = null;
        try {
            BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
            int count = 0;
            if (AssertUtil.isAllNotEmpty(index, type, jsonValueMap)) {
                for (Map.Entry<String, String> entry : jsonValueMap.entrySet()) {
                    String keyId = entry.getKey();
                    String jsonValue = entry.getValue();
                    if (jsonValue == null) continue;
                    bulkRequest.add(((UpdateRequestBuilder)this.getClient().prepareUpdate(index, type, keyId).setUpsert(jsonValue).setDoc(jsonValue).setTimeout(TimeValue.timeValueSeconds((long)2L))).setTtl(TimeValue.timeValueMinutes((long)ttl)));
                    if (count % this.getBulkSize(bulkSize) == 0) {
                        bulkRequest.get();
                    }
                    ++count;
                }
                bulkResponse = (BulkResponse)bulkRequest.get();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public BulkResponse multiUpsert(String index, String type, Map<String, String> jsonValueMap, int bulkSize) {
        BulkResponse bulkResponse = null;
        try {
            bulkResponse = this.multiUpsert(index, type, jsonValueMap, bulkSize, this.TTLTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public <T> BulkResponse multiUpsertT(String index, String type, Map<String, T> tMap, int bulkSize) {
        BulkResponse bulkResponse = null;
        try {
            bulkResponse = this.multiUpsertT(index, type, tMap, bulkSize, this.TTLTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public <T> BulkResponse multiUpsertT(String index, String type, Map<String, T> tMap, int bulkSize, int ttl) {
        BulkResponse bulkResponse = null;
        try {
            HashMap<String, String> jsonValueMap = new HashMap<String, String>();
            if (tMap != null) {
                for (Map.Entry<String, T> entry : tMap.entrySet()) {
                    String keyId = entry.getKey();
                    T t = entry.getValue();
                    String jsonValue = JSON.toJSONString(t);
                    if (jsonValue == null) continue;
                    jsonValueMap.put(keyId, jsonValue);
                }
                bulkResponse = this.multiUpsert(index, type, jsonValueMap, bulkSize, ttl);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    public Map<String, Object> getValueMap(String index, String type, String keyId) {
        Map ret = null;
        try {
            GetResponse response = this.get(index, type, keyId);
            if (response != null) {
                ret = response.getSourceAsMap();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return ret;
    }

    public String getValueString(String index, String type, String keyId) {
        String ret = null;
        try {
            GetResponse response = this.get(index, type, keyId);
            if (response != null) {
                ret = response.getSourceAsString();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return ret;
    }

    public <T> T getValueT(String index, String type, String keyId, Class<T> clazz) {
        Object ret = null;
        try {
            String retStr;
            GetResponse response = this.get(index, type, keyId);
            if (response != null && (retStr = response.getSourceAsString()) != null) {
                ret = JSON.parseObject((String)retStr, clazz);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return (T)ret;
    }

    public <T> T getValueT(String index, String type, String keyId, Class<T> clazz, int timeOut) {
        String retStr;
        Object ret = null;
        GetResponse response = this.get(index, type, keyId);
        if (response != null && (retStr = response.getSourceAsString()) != null) {
            ret = JSON.parseObject((String)retStr, clazz);
        }
        return (T)ret;
    }

    public GetResponse get(String index, String type, String keyId) {
        GetResponse response = null;
        try {
            if (AssertUtil.isAllNotEmpty(index, type, keyId)) {
                response = this.get(index, type, keyId, 1);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public GetResponse get(String index, String type, String keyId, int timeOut) {
        GetResponse response = null;
        try {
            if (AssertUtil.isAllNotEmpty(index, type, keyId)) {
                response = (GetResponse)this.getClient().prepareGet(index, type, keyId).execute().actionGet(TimeValue.timeValueSeconds((long)timeOut));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public <T> Map<String, T> multiGetValueT(String index, String type, List<String> keyIdList, Class<T> clazz) {
        HashMap<String, Object> ret = null;
        Map<String, String> retMap = this.multiGetValueString(index, type, keyIdList);
        if (retMap != null) {
            ret = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : retMap.entrySet()) {
                String keyId = entry.getKey();
                String jsonStr = entry.getValue();
                if (keyId == null || jsonStr == null) continue;
                Object t = JSON.parseObject((String)jsonStr, clazz);
                ret.put(keyId, t);
            }
        }
        return ret;
    }

    public Map<String, String> multiGetValueString(String index, String type, List<String> keyIdList) {
        HashMap<String, String> ret = null;
        MultiGetResponse multiGetItemResponses = this.multiGet(index, type, keyIdList);
        if (multiGetItemResponses != null) {
            ret = new HashMap<String, String>();
            for (MultiGetItemResponse itemResponse : multiGetItemResponses) {
                GetResponse response = itemResponse.getResponse();
                if (!response.isExists()) continue;
                String id = response.getId();
                String json = response.getSourceAsString();
                if (id == null || json == null) continue;
                ret.put(id, json);
            }
        }
        return ret;
    }

    public MultiGetResponse multiGet(String index, String type, List<String> keyIdList) {
        MultiGetResponse response = null;
        if (AssertUtil.isAllNotEmpty(index, type, keyIdList)) {
            response = (MultiGetResponse)this.getClient().prepareMultiGet().add(index, type, keyIdList).execute().actionGet(TimeValue.timeValueSeconds((long)1L));
        }
        return response;
    }

    public DeleteResponse delete(String index, String type, String keyId) {
        DeleteResponse response = null;
        try {
            if (AssertUtil.isAllNotEmpty(index, type, keyId)) {
                response = (DeleteResponse)((DeleteRequestBuilder)this.getClient().prepareDelete(index, type, keyId).setTimeout(TimeValue.timeValueSeconds((long)5L))).execute().actionGet();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public BulkResponse multiDelete(String index, String type, List<String> keyIdList, int bulkSize) {
        BulkResponse bulkResponse = null;
        try {
            BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
            int count = 0;
            if (AssertUtil.isAllNotEmpty(index, type, keyIdList)) {
                for (String keyId : keyIdList) {
                    bulkRequest.add((DeleteRequestBuilder)this.getClient().prepareDelete(index, type, keyId).setTimeout(TimeValue.timeValueSeconds((long)5L)));
                    if (count % this.getBulkSize(bulkSize) == 0) {
                        bulkRequest.get();
                    }
                    ++count;
                }
                bulkResponse = (BulkResponse)bulkRequest.get();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bulkResponse;
    }

    private int getBulkSize(int bulkSize) {
        int ret = 1;
        if (bulkSize > 0) {
            ret = bulkSize;
        }
        return ret;
    }
}

