package cn.com.duiba.nezha.compute.common.model;


import cn.com.duiba.nezha.compute.common.dict.CategoryFeatureDict;
import cn.com.duiba.nezha.compute.common.util.CategoryFeatureDictUtil;
import cn.com.duiba.nezha.compute.common.util.LogisticRegressionModelUtil;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by pc on 2016/12/22.
 */
public class AdvertCtrLogisticRegression implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AdvertCtrLogisticRegression.class);
    private CategoryFeatureDictUtil categoryFeatureDictUtil = null;
    private LogisticRegressionModelUtil logisticRegressionModelUtil = null;
    private List<String> featureIdxList = null;

    public AdvertCtrLogisticRegression() {
    }

    public AdvertCtrLogisticRegression(String featureIdxList, String dict, String modelStr) {
        setFeatureDict(dict);
        setModel(modelStr);
        setFeatureIdxList(featureIdxList);
    }


    public List<String> getFeatureIdxList() {
        if (this.featureIdxList == null) {
            return null;
        } else {
            return this.featureIdxList;
        }
    }


    public CategoryFeatureDictUtil getDictUtil() {
        if (this.categoryFeatureDictUtil == null) {
            this.categoryFeatureDictUtil = new CategoryFeatureDictUtil();
        }
        return this.categoryFeatureDictUtil;
    }

    public LogisticRegressionModelUtil getModelUtil() {
        if (this.logisticRegressionModelUtil == null) {
            this.logisticRegressionModelUtil = new LogisticRegressionModelUtil();
        }
        return this.logisticRegressionModelUtil;
    }

    public void setFeatureDict(CategoryFeatureDict dict) {
        getDictUtil().setFeatureDict(dict);
    }

    public void setFeatureDict(String dict) {
        getDictUtil().setFeatureDict(dict);
    }

    public void setModel(LogisticRegressionModel model) {
        getModelUtil().setModel(model);
    }

    public void setModel(String modelStr) {
        getModelUtil().setModel(modelStr);
    }


    public void setFeatureIdxList(List<String> featureIdxList) {
        this.featureIdxList = featureIdxList;
    }

    public void setFeatureIdxList(String featureIdxStr) {

        this.featureIdxList = getDictUtil().getFeatureIdxList(featureIdxStr);

    }

    public String getFeatureIdxListStr() {
        return getDictUtil().featureIdxList2Str(getFeatureIdxList());
    }

    public String getFeatureDictStr() {
        return getDictUtil().getFeatureDictStr();
    }

    public String getModelStr() {
        return getModelUtil().getModelStr();
    }


    public Double predict(List<String> categoryList) {
        Double ret = null;
        try {
            double[] doubleRet = getDictUtil().oneHotDoubleEncode(getFeatureIdxList(), categoryList);
            if (doubleRet != null) {
                Vector value = Vectors.dense(doubleRet);
                if (value != null) {
                    ret = getModelUtil().predict(value);
                }
            }
        } catch (Exception e) {
            logger.error("predict happend error", e);
        }
        return ret;
    }

    public Double predict(Map<String, String> categoryMap) {
        Double ret = null;
        try {
            double[] doubleRet = getDictUtil().oneHotDoubleEncodeWithMap(getFeatureIdxList(), categoryMap);
            if (doubleRet != null) {
                Vector value = Vectors.dense(doubleRet);
                if (value != null) {
                    ret = getModelUtil().predict(value);
                }
            }
        } catch (Exception e) {
            logger.error("predict happend error", e);
        }

        return ret;
    }
    public Double getFeatureStatus(Map<String, String> categoryMap) {
        Double ret = null;
        try {



            double[] doubleRet = getDictUtil().oneHotDoubleEncodeWithMap(getFeatureIdxList(), categoryMap);
            if (doubleRet != null) {
                Vector value = Vectors.dense(doubleRet);
                if (value != null) {
                    ret = getModelUtil().predict(value);
                }
            }
        } catch (Exception e) {
            logger.error("predict happend error", e);
        }

        return ret;
    }
}
